/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.util.Date;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.CalculatePart;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.common.part.LaborAgreementPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.payroll.dao.KdPaidHolidayDao;
import jp.mosp.kintai.payroll.dao.MKintaiKeisanDao;
import jp.mosp.kintai.payroll.dao.MYukyuDao;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.dto.MKintaiKeisanDto;
import jp.mosp.kintai.payroll.dto.MYukyuDto;
import jp.mosp.kintai.payroll.vo.AttendanceCalculateEndCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateEndCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_CARD_SHOW	= "P1060";
	private static final String	CMD_CARD_UPDATE	= "P1061";
	

	/**
	 * RXgN^
	 */
	public AttendanceCalculateEndCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceCalculateEndCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceCalculateEndCardVo vo = (AttendanceCalculateEndCardVo)getVo();
		vo.setDefaultValues();
		// DTȌ
		MKintaiKeisanDto dto = part().calculate().findForCalc();
		if (chkExistDto(dto)) {
			//	dtoAdtoVoɃZbgB
			vo.setFields(dto);
			// vZ̏ꍇ
			if (CalculatePart.isCalculateFinish(dto)) {
				// bZ[WpvZN
				addErrMessage(getMessage(CommonConst.MSG_ALREADY_CALCULATE, StringUtil.combineByComma(dto.getKTNen(),
						dto.getKTTuki())));
				// [hݒ
				vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
			} else {
				// [hݒ
				vo.setMode(AttendanceCalculateEndCardVo.MODE_UPDATE);
			}
		} else {
			// INZbg
			vo.setLblKTnen(String.valueOf(MospUtility.getYear(DateUtil.getSystemDate())));
			vo.setLblKTtuki(String.valueOf(MospUtility.getMonth(DateUtil.getSystemDate())));
			// vZ񖳂
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
			// [hݒ
			vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
		}
	}
	
	@Override
	protected void update() throws Exception {
		AttendanceCalculateEndCardVo vo = (AttendanceCalculateEndCardVo)getVo();
		// DAȌ
		MKintaiKeisanDao dao = part().calculate().getKeisanDao();
		// DTȌ
		// XVOdto݂邩ǂ`FbN
		MKintaiKeisanDto dto = dao.findForUpdate();
		if (chkExistDto(dto)) {
			dto.setKKanryou(CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_ON);
			// XV
			dao.update(dto);
			// DTO̍Ď擾
			MKintaiKeisanDto retDto = dao.findForKey(dto.getKTNen());
			chkUpdate(retDto);
			// VOɃZbg
			vo.setFields(retDto);
			// Sꗗ擾
			String[][] arySections = getSectionArrayAll();
			// R~bgtO
			boolean[] flagArraySection = new boolean[arySections.length];
			for (int i = 0; i < arySections.length; i++) {
				// ݐЎЈꗗ
				String[] aryAllusers = part().human().getBasisArray(arySections[i][0], getCalcAttendance());
				boolean[] flagArrayUsers = new boolean[aryAllusers.length];
				for (int j = 0; j < aryAllusers.length; j++) {
					// LJz
					flagArrayUsers[j] = registPaidHolidayCarryForward(aryAllusers[j], retDto);
				}
				// JztO
				boolean isCarryForward = true;
				for (int j = 0; j < flagArrayUsers.length; j++) {
					if (!flagArrayUsers[j]) {
						isCarryForward = false;
						break;
					}
				}
				if (isCarryForward) {
					flagArraySection[i] = true;
				} else {
					flagArraySection[i] = false;
				}
			}
			// JzItO
			boolean isAllCarryForward = true;
			for (int k = 0; k < flagArraySection.length; k++) {
				if (!flagArraySection[k]) {
					isAllCarryForward = false;
					break;
				}
			}
			if (isAllCarryForward) {
				// bZ[Wݒ
				setMessage(getMessage(MospConst.MSG_UPDATE, ""));
				// R~bg
				commit();
			} else {
				// vZsbZ[W
				setMessage(MospConst.LOG_MSG_1022);
			}
		} else {
			// vZ񖳂
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		// [hݒ
		vo.setMode(AttendanceCalculateEndCardVo.MODE_IMPOSSIBLE);
	}
	
	/**
	 * LJz
	 * @param kCode ЈR[h
	 * @param dto ΏDTO
	 * @return LJzꍇtrueAłȂꍇfalse
	 * @throws Exception 	Oꍇ
	 */
	private boolean registPaidHolidayCarryForward(String kCode, MKintaiKeisanDto dto) throws Exception {
		// 
		Date processMonth = DateUtil.getYearMonth(dto.getKTNen(), dto.getKTTuki());
		// Wvς݃tO
		boolean isCompiledFlag = false;
		// ΑӏWv
		if (MosPCodePart.afterLegalReformDate(getEndDate(processMonth))) {
			// J@{s̏ꍇ
			isCompiledFlag = VariousUtil.isNotNull(compile().getKdWorkInfo(kCode, processMonth));
		} else {
			isCompiledFlag = VariousUtil.isNotNull(compile().getKintaiInfo(kCode, processMonth));
		}
		if (isCompiledFlag) {
			// ΑӏF@\LmF
			if (isAttendanceApprovalFunction()) {
				// FL
				if (!KintaiCompilePart.checkApproval(getAttendanceList(kCode, getCalcMonth()))) {
					// Ff[^ݏꍇ
					addErrMessage(getMessage(CommonConst.MSG_EXIST_NOT_APPROVED, getKName(kCode)));
					return false;
				}
			}
			// Jz
			if (MosPCodePart.afterLegalReformDate(processMonth)) {
				// J@{s̏ꍇ
				return carryForwardAfterReform(kCode, processMonth);
			} else {
				return carryForwardBeforeReform(kCode, processMonth);
			}
		} else {
			// ΑӏWvf[^Ȃꍇ
			addErrMessage(getMessage(CommonConst.MSG_NO_ATTENDANCE_COMPILED, getKName(kCode)));
		}
		return false;
	}
	
	/**
	 * J@{sȑO̗LxJz
	 * @param kCode ΏێЈR[h
	 * @param processMonth ΏۏN
	 * @return Lx񂪐ȏꍇtureAłȂꍇfalse
	 * @throws Exception 	Oꍇ
	 */
	private boolean carryForwardBeforeReform(String kCode, Date processMonth) throws Exception {
		// Jz
		Date carryDate = getCalcPayment(processMonth);
		// 
		int iCarryDate = DateUtil.convDateToInteger(carryDate);
		// DAȌ
		MYukyuDao dao = part().paidHoliday().getMYukyuDao();
		// ̗Lx擾
		MYukyuDto currentDto = dao.findForKey(kCode, iCarryDate);
		if (VariousUtil.isNull(currentDto)) {
			currentDto = new MYukyuDto();
			currentDto.setKCode(kCode);
			currentDto.setKyuyoYMD(iCarryDate);
		}
		// O̗L񌟍
		MYukyuDto formerDto = dao.findForKey(kCode, DateUtil.convDateToInteger(DateUtil.addMonth(carryDate, -1)));
		if (VariousUtil.isNull(formerDto)) {
			formerDto = new MYukyuDto();
		}
		// LxɎx
		int carryForwardMonth = 0;
		if (part().mospcode().useProvideEmployMonth()) {
			// ΏێЈ̓ЌZbgB
			carryForwardMonth = MospUtility.getMonth(part().human().getEmployDate(kCode));
		} else {
			// JzZbgB
			carryForwardMonth = part().mospcode().getCarriedForwardMonth();
		}
		// JztO
		boolean isCarryForward = carryForwardMonth == MospUtility.getMonth(processMonth);
		// x
		int payment = 0;
		if (isCarryForward) {
			payment = part().paidHoliday().getCarryForwardSupplyDays(kCode);
		}
		// OciONxj
		double formerLastRemain = formerDto.getTZanZ();
		// OciNxj
		double formerThisRemain = formerDto.getTZanT();
		// ΑӏWv
		MKintaiDto mKintaiDto = compile().getKintaiInfo(kCode, processMonth);
		// p
		double useDays = mKintaiDto.getYukyu();
		// Jzʎ擾
		Map<String, Double> map = part().paidHoliday().getOldCarryForwardInfo(formerLastRemain, formerThisRemain,
				useDays, payment, isCarryForward);
		// j
		double waste = PaidHolidayPart.getMapWasteDays(map);
		// Lx\萔iNxj
		double thisRemain = PaidHolidayPart.getMapRemainDays(map);
		// Lx\萔iONxj
		double lastRemain = PaidHolidayPart.getMapLastRemainDays(map);
		// c̃`FbNsB
		if (PaidHolidayPart.checkRemainInfoMap(map)) {
			// DTOɃZbg
			currentDto.setZZanT(formerThisRemain);
			currentDto.setZZanZ(formerLastRemain);
			currentDto.setSyoka(useDays);
			currentDto.setSyutoku(payment);
			currentDto.setHaiki(waste);
			currentDto.setTZanT(thisRemain);
			currentDto.setTZanZ(lastRemain);
			// o^
			if (VariousUtil.isNull(dao.findForUpdate(kCode, iCarryDate))) {
				// o^
				dao.insert(currentDto);
			} else {
				// XV
				dao.update(currentDto);
			}
			// XV`FbN
			chkUpdate(dao.findForKey(kCode, iCarryDate));
			// 2010N3̏ꍇ
			if (processMonth.compareTo(DateUtil.addMonth(DateUtil.getLegalReformDate(), -1)) == 0) {
				Date nextProcess = DateUtil.addMonth(processMonth, 1);
				Date nextStart = part().calculate().getStartDate(nextProcess);
				Date nextEnd = part().calculate().getEndDate(nextProcess);
				// 2010N4ȍ~܂ޏꍇ
				if (PaidHolidayPart.checkAfterReformDate(nextStart, nextEnd)) {
					// Ve[u2010N4痘pł𔭍sB
					carryForwardAfterReform(kCode, processMonth);
				}
			}
			return true;
		}
		// G[bZ[W
		addErrMessage(getMessage("WC2056", StringUtil.combineByComma(getKName(kCode), DateUtil
			.convDateToFormatDateJPShort(carryDate))));
		return false;
	}
	
	/**
	 * J@{sȍ~̗LxJz
	 * @param kCode ΏێЈR[h
	 * @param processMonth ΏۏN
	 * @return Lx񂪐ȏꍇtureAłȂꍇfalse
	 * @throws Exception 	Oꍇ
	 */
	private boolean carryForwardAfterReform(String kCode, Date processMonth) throws Exception {
		// LxɎx
		int carryForwardMonth = 0;
		if (part().mospcode().useProvideEmployMonth()) {
			// ΏێЈ̓ЌZbgB
			carryForwardMonth = MospUtility.getMonth(part().human().getEmployDate(kCode));
		} else {
			// JzZbgB
			carryForwardMonth = part().mospcode().getCarriedForwardMonth();
		}
		// JztO
		boolean isCarryForward = carryForwardMonth == MospUtility.getMonth(processMonth);
		// x
		int supplyDays = 0;
		// ΑӏWv̎cEcԏ
		Map<String, Double> map = part().paidHoliday().getPaidHolidayInfoMap(kCode, processMonth);
		// Jg
		setLaborAgreementInfo(kCode, getEndDate(getCalcMonth()));
		if (isCarryForward) {
			supplyDays = part().paidHoliday().getCarryForwardSupplyDays(kCode);
			map = part().paidHoliday().carryForward(PaidHolidayPart.getMapLastRemainDays(map),
					PaidHolidayPart.getMapLastRemainHour(map), PaidHolidayPart.getMapRemainDays(map),
					PaidHolidayPart.getMapRemainHour(map), supplyDays, LaborAgreementPart.getPrescribedTime(agreement));
		}
		// cEcԂ̃`FbN
		if (PaidHolidayPart.checkRemainInfoMap(map)) {
			// Jz͏̗NZ
			Date carryDate = getStartDate(DateUtil.addMonth(processMonth, 1));
			// DTO̐
			KdPaidHolidayDto monthlyDto = PaidHolidayPart.createMonthlyDto(kCode, carryDate, map);
			// DAȌ
			KdPaidHolidayDao dao = part().paidHoliday().getPaidHolidayDao();
			// ȑȌ_폜B
			KdPaidHolidayDto currentDto = dao.findForProcess(kCode, CommonConst.CODE_PROCESS_MONTHLY, carryDate);
			if (VariousUtil.isNotNull(currentDto)) {
				currentDto = dao.findForUpdate(currentDto.getPaidId(), currentDto.getKCode());
				currentDto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
				dao.update(currentDto);
			}
			String maxPaidId = dao.findForMax(kCode);
			if (StringUtil.isNull(maxPaidId)) {
				maxPaidId = "0";
			}
			dao.findForUpdate(Long.parseLong(maxPaidId), kCode);
			monthlyDto.setPaidId(Long.parseLong(maxPaidId) + 1);
			// o^
			dao.insert(monthlyDto);
			chkInsert(dao.findForKey(monthlyDto.getPaidId(), monthlyDto.getKCode()));
			return true;
		}
		// G[bZ[W
		addErrMessage(getMessage("WC2056", StringUtil.combineByComma(getKName(kCode), DateUtil
			.convDateToFormatDateJPShort(processMonth))));
		return false;
	}
	
}
