/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * 
 */
public class EmployeeAttendanceListVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID	= 159955841494832069L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_NAME;
	
	// tB[h
	private String[]			aryKCode;
	private String[]			aryKName;
	private String[]			arySection;
	private String[]			aryPosition;
	private String				txtKCode;
	private String				txtKName;
	private String				pltSection;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltSectionAll;
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	/**
	 * 
	 */
	public String[][]			aryPltPosition;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * 
	 */
	public final String			KEY_K_NAME			= "keyKName";
	/**
	 * 
	 */
	public final String			KEY_SECTION			= "keySection";
	/**
	 * 
	 */
	public final String			KEY_POSITION		= "keyPosition";
	

	/**
	 * RXgN^
	 */
	public EmployeeAttendanceListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		pltSection = "";
		aryKCode = new String[0];
		aryKName = new String[0];
		arySection = new String[0];
		aryPosition = new String[0];
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_EMPLOYEE_SELECT;
		aryMenu = new String[][]{ { CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltSection = request.getParameter(PRM_PLT_SECTION);
	}
	
	@Override
	public void setFields(List<?> list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryKCode = new String[count];
		aryKName = new String[count];
		arySection = new String[count];
		aryPosition = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			aryKCode[i] = escapeHTML(dto.getKCode());
			aryKName[i] = escapeHTML(dto.getSimei());
			arySection[i] = escapeHTML(getCodeName(dto.getSCode(), aryPltSectionAll));
			aryPosition[i] = "";
			for (String[] element : aryPltPosition) {
				if (element[0].equals(dto.getYCode()) && element[2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(element[1]);
					break;
				}
			}
			i++;
		}
	}
	
	/**
	 * @return aryKCode
	 */
	public String[] getAryKCode() {
		return aryKCode.clone();
	}
	
	/**
	 * @return aryKName
	 */
	public String[] getAryKName() {
		return aryKName.clone();
	}
	
	/**
	 * @return arySection
	 */
	public String[] getArySection() {
		return arySection.clone();
	}
	
	/**
	 * @return aryPosition
	 */
	public String[] getAryPosition() {
		return aryPosition.clone();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @param aryKCode Zbg aryKCode
	 */
	public void setAryKCode(String[] aryKCode) {
		this.aryKCode = aryKCode.clone();
	}
	
	/**
	 * @param aryKName Zbg aryKName
	 */
	public void setAryKName(String[] aryKName) {
		this.aryKName = aryKName.clone();
	}
	
	/**
	 * @param arySection Zbg arySection
	 */
	public void setArySection(String[] arySection) {
		this.arySection = arySection.clone();
	}
	
	/**
	 * @param aryPosition Zbg aryPosition
	 */
	public void setAryPosition(String[] aryPosition) {
		this.aryPosition = aryPosition.clone();
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
}
