/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;

/**
 * 
 */
public class AttendanceStartCardVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID			= 5615485616797787215L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_HOUR			= "txtStartHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_MIN			= "txtStartMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_WORK_TYPE			= "pltWorkType";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HALF_HOLIDAY		= "pltHalfHoliday";
	/**
	 * 
	 */
	public static final String	PRM_PLT_WORK_ON_HOLIDAY		= "pltWorkOnHoliday";
	
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_HOUR			= "txtLateHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_MIN			= "txtLateMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LATE_REASON			= "pltLateReason";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LATE_CERTIFICATE	= "pltLateCertificate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_COMMENT		= "txtLateComment";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_START_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_START_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_WORKING_TYPE;
	/**
	 * 
	 */
	public String				NAM_HALF_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_LATE_REASON;
	/**
	 * 
	 */
	public String				NAM_LATE_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LATE_COMMENT;
	/**
	 * 
	 */
	public int					LEN_HOUR;
	/**
	 * 
	 */
	public int					LEN_MIN;
	/**
	 * 
	 */
	public int					LEN_COMMENT;
	
	// tB[h	
	private String				txtStartHour;
	private String				txtStartMin;
	private String				pltWorkType;
	private String				pltHalfHoliday;
	private String				pltWorkOnHoliday;
	
	private String				txtLateHour;
	private String				txtLateMin;
	private String				pltLateReason;
	private String				pltLateCertificate;
	private String				txtLateComment;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	/**
	 * 
	 */
	public String[][]			aryPltHalfHoliday;
	/**
	 * 
	 */
	public String[][]			aryPltWorkOnHoliday;
	/**
	 * 
	 */
	public String[][]			aryPltLateReason;
	/**
	 * 
	 */
	public String[][]			aryPltLateCertificate;
	

	/**
	 * RXgN^
	 */
	public AttendanceStartCardVo() {
		super();
		setViewPath(getClassName());
		setMode(MODE_EDIT);
		addAttendanceMenuCss();
		addAttendanceMenuJs();
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_INPUT_START;
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_START_TIME = CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
		NAM_START_TIME_HOUR = CommonConst.NAM_START_TIME + CommonConst.MSG_HOUR;
		NAM_START_TIME_MIN = CommonConst.NAM_START_TIME + CommonConst.MSG_MINUTES;
		NAM_WORKING_TYPE = CommonConst.NAM_WORKING_TYPE;
		NAM_HALF_HOLIDAY = CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
		NAM_WORK_ON_HOLIDAY = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;
		NAM_LATE_TIME = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_TIME_HOUR = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
		NAM_LATE_TIME_MIN = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
		NAM_LATE_REASON = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
		NAM_LATE_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LATE_COMMENT = CommonConst.NAM_COMMENT;
		LEN_HOUR = CommonConst.LEN_TIME_HOUR;
		LEN_MIN = CommonConst.LEN_TIME_MIN;
		LEN_COMMENT = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		txtStartHour = request.getParameter(PRM_TXT_START_HOUR);
		txtStartMin = request.getParameter(PRM_TXT_START_MIN);
		pltWorkType = request.getParameter(PRM_PLT_WORK_TYPE);
		pltHalfHoliday = request.getParameter(PRM_PLT_HALF_HOLIDAY);
		pltWorkOnHoliday = request.getParameter(PRM_PLT_WORK_ON_HOLIDAY);
		txtLateHour = request.getParameter(PRM_TXT_LATE_HOUR);
		txtLateMin = request.getParameter(PRM_TXT_LATE_MIN);
		pltLateReason = request.getParameter(PRM_PLT_LATE_REASON);
		pltLateCertificate = request.getParameter(PRM_PLT_LATE_CERTIFICATE);
		txtLateComment = request.getParameter(PRM_TXT_LATE_COMMENT);
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MSyukkinboDto dto) {
		txtStartHour = TimeUtil.convStringTimeToStringHour(dto.getSyJikoku());
		txtStartMin = TimeUtil.convStringTimeToStringMinutes(dto.getSyJikoku());
		pltWorkType = dto.getKinmu();
		pltHalfHoliday = dto.getSHankyuKb();
		pltWorkOnHoliday = dto.getKyusyuKb();
		txtLateHour = String.valueOf(TimeUtil.convIntegerTimeToStringHour(dto.getTiJikan()));
		txtLateMin = String.valueOf(TimeUtil.convIntegerTimeToStringMinutes(dto.getTiJikan()));
		pltLateReason = dto.getTiRiyuu();
		pltLateCertificate = dto.getTiSyoumei();
		txtLateComment = dto.getTiComent();
	}
	
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setSyJikoku(TimeUtil.convStringTimeFormatted(txtStartHour, txtStartMin));
		dto.setKinmu(pltWorkType);
		dto.setSHankyuKb(pltHalfHoliday);
		dto.setKyusyuKb(pltWorkOnHoliday);
		dto.setTiJikan(TimeUtil.convStringTimeToIntegerTime(txtLateHour, txtLateMin));
		dto.setTiRiyuu(pltLateReason);
		dto.setTiSyoumei(pltLateCertificate);
		dto.setTiComent(txtLateComment);
		dto.setSyTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
	}
	
	/**
	 * tB[h
	 */
	public void initFields() {
		txtStartHour = String.valueOf(MospUtility.getHour(DateUtil.getNowDate()));
		txtStartMin = String.valueOf(MospUtility.getMinute(DateUtil.getNowDate()));
		pltWorkType = "";
		pltHalfHoliday = "";
		pltWorkOnHoliday = "";
		txtLateHour = "0";
		txtLateMin = "0";
		pltLateReason = "";
		pltLateCertificate = "";
		txtLateComment = "";
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtStartHour, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkRequired(txtStartMin, NAM_START_TIME, PRM_TXT_START_MIN);
		checkRequired(txtLateHour, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkRequired(txtLateMin, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		// mF
		checkNumber(txtStartHour, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkNumber(txtStartMin, NAM_START_TIME, PRM_TXT_START_MIN);
		checkNumber(txtLateHour, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkNumber(txtLateMin, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		// mF	
		checkLength(txtStartHour, LEN_HOUR, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkLength(txtStartMin, LEN_MIN, NAM_START_TIME, PRM_TXT_START_MIN);
		checkLength(txtLateHour, LEN_HOUR, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkLength(txtLateMin, LEN_MIN, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		checkLength(txtLateComment, LEN_COMMENT, NAM_LATE_COMMENT, PRM_TXT_LATE_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * @return txtStartHour
	 */
	public String getTxtStartHour() {
		return txtStartHour;
	}
	
	/**
	 * @return txtStartMin
	 */
	public String getTxtStartMin() {
		return txtStartMin;
	}
	
	/**
	 * @return pltWorkType
	 */
	public String getPltWorkType() {
		return pltWorkType;
	}
	
	/**
	 * @return pltHalfHoliday
	 */
	public String getPltHalfHoliday() {
		return pltHalfHoliday;
	}
	
	/**
	 * @return pltWorkOnHoliday
	 */
	public String getPltWorkOnHoliday() {
		return pltWorkOnHoliday;
	}
	
	/**
	 * @return txtLateHour
	 */
	public String getTxtLateHour() {
		return txtLateHour;
	}
	
	/**
	 * @return txtLateMin
	 */
	public String getTxtLateMin() {
		return txtLateMin;
	}
	
	/**
	 * @return pltLateReason
	 */
	public String getPltLateReason() {
		return pltLateReason;
	}
	
	/**
	 * @return pltLateCertificate
	 */
	public String getPltLateCertificate() {
		return pltLateCertificate;
	}
	
	/**
	 * @return txtLateComment
	 */
	public String getTxtLateComment() {
		return txtLateComment;
	}
	
	/**
	 * @param txtStartHour Zbg txtStartHour
	 */
	public void setTxtStartHour(String txtStartHour) {
		this.txtStartHour = txtStartHour;
	}
	
	/**
	 * @param txtStartMin Zbg txtStartMin
	 */
	public void setTxtStartMin(String txtStartMin) {
		this.txtStartMin = txtStartMin;
	}
	
	/**
	 * @param pltWorkType Zbg pltWorkType
	 */
	public void setPltWorkType(String pltWorkType) {
		this.pltWorkType = pltWorkType;
	}
	
	/**
	 * @param pltHalfHoliday Zbg pltHalfHoliday
	 */
	public void setPltHalfHoliday(String pltHalfHoliday) {
		this.pltHalfHoliday = pltHalfHoliday;
	}
	
	/**
	 * @param pltWorkOnHoliday Zbg pltWorkOnHoliday
	 */
	public void setPltWorkOnHoliday(String pltWorkOnHoliday) {
		this.pltWorkOnHoliday = pltWorkOnHoliday;
	}
	
	/**
	 * @param txtLateHour Zbg txtLateHour
	 */
	public void setTxtLateHour(String txtLateHour) {
		this.txtLateHour = txtLateHour;
	}
	
	/**
	 * @param txtLateMin Zbg txtLateMin
	 */
	public void setTxtLateMin(String txtLateMin) {
		this.txtLateMin = txtLateMin;
	}
	
	/**
	 * @param pltLateReason Zbg pltLateReason
	 */
	public void setPltLateReason(String pltLateReason) {
		this.pltLateReason = pltLateReason;
	}
	
	/**
	 * @param pltLateCertificate Zbg pltLateCertificate
	 */
	public void setPltLateCertificate(String pltLateCertificate) {
		this.pltLateCertificate = pltLateCertificate;
	}
	
	/**
	 * @param txtLateComment Zbg txtLateComment
	 */
	public void setTxtLateComment(String txtLateComment) {
		this.txtLateComment = txtLateComment;
	}
	
}
