/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.util.Date;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.HolidayRequestPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.part.LaborAgreementPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.PaidHolidayConfirmCardVo;
import jp.mosp.kintai.payroll.dto.MYukyuDto;
import jp.mosp.kintai.workflow.dto.KtHolidayRequestDto;

/**
 * LxmF(l)̕\sB
 * <ul><li>
 * {@link #CMD_YUKYU_PERSONAL_SHOW}
 * </li></ul>
 */
public class PaidHolidayConfirmCardAction extends AttendanceTotalAction {
	
	/**
	 * LxmF(l)\R}hB<br><br>
	 * LxmF(l)\B
	 */
	private static final String	CMD_YUKYU_PERSONAL_SHOW	= "K1300";	// \
																	
	
	/**
	 * RXgN^
	 */
	public PaidHolidayConfirmCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_YUKYU_PERSONAL_SHOW)) {
			// \
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PaidHolidayConfirmCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U[擾  ЈR[hێ
		getInfo(user.getUserId());
	}
	
	@Override
	protected void show() throws Exception {
		PaidHolidayConfirmCardVo vo = (PaidHolidayConfirmCardVo)getVo();
		vo.setDefaultValues();
		// Ώ۔N擾
		Date calcPayment = getCalcPayment();
		// Ώ۔N̏FEF쐬
		double[] number = makeApprovalYukyuNumber(calcPayment);
		// Ώ۔N̒ǉEp\쐬
		makeAddAndDispose(calcPayment, number[2], number[3]);
		// VOɏݒ
		vo.setLblRemainApproved(String.valueOf(number[0]) + CommonConst.NAM_DAY);
		vo.setLblApproved(String.valueOf(number[2]) + CommonConst.NAM_DAY);
		if (MosPCodePart.afterLegalReformDate(calcPayment)) {
			vo.setLblRemainApprovedTime(NumberUtil.getNumberString(number[1], 2, 0) + CommonConst.NAM_COMMON_TIME);
			vo.setLblApprovedTime(NumberUtil.getNumberString(number[3], 2, 0) + CommonConst.NAM_COMMON_TIME);
		}
		// VOɏݒ
		vo.setLblAttendanceCalcY(String.valueOf(MospUtility.getYear(calcPayment)));
		vo.setLblAttendanceCalcM(String.valueOf(MospUtility.getMonth(calcPayment)));
	}
	
	/**
	 * LxFEF쐬B
	 * @param targetDate	Ώ۔NB
	 * @return [0]cFς݌A[1]cFςݎԐ [2]cFA[3]cFԐB
	 * @throws Exception 	OꍇB
	 */
	private double[] makeApprovalYukyuNumber(Date targetDate) throws Exception {
		// ΑӏWvΏی̏oΕ̎擾
		getAttendanceList(userBasis.getKCode(), getCalcMonth());
		// z񏉊
		double[] number = { 0.0, 0, 0.0, 0 };
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			// F@\
			number = getApprovalNumber(targetDate);
		} else {
			// F@\Ȃ
			// oΕWvf[^
			for (MSyukkinboDto dto : attendanceList) {
				// Lxx
				if (KintaiCommonPart.isAllHoliday(dto)) {
					// FƂăJEg
					number[0]++;
				} else if (KintaiCommonPart.isHalfHoliday(dto)) {
					// x
					// FAF
					number[0] += CommonConst.NUM_HALF_DAY;
				}
			}
		}
		return number;
	}
	
	/**
	 * FEF̗Lxɐ\擾B
	 * @param targetDate Ώ۔NB
	 * @return Lxx()̎擾ƎԐB
	 * @throws Exception OꍇB
	 */
	private double[] getApprovalNumber(Date targetDate) throws Exception {
		List<KtHolidayRequestDto> list = part().holidayRequest().getKtHolidayRequestDao().findForCondition(
				userBasis.getKCode(), CommonConst.CODE_HOLIDAY_REASON_PAID, getStartDateForList(targetDate),
				getEndDateForList(targetDate), CommonConst.NUM_REQUEST_LAYER, "");
		// z񏉊
		double[] approval = { 0.0, 0, 0.0, 0 };
		for (KtHolidayRequestDto dto : list) {
			if (part().workflow().isStatusApproved(dto.getWorkflow())) {
				// Fς݂̏ꍇ
				if (HolidayRequestPart.isPaidHolidayAll(dto)) {
					// Sx
					approval[2]++;
				} else if (HolidayRequestPart.isPaidHolidayHalf(dto)) {
					// x
					approval[2] += CommonConst.NUM_HALF_DAY;
				} else if (HolidayRequestPart.isPaidHolidayTime(dto)) {
					// 
					approval[3] += HolidayRequestPart.getHolidayTime(dto);
				}
			} else {
				// F̏ꍇ
				if (HolidayRequestPart.isPaidHolidayAll(dto)) {
					// Sx
					approval[0]++;
				} else if (HolidayRequestPart.isPaidHolidayHalf(dto)) {
					// x
					approval[0] += CommonConst.NUM_HALF_DAY;
				} else if (HolidayRequestPart.isPaidHolidayTime(dto)) {
					// 
					approval[1] += HolidayRequestPart.getHolidayTime(dto);
				}
			}
		}
		return approval;
	}
	
	/**
	 * LxǉEp쐬B
	 * @param calcPayment	^xB
	 * @param useDays Ώ۔N̏F()쐬B
	 * @param useTime Ώ۔N̏F()쐬B
	 * @throws Exception	OꍇB
	 */
	private void makeAddAndDispose(Date calcPayment, double useDays, double useTime) throws Exception {
		if (MosPCodePart.afterLegalReformDate(calcPayment)) {
			// J@{s̏ꍇ
			makeAddAndDisposeNew(calcPayment, useDays, useTime);
		} else {
			// J@{sȑȌꍇ
			makeAddAndDisposeOld(calcPayment, useDays);
		}
	}
	
	/**
	 * Lx擾()B
	 * @param calcPayment ^xB
	 * @param useDays Ώ۔N̏F()쐬B
	 * @throws Exception OꍇB
	 */
	private void makeAddAndDisposeOld(Date calcPayment, double useDays) throws Exception {
		double supplyDays = 0;
		// O̗L񌟍
		MYukyuDto formerDto = part().paidHoliday().getYukyuInfo(userBasis.getKCode(),
				DateUtil.addMonth(calcPayment, -1));
		if (VariousUtil.isNull(formerDto)) {
			formerDto = new MYukyuDto();
		}
		// JztO
		boolean isCarryForward = false;
		int carryForwardMonth = 0;
		if (part().mospcode().useProvideEmployMonth()) {
			// ЌJz
			carryForwardMonth = MospUtility.getMonth(part().human().getEmployDate(userBasis.getKCode()));
			if (MospUtility.getMonth(calcPayment) == carryForwardMonth) {
				isCarryForward = true;
			}
		} else {
			// Jz
			isCarryForward = part().mospcode().getCarriedForwardMonth() == MospUtility.getMonth(calcPayment);
		}
		// x
		int payment = 0;
		if (isCarryForward) {
			payment = part().paidHoliday().getCarryForwardSupplyDays(userBasis.getKCode());
		}
		// 蓮x̎擾
		payment += formerDto.getSyutoku();
		// OciONxj
		double lastRemainDays = formerDto.getTZanZ();
		// OciNxj
		double remainDays = formerDto.getTZanT();
		// Jzʎ擾
		Map<String, Double> map = part().paidHoliday().getOldCarryForwardInfo(lastRemainDays, remainDays, useDays,
				payment, isCarryForward);
		// ǉ
		supplyDays += PaidHolidayPart.getMapSupplyDays(map);
		// j
		double waste = PaidHolidayPart.getMapWasteDays(map);
		// 蓮xj̎擾
		waste += formerDto.getHaiki();
		// Lx\萔iNxj
		double remainThisThis = PaidHolidayPart.getMapRemainDays(map);
		// Lx\萔iONxj
		double remainThisPrev = PaidHolidayPart.getMapLastRemainDays(map);
		// VOɏݒ
		PaidHolidayConfirmCardVo vo = (PaidHolidayConfirmCardVo)getVo();
		vo.setLblThisMGet(String.valueOf(supplyDays) + CommonConst.NAM_DAY);
		vo.setLblThisMDispose(String.valueOf(waste) + CommonConst.NAM_DAY);
		vo.setLblThisMRestLY(String.valueOf(remainThisPrev) + CommonConst.NAM_DAY);
		vo.setLblThisMRestTY(String.valueOf(remainThisThis) + CommonConst.NAM_DAY);
		vo.setLblPaidHolidayLY(String.valueOf(lastRemainDays) + CommonConst.NAM_DAY);
		vo.setLblPaidHolidayTY(String.valueOf(remainDays) + CommonConst.NAM_DAY);
	}
	
	/**
	 * Lx擾(V)B
	 * @param calcPayment ^xB
	 * @param useDays Ώ۔N̏F()쐬B
	 * @param useTime Ώ۔N̏F()쐬B
	 * @throws Exception OꍇB
	 */
	private void makeAddAndDisposeNew(Date calcPayment, double useDays, double useTime) throws Exception {
		double lastRemainDays = 0;
		int lastRemainTime = 0;
		double remainDays = 0;
		int remainTime = 0;
		double possibleTime = 0;
		double wasteDays = 0;
		int wasteTime = 0;
		double remainThisThisDays = 0;
		double remainThisPrevDays = 0;
		int remainThisThisTime = 0;
		int remainThisPrevTime = 0;
		double possibleThisTime = 0;
		double supplyDays = 0;
		// JztO
		boolean isCarryForward = false;
		int carryForwardMonth = 0;
		if (part().mospcode().useProvideEmployMonth()) {
			// ЌJz
			carryForwardMonth = MospUtility.getMonth(part().human().getEmployDate(userBasis.getKCode()));
			if (MospUtility.getMonth(calcPayment) == carryForwardMonth) {
				isCarryForward = true;
			}
		} else {
			// Jz
			isCarryForward = part().mospcode().getCarriedForwardMonth() == MospUtility.getMonth(calcPayment);
		}
		// x
		int paymentDays = 0;
		int paymentTime = 0;
		if (isCarryForward) {
			paymentDays = part().paidHoliday().getCarryForwardSupplyDays(userBasis.getKCode());
		}
		// ΏۊԂ̎cAcԏ(Oc̎擾)
		Map<String, Double> map3 = part().paidHoliday().getPeriodRemainInfoMap(userBasis.getKCode(),
				DateUtil.getFirstDateOfMonth(calcPayment), DateUtil.getLastDateOfMonth(calcPayment));
		lastRemainDays = PaidHolidayPart.getMapLastRemainDays(map3);
		lastRemainTime = PaidHolidayPart.getMapLastRemainHour(map3);
		remainDays = PaidHolidayPart.getMapRemainDays(map3);
		remainTime = PaidHolidayPart.getMapRemainHour(map3);
		if (part().mospcode().useHourPaidHolidayFunction()) {
			possibleTime = PaidHolidayPart.getMapPossible(map3);
		}
		// x
		if (isCarryForward) {
			// Jg
			setLaborAgreementInfo(userBasis.getKCode(), calcPayment);
			// Jzʎ擾
			Map<String, Double> map2 = part().paidHoliday().carryForward(lastRemainDays, lastRemainTime, remainDays,
					remainTime, paymentDays, LaborAgreementPart.getPrescribedTime(agreement));
			// Jz̏(Jzɂc擾)
			supplyDays += PaidHolidayPart.getMapSupplyDays(map2);
			paymentTime += PaidHolidayPart.getMapSupplyHour(map2);
			// p擾
			wasteDays += PaidHolidayPart.getMapWasteDays(map2);
			wasteTime += PaidHolidayPart.getMapWasteHour(map2);
			// Lx\萔iNxj
			remainThisThisDays = PaidHolidayPart.getMapRemainDays(map2);
			remainThisThisTime = PaidHolidayPart.getMapRemainHour(map2);
			if (part().mospcode().useHourPaidHolidayFunction()) {
				possibleThisTime = PaidHolidayPart.getMapPossible(map2);
			}
			// Lx\萔iONxj
			remainThisPrevDays = PaidHolidayPart.getMapLastRemainDays(map2);
			remainThisPrevTime = PaidHolidayPart.getMapLastRemainHour(map2);
		} else {
			// Ώ۔N̎cAcԏ擾(Fς݃f[^̍TZoς)
			Map<String, Double> map = part().paidHoliday().getAvairablePaidHolidayMap(userBasis.getKCode(),
					MospUtility.getYear(calcPayment), MospUtility.getMonth(calcPayment));
			// JzȊȌ(̎c擾)
			supplyDays += PaidHolidayPart.getMapSupplyDays(map);
			paymentTime += PaidHolidayPart.getMapSupplyHour(map);
			// p擾
			wasteDays += PaidHolidayPart.getMapWasteDays(map);
			wasteTime += PaidHolidayPart.getMapWasteHour(map);
			// Lx\萔iONxj
			remainThisPrevDays = PaidHolidayPart.getMapLastRemainDays(map);
			remainThisPrevTime = PaidHolidayPart.getMapLastRemainHour(map);
			// Lx\萔iNxj
			remainThisThisDays = PaidHolidayPart.getMapRemainDays(map);
			remainThisThisTime = PaidHolidayPart.getMapRemainHour(map);
			if (part().mospcode().useHourPaidHolidayFunction()) {
				possibleThisTime = PaidHolidayPart.getMapPossible(map);
			}
		}
		PaidHolidayConfirmCardVo vo = (PaidHolidayConfirmCardVo)getVo();
		// VOɏݒ
		vo.setLblThisMGet(String.valueOf(supplyDays) + CommonConst.NAM_DAY);
		vo.setLblThisMGetTime(String.valueOf(paymentTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblThisMDispose(String.valueOf(wasteDays) + CommonConst.NAM_DAY);
		vo.setLblThisMDisposeTime(String.valueOf(wasteTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblThisMRestLY(String.valueOf(remainThisPrevDays) + CommonConst.NAM_DAY);
		vo.setLblThisMRestTimeLY(String.valueOf(remainThisPrevTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblThisMRestTY(String.valueOf(remainThisThisDays) + CommonConst.NAM_DAY);
		vo.setLblThisMRestTimeTY(String.valueOf(remainThisThisTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblPaidHolidayLY(String.valueOf(lastRemainDays) + CommonConst.NAM_DAY);
		vo.setLblPaidHolidayTimeLY(String.valueOf(lastRemainTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblPaidHolidayTY(String.valueOf(remainDays) + CommonConst.NAM_DAY);
		vo.setLblPaidHolidayTimeTY(String.valueOf(remainTime) + CommonConst.NAM_COMMON_TIME);
		vo.setLblPaidHolidayPossibleTime(NumberUtil.getNumberString(possibleTime, 2, 0) + CommonConst.NAM_COMMON_TIME);
		vo.setLblPaidHolidayPossibleThisTime(NumberUtil.getNumberString(possibleThisTime, 2, 0)
				+ CommonConst.NAM_COMMON_TIME);
	}
	
}
