/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.AttendanceQuitCardVo;
import jp.mosp.kintai.schedule.dto.MScheduleDto;

/**
 * @author yoshida
 *
 */
public class AttendanceQuitCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_QUIT_CARD_SHOW		= "K1110";
	private static final String	CMD_QUIT_CARD_REGIST	= "K1112";
	private static final String	CMD_QUIT_CARD_DELETE	= "K1113";
	private static final String	CMD_QUIT_CARD_DRAFT		= "K1114";
	private static final String	CMD_QUIT_CARD_REFLECT	= "K1115";
	private static final String	CMD_QUIT_CARD_CALCULATE	= "K1116";
	

	/**
	 * RXgN^
	 */
	public AttendanceQuitCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_QUIT_CARD_SHOW)) {
			// I
			select();
		} else if (cmd.equals(CMD_QUIT_CARD_REGIST)) {
			// o^
			regist(false);
		} else if (cmd.equals(CMD_QUIT_CARD_DELETE)) {
			// 폜
			delete();
		} else if (CMD_QUIT_CARD_DRAFT.equals(cmd)) {
			// 
			regist(true);
		} else if (CMD_QUIT_CARD_REFLECT.equals(cmd)) {
			// \̔f
			reflect();
		} else if (CMD_QUIT_CARD_CALCULATE.equals(cmd)) {
			// Wv
			runCalc();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceQuitCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceQuitCardVo vo = (AttendanceQuitCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// 蓖ꗗ
		vo.setAryAllowance(getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME));
		// ދΎx敪v_E
		vo.aryPltHalfHoliday = getHalfHolidayArray();
		// ޗRv_E
		vo.aryPltLeaveEarlyReason = getReasonCodeArray(CommonConst.TID_LEAVE_EARLY_REASON);
		// ޏؖv_E
		vo.aryPltLeaveEarlyCertificate = getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu();
	}
	
	@Override
	protected void select() throws Exception {
		AttendanceQuitCardVo vo = (AttendanceQuitCardVo)getVo();
		// \̏
		setAttendanceInfo();
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), false);
		// f[^̑݊mF
		chkExist(dto);
		if (StringUtil.isNull(dto.getTaJikoku())) {
			// ދ΍ږ
			vo.initFields();
		} else {
			// ދ΍ڗL
			// VOɏݒ
			vo.setFields(dto);
			// 
			if (!KintaiApprovalPart.isDraft(dto)) {
				vo.setDraft(false);
			}
		}
		// \[h̃Zbg
		setMode(dto);
		// x\̃Zbg
		vo.setLabelInfo(dto);
		vo.setLblWorkType(part().kintai().getWorkTypeNameForKinmu(dto, false));
		// ԊOxΉ
		setOverTimeCaution(vo.getHidKCode(), DateUtil.convStringDateToDate(vo.getHidDate()));
	}
	
	/**
	 * ދΓo^
	 * @param isDraft	tO
	 * @throws Exception	Oꍇ
	 */
	private void regist(boolean isDraft) throws Exception {
		AttendanceQuitCardVo vo = (AttendanceQuitCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), true);
		// Αӌ
		if (VariousUtil.isNull(dto)) {
			// Αӈꗗ֖߂(ΑӃf[^ꍇ)
			String errMessage = getMessage(CommonConst.MSG_NO_ATTENDANCE, "");
			addErrMessage(errMessage);
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			throw new MospException(CommonConst.EX_NO_ATTENDANCE, errMessage);
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (KintaiApprovalPart.isApproved(dto)) {
				// bZ[Wݒ
				setMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
			} else {
				// UPDATE
				// rmF
				chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
				// VO̒lZbg
				vo.setDtoFields(dto);
				// f
				if (isDraft) {
					dto.setSnRiyuu(CommonConst.CODE_DRAFT);
				}
				boolean updateFlag = true;
				Date targetDate = DateUtil.convStringDateToDate(dto.getHizuke());
				// ߌ㔼x̏ꍇAc`FbNB
				if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestQuitHalf(dto)) {
						updateFlag = checkRemainPaidHoliday(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY, 0);
					}
				}
				// ԊOx()̏ꍇAc`FbNB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isOverTimeSubHolidayQuit(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestQuitHalf(dto)) {
						updateFlag = checkRemainSubstitute(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY);
					}
				}
				if (updateFlag) {
					// ߑOxAߌ㔼xAԒPʂ̔Nx̏FꍇAf
					margeHolidayRequest(dto);
					// vZ
					runAutoQuitCalc(dto);
					// XV
					syukkinboDao().update(dto);
					// bZ[Wݒ
					setMessage(getMessage(MospConst.MSG_UPDATE, ""));
				}
			}
		}
		// R~bg
		commit();
		// Αӈꗗ֑J
		setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
	}
	
	/**
	 * \̔f
	 * @throws Exception	Oꍇ
	 */
	private void reflect() throws Exception {
		AttendanceQuitCardVo vo = (AttendanceQuitCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		String kCode = vo.getHidKCode();
		String strTargetDate = vo.getHidDate();
		MScheduleDto dto = part().kintai().getScheduleInfo(kCode, strTargetDate);
		if (VariousUtil.isNull(dto)) {
			MSyukkinboDto syukkinboDto = kintai().getSyukkinboInfo(kCode, strTargetDate);
			dto = kintai().createScheduleInfo(getBasisInfo(kCode), DateUtil.convStringDateToDate(strTargetDate),
					syukkinboDto.getKinmu());
		}
		if (KintaiCommonPart.isAvailableWorkType(dto)) {
			MSyukkinboDto syukkinboDto = KintaiCommonPart.copyToSyukkinbo(dto);
			vo.setDtoFields(syukkinboDto);
			syukkinboDto.setTaJikoku(dto.getTaJikoku());
			kintai().runCalculatedInfo(syukkinboDto);
			// xɐ\ƃ}[W
			margeHolidayRequest(syukkinboDto);
			vo.setFields(syukkinboDto);
			vo.setLabelInfo(syukkinboDto);
			vo.setLblWorkType(part().kintai().getWorkTypeNameForKinmu(dto, false));
		}
		setLabelAttendanceInfo(DateUtil.convStringDateToDate(vo.getHidDate()));
	}
	
	/**
	 * Wv
	 * @throws Exception	Oꍇ
	 */
	private void runCalc() throws Exception {
		AttendanceQuitCardVo vo = (AttendanceQuitCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate());
		vo.setDtoFields(dto);
		// Αӏݒ
		setCalcParam();
		// VOɃZbg
		kintai().runCalculatedInfo(dto);
		vo.setFields(dto);
		vo.setLabelInfo(dto);
		vo.setLblWorkType(part().kintai().getWorkTypeNameForKinmu(dto, false));
		// ԊOxΉ
		setOverTimeCaution(vo.getHidKCode(), DateUtil.convStringDateToDate(vo.getHidDate()), dto.getZaJikan());
	}
	
	/**
	 * vZ\bh
	 * @param dto		ΏDTO
	 * @throws Exception	Oꍇ
	 */
	private void runAutoQuitCalc(MSyukkinboDto dto) throws Exception {
		// Αӏݒ
		setCalcParam();
		// vZtOL̂
		//if (isAutoCalc) {
		// vZtO
		if (isDailyAutoCalc) {
			// ΑӍڌvZ
			kintai().runCalculatedInfo(dto);
		}
	}
	
}
