/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.human.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPHumanAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.human.vo.HumanListVo;

/**
 * @author yoshida
 *
 */
public class HumanListAction extends MosPHumanAction {
	
	// R}h
	private static final String	CMD_HUMAN_LIST_SHOW			= "H1010";
	private static final String	CMD_HUMAN_LIST_SEARCH		= "H1011";
	private static final String	CMD_HUMAN_LIST_RE_SEARCH	= "H1012";
	private static final String	CMD_HUMAN_LIST_SORT			= "H1013";
	

	/**
	 * RXgN^
	 */
	public HumanListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_HUMAN_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_HUMAN_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_HUMAN_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_HUMAN_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HumanListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		HumanListVo vo = (HumanListVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		if (vo.aryPltPositionAll == null) {
			vo.aryPltOfficeAll = getOfficeArrayAll();
			vo.aryPltOffice = getOfficeArray();
			vo.aryPltSectionAll = getSectionArrayAll();
			vo.aryPltSection = getSectionArrayForHuman();
			vo.aryPltPositionAll = getPositionArrayAll();
			vo.aryPltPosition = getPositionTitleArray();
			vo.aryPltRetirement = StringUtil.getRetirementFlagArrayAll();
		}
	}
	
	@Override
	protected void show() throws Exception {
		HumanListVo vo = (HumanListVo)getVo();
		vo.setPltRetirement(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF));
	}
	
	@Override
	protected void search() throws Exception {
		HumanListVo vo = (HumanListVo)getVo();
		vo.setParams(request);
		serachEmployeeList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		HumanListVo vo = (HumanListVo)getVo();
		removeSessionDto();
		serachEmployeeList();
		vo.setPageButton();
		sortList();
	}
	
	/**
	 * ЈXg
	 * @throws Exception	Oꍇ
	 */
	private void serachEmployeeList() throws Exception {
		HumanListVo vo = (HumanListVo)getVo();
		// VOɐݒ
		vo.setFields(humanBasisDao().findForHumanList(vo.getTxtKCode(), vo.getTxtKName(), vo.getPltOffice(),
				vo.getPltSection(), vo.getPltPosition(), vo.getPltRetirement()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryKCode().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		HumanListVo vo = (HumanListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_OFFICE)) {
			comp = new CompOffice();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else if (key.equals(vo.KEY_RETIREMENT)) {
			comp = new CompRetirement();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5119036808145029871L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 193124556803850458L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}
	
	/**
	 * ƏR[hɂrNX
	 */
	protected static class CompOffice implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 4714384681014176376L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getJCode().compareTo(dto2.getJCode());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -541480811429249595L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * EijɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6565419791696911049L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}
	
	/**
	 * ގГɂrNX
	 */
	protected static class CompRetirement implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5285750385665762813L;
		

		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getKnKubun().compareTo(dto2.getKnKubun());
		}
	}
	
}
