/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.human.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPHumanAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.human.vo.HumanKihonCardVo;

/**
 * @author yoshida
 *
 */
public class HumanKihonCardAction extends MosPHumanAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_HUMAN_BASIS_SHOW	= "H1020";
	/**
	 * 
	 */
	public static final String	CMD_HUMAN_BASIS_SELECT	= "H1021";
	private static final String	CMD_HUMAN_BASIS_INSERT	= "H1022";
	private static final String	CMD_HUMAN_BASIS_UPDATE	= "H1023";
	

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_HUMAN_BASIS_SHOW)) {
			// \(VK)
			show();
		} else if (cmd.equals(CMD_HUMAN_BASIS_SELECT)) {
			// \(ЈR[hŏ)
			select();
		} else if (cmd.equals(CMD_HUMAN_BASIS_INSERT)) {
			// o^
			insert();
		} else if (cmd.equals(CMD_HUMAN_BASIS_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HumanKihonCardVo();
	}
	
	/**
	 * 
	 */
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// {^eݒ
		setListButton();
		// v_Eݒ
		setPulldown();
		// @\{^ݒ
		setFunctionButton(false);
	}
	
	@Override
	protected void show() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// [hݒ
		vo.setMode(HumanKihonCardVo.MODE_INSERT);
		// IЈR[h擾
		// VO
		vo.initFields();
		// IЈR[h擾
		vo.setTxtKCode(vo.getTxtChangeKCode());
		Date date = DateUtil.getSystemDate();
		vo.setPltEntranceYear(String.valueOf(MospUtility.getYear(date)));
		vo.setPltEntranceMonth(String.valueOf(MospUtility.getMonth(date)));
		vo.setPltEntranceDay(String.valueOf(MospUtility.getDay(date)));
		// @\{^ݒ
		setFunctionButton(true);
	}
	
	@Override
	protected void select() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// \(ЈR[hŏ)
		// IЈR[h擾
		String kCode = "";
		if (StringUtil.isNotNull(vo.getTxtChangeKCode())) {
			kCode = vo.getTxtChangeKCode();
		} else if (StringUtil.isNotNull(key1)) {
			kCode = key1;
		} else {
			kCode = vo.getTxtKCode();
		}
		// l{擾
		getHumanBasisInfo(kCode);
		// ZbVDTOZbg
		setStoredDto();
	}
	
	@Override
	protected void insert() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		// }X^f[^݊mF
		chkDuplicate(humanBasisDao().findForKey(vo.getTxtKCode()));
		// o^
		String message = regist();
		// R~bg
		commit();
		// l{擾
		getHumanBasisInfo(vo.getTxtKCode());
		// bZ[Wݒ
		vo.setMessage(message);
		// ZbVDTOZbg
		setStoredDto();
	}
	
	@Override
	protected void update() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// ZbVێDTO擾
		getStoredDto();
		// p[^̑ÓmF
		vo.validate();
		// o^
		String message = regist();
		// R~bg
		commit();
		// l{擾
		getHumanBasisInfo(vo.getTxtKCode());
		// bZ[Wݒ
		vo.setMessage(message);
		// ZbVDTOZbg
		setStoredDto();
	}
	
	/**
	 * v_Eݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setPulldown() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// v_Eݒ
		if (vo.aryPltSectionAll != null) {
			return;
		}
		vo.aryPltOfficeAll = getOfficeArrayAll();
		vo.aryPltOffice = getOfficeArray();
		vo.aryPltSectionAll = getSectionArrayAll();
		vo.aryPltSection = getSectionArrayForHuman();
		vo.aryPltPositionAll = getPositionArrayAll();
		vo.aryPltPosition = getPositionPltArray();
		vo.aryPltRetirement = StringUtil.getRetirementFlagArray();
		final int former = 80;
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), former, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	/**
	 * 擾
	 * @param kCode 擾ΏێЈR[h
	 * @throws Exception	Oꍇ
	 */
	protected void getHumanBasisInfo(String kCode) throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// l{擾
		findHumanBasisInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKihonDto == null) {
			vo.addErrMessage(getMessage(CommonConst.MSG_NO_HUMAN_DATA, ""));
			vo.setTxtChangeKCode(kCode);
			show();
			return;
		}
		// VO
		vo.initFields();
		vo.setTxtChangeKCode(kCode);
		// VOɏݒ
		vo.setFields(mKihonDto);
		vo.setMode(HumanKihonCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmKihonDto = mKihonDto;
		// rݒ
		String editor = setExclusive(CommonConst.EXC_HUMAN_BASIS, user.getUserId(), kCode);
		if (editor != null) {
			vo.addErrMessage(getMessage(CommonConst.MSG_EXCLUSIVE, editor));
		}
		setNeedExclusive(true);
	}
	
	/**
	 * o^
	 * @return bZ[W
	 * @throws Exception	Oꍇ
	 */
	protected String regist() throws Exception {
		HumanKihonCardVo vo = (HumanKihonCardVo)getVo();
		// DTO
		mKihonDto = storedmKihonDto;
		if (mKihonDto == null) {
			mKihonDto = new MKihonDto();
		}
		vo.setDtoFields(mKihonDto);
		// ݊mF
		String message = "";
		MKihonDto duplicateDto = humanBasisDao().findForUpdate(mKihonDto.getKCode());
		if (duplicateDto == null) {
			// VKo^
			humanBasisDao().insert(mKihonDto);
			applyHistory(mKihonDto.getKCode(), false);
			message = getMessage(MospConst.MSG_INSERT, "");
		} else {
			// XV
			humanBasisDao().update(mKihonDto);
			applyHistory(mKihonDto.getKCode(), true);
			message = getMessage(MospConst.MSG_UPDATE, "");
		}
		return message;
	}
	
}
