/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.common.part;

import jp.mosp.common.common.MospException;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.part.PartStore;

/**
 * MosPΑӊǗPartێNX
 * @author yoshida
 *	@version 0.0.5
 */
public class KintaiPartStore extends PartStore {
	
	/**
	 * RXgN^
	 */
	public KintaiPartStore() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	private KintaiPartStore(PartInfo partInfo) {
		this();
		setPartInfo(partInfo);
	}
	
	/**
	 * KintaiPartStoreCX^X
	 * @param partInfo		Part𗘗pۂɕKvȏ
	 * @return	KintaiPartStoreCX^X
	 */
	public static KintaiPartStore getInstance(PartInfo partInfo) {
		return new KintaiPartStore(partInfo);
	}
	
	/**
	 * CalculatePartCX^X擾
	 * @return	ςCalculatePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public CalculatePart calculate() throws MospException {
		return (CalculatePart)get(CalculatePart.class);
	}
	
	/**
	 * HumanPartCX^X擾
	 * @return	ςHumanPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public HumanPart human() throws MospException {
		return (HumanPart)get(HumanPart.class);
	}
	
	/**
	 * SectionPartCX^X擾
	 * @return	ςSectionPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public SectionPart section() throws MospException {
		return (SectionPart)get(SectionPart.class);
	}
	
	/**
	 * OfficePartCX^X擾
	 * @return	ςOfficePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public OfficePart office() throws MospException {
		return (OfficePart)get(OfficePart.class);
	}
	
	/**
	 * WorkTypePartCX^X擾
	 * @return	ςWorkTypePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public WorkTypePart worktype() throws MospException {
		return (WorkTypePart)get(WorkTypePart.class);
	}
	
	/**
	 * PositionPartCX^X擾
	 * @return	ςPositionPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public PositionPart position() throws MospException {
		return (PositionPart)get(PositionPart.class);
	}
	
	/**
	 * RotationPartCX^X擾
	 * @return	ςRotationPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public RotationPart rotation() throws MospException {
		return (RotationPart)get(RotationPart.class);
	}
	
	/**
	 * KintaiApprovalPartCX^X擾
	 * @return	ςKintaiApprovalPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public KintaiApprovalPart kintaiApproval() throws MospException {
		return (KintaiApprovalPart)get(KintaiApprovalPart.class);
	}
	
	/**
	 * ApprovalPartCX^X擾
	 * @return	ςApprovalPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public ApprovalPart approval() throws MospException {
		return (ApprovalPart)get(ApprovalPart.class);
	}
	
	/**
	 * KintaiCommonPartCX^X擾
	 * @return	ςKintaiCommonPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public KintaiCommonPart kintai() throws MospException {
		return (KintaiCommonPart)get(KintaiCommonPart.class);
	}
	
	/**
	 * KintaiCompilePartCX^X擾
	 * @return	ςKintaiCompilePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public KintaiCompilePart compile() throws MospException {
		return (KintaiCompilePart)get(KintaiCompilePart.class);
	}
	
	/**
	 * OverTimePartCX^X擾
	 * @return	ςOverTimePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public OverTimePart overtime() throws MospException {
		return (OverTimePart)get(OverTimePart.class);
	}
	
	/**
	 * ExportPartCX^X擾
	 * @return	ςExportPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public ExportPart export() throws MospException {
		return (ExportPart)get(ExportPart.class);
	}
	
	/**
	 * HolidayRequestPartCX^X擾
	 * @since	0.0.2
	 * @return	ςHolidayRequestPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public HolidayRequestPart holidayRequest() throws MospException {
		return (HolidayRequestPart)get(HolidayRequestPart.class);
	}
	
	/**
	 * PaidHolidayPartCX^X擾
	 * @since	0.0.3
	 * @return	ςPaidHolidayPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public PaidHolidayPart paidHoliday() throws MospException {
		return (PaidHolidayPart)get(PaidHolidayPart.class);
	}
	
	/**
	 * WorkflowPartCX^X擾
	 * @return ςWorkflowPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public WorkflowPart workflow() throws MospException {
		return (WorkflowPart)get(WorkflowPart.class);
	}
	
	/**
	 * LaborAgreementPartCX^X擾
	 * @since 0.0.5
	 * @return ςLaborAgreementPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public LaborAgreementPart laborAgreement() throws MospException {
		return (LaborAgreementPart)get(LaborAgreementPart.class);
	}
	
	/**
	 * SubstituteHolidayPartCX^X擾
	 * @since 0.0.6
	 * @return ςSubstituteHolidayPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public SubstituteHolidayPart subHoliday() throws MospException {
		return (SubstituteHolidayPart)get(SubstituteHolidayPart.class);
	}
	
}
