/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.payroll.dao.CompileAmendmentDao;
import jp.mosp.kintai.payroll.dao.KdWorkDao;
import jp.mosp.kintai.payroll.dao.MKintaiDao;
import jp.mosp.kintai.payroll.dao.MKintaiKinmuDao;
import jp.mosp.kintai.payroll.dto.CompileAmendmentDto;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.dto.KintaiCompileDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.dto.MKintaiKinmuDto;
import jp.mosp.mospcommon.system.AgreementBaseInfo;

/**
 * ΑӏWvpPartNX
 * @author yoshida
 *	@version	0.0.8
 */
public class KintaiCompilePart extends KintaiBasePart {
	
	/**
	 * M_KINTAI
	 */
	public static final String	KINTAI_TABLE		= MKintaiDao.TABLE;
	
	/**
	 * KD_WORK
	 */
	public static final String	KINTAI_NEW_TABLE	= KdWorkDao.TABLE;
	

	/**
	 * RXgN^
	 */
	public KintaiCompilePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public KintaiCompilePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MKintaiDaoCX^X
	 */
	private MKintaiDao	kintaiDao;
	

	/**
	 * ΑӏWve[upDAO̎擾
	 * @since	0.0.3
	 * @return	ςMKintaiDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MKintaiDao getMKintaiDao() throws Exception {
		if (VariousUtil.isNull(kintaiDao)) {
			kintaiDao = (MKintaiDao)getPreparedDao(MKintaiDao.class.getCanonicalName());
		}
		return kintaiDao;
	}
	

	/**
	 * MKintaiKinmuDaoCX^X
	 */
	private MKintaiKinmuDao	kinmuDao;
	

	/**
	 * Ζ`ԕʋΑӏWve[upDAO̎擾
	 * @since	0.0.3
	 * @return	ςMKintaiKinmuDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MKintaiKinmuDao getMKintaiKinmuDao() throws Exception {
		if (VariousUtil.isNull(kinmuDao)) {
			kinmuDao = (MKintaiKinmuDao)getPreparedDao(MKintaiKinmuDao.class.getCanonicalName());
		}
		return kinmuDao;
	}
	

	/**
	 * CompileAmendmentDaoCX^X
	 */
	private CompileAmendmentDao	amendmentDao;
	

	/**
	 * ΑӏWvpDAO̎擾
	 * @since	0.0.5
	 * @return	ςCompileAmendmentDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public CompileAmendmentDao getCompileAmendmentDao() throws Exception {
		if (VariousUtil.isNull(amendmentDao)) {
			amendmentDao = (CompileAmendmentDao)getPreparedDao(CompileAmendmentDao.class.getCanonicalName());
		}
		return amendmentDao;
	}
	

	private KdWorkDao	kdWorkDao;
	

	/**
	 * ΑӏWvpDAO̎擾
	 * @return ςKdWorkDaoCX^X
	 * @throws MospException 	MosPOꍇ
	 */
	public KdWorkDao getKdWorkDao() throws MospException {
		if (VariousUtil.isNull(kdWorkDao)) {
			kdWorkDao = (KdWorkDao)getPreparedDao(KdWorkDao.class.getCanonicalName());
		}
		return kdWorkDao;
	}
	
	/**
	 * ΑӏWvij擾
	 * @param kCode ΏێЈR[h
	 * @param yearMonth Ώ۔N
	 * @return ΑӏWvij
	 * @throws Exception  	Oꍇ
	 */
	public MKintaiDto getKintaiInfo(String kCode, Date yearMonth) throws Exception {
		return getMKintaiDao().findForKey(kCode, DateUtil.convDateToStringYearMonthShort(yearMonth));
	}
	
	/**
	 * ΑӏWvij擾
	 * @param kCode ΏێЈR[h
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return ΑӏWvij
	 * @throws Exception  	Oꍇ
	 */
	public MKintaiDto getKintaiInfo(String kCode, int year, int month) throws Exception {
		return getKintaiInfo(kCode, DateUtil.getYearMonth(year, month));
	}
	
	/**
	 * ΑӏWviVj擾
	 * @param kCode ΏێЈR[h
	 * @param yearMonth Ώ۔N
	 * @return ΑӏWviVj
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public KdWorkDto getKdWorkInfo(String kCode, Date yearMonth) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getKdWorkDao().findForKey(kCode, DateUtil.convDateToStringYearMonthShort(yearMonth));
	}
	
	/**
	 * ΑӏWviVj擾
	 * @param kCode ΏێЈR[h
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return ΑӏWviVj
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public KdWorkDto getKdWorkInfo(String kCode, String year, String month) throws SQLException,
			IllegalAccessException, NoSuchFieldException, MospException {
		return getKdWorkInfo(kCode, DateUtil.getYearMonth(year, month));
	}
	
	/**
	 * ΑӏWviVj擾
	 * @param kCode ΏێЈR[h
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return ΑӏWviVj
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public KdWorkDto getKdWorkInfo(String kCode, int year, int month) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getKdWorkInfo(kCode, DateUtil.getYearMonth(year, month));
	}
	
	/**
	 * ΏۏoΕE\냊XgΑӏWv擾
	 * @param kCode				ΏێЈR[h
	 * @param attendanceList	Ώ۔NoΕE\냊Xg
	 * @param useApprovalFunction	ΑӏF@\tO
	 * @return	oΕE\냊XgΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public KintaiCompileDto getCompiledInfo(String kCode, List<?> attendanceList, boolean useApprovalFunction)
			throws Exception {
		// J@ɑΉ
		return getReformCompiledInfo(kCode, attendanceList, useApprovalFunction);
	}
	
	/**
	 * Ώ۔NΑӏWvϊ
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param dto			Ώ۔NΑӏWvDTO
	 * @return	ΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public MKintaiDto convCompileToKintai(String kCode, Date targetMonth, KintaiCompileDto dto) throws Exception {
		// DTȌ
		MKintaiDto kintaiDto = new MKintaiDto();
		// DTOɒlZbg
		margeKintaiAndCompile(kCode, targetMonth, part().calculate().getCalcPayment(targetMonth), kintaiDto, dto);
		return kintaiDto;
	}
	
	/**
	 * Ώ۔NΑӏWvϊ
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param dto			Ώ۔NΑӏWvDTO
	 * @return	ΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public KdWorkDto convNewCompileToKintai(String kCode, Date targetMonth, KintaiCompileDto dto) throws Exception {
		// DTȌ
		KdWorkDto kdWorkDto = new KdWorkDto();
		// DTOɒlZbg
		margeKdWorkAndCompile(kCode, targetMonth, part().calculate().getCalcPayment(targetMonth), kdWorkDto, dto);
		return kdWorkDto;
	}
	
	/**
	 * Ώ۔NΑӏWv}[W
	 * @param kCode 	ΏێЈR[h
	 * @param targetMonth Ώ۔N
	 * @param paymentDate xN
	 * @param kintaiDto ΏDTO
	 * @param compileDto Ώ۔NΑӏWvDTO
	 */
	public static void margeKintaiAndCompile(String kCode, Date targetMonth, Date paymentDate, MKintaiDto kintaiDto,
			KintaiCompileDto compileDto) {
		MKintaiDto dto = kintaiDto;
		if (VariousUtil.isNotNull(kintaiDto)) {
			// ЈR[h
			dto.setKCode(kCode);
			// xN
			dto.setSikyuYM(DateUtil.convDateToStringYearMonthShort(targetMonth));
			// xN
			dto.setSNen(MospUtility.getYear(paymentDate));
			// x
			dto.setSTuki(MospUtility.getMonth(paymentDate));
			// x
			dto.setSHi(MospUtility.getDay(paymentDate));
			if (VariousUtil.isNotNull(compileDto)) {
				// oΓ
				dto.setSNissu(compileDto.getTotalWorkDays());
				// oΉ
				dto.setSKaisu(compileDto.getTotalWorkNumber());
				// Ζԍv
				dto.setKinmuJi(compileDto.getTotalWork());
				// xeԍv
				dto.setKyukeiJi(compileDto.getTotalInterbal());
				// Lxɓ
				dto.setYukyu(compileDto.getTotalPaidHoliday());
				// ʋxɓ
				dto.setTokuKyu(compileDto.getTotalParticularHoliday());
				// ΋xɓ
				dto.setKekkin(compileDto.getTotalAbsence());
				// axɓ
				dto.setSKekkin(compileDto.getTotalMedicalLeave());
				// x
				dto.setDaiKyu(compileDto.getTotalCompensationDay());
				// U֋xɓ
				dto.setFurikae(compileDto.getTotalTransfer());
				// ̑xɐ
				double totalOther = compileDto.getTotalOther();
				totalOther += compileDto.getTotalKkRiyuu6();
				totalOther += compileDto.getTotalKkRiyuu7();
				totalOther += compileDto.getTotalKkRiyuu8();
				totalOther += compileDto.getTotalKkRiyuu9();
				// xɓ
				dto.setSonota(Double.valueOf(totalOther).intValue());
				// xސ
				dto.setTiSoKai(compileDto.getLeaveAndLate());
				// xގԍv
				dto.setTiJikan(compileDto.getTotalLeaveAndLate());
				// cƎԍv
				dto.setZaJikan(compileDto.getTotalOver());
				// xoԍv
				dto.setKsJikan(compileDto.getTotalHolidayWork());
				// [鎞ԍv
				dto.setSnJikan(compileDto.getTotalLateNight());
				// F
				dto.setKaikin(0);
				if (compileDto.isApplyAttendanceAllowance()) {
					dto.setKaikin(1);
				}
				// 蓖
				// H蓖v
				dto.setSyokujiKaisu(compileDto.getSyokuji());
				// P蓖v
				dto.setCyokuKaisu1(compileDto.getCyoku1());
				// Q蓖v
				dto.setCyokuKaisu2(compileDto.getCyoku2());
				// R蓖v
				dto.setCyokuKaisu3(compileDto.getCyoku3());
				// ̑蓖Pv
				dto.setHokaKaisu1(compileDto.getHoka1());
				// ̑蓖Qv
				dto.setHokaKaisu2(compileDto.getHoka2());
				// ̑蓖Rv
				dto.setHokaKaisu3(compileDto.getHoka3());
				// ̑蓖Sv
				dto.setHokaKaisu4(compileDto.getHoka4());
				// ̑蓖Tv
				dto.setHokaKaisu5(compileDto.getHoka5());
				// ԒPʔNxv
				dto.setNijiKyu(compileDto.getUnitHourHoliday());
				// 1.00
				dto.setWarimasi1(compileDto.getWarimasi1());
			}
		}
	}
	
	/**
	 * ΑӏWvijKintaiCompileDto֕ϊ
	 * @param dto ΏDTO
	 * @return ϊΑӏWv
	 */
	public static KintaiCompileDto convKintaiToCompile(MKintaiDto dto) {
		KintaiCompileDto compileDto = new KintaiCompileDto();
		if (VariousUtil.isNotNull(dto)) {
			// oΓ
			compileDto.setTotalWorkDays(dto.getSNissu());
			// oΉ
			compileDto.setTotalWorkNumber(dto.getSKaisu());
			// Ζԍv
			compileDto.setTotalWork(dto.getKinmuJi());
			// xeԍv
			compileDto.setTotalInterbal(dto.getKyukeiJi());
			// Lxɓ
			compileDto.setTotalPaidHoliday(dto.getYukyu());
			// ʋxɓ
			compileDto.setTotalParticularHoliday(dto.getTokuKyu());
			// ΋xɓ
			compileDto.setTotalAbsence(dto.getKekkin());
			// axɓ
			compileDto.setTotalMedicalLeave(dto.getSKekkin());
			// x
			compileDto.setTotalCompensationDay(dto.getDaiKyu());
			// U֋xɓ
			compileDto.setTotalTransfer(dto.getFurikae());
			// xɓ
			compileDto.setTotalOther(dto.getSonota());
			// xސ
			compileDto.setLeaveAndLate(dto.getTiSoKai());
			// xގԍv
			compileDto.setTotalLeaveAndLate(dto.getTiJikan());
			// cƎԍv
			compileDto.setTotalOver(dto.getZaJikan());
			// xoԍv
			compileDto.setTotalHolidayWork(dto.getKsJikan());
			// [鎞ԍv
			compileDto.setTotalLateNight(dto.getSnJikan());
			// F
			compileDto.setApplyAttendanceAllowance(StringUtil.isFlagOn(String.valueOf(dto.getKaikin())));
			// 蓖
			// H蓖v
			compileDto.setSyokuji(dto.getSyokujiKaisu());
			// P蓖v
			compileDto.setCyoku1(dto.getCyokuKaisu1());
			// Q蓖v
			compileDto.setCyoku2(dto.getCyokuKaisu2());
			// R蓖v
			compileDto.setCyoku3(dto.getCyokuKaisu3());
			// ̑蓖Pv
			compileDto.setHoka1(dto.getHokaKaisu1());
			// ̑蓖Qv
			compileDto.setHoka2(dto.getHokaKaisu2());
			// ̑蓖Rv
			compileDto.setHoka3(dto.getHokaKaisu3());
			// ̑蓖Sv
			compileDto.setHoka4(dto.getHokaKaisu4());
			// ̑蓖Tv
			compileDto.setHoka5(dto.getHokaKaisu5());
			// ԒPʔNxv
			compileDto.setUnitHourHoliday(dto.getNijiKyu());
			// 1.00
			compileDto.setWarimasi1(dto.getWarimasi1());
		}
		return compileDto;
	}
	
	/**
	 * ΑӌWv
	 * @param kCode				ΏێЈR[h
	 * @param targetMonth		Ώ۔N
	 * @param attendanceList 	Ώ۔NoΕE\냊Xg
	 * @return	ΑӌWv
	 * @throws Exception	Oꍇ
	 */
	public MKintaiDto getCompiledInfo(String kCode, Date targetMonth, List<?> attendanceList) throws Exception {
		// Ώ۔NΑӏWv
		return convCompileToKintai(kCode, targetMonth, getCompiledInfo(kCode, attendanceList, part().mospcode()
			.isAttendanceApprovalFunction()));
	}
	
	/**
	 * ΑӌWv
	 * @param kCode				ΏێЈR[h
	 * @param targetMonth		Ώ۔N
	 * @param attendanceList 	Ώ۔NoΕE\냊Xg
	 * @return	ΑӌWv
	 * @throws Exception	Oꍇ
	 */
	public KdWorkDto getNewCompiledInfo(String kCode, Date targetMonth, List<?> attendanceList) throws Exception {
		// Ώ۔NΑӏWv
		return convNewCompileToKintai(kCode, targetMonth, getCompiledInfo(kCode, attendanceList, part().mospcode()
			.isAttendanceApprovalFunction()));
	}
	
	/**
	 * FEF쐬
	 * @param attendanceList 	Ώ۔NoΕE\냊Xg
	 * @since	0.0.2
	 * @return [0]cFA[1]cFA[2]coΌ
	 */
	public static int[] makeApprovalNumber(List<MSyukkinboDto> attendanceList) {
		// z񏉊
		int[] number = { 0, 0, 0 };
		// oΌ
		number[2] = attendanceList.size();
		for (MSyukkinboDto dto : attendanceList) {
			// ꎟFA񎟏F
			if (KintaiApprovalPart.is2ndApproved(dto)) {
				number[0]++;
			} else {
				number[1]++;
			}
		}
		return number;
	}
	
	/**
	 * ΑӏWv擾
	 * @param kCode		ΏێЈR[h
	 * @param yearMonth Ώ۔N
	 * @param sCode		ΏۏR[h
	 * @return	ΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public CompileAmendmentDto getCompileAmendmentInfo(String kCode, Date yearMonth, String sCode) throws Exception {
		String sikyuYM = DateUtil.convDateToStringYearMonthShort(yearMonth);
		if (MosPCodePart.afterLegalReformDate(yearMonth)) {
			if (DateUtil.getLegalReformDate().compareTo(yearMonth) == 0) {
				// 2010N4̏ꍇ
				if (part().calculate().getMinusMonth() == 0) {
					// ΑӒ̏ꍇ
					return getCompileAmendmentDao().findForNewTable(kCode, sikyuYM, sCode);
				} else {
					// ΑӒȌꍇ
					return getCompileAmendmentDao().findForCondition(kCode, sikyuYM, sCode);
				}
			} else {
				// 2010N5ȍ~
				return getCompileAmendmentDao().findForNewTable(kCode, sikyuYM, sCode);
			}
		} else {
			return getCompileAmendmentDao().findForCondition(kCode, sikyuYM, sCode);
		}
	}
	
	/**
	 * FL
	 * @since	0.0.6
	 * @param attendanceList	Ώ۔NoΕE\냊Xg
	 * @return truecFAfalsecFL
	 */
	public static boolean checkApproval(List<MSyukkinboDto> attendanceList) {
		// FEF쐬
		int[] number = makeApprovalNumber(attendanceList);
		if (number[2] > 0) {
			// F
			return number[1] == 0;
		} else if (number[2] == 0) {
			// oΌ0̏ꍇ
			return true;
		}
		return false;
	}
	
	/**
	 * Ζ`ԕʋΑӌWv
	 * @since	0.0.7
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param workType		ΏۋΖ`ԃR[h
	 * @param attendanceList 	Ώ۔NoΕE\냊Xg
	 * @param inputUnit ͒P
	 * @return	mKinmuDto	Wvς݋Ζ`ԕʏWvDTO
	 * @throws Exception  @Oꍇ
	 */
	public MKintaiKinmuDto getCompileForWorkType(String kCode, Date targetMonth, String workType,
			List<?> attendanceList, int inputUnit) throws Exception {
		MKintaiKinmuDto kinmuDto = new MKintaiKinmuDto();
		// ϐ錾Aϐ̏
		// cƎԌv
		int totalOver = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// oΓv
		int totalWorkDays = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// WvJn
		for (Object obj : attendanceList) {
			KintaiCommonDtoInterface dto = (KintaiCommonDtoInterface)obj;
			// ΑӍ
			if (dto.getKinmu().equals(workType)) {
				// cƎ
				totalOver += dto.getZaJikan();
				// [鎞
				totalLateNight += dto.getSnJikan();
				// xo
				totalHolidayWork += dto.getKsJikan();
				// oΓ
				if (dto.getKinmuJi() > 0) {
					totalWorkDays++;
				}
				// 蓖
				syokuji += dto.getSyokuji();
				cyoku1 += dto.getCyoku1();
				cyoku2 += dto.getCyoku2();
				cyoku3 += dto.getCyoku3();
				hoka1 += dto.getHoka1();
				hoka2 += dto.getHoka2();
				hoka3 += dto.getHoka3();
				hoka4 += dto.getHoka4();
				hoka5 += dto.getHoka5();
			}
		}
		// ۂߏf
		if (part().kintai().isRoundNumberMonthly()) {
			// ΑӏWvɊۂߏsB
			// cƎԍv
			totalOver = NumberUtil.roundIntegerNumber(totalWorkDays, inputUnit);
			// [鎞ԍv
			totalLateNight = NumberUtil.roundIntegerNumber(totalLateNight, inputUnit);
			// xoԍv
			totalHolidayWork = NumberUtil.roundIntegerNumber(totalHolidayWork, inputUnit);
		}
		// DTOɒlZbg
		kinmuDto.setKCode(kCode);
		// xN
		kinmuDto.setSikyuYM(DateUtil.convDateToStringYearMonthShort(targetMonth));
		// Ζ`ԃR[h
		kinmuDto.setKinmu(workType);
		// oΓ
		kinmuDto.setSNissu(totalWorkDays);
		// cƎԍv
		kinmuDto.setZaJikan(totalOver);
		// [鎞ԍv
		kinmuDto.setSZJikan(totalLateNight);
		// xoԍv
		kinmuDto.setHSJikan(totalHolidayWork);
		// 蓖
		// H蓖v
		kinmuDto.setSyokuji(syokuji);
		// P蓖v
		kinmuDto.setCyoku1(cyoku1);
		// Q蓖v
		kinmuDto.setCyoku2(cyoku2);
		// R蓖v
		kinmuDto.setCyoku3(cyoku3);
		// ̑蓖Pv
		kinmuDto.setHoka1(hoka1);
		// ̑蓖Qv
		kinmuDto.setHoka2(hoka2);
		// ̑蓖Rv
		kinmuDto.setHoka3(hoka3);
		// ̑蓖Sv
		kinmuDto.setHoka4(hoka4);
		// ̑蓖Tv
		kinmuDto.setHoka5(hoka5);
		return kinmuDto;
	}
	
	/**
	 * Ώ۔N̋ΑӏWvXg
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return Ώ۔N̋ΑӏWvXg
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public List<KdWorkDto> getKdWorkList(int year, int month) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getKdWorkList(String.valueOf(year), String.valueOf(month));
		
	}
	
	/**
	 * Ώ۔N̋ΑӏWvXg
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return Ώ۔N̋ΑӏWvXg
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public List<KdWorkDto> getKdWorkList(String year, String month) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getKdWorkDao().findForCondition(StringUtil.combineByHyphen(year, month));
		
	}
	
	/**
	 * 60ԒߕcƎԁi{xj̍v擾B
	 * @param dto ΏDTO
	 * @return Ώ۔N60ԒߕcƎԁi{xj̍v
	 */
	public static int getOver60HourOverTime(KdWorkDto dto) {
		int over60Hour = 0;
		if (VariousUtil.isNotNull(dto)) {
			over60Hour = dto.getMonthlyOverTime() + dto.getMonthlyWeekHoliday();
		}
		return over60Hour;
	}
	
	/**
	 * ΑӏWv擾
	 * @param kCode ΏێЈR[h
	 * @param yearMonth Ώ۔N
	 * @return ΑӏWv
	 * @throws Exception 	Oꍇ
	 */
	public KintaiCompileDto getCompileInfo(String kCode, Date yearMonth) throws Exception {
		MKintaiDto kintaiDto = getKintaiInfo(kCode, yearMonth);
		if (VariousUtil.isNotNull(kintaiDto)) {
			return convKintaiToCompile(kintaiDto);
		} else {
			KdWorkDto kdWorkDto = getKdWorkInfo(kCode, yearMonth);
			if (VariousUtil.isNotNull(kdWorkDto)) {
				return convKdWorkToCompile(kdWorkDto);
			}
			return getCompiledInfo(kCode, part().kintai().getAttendanceList(kCode,
					part().calculate().getStartDate(yearMonth), part().calculate().getEndDate(yearMonth)), part()
				.mospcode().isAttendanceApprovalFunction());
		}
	}
	
	/* J@{sΉ */

	/**
	 * ΏۏoΕE\냊XgΑӏWviJ@{sΉj擾
	 * @param kCode				ΏێЈR[h
	 * @param attendanceList	Ώ۔NoΕE\냊Xg
	 * @param useApprovalFunction	ΑӏF@\tO
	 * @return	oΕE\냊XgΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public KintaiCompileDto getReformCompiledInfo(String kCode, List<?> attendanceList, boolean useApprovalFunction)
			throws Exception {
		// DTȌ
		KintaiCompileDto compileDto = new KintaiCompileDto();
		// ϐ錾Aϐ̏
		// ΖԌv
		int totalWork = 0;
		// xeԌv
		int totalInterbal = 0;
		// xԌv
		int totalLate = 0;
		// ގԌv
		int totalLeave = 0;
		// cƎԌv
		int totalOver = 0;
		// xoԌv
		int totalHolidayWork = 0;
		// [鎞Ԍv
		int totalLateNight = 0;
		// oΓv
		double totalWorkDays = 0;
		// oΉ񐔌v
		int totalWorkNumber = 0;
		// Lxv
		double totalPaidHoliday = 0;
		// ʋxɌv
		double totalParticularHoliday = 0;
		// Γv
		double totalAbsence = 0;
		// axɌv
		double totalMedicalLeave = 0;
		// xv
		double totalCompensationDay = 0;
		// U֋xɌv
		double totalTransfer = 0;
		// xɌv
		double totalOther = 0;
		// xސ
		int leaveAndLate = 0;
		// 蓖
		int syokuji = 0;
		int cyoku1 = 0;
		int cyoku2 = 0;
		int cyoku3 = 0;
		int hoka1 = 0;
		int hoka2 = 0;
		int hoka3 = 0;
		int hoka4 = 0;
		int hoka5 = 0;
		// ԒPʗLx
		int unitHourHoliday = 0;
		// xɗR6
		double totalVacationReason6 = 0;
		// xɗR7
		double totalVacationReason7 = 0;
		// xɗR8
		double totalVacationReason8 = 0;
		// xɗR9
		double totalVacationReason9 = 0;
		// ԊO
		int totalWeekDayOverTime = 0;
		// xԊO
		int totalHolidayOverTime = 0;
		// 60ԒߕԊO
		int totalMonthlyWeekDayOverTime = 0;
		// 60ԒߏxԊO
		int totalMonthlyHolidayOverTime = 0;
		// ԊO֋xɎ擾
		double substituteHoliday = 0;
		// 1.00
		int warimasi1 = 0;
		// ͒P
		int inputUnit = part().kintai().getInputUnitTimes();
		// WvJn
		for (Object obj : attendanceList) {
			KintaiCommonDtoInterface dto = (KintaiCommonDtoInterface)obj;
			// Ώ۔N
			Date date = DateUtil.convStringDateToDate(dto.getHizuke());
			// Jg̎擾
			AgreementBaseInfo agreement = part().laborAgreement().getUserLaborAgreement(kCode, date);
			// ΑӏF@\
			boolean compileFlag = true;
			if (useApprovalFunction && !KintaiApprovalPart.isApproved(dto)) {
				compileFlag = false;
			}
			if (compileFlag) {
				// ΑӍ
				if (KintaiCommonPart.isAvailableWorkType(dto)) {
					// vZ
					if (part().kintai().isMonthlyAutoCalc()) {
						part().kintai().runCalculatedInfo(dto);
					}
					// Ζ
					totalWork += dto.getKinmuJi();
					// xe
					totalInterbal += dto.getKyukeiJi();
					// x
					totalLate += dto.getTiJikan();
					// ގ
					totalLeave += dto.getSoJikan();
					// [鎞
					totalLateNight += dto.getSnJikan();
					// oΓ
					if (dto.getKinmuJi() > 0) {
						totalWorkDays++;
						totalWorkNumber++;
					}
					// xސ
					// ɒx/ނsꍇAxސꂼCNg
					if (dto.getTiJikan() > 0) {
						leaveAndLate++;
					}
					if (dto.getSoJikan() > 0) {
						leaveAndLate++;
					}
					// 蓖
					syokuji += dto.getSyokuji();
					cyoku1 += dto.getCyoku1();
					cyoku2 += dto.getCyoku2();
					cyoku3 += dto.getCyoku3();
					hoka1 += dto.getHoka1();
					hoka2 += dto.getHoka2();
					hoka3 += dto.getHoka3();
					hoka4 += dto.getHoka4();
					hoka5 += dto.getHoka5();
					// 60ԎԊOɂx
					if (KintaiCommonPart.isOverTimeSubHolidayHalf(dto)) {
						substituteHoliday += CommonConst.NUM_HALF_DAY;
						totalWorkDays -= CommonConst.NUM_HALF_DAY;
					}
					// x
					if (KintaiCommonPart.isHalfHoliday(dto)) {
						totalPaidHoliday += CommonConst.NUM_HALF_DAY;
						totalWorkDays -= CommonConst.NUM_HALF_DAY;
					}
					// ԔNx
					unitHourHoliday += dto.getNijiKyu();
					// 1.00
					warimasi1 += dto.getWarimasi1();
					// xftO
					boolean standardHoliday = part().laborAgreement().isStandardHoliday(date, agreement);
					// cƉZ
					int overTime = dto.getZaJikan();
					// xo
					int holidayWork = 0;
					// xof
					if (KintaiCommonPart.isWorkOnHoliday(dto)) {
						if (VariousUtil.isNotNull(agreement)) {
							if (LaborAgreementPart.isOfficialHoliday(date, agreement)) {
								holidayWork = dto.getKsJikan();
							}
						} else {
							// Jg肪ꍇA]ʂ
							overTime = 0;
							holidayWork = dto.getKsJikan();
						}
					}
					// xo
					totalHolidayWork += holidayWork;
					// ZcƎ
					int overAdded = overTime + totalOver;
					// 60Ԃ̑Ή
					if (totalOver > CommonConst.NUM_OVER_TIME_60_HOUR) {
						// totalOver݂̂60ԒĂꍇ
						if (standardHoliday) {
							// x̏ꍇ
							totalMonthlyHolidayOverTime += overTime;
						} else {
							// ̏ꍇ
							totalMonthlyWeekDayOverTime += overTime;
						}
					} else {
						// ǉɌ60Ԃ𒴂ꍇ
						if (overAdded > CommonConst.NUM_OVER_TIME_60_HOUR) {
							// 60Ԃ܂ł̎
							int gapTime = CommonConst.NUM_OVER_TIME_60_HOUR - totalOver;
							// 60Ԓߎ
							int overflowTime = overAdded - CommonConst.NUM_OVER_TIME_60_HOUR;
							if (standardHoliday) {
								// x̏ꍇ
								totalHolidayOverTime += gapTime;
								totalMonthlyHolidayOverTime += overflowTime;
							} else {
								// ̏ꍇ
								totalWeekDayOverTime += gapTime;
								totalMonthlyWeekDayOverTime += overflowTime;
							}
						} else {
							// vĂ60ԒȂꍇ
							if (standardHoliday) {
								// x̏ꍇ
								totalHolidayOverTime += overTime;
							} else {
								// ̏ꍇ
								totalWeekDayOverTime += overTime;
							}
						}
					}
					// cƎ
					totalOver += overTime;
				} else {
					// xɍ
					if (KintaiCommonPart.isHoliday(dto)) {
						String kkRiyuu = dto.getKKRiyuu();
						if (KintaiCommonPart.isAllHoliday(dto)) {
							// Lx
							totalPaidHoliday++;
						} else if (KintaiCommonPart.isParticularHoliday(kkRiyuu)) {
							// ʋx
							totalParticularHoliday++;
						} else if (KintaiCommonPart.isAbsence(kkRiyuu)) {
							// Γ
							totalAbsence++;
						} else if (KintaiCommonPart.isMedical(kkRiyuu)) {
							// ax
							totalMedicalLeave++;
						} else if (KintaiCommonPart.isCompensationHoliday(dto)) {
							// x
							totalCompensationDay++;
						} else if (KintaiCommonPart.isTransfer(kkRiyuu)) {
							// U֋x
							totalTransfer++;
						} else if (KintaiCommonPart.isHolidayReason6(kkRiyuu)) {
							// xeR6
							totalVacationReason6++;
						} else if (KintaiCommonPart.isHolidayReason7(kkRiyuu)) {
							// xeR7
							totalVacationReason7++;
						} else if (KintaiCommonPart.isHolidayReason8(kkRiyuu)) {
							// xeR8
							totalVacationReason8++;
						} else if (KintaiCommonPart.isHolidayReason9(kkRiyuu)) {
							// xeR9
							totalVacationReason9++;
						} else if (HolidayRequestPart.isSubHoliday(dto.getKKRiyuu())) {
							// 60ԎԊOɂx̎擾
							substituteHoliday++;
						} else {
							// x(LɓĂ͂܂Ȃꍇ)
							totalOther++;
						}
					}
				}
			}
		}
		// ۂߏf
		if (part().kintai().isRoundNumberMonthly()) {
			// ΑӏWvɊۂߏsB
			// ΖԌv
			totalWork = NumberUtil.roundIntegerNumber(totalWork, inputUnit);
			// xeԌv
			totalInterbal = NumberUtil.roundIntegerNumber(totalInterbal, inputUnit);
			// xԌv
			totalLate = NumberUtil.roundIntegerNumber(totalLate, inputUnit);
			// ގԌv
			totalLeave = NumberUtil.roundIntegerNumber(totalLeave, inputUnit);
			// cƎԌv
			totalOver = NumberUtil.roundIntegerNumber(totalOver, inputUnit);
			// xoԌv
			totalHolidayWork = NumberUtil.roundIntegerNumber(totalHolidayWork, inputUnit);
			// 1.00
			warimasi1 = NumberUtil.roundIntegerNumber(warimasi1, inputUnit);
			// ԊO
			totalWeekDayOverTime = NumberUtil.roundIntegerNumber(totalWeekDayOverTime, inputUnit);
			// xԊO
			totalHolidayOverTime = NumberUtil.roundIntegerNumber(totalHolidayOverTime, inputUnit);
			// 60
			totalMonthlyWeekDayOverTime = NumberUtil.roundIntegerNumber(totalMonthlyWeekDayOverTime, inputUnit);
			// 60
			totalMonthlyHolidayOverTime = NumberUtil.roundIntegerNumber(totalMonthlyHolidayOverTime, inputUnit);
		}
		// oΓ
		compileDto.setTotalWorkDays(totalWorkDays);
		// oΉ
		compileDto.setTotalWorkNumber(totalWorkNumber);
		// Ζԍv
		compileDto.setTotalWork(totalWork);
		// xeԍv
		compileDto.setTotalInterbal(totalInterbal);
		// Lxɓ
		compileDto.setTotalPaidHoliday(totalPaidHoliday);
		// ʋxɓ
		compileDto.setTotalParticularHoliday(totalParticularHoliday);
		// ΋xɓ
		compileDto.setTotalAbsence(totalAbsence);
		// axɓ
		compileDto.setTotalMedicalLeave(totalMedicalLeave);
		// x
		compileDto.setTotalCompensationDay(totalCompensationDay);
		// U֋xɓ
		compileDto.setTotalTransfer(totalTransfer);
		// xɓ
		compileDto.setTotalOther(totalOther);
		// xސ
		compileDto.setLeaveAndLate(leaveAndLate);
		// x
		compileDto.setTotalLate(totalLate);
		// ގ
		compileDto.setTotalLeave(totalLeave);
		// xގ
		compileDto.setTotalLeaveAndLate(totalLeave + totalLate);
		// cƎԍv
		compileDto.setTotalOver(totalOver);
		// xoԍv
		compileDto.setTotalHolidayWork(totalHolidayWork);
		// [鎞ԍv
		compileDto.setTotalLateNight(totalLateNight);
		// F΁i΁AʋxɁAaAxސ̍vj
		if ((totalAbsence + totalParticularHoliday + totalMedicalLeave + leaveAndLate) == 0 && totalWorkDays != 0) {
			compileDto.setApplyAttendanceAllowance(true);
		}
		// Eɂ蓖xݒ
		if (!part().position().isApplyAttendanceAllowance(kCode)) {
			compileDto.setApplyAttendanceAllowance(false);
		}
		// 蓖
		// H蓖v
		compileDto.setSyokuji(syokuji);
		// P蓖v
		compileDto.setCyoku1(cyoku1);
		// Q蓖v
		compileDto.setCyoku2(cyoku2);
		// R蓖v
		compileDto.setCyoku3(cyoku3);
		// ̑蓖Pv
		compileDto.setHoka1(hoka1);
		// ̑蓖Qv
		compileDto.setHoka2(hoka2);
		// ̑蓖Rv
		compileDto.setHoka3(hoka3);
		// ̑蓖Sv
		compileDto.setHoka4(hoka4);
		// ̑蓖Tv
		compileDto.setHoka5(hoka5);
		// ԒPʔNxv
		compileDto.setUnitHourHoliday(unitHourHoliday);
		// 1.00ԍv
		compileDto.setWarimasi1(warimasi1);
		// xeRUv
		compileDto.setTotalKkRiyuu6(totalVacationReason6);
		// xeRVv
		compileDto.setTotalKkRiyuu7(totalVacationReason7);
		// xeRWv
		compileDto.setTotalKkRiyuu8(totalVacationReason8);
		// xeRXv
		compileDto.setTotalKkRiyuu9(totalVacationReason9);
		// ԊO
		compileDto.setTotalWeekDayOverTime(totalWeekDayOverTime);
		// xԊO
		compileDto.setTotalWeekHolidayOverTime(totalHolidayOverTime);
		// 60ԒߕԊO
		compileDto.setTotalMonthlyOverTime(totalMonthlyWeekDayOverTime);
		// 60ԒߏxԊO
		compileDto.setTotalMonthlyWeekHoliday(totalMonthlyHolidayOverTime);
		// ԊOԊO֋xɓv
		compileDto.setTotalSubstituteHoliday(substituteHoliday);
		return compileDto;
	}
	
	/**
	 * Ώ۔NΑӏWv(V)ϊ
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param dto			Ώ۔NΑӏWvDTO
	 * @return	ΑӏWv
	 * @throws Exception	Oꍇ
	 */
	public KdWorkDto convCompileToKdWork(String kCode, Date targetMonth, KintaiCompileDto dto) throws Exception {
		// DTȌ
		KdWorkDto kdWorkDto = new KdWorkDto();
		// DTOɒlZbg
		margeKdWorkAndCompile(kCode, targetMonth, part().calculate().getCalcPayment(targetMonth), kdWorkDto, dto);
		return kdWorkDto;
	}
	
	/**
	 * Ώ۔NΑӏWv(V)}[W
	 * @param kCode 	ΏێЈR[h
	 * @param targetMonth Ώ۔N
	 * @param paymentDate xN
	 * @param kdWorkDto ΏDTO
	 * @param compileDto Ώ۔NΑӏWvDTO
	 */
	public static void margeKdWorkAndCompile(String kCode, Date targetMonth, Date paymentDate, KdWorkDto kdWorkDto,
			KintaiCompileDto compileDto) {
		KdWorkDto dto = kdWorkDto;
		if (VariousUtil.isNull(dto)) {
			dto = new KdWorkDto();
		}
		// ЈR[h
		dto.setKCode(kCode);
		// xN
		dto.setSikyuYm(DateUtil.convDateToStringYearMonthShort(targetMonth));
		// xN
		dto.setSNen(MospUtility.getYear(paymentDate));
		// x
		dto.setSTuki(MospUtility.getMonth(paymentDate));
		// x
		dto.setSHi(MospUtility.getDay(paymentDate));
		if (VariousUtil.isNotNull(compileDto)) {
			// oΓ
			dto.setSNissu(compileDto.getTotalWorkDays());
			// oΉ
			dto.setSKaisu(compileDto.getTotalWorkNumber());
			// Ζԍv
			dto.setKinmuJi(compileDto.getTotalWork());
			// xeԍv
			dto.setKyukeiJi(compileDto.getTotalInterbal());
			// Lxɓ
			dto.setYukyu(compileDto.getTotalPaidHoliday());
			// ʋxɓ
			dto.setTokukyu(compileDto.getTotalParticularHoliday());
			// ΋xɓ
			dto.setKekkin(compileDto.getTotalAbsence());
			// axɓ
			dto.setSKekkin(compileDto.getTotalMedicalLeave());
			// x
			dto.setDaikyu(compileDto.getTotalCompensationDay());
			// U֋xɓ
			dto.setFurikae(compileDto.getTotalTransfer());
			// xɗR6
			dto.setKkRiyuu6(compileDto.getTotalKkRiyuu6());
			// xɗR7
			dto.setKkRiyuu7(compileDto.getTotalKkRiyuu7());
			// xɗR8
			dto.setKkRiyuu8(compileDto.getTotalKkRiyuu8());
			// xɗR9
			dto.setKkRiyuu9(compileDto.getTotalKkRiyuu9());
			// xɓ
			dto.setSonota(compileDto.getTotalOther());
			// xސ
			dto.setTiSoKai(compileDto.getLeaveAndLate());
			// xގԍv
			dto.setTiSoJikan(compileDto.getTotalLeaveAndLate());
			// cƎԍv
			dto.setZaJikan(compileDto.getTotalOver());
			// xoԍv
			dto.setKsJikan(compileDto.getTotalHolidayWork());
			// [鎞ԍv
			dto.setSnJikan(compileDto.getTotalLateNight());
			// F
			dto.setKaikin(0);
			if (compileDto.isApplyAttendanceAllowance()) {
				dto.setKaikin(1);
			}
			// 蓖
			// H蓖v
			dto.setSyokujiKaisu(compileDto.getSyokuji());
			// P蓖v
			dto.setCyokuKaisu1(compileDto.getCyoku1());
			// Q蓖v
			dto.setCyokuKaisu2(compileDto.getCyoku2());
			// R蓖v
			dto.setCyokuKaisu3(compileDto.getCyoku3());
			// ̑蓖Pv
			dto.setHokaKaisu1(compileDto.getHoka1());
			// ̑蓖Qv
			dto.setHokaKaisu2(compileDto.getHoka2());
			// ̑蓖Rv
			dto.setHokaKaisu3(compileDto.getHoka3());
			// ̑蓖Sv
			dto.setHokaKaisu4(compileDto.getHoka4());
			// ̑蓖Tv
			dto.setHokaKaisu5(compileDto.getHoka5());
			// ԒPʔNxv
			dto.setHourHoliday(compileDto.getUnitHourHoliday());
			// 1.00
			dto.setWarimasi1(compileDto.getWarimasi1());
			// ԊO
			dto.setWeekDayOverTime(compileDto.getTotalWeekDayOverTime());
			// xԊO
			dto.setWeekHolidayOverTime(compileDto.getTotalWeekHolidayOverTime());
			// 60ԒߕԊO
			dto.setMonthlyOverTime(compileDto.getTotalMonthlyOverTime());
			// 60ԒߏxԊO
			dto.setMonthlyWeekHoliday(compileDto.getTotalMonthlyWeekHoliday());
			// ԊOԑ֋xɎ擾
			dto.setSubstituteHoliday(compileDto.getTotalSubstituteHoliday());
		}
	}
	
	/**
	 * ΑӏWviVjKintaiCompileDto֕ϊ
	 * @param dto ΏDTO
	 * @return ϊΑӏWv
	 */
	public static KintaiCompileDto convKdWorkToCompile(KdWorkDto dto) {
		KintaiCompileDto compileDto = new KintaiCompileDto();
		if (VariousUtil.isNotNull(dto)) {
			// oΓ
			compileDto.setTotalWorkDays(dto.getSNissu());
			// oΉ
			compileDto.setTotalWorkNumber(dto.getSKaisu());
			// Ζԍv
			compileDto.setTotalWork(dto.getKinmuJi());
			// xeԍv
			compileDto.setTotalInterbal(dto.getKyukeiJi());
			// Lxɓ
			compileDto.setTotalPaidHoliday(dto.getYukyu());
			// ʋxɓ
			compileDto.setTotalParticularHoliday(dto.getTokukyu());
			// ΋xɓ
			compileDto.setTotalAbsence(dto.getKekkin());
			// axɓ
			compileDto.setTotalMedicalLeave(dto.getSKekkin());
			// x
			compileDto.setTotalCompensationDay(dto.getDaikyu());
			// U֋xɓ
			compileDto.setTotalTransfer(dto.getFurikae());
			// xɗR6
			compileDto.setTotalKkRiyuu6(dto.getKkRiyuu6());
			// xɗR7
			compileDto.setTotalKkRiyuu7(dto.getKkRiyuu7());
			// xɗR8
			compileDto.setTotalKkRiyuu8(dto.getKkRiyuu8());
			// xɗR9
			compileDto.setTotalKkRiyuu9(dto.getKkRiyuu9());
			// xɓ
			compileDto.setTotalOther(dto.getSonota());
			// xސ
			compileDto.setLeaveAndLate(dto.getTiSoKai());
			// xގԍv
			compileDto.setTotalLeaveAndLate(dto.getTiSoJikan());
			// cƎԍv
			compileDto.setTotalOver(dto.getZaJikan());
			// xoԍv
			compileDto.setTotalHolidayWork(dto.getKsJikan());
			// [鎞ԍv
			compileDto.setTotalLateNight(dto.getSnJikan());
			// F
			compileDto.setApplyAttendanceAllowance(StringUtil.isFlagOn(String.valueOf(dto.getKaikin())));
			// 蓖
			// H蓖v
			compileDto.setSyokuji(dto.getSyokujiKaisu());
			// P蓖v
			compileDto.setCyoku1(dto.getCyokuKaisu1());
			// Q蓖v
			compileDto.setCyoku2(dto.getCyokuKaisu2());
			// R蓖v
			compileDto.setCyoku3(dto.getCyokuKaisu3());
			// ̑蓖Pv
			compileDto.setHoka1(dto.getHokaKaisu1());
			// ̑蓖Qv
			compileDto.setHoka2(dto.getHokaKaisu2());
			// ̑蓖Rv
			compileDto.setHoka3(dto.getHokaKaisu3());
			// ̑蓖Sv
			compileDto.setHoka4(dto.getHokaKaisu4());
			// ̑蓖Tv
			compileDto.setHoka5(dto.getHokaKaisu5());
			// ԒPʔNxv
			compileDto.setUnitHourHoliday(dto.getHourHoliday());
			// 1.00
			compileDto.setWarimasi1(dto.getWarimasi1());
			// ԊO
			compileDto.setTotalWeekDayOverTime(dto.getWeekDayOverTime());
			// xԊO
			compileDto.setTotalWeekHolidayOverTime(dto.getWeekHolidayOverTime());
			// 60ԒߕԊO
			compileDto.setTotalMonthlyOverTime(dto.getMonthlyOverTime());
			// 60ԒߏxԊO
			compileDto.setTotalMonthlyWeekHoliday(dto.getMonthlyWeekHoliday());
			// ԊOԑ֋xɎ擾
			compileDto.setTotalSubstituteHoliday(dto.getSubstituteHoliday());
		}
		return compileDto;
	}
	
	/**
	 * CSVt@Cpwb_[z(e[u)擾
	 * @return	CSVt@Cpwb_[z
	 * @throws Exception 	Oꍇ
	 */
	public String[] getOldWorkCsvHeader() throws Exception {
		List<String> headerList = new LinkedList<String>();
		String[] aryColumnInfo = part().export().getTableColumnInfo(KINTAI_TABLE);
		for (String columnInfo : aryColumnInfo) {
			headerList.add(VariousUtil.getCsvSplitInfo(columnInfo, 3));
		}
		return StringUtil.listToArray(headerList);
	}
	
	/**
	 * CSVt@Cpwb_[z(Ve[u)擾
	 * @return	CSVt@Cpwb_[z
	 * @throws Exception 	Oꍇ
	 */
	public String[] getNewWorkCsvHeader() throws Exception {
		List<String> headerList = new LinkedList<String>();
		String[] aryColumnInfo = part().export().getTableColumnInfo(KINTAI_NEW_TABLE);
		for (String columnInfo : aryColumnInfo) {
			headerList.add(VariousUtil.getCsvSplitInfo(columnInfo, 3));
		}
		return StringUtil.listToArray(headerList);
	}
	
	/**
	 * @param kCode 		ЈR[h
	 * @param sikyuYM		xN
	 * @param sNen			xN
	 * @param sTuki			x
	 * @param sHi			x
	 * @param sNissu		oΓ
	 * @param sKaisu		oΉ
	 * @param kinmuJi		Ζ
	 * @param kyukeiJi		xe
	 * @param yukyu			Lx
	 * @param tokukyu		ʋx
	 * @param kekkin		ʌΓ
	 * @param sKekkin		aΓ
	 * @param daikyu		֋x
	 * @param furikae		U֋x
	 * @param kkRiyuu6		xɗR6
	 * @param kkRiyuu7		xɗR7
	 * @param kkRiyuu8		xɗR8
	 * @param kkRiyuu9		xɗR9
	 * @param sonota		̑xɗR
	 * @param tiSoKai		xމ
	 * @param tiSoJikan		xގ
	 * @param zaJikan		ʎcƎ
	 * @param ksJikan		xooΎ
	 * @param snJikan 		[Ζ
	 * @param kaikin		FΎ蓖x
	 * @param syokujiKaisu 	H蓖x
	 * @param cyokuKaisu1 	1蓖x
	 * @param cyokuKaisu2 	2蓖x
	 * @param cyokuKaisu3 	3蓖x
	 * @param hokaKaisu1 	̑x1
	 * @param hokaKaisu2 	̑x2
	 * @param hokaKaisu3 	̑x3
	 * @param hokaKaisu4 	̑x4
	 * @param hokaKaisu5 	̑x5
	 * @param sinseiGaku 	x\z
	 * @param warimasi1 	1.00
	 * @param weekDayOverTime 		ԊO
	 * @param weekHolidayOverTime 	xԊO
	 * @param monthlyOverTime 		60ԒߕԊO
	 * @param monthlyWeekHoliday 	60ԒߏxԊO
	 * @param hourHoliday 			ԒPʔNx擾
	 * @param substituteHoliday 	ԊOԑ֋xɎ擾
	 * @param amendFlag 			CtO
	 * @return			VΑӃe[uDto
	 */
	public static KdWorkDto createKdWorkDto(String kCode, String sikyuYM, int sNen, int sTuki, int sHi, double sNissu,
			int sKaisu, int kinmuJi, int kyukeiJi, double yukyu, double tokukyu, double kekkin, double sKekkin,
			double daikyu, double furikae, double kkRiyuu6, double kkRiyuu7, double kkRiyuu8, double kkRiyuu9,
			double sonota, int tiSoKai, int tiSoJikan, int zaJikan, int ksJikan, int snJikan, int kaikin,
			int syokujiKaisu, int cyokuKaisu1, int cyokuKaisu2, int cyokuKaisu3, int hokaKaisu1, int hokaKaisu2,
			int hokaKaisu3, int hokaKaisu4, int hokaKaisu5, int sinseiGaku, int warimasi1, int weekDayOverTime,
			int weekHolidayOverTime, int monthlyOverTime, int monthlyWeekHoliday, int hourHoliday,
			double substituteHoliday, int amendFlag) {
		KdWorkDto dto = new KdWorkDto();
		dto.setKCode(kCode);
		dto.setSikyuYm(sikyuYM);
		dto.setSNen(sNen);
		dto.setSTuki(sTuki);
		dto.setSHi(sHi);
		dto.setSNissu(sNissu);
		dto.setSKaisu(sKaisu);
		dto.setKinmuJi(kinmuJi);
		dto.setKyukeiJi(kyukeiJi);
		dto.setYukyu(yukyu);
		dto.setTokukyu(tokukyu);
		dto.setKekkin(kekkin);
		dto.setSKekkin(sKekkin);
		dto.setDaikyu(daikyu);
		dto.setFurikae(furikae);
		dto.setKkRiyuu6(kkRiyuu6);
		dto.setKkRiyuu7(kkRiyuu7);
		dto.setKkRiyuu8(kkRiyuu8);
		dto.setKkRiyuu9(kkRiyuu9);
		dto.setSonota(sonota);
		dto.setTiSoKai(tiSoKai);
		dto.setTiSoJikan(tiSoJikan);
		dto.setZaJikan(zaJikan);
		dto.setKsJikan(ksJikan);
		dto.setKaikin(kaikin);
		dto.setSyokujiKaisu(syokujiKaisu);
		dto.setCyokuKaisu1(cyokuKaisu1);
		dto.setCyokuKaisu2(cyokuKaisu2);
		dto.setCyokuKaisu3(cyokuKaisu3);
		dto.setHokaKaisu1(hokaKaisu1);
		dto.setHokaKaisu2(hokaKaisu2);
		dto.setHokaKaisu3(hokaKaisu3);
		dto.setHokaKaisu4(hokaKaisu4);
		dto.setHokaKaisu5(hokaKaisu5);
		return dto;
	}
	
	/**
	 * CtOR[h擾
	 * @param kCode ΏێЈR[h
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return CtOR[h
	 * @throws Exception Oꍇ
	 */
	public String getAmendFlagCode(String kCode, int year, int month) throws Exception {
		if (MosPCodePart.afterLegalReformDate(DateUtil.getYearMonth(year, month))) {
			KdWorkDto kdWorkDto = getKdWorkInfo(kCode, year, month);
			if (VariousUtil.isNotNull(kdWorkDto)) {
				if (kdWorkDto.getAmendFlag() == MospConst.DELETE_FLAG_ON) {
					return String.valueOf(MospConst.DELETE_FLAG_ON);
				}
				return String.valueOf(MospConst.DELETE_FLAG_OFF);
			}
		} else {
			MKintaiDto kintaiDto = getKintaiInfo(kCode, year, month);
			if (VariousUtil.isNotNull(kintaiDto)) {
				if (kintaiDto.getInsertDate().compareTo(kintaiDto.getUpdateDate()) != 0) {
					return String.valueOf(MospConst.DELETE_FLAG_ON);
				}
				return String.valueOf(MospConst.DELETE_FLAG_OFF);
			}
			
		}
		return "";
	}
	
	/**
	 * CtOR[h擾
	 * @param kCode ΏێЈR[h
	 * @param year Ώ۔N
	 * @param month Ώی
	 * @return CtOR[h
	 * @throws Exception Oꍇ
	 */
	public String getAmendFlagCode(String kCode, String year, String month) throws Exception {
		return getAmendFlagCode(kCode, NumberUtil.getIntParam(year), NumberUtil.getIntParam(month));
	}
	
	/**
	 * CtO
	 * @param code CtOR[h
	 * @return  CtO
	 * <p>
	 * code󗓂̏ꍇu{@link CommonConst#NAM_REMAIN_COMPILE}vA<br>
	 * codeu0v̏ꍇu{@link CommonConst#NAM_COMPILE_COMPLETE}vA<br>
	 * codeu1v̏ꍇu{@link CommonConst#NAM_COMPILE_AMEND}vB
	 * </p>
	 */
	public static String getAmendFlagName(String code) {
		if (StringUtil.isNotNull(code)) {
			if (String.valueOf(MospConst.DELETE_FLAG_OFF).equals(code)) {
				return CommonConst.NAM_COMPILE_COMPLETE;
			}
			if (String.valueOf(MospConst.DELETE_FLAG_ON).equals(code)) {
				return CommonConst.NAM_COMPILE_AMEND;
			}
		}
		return CommonConst.NAM_REMAIN_COMPILE;
	}
	
}
