/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.List;

import jp.mosp.common.dao.CmComponentDao;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.utils.VariousUtil;

/**
 * j[ɊւPartNX
 * @author yoshida
 * 	@version	0.0.3
 */
public class ComponentPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public ComponentPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public ComponentPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * CmComponentDaoCX^X
	 */
	private CmComponentDao	componentDao;
	

	/**
	 * CM_COMPONENTe[upDAO擾
	 * @return	ςCmComponentDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public CmComponentDao getCmComponentDao() throws Exception {
		if (VariousUtil.isNull(componentDao)) {
			componentDao = (CmComponentDao)getPreparedDao(CmComponentDao.class.getCanonicalName());
		}
		return componentDao;
	}
	
	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @param division		ΏەރR[h
	 * @return	j[\
	 * @throws Exception Oꍇ
	 */
	public CmComponentDto findForDto(String compcode, String division) throws Exception {
		return getCmComponentDao().findForDto(compcode, division);
	}
	
	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @return				j[\
	 * @throws Exception Oꍇ
	 */
	public CmComponentDto findForKey(String compcode) throws Exception {
		return getCmComponentDao().findForKey(compcode);
	}
	
	/**
	 * j[\擾
	 * @param compcode		ΏۃR}hjbgR[h
	 * @return				j[\
	 * @throws Exception Oꍇ
	 */
	public CmComponentDto findForComponent(String compcode) throws Exception {
		return getCmComponentDao().findForComponent(compcode);
	}
	
	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @since	0.0.2
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception  Oꍇ
	 */
	public String[][] getDivisionAuthArray(String division) throws Exception {
		// R[h̎擾
		List<CmComponentDto> list = getCmComponentDao().findForAvailable(division);
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			aryCode[i][0] = list.get(i).getCompCode();
			aryCode[i][1] = list.get(i).getCompName();
		}
		return aryCode;
	}
	
	/**
	 * ޕʌ敪擾(CM_COMPONENT)
	 * @since	0.0.2
	 * @param division 
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception  Oꍇ
	 */
	public String[][] getDivisionAuthAllArray(String division) throws Exception {
		// R[h̎擾
		List<CmComponentDto> list = getCmComponentDao().findForCondition(division);
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			aryCode[i][0] = list.get(i).getCompCode();
			aryCode[i][1] = list.get(i).getCompName();
		}
		return aryCode;
	}
	
	/**
	 * {fî݁j
	 * @since	0.0.3
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * {݂̂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isBelongingSection(CmComponentDto dto) {
		if (VariousUtil.chkExistDto(dto)) {
			return dto.getManage() == VariousUtil.getManageCode()[0];
		}
		return false;
	}
	
	/**
	 * {fiI𕔏̂݁j
	 * @since	0.0.3
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * {I𕔏݂̂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSelectSection(CmComponentDto dto) {
		if (VariousUtil.chkExistDto(dto)) {
			return dto.getManage() == VariousUtil.getManageCode()[1];
		}
		return false;
	}
	
	/**
	 * {fiSj
	 * @since	0.0.3
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * {S̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllSection(CmComponentDto dto) {
		if (VariousUtil.chkExistDto(dto)) {
			return dto.getManage() == VariousUtil.getManageCode()[2];
		}
		return false;
	}
	
}
