<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.common.vo.ReferSlipVo"
%><%
ReferSlipVo vo  = (ReferSlipVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table id="tabCondition">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_PAY_BON") + vo.getName("P_TYPE") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= ReferSlipVo.PRM_PLT_TYPE %>" name="<%= ReferSlipVo.PRM_PLT_TYPE %>">
						<%= HtmlUtility.getSelectOption(vo.getPitType(), String.valueOf(vo.getPltType())) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_ALLOWANCE") + vo.getName("C_YEAR") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= ReferSlipVo.PRM_PLT_YEAR %>" name="<%= ReferSlipVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.getPitYear(), String.valueOf(vo.getPltYear())) %>
					</select><%= vo.getName("C_YEAR") %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="submitForm(document.form, 'P8501')"><%= vo.getName("C_SEARCH") %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfoFlex(vo) %>
	<div class="List">
		<table id="tabList">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th id="thType"                                                            >&nbsp;<%= vo.getName("P_PAY_BON") + vo.getName("P_TYPE")                                   %>&nbsp;                          </th>
					<th id="thDate"      onclick="doSubmitKey(document.form, 'P8503', '1', '')">&nbsp;<%= vo.getName("P_ALLOWANCE") + vo.getName("C_DAY")                                  %>&nbsp;<%= vo.getSortMark("1") %></th>
					<th id="thAllowance" onclick="doSubmitKey(document.form, 'P8503', '2', '')">&nbsp;<%= vo.getName("P_TOTAL") + vo.getName("P_ALLOWANCE") + vo.getName("P_MONEY_AMOUNT") %>&nbsp;<%= vo.getSortMark("2") %></th>
					<th id="thDeduction" onclick="doSubmitKey(document.form, 'P8503', '3', '')">&nbsp;<%= vo.getName("P_TOTAL") + vo.getName("P_DEDUCTION") + vo.getName("P_MONEY_AMOUNT") %>&nbsp;<%= vo.getSortMark("3") %></th>
					<th id="thTotal"     onclick="doSubmitKey(document.form, 'P8503', '4', '')">&nbsp;<%= vo.getName("P_PAY_TOTAL")                                                        %>&nbsp;<%= vo.getSortMark("4") %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < vo.getCount(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitFileKey(document.form, '<%= vo.getHidCmd() %>', '<%= vo.getHidKCode() %>', '<%= vo.getAryHidDate(i) %>')">
							<%= vo.getName("C_EXPORT") %>
						</button>
					</td>
					<td class="CenterTd"><%= vo.getAryType     (i) %></td>
					<td class="CenterTd"><%= vo.getAryDate     (i) %></td>
					<td class="RightTd" ><%= vo.getAryAllowance(i) %></td>
					<td class="RightTd" ><%= vo.getAryDeduction(i) %></td>
					<td class="RightTd" ><%= vo.getAryTotal    (i) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
