<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.kintai.workflow.vo.AttendanceRouteListVo"
%><%
AttendanceRouteListVo vo = (AttendanceRouteListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryAttendanceRoute    = vo.getAryAttendanceRoute();
%>
<%=HtmlUtility.getHeader(vo)%>
<%=HtmlUtility.getSubTitle(vo)%>
<div class="Body" id="approvalUnit">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Search">
		<table>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= vo.NAM_K_CODE %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<input type="text" class="UserIdText" id="<%= AttendanceRouteListVo.PRM_TXT_K_CODE %>" name="<%= AttendanceRouteListVo.PRM_TXT_K_CODE %>" value="<%= BaseVo.escapeHTML(vo.getTxtKCode()) %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= vo.NAM_K_NAME %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<input type="text" class="TextBox" id="<%= AttendanceRouteListVo.PRM_TXT_K_NAME %>" name="<%= AttendanceRouteListVo.PRM_TXT_K_NAME %>" value="<%= BaseVo.escapeHTML(vo.getTxtKName()) %>" />
				</td>
				<td id="tdSection" colspan="2">
					<span class="TitleLabel"><%= vo.NAM_SECTION %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<select class="SectionSelect" id="<%= AttendanceRouteListVo.PRM_PLT_SECTION %>" name="<%= AttendanceRouteListVo.PRM_PLT_SECTION %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltSection, vo.getPltSection())%>
					</select>
				</td>
			</tr>
			<tr>
				<td id="tdRtCode">
					<span class="TitleLabel"><%= vo.NAM_ROUTE_CODE %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<input type="text" class="UserIdText" id="<%= AttendanceRouteListVo.PRM_TXT_ROUTE_CODE %>" name="<%= AttendanceRouteListVo.PRM_TXT_ROUTE_CODE %>" value="<%= BaseVo.escapeHTML(vo.getTxtRouteCode()) %>" />
				</td>
<!--	2009/07/22	m.yoshida	ΑӏF[gC	-->
				<td id="tdOffice" colspan="2">
					<span class="TitleLabel"><%= vo.NAM_OFFICE %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<select class="OfficeSelect" id="<%= AttendanceRouteListVo.PRM_PLT_OFFICE %>" name="<%= AttendanceRouteListVo.PRM_PLT_OFFICE %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltOffice, vo.getPltOffice())%>
					</select>
				</td>
				<td class="ButtonTd" >
					<button type="button" onclick="submitForm(document.form, 'S2831')"><%=CommonConst.NAM_SEARCH%></button>
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thSection" onclick="doSubmitKey(document.form, 'S2833', '<%= vo.KEY_SECTION %>', '')">&nbsp;<%= vo.NAM_SECTION %>&nbsp;<%=vo.getSortMark(vo.KEY_SECTION)%></th>
					<th id="thKCode" onclick="doSubmitKey(document.form, 'S2833', '<%= vo.KEY_K_CODE %>', '')">&nbsp;<%= vo.NAM_K_NAME %>&nbsp;<%=vo.getSortMark(vo.KEY_K_CODE)%></th>
<!--	2009/07/22	m.yoshida	ΑӏF[gC	-->
					<th id="thOffice" onclick="doSubmitKey(document.form, 'S2833', '<%= vo.KEY_OFFICE %>', '')">&nbsp;<%= vo.NAM_OFFICE %>&nbsp;<%=vo.getSortMark(vo.KEY_OFFICE)%></th>
					<th id="thLayer">&nbsp;<%= vo.NAM_LAYER1 %>	&nbsp;</th>
					<th id="thLayer">&nbsp;<%= vo.NAM_LAST_LAYER %>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'S2836', '<%= aryAttendanceRoute[i][0] %>', '')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryAttendanceRoute[i][1] %></td>
					<td><%= aryAttendanceRoute[i][2] %></td>
<!--	2009/07/22	m.yoshida	ΑӏF[gC	-->
					<td><%= aryAttendanceRoute[i][5] %></td>
					<td><%= aryAttendanceRoute[i][3] %></td>
					<td><%= aryAttendanceRoute[i][4] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>	
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2835')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
