/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

/**
 * @author yoshida
 *
 */
public class OverTimeRequestCardVo extends MosPWorkFlowVo {
	
	private static final long	serialVersionUID		= -7782303860861379213L;
	
	// 萔
	/**
	 * 0
	 */
	public static final int		MODE_INSERT				= 0;
	/**
	 * 1
	 */
	public static final int		MODE_UPDATE				= 1;
	/**
	 * 2
	 */
	public static final int		MODE_REQUEST			= 2;
	/**
	 * 3
	 */
	public static final int		MODE_APPROVED			= 3;
	/**
	 * 4
	 */
	public static final int		MODE_RETURNED			= 4;
	
	// p[^
	/**
	 * pltRequestYear
	 */
	public static final String	PRM_PLT_REQUEST_YEAR	= "pltRequestYear";
	/**
	 * pltRequestMonth
	 */
	public static final String	PRM_PLT_REQUEST_MONTH	= "pltRequestMonth";
	/**
	 * pltRequestDay
	 */
	public static final String	PRM_PLT_REQUEST_DAY		= "pltRequestDay";
	/**
	 * pltRequestHour
	 */
	public static final String	PRM_PLT_REQUEST_HOUR	= "pltRequestHour";
	/**
	 * pltRequestMin
	 */
	public static final String	PRM_PLT_REQUEST_MIN		= "pltRequestMin";
	/**
	 * txtReason
	 */
	public static final String	PRM_TXT_REASON			= "txtReason";
	
	// tB[h
	private String				pltRequestYear;
	private String				pltRequestMonth;
	private String				pltRequestDay;
	private String				pltRequestHour;
	private String				pltRequestMin;
	private String				txtReason;
	private String				lblApprover;
	private String				lblStatus;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	/**
	 * 
	 */
	public String[][]			aryPltHour;
	/**
	 * 
	 */
	public String[][]			aryPltMin;
	
	// [h(0FVKo^A1FύXA2FύXs)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE_YEAR;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE_MONTH;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE_DAY;
	/**
	 * 
	 */
	public String				NAM_REQUEST_TIME;
	/**
	 * 
	 */
	public String				NAM_REQUEST_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_REQUEST_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_APPROVER;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public int					LEN_REASON;
	

	/**
	 * RXgN^
	 */
	public OverTimeRequestCardVo() {
		super();
		setViewPath(getClassName());
		aryPltYear = new String[0][0];
		aryPltMonth = new String[0][0];
		aryPltDay = new String[0][0];
		aryPltHour = new String[0][0];
		aryPltMin = new String[0][0];
		mode = MODE_INSERT;
	}
	
	@Override
	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuApplication(), };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_WORK_DATE = CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
		NAM_WORK_DATE_YEAR = CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_YEAR;
		NAM_WORK_DATE_MONTH = CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_MONTH;
		NAM_WORK_DATE_DAY = CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_DAY;
		NAM_REQUEST_TIME = CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
		NAM_REQUEST_TIME_HOUR = CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
		NAM_REQUEST_TIME_MIN = CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
		NAM_REASON = CommonConst.NAM_REASON;
		NAM_APPROVER = CommonConst.NAM_APPROVER;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		LEN_REASON = 50;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		pltRequestYear = "0";
		pltRequestMonth = "0";
		pltRequestDay = "0";
		pltRequestHour = "0";
		pltRequestMin = "0";
		lblApprover = "";
		lblStatus = "";
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltRequestYear = request.getParameter(PRM_PLT_REQUEST_YEAR);
		pltRequestMonth = request.getParameter(PRM_PLT_REQUEST_MONTH);
		pltRequestDay = request.getParameter(PRM_PLT_REQUEST_DAY);
		pltRequestHour = request.getParameter(PRM_PLT_REQUEST_HOUR);
		pltRequestMin = request.getParameter(PRM_PLT_REQUEST_MIN);
		txtReason = request.getParameter(PRM_TXT_REASON);
		super.setParams(request);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 */
	public void setFields(CtOvertimeRequestDto dto) {
		pltRequestYear = String.valueOf(MospUtility.getYear(dto.getWorkDate()));
		pltRequestMonth = String.valueOf(MospUtility.getMonth(dto.getWorkDate()));
		pltRequestDay = String.valueOf(MospUtility.getDay(dto.getWorkDate()));
		pltRequestHour = TimeUtil.convIntegerTimeToStringHour(dto.getOverTime());
		pltRequestMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getOverTime());
		txtReason = dto.getReason();
		setHidVoucher(String.valueOf(dto.getVoucher()));
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CtOvertimeRequestDto dto) {
		dto.setWorkDate(DateUtil.getDate(pltRequestYear, pltRequestMonth, pltRequestDay));
		dto.setOverTime(TimeUtil.convStringTimeToIntegerTime(pltRequestHour, pltRequestMin));
		dto.setReason(txtReason);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltRequestYear, NAM_WORK_DATE_YEAR, PRM_PLT_REQUEST_YEAR);
		checkRequired(pltRequestMonth, NAM_WORK_DATE_MONTH, PRM_PLT_REQUEST_MONTH);
		checkRequired(pltRequestDay, NAM_WORK_DATE_DAY, PRM_PLT_REQUEST_DAY);
		checkRequired(pltRequestHour, NAM_REQUEST_TIME_HOUR, PRM_PLT_REQUEST_HOUR);
		checkRequired(pltRequestMin, NAM_REQUEST_TIME_MIN, PRM_PLT_REQUEST_MIN);
		checkRequired(txtReason, NAM_REASON, PRM_TXT_REASON);
		// tÓmF
		checkDate(getIntParam(pltRequestYear), getIntParam(pltRequestMonth), getIntParam(pltRequestDay), NAM_WORK_DATE,
				PRM_PLT_REQUEST_DAY);
		// 񒷊mF
		checkLength(txtReason, LEN_REASON, NAM_REASON, PRM_TXT_REASON);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtReason
	 */
	public String getEscTxtReason() {
		return escapeHTML(txtReason);
	}
	
	/**
	 * @return lblApprover
	 */
	public String getEscLblApprover() {
		return escapeHTML(lblApprover);
	}
	
	/**
	 * @return lblStatus
	 */
	public String getEscLblStatus() {
		return escapeHTML(lblStatus);
	}
	
	/**
	 * @return pltRequestYear
	 */
	public String getPltRequestYear() {
		return pltRequestYear;
	}
	
	/**
	 * @return pltRequestMonth
	 */
	public String getPltRequestMonth() {
		return pltRequestMonth;
	}
	
	/**
	 * @return pltRequestDay
	 */
	public String getPltRequestDay() {
		return pltRequestDay;
	}
	
	/**
	 * @return pltRequestHour
	 */
	public String getPltRequestHour() {
		return pltRequestHour;
	}
	
	/**
	 * @return pltRequestMin
	 */
	public String getPltRequestMin() {
		return pltRequestMin;
	}
	
	/**
	 * @return txtReason
	 */
	public String getTxtReason() {
		return txtReason;
	}
	
	/**
	 * @return lblApprover
	 */
	public String getLblApprover() {
		return lblApprover;
	}
	
	/**
	 * @return lblStatus
	 */
	public String getLblStatus() {
		return lblStatus;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param pltRequestYear Zbg pltRequestYear
	 */
	public void setPltRequestYear(String pltRequestYear) {
		this.pltRequestYear = pltRequestYear;
	}
	
	/**
	 * @param pltRequestMonth Zbg pltRequestMonth
	 */
	public void setPltRequestMonth(String pltRequestMonth) {
		this.pltRequestMonth = pltRequestMonth;
	}
	
	/**
	 * @param pltRequestDay Zbg pltRequestDay
	 */
	public void setPltRequestDay(String pltRequestDay) {
		this.pltRequestDay = pltRequestDay;
	}
	
	/**
	 * @param pltRequestHour Zbg pltRequestHour
	 */
	public void setPltRequestHour(String pltRequestHour) {
		this.pltRequestHour = pltRequestHour;
	}
	
	/**
	 * @param pltRequestMin Zbg pltRequestMin
	 */
	public void setPltRequestMin(String pltRequestMin) {
		this.pltRequestMin = pltRequestMin;
	}
	
	/**
	 * @param txtReason Zbg txtReason
	 */
	public void setTxtReason(String txtReason) {
		this.txtReason = txtReason;
	}
	
	/**
	 * @param lblApprover Zbg lblApprover
	 */
	public void setLblApprover(String lblApprover) {
		this.lblApprover = lblApprover;
	}
	
	/**
	 * @param lblStatus Zbg lblStatus
	 */
	public void setLblStatus(String lblStatus) {
		this.lblStatus = lblStatus;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
