/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;

/**
 * @author yoshida
 *
 */
public class ApprovalFunctionCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6334613963777191151L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_ATTENDANCE	= "pltAttendance";
	
	// tB[h
	private String				pltAttendance;
	private String				lblAttendance;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_STATE;
	/**
	 * 
	 */
	public String				NAM_ATTENDANCE;
	/**
	 * 
	 */
	public String				NAM_SELECT;
	/**
	 * 
	 */
	public String				REG_DELETE;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltState;
	

	/**
	 * RXgN^
	 */
	public ApprovalFunctionCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_FUNCTION;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_STATE = CommonConst.NAM_NOW_STATUS;
		NAM_ATTENDANCE = CommonConst.NAM_DELETE_FLAG;
		NAM_SELECT = CommonConst.NAM_SELECT;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		pltAttendance = request.getParameter(PRM_PLT_ATTENDANCE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(MCodeDto dto) {
		pltAttendance = dto.getTName();
		lblAttendance = getCodeName(pltAttendance, aryPltState);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltAttendance, NAM_ATTENDANCE, PRM_PLT_ATTENDANCE);
		// ^CvmF
		checkRegex(pltAttendance, REG_DELETE, NAM_ATTENDANCE, PRM_PLT_ATTENDANCE);
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return pltAttendance
	 */
	public String getPltAttendance() {
		return pltAttendance;
	}
	
	/**
	 * @param pltAttendance pltAttendance
	 */
	public void setPltAttendance(String pltAttendance) {
		this.pltAttendance = pltAttendance;
	}
	
	/**
	 * @return lblAttendance
	 */
	public String getEscLblAttendance() {
		return escapeHTML(lblAttendance);
	}
	
}
