/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPCodeAction;
import jp.mosp.workflow.vo.ApprovalFunctionCardVo;

/**
 * @author yoshida
 *
 */
public class ApprovalFunctionCardAction extends MosPCodeAction {
	
	// R}h
	private static final String	CMD_FUNCTION_CARD_SHOW		= "S2840";	// \
	private static final String	CMD_FUNCTION_CARD_UPDATE	= "S2848";	// XV
																		
	
	/**
	 * RXgN^
	 */
	public ApprovalFunctionCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_FUNCTION_CARD_SHOW)) {
			// \(L[ŏ)
			show();
		} else if (cmd.equals(CMD_FUNCTION_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalFunctionCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		ApprovalFunctionCardVo vo = (ApprovalFunctionCardVo)getVo();
		// v_ẼZbg
		vo.aryPltState = VariousUtil.getDeleteArray();
	}
	
	@Override
	protected void show() throws Exception {
		ApprovalFunctionCardVo vo = (ApprovalFunctionCardVo)getVo();
		// f[^̎擾
		MCodeDto dto = findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);
		if (chkExistDto(dto)) {
			// VOɏZbg
			vo.setFields(dto);
		} else {
			dto = new MCodeDto();
			// ĺuv
			dto.setTName(String.valueOf(MospConst.DELETE_FLAG_ON));
			vo.setFields(dto);
			vo.setMessage(CommonConst.MSG_ATTENDANCE_APPROVAL_FUNCTION1);
		}
	}
	
	@Override
	protected void update() throws Exception {
		ApprovalFunctionCardVo vo = (ApprovalFunctionCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// o^
		regist(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL, vo.getPltAttendance(), "");
		// DTO̍Ď擾		
		MCodeDto retDto = findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		vo.setFields(retDto);
	}
	
}
