/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class OptionFunctionMenuVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1855708611362378750L;
	
	/**
	 * ʃTu^Cg	
	 */
	public String				NAM_OPION_FUNCTION_MENU;
	
	// tB[h
	private String[][]			aryOptionFunctionMenu;
	

	/**
	 * RXgN^
	 */
	public OptionFunctionMenuVo() {
		super();
		setViewPath(getClassName());
		aryOptionFunctionMenu = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_OPION_FUNCTION_MENU;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OPION_FUNCTION_MENU = CommonConst.TTL_OPION_FUNCTION_MENU;
	}
	
	/**
	 * @return aryOptionFunctionMenu
	 */
	public String[][] getAryOptionFunctionMenu() {
		return escapeArray(aryOptionFunctionMenu).clone();
	}
	
	/**
	 * @param aryOptionFunctionMenu Zbg aryOptionFunctionMenu
	 */
	public void setAryOptionFunctionMenu(String[][] aryOptionFunctionMenu) {
		this.aryOptionFunctionMenu = aryOptionFunctionMenu.clone();
	}
	
}
