/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmUserDto;

/**
 * @author yoshida
 *
 */
public class AccountMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 621967770700551876L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_SYSTEM			= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_USER_ID		= "txtUserId";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_USER_NAME	= "txtUserName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_AUTHORITY	= "pltAuthority";
	/**
	 * 
	 */
	public static final String	PRM_TXT_DATA_LEVEL	= "txtDataLevel";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtUserId;
	private String				txtKCode;
	private String				txtUserName;
	private String				pltAuthority;
	private String				txtDataLevel;
	private String				pltDelete;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltAuthority;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_USER_ID;
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_USER_NAME;
	/**
	 * 
	 */
	public String				NAM_AUTHORITY;
	/**
	 * 
	 */
	public String				NAM_DATA_LEVEL;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_USER_ID;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_USER_NAME;
	/**
	 * 
	 */
	public int					LEN_AUTHORITY;
	/**
	 * 
	 */
	public int					LEN_DATA_LEVEL;
	/**
	 * 
	 */
	public String				REG_DELETE;
	

	/**
	 * RXgN^
	 */
	public AccountMasterCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ACCOUNT_MASTER;
		createAryMenu(CMD_MENU_SYSTEM2);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_USER_ID = CommonConst.NAM_USER_ID;
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_USER_NAME = CommonConst.NAM_USER_NAME;
		NAM_AUTHORITY = CommonConst.NAM_AUTHORITY;
		NAM_DATA_LEVEL = CommonConst.NAM_DATA_LEVEL;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_USER_ID = 10;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_USER_NAME = 16;
		LEN_AUTHORITY = 2;
		LEN_DATA_LEVEL = 2;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtUserId("");
		setTxtUserName("");
		setPltAuthority("");
		setTxtDataLevel("");
		setPltDelete("");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtUserId = request.getParameter(PRM_TXT_USER_ID);
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtUserName = request.getParameter(PRM_TXT_USER_NAME);
		pltAuthority = request.getParameter(PRM_PLT_AUTHORITY);
		txtDataLevel = request.getParameter(PRM_TXT_DATA_LEVEL);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(CmUserDto dto) {
		// f[^̐ݒ
		txtUserId = dto.getUserId();
		txtKCode = dto.getKCode();
		txtUserName = dto.getUserName();
		pltAuthority = dto.getAuthority();
		txtDataLevel = String.valueOf(dto.getDataLevel());
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtUserId, NAM_USER_ID, PRM_TXT_USER_ID);
		checkRequired(txtUserName, NAM_USER_NAME, PRM_TXT_USER_NAME);
		checkRequired(pltAuthority, NAM_AUTHORITY, PRM_PLT_AUTHORITY);
		checkRequired(txtDataLevel, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		checkRequired(pltDelete, NAM_DELETE, PRM_PLT_DELETE);
		// ^CvmF
		checkCode(txtUserId, NAM_USER_ID, PRM_TXT_USER_ID);
		checkCode(txtKCode, NAM_K_CODE, PRM_TXT_K_CODE);
		checkCode(pltAuthority, NAM_AUTHORITY, PRM_PLT_AUTHORITY);
		checkNumber(txtDataLevel, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		checkRegex(pltDelete, REG_DELETE, NAM_DELETE, PRM_PLT_DELETE);
		// 񒷊mF
		checkLength(txtUserId, LEN_USER_ID, NAM_USER_ID, PRM_TXT_USER_ID);
		checkLength(txtKCode, LEN_K_CODE, NAM_K_CODE, PRM_TXT_K_CODE);
		checkLength(txtUserName, LEN_USER_NAME, NAM_USER_NAME, PRM_TXT_USER_NAME);
		checkLength(pltAuthority, LEN_AUTHORITY, NAM_AUTHORITY, PRM_PLT_AUTHORITY);
		checkLength(txtDataLevel, LEN_DATA_LEVEL, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmUserDto dto) {
		dto.setUserId(txtUserId);
		dto.setKCode(txtKCode);
		dto.setUserName(txtUserName);
		dto.setAuthority(pltAuthority);
		dto.setDataLevel(Integer.parseInt(txtDataLevel));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("mode = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtUserId
	 */
	public String getEscTxtUserId() {
		return escapeHTML(txtUserId);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return txtUserName
	 */
	public String getEscTxtUserName() {
		return escapeHTML(txtUserName);
	}
	
	/**
	 * @return txtDataLevel
	 */
	public String getEscTxtDataLevel() {
		return escapeHTML(txtDataLevel);
	}
	
	/**
	 * @return txtUserId
	 */
	public String getTxtUserId() {
		return txtUserId;
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtUserName
	 */
	public String getTxtUserName() {
		return txtUserName;
	}
	
	/**
	 * @return pltAuthority
	 */
	public String getPltAuthority() {
		return pltAuthority;
	}
	
	/**
	 * @return txtDataLevel
	 */
	public String getTxtDataLevel() {
		return txtDataLevel;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtUserId Zbg txtUserId
	 */
	public void setTxtUserId(String txtUserId) {
		this.txtUserId = txtUserId;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtUserName Zbg txtUserName
	 */
	public void setTxtUserName(String txtUserName) {
		this.txtUserName = txtUserName;
	}
	
	/**
	 * @param pltAuthority Zbg pltAuthority
	 */
	public void setPltAuthority(String pltAuthority) {
		this.pltAuthority = pltAuthority;
	}
	
	/**
	 * @param txtDataLevel Zbg txtDataLevel
	 */
	public void setTxtDataLevel(String txtDataLevel) {
		this.txtDataLevel = txtDataLevel;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
