/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MYakusyokuDto;
import jp.mosp.system.vo.YakusyokuMasterListVo;

/**
 * @author yoshida
 *
 */
public class YakusyokuMasterListAction extends KintaiCommonAction {
	
	private static final String	CMD_YAKUSYOKU_MASTER_LIST_SHOW		= "S2200";
	private static final String	CMD_YAKUSYOKU_MASTER_LIST_SEARCH	= "S2201";
	private static final String	CMD_YAKUSYOKU_MASTER_LIST_RE_SEARCH	= "S2202";
	private static final String	CMD_YAKUSYOKU_MASTER_LIST_SORT		= "S2203";
	

	/**
	 * RXgN^
	 */
	public YakusyokuMasterListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		//  
		init();
		// R}h̏		
		if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_YAKUSYOKU_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new YakusyokuMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		// 敪v_EXg쐬
		vo.aryPltTokyu = StringUtil.addArrayFirstRowSpace(getMosPCodeArray(CommonConst.TID_GRADE));
	}
	
	@Override
	protected void show() throws Exception {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		// lɃZbg	
		vo.setSearchmode(YakusyokuMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		vo.setParams(request);
		searchPositionList();
		vo.setFormerKey(vo.KEY_YCODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(YakusyokuMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		if (vo.getSearchmode() == YakusyokuMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchPositionList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * EXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchPositionList() throws Exception {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		vo.setFields(part().position().getMYakusyokuDao().findForCondition(vo.getTxtYCode(), vo.getPltTokyu(),
				vo.getTxtYName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryYCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		YakusyokuMasterListVo vo = (YakusyokuMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_YCODE)) {
			comp = new CompYCode();
		} else if (key.equals(vo.KEY_YNAME)) {
			comp = new CompYName();
		} else if (key.equals(vo.KEY_TOKYU)) {
			comp = new CompTokyu();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ER[hɂrNX
	 */
	protected static class CompYCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5729849389393964036L;
		

		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getYcode().compareTo(dto2.getYcode());
		}
	}
	
	/**
	 * ÊɂrNX
	 */
	protected static class CompYName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1765058312562701593L;
		

		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getYname().compareTo(dto2.getYname());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompTokyu implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -3586842444641043500L;
		

		public int compare(Object obj1, Object obj2) {
			MYakusyokuDto dto1 = (MYakusyokuDto)obj1;
			MYakusyokuDto dto2 = (MYakusyokuDto)obj2;
			return dto1.getTokyu().compareTo(dto2.getTokyu());
		}
	}
	
}
