/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCompileCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -8482835887182137352L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 2;
	
	// p[^
	/**
	 * hidCompileYear
	 */
	public static final String	PRM_HID_YEAR		= "hidCompileYear";
	/**
	 * hidCompileMonth
	 */
	public static final String	PRM_HID_MONTH		= "hidCompileMonth";
	/**
	 * pltSection
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	/**
	 * txtKCode
	 */
	public static final String	PRM_TXT_KCODE		= "txtKCode";
	
	// tB[h
	private String				hidCompileYear;
	private String				hidCompileMonth;
	private String				pltSection;
	private String				txtKCode;
	
	// tB[h(\̂)
	private String				lblStartCompileDate;
	private String				lblEndCompileDate;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CALCULATE_TARGET;
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	
	/**
	 * 
	 */
	public static final int		LEN_CODE			= CommonConst.LEN_K_CODE;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	
	// [h(1FXVA2FvZ񖳂)
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public AttendanceCompileCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_UPDATE;
		hidCompileYear = "";
		hidCompileMonth = "";
		pltSection = "";
		txtKCode = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_COMPILE;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CALCULATE_TARGET = CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_ACCOUNTING_PERIOD;
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_SECTION = CommonConst.NAM_STATION;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidCompileYear = request.getParameter(PRM_HID_YEAR);
		hidCompileMonth = request.getParameter(PRM_HID_MONTH);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		txtKCode = request.getParameter(PRM_TXT_KCODE);
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	
	/**
	 * @return lblEndCompileDate
	 */
	public String getEscLblEndCompileDate() {
		return escapeHTML(lblEndCompileDate);
	}
	
	/**
	 * @return lblStartCompileDate
	 */
	public String getEscLblStartCompileDate() {
		return escapeHTML(lblStartCompileDate);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return hidCompileYear
	 */
	public String getHidCompileYear() {
		return hidCompileYear;
	}
	
	/**
	 * @return hidCompileMonth
	 */
	public String getHidCompileMonth() {
		return hidCompileMonth;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return lblStartCompileDate
	 */
	public String getLblStartCompileDate() {
		return lblStartCompileDate;
	}
	
	/**
	 * @return lblEndCompileDate
	 */
	public String getLblEndCompileDate() {
		return lblEndCompileDate;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param hidCompileYear Zbg hidCompileYear
	 */
	public void setHidCompileYear(String hidCompileYear) {
		this.hidCompileYear = hidCompileYear;
	}
	
	/**
	 * @param hidCompileMonth Zbg hidCompileMonth
	 */
	public void setHidCompileMonth(String hidCompileMonth) {
		this.hidCompileMonth = hidCompileMonth;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param lblStartCompileDate Zbg lblStartCompileDate
	 */
	public void setLblStartCompileDate(String lblStartCompileDate) {
		this.lblStartCompileDate = lblStartCompileDate;
	}
	
	/**
	 * @param lblEndCompileDate Zbg lblEndCompileDate
	 */
	public void setLblEndCompileDate(String lblEndCompileDate) {
		this.lblEndCompileDate = lblEndCompileDate;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
