/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.system.action;

import java.sql.SQLException;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PmDetailBaDto;
import jp.mosp.payroll.bonus.dto.PmDetailBdDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.system.vo.DetailCardVo;

/**
 * אݒꗗʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SELECT}
 * </li><li>
 * {@link #CMD_REGIST}
 * </li></ul>
 */
public class DetailCardAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * אݒҏWʂ\B<br>
	 */
	public static final String	CMD_SHOW	= "P7015";
	
	/**
	 * R}hB<br><br>
	 * w肳ꂽŖאݒIA\B<br>
	 */
	public static final String	CMD_SELECT	= "P7016";
	
	/**
	 * o^R}hB<br><br>
	 * ҏWꂽeAo^B<br>
	 */
	public static final String	CMD_REGIST	= "P7017";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public DetailCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new DetailCardVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (cmd.equals(CMD_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_REGIST)) {
			// o^
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	@Override
	public void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// VOtB[hݒ
		vo.setPltType(String.valueOf(PayrollConst.DETAIL_TYPE_PT));
		vo.setTxtCode("");
		vo.setTxtName("");
		vo.setTxtAbbr("");
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}
	
	/**
	 * IsB
	 * @throws Exception 
	 */
	@Override
	public void select() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// L[݊mF
		if (key1 == null || key1.equals("") || key2 == null || key2.equals("")) {
			addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			setNextCmd(DetailListAction.CMD_RE_SEARCH);
			return;
		}
		// ׋敪擾
		DetailDto dto = null;
		if (key1.equals(PayrollConst.DETAIL_TYPE_PT)) {
			// ^Α
			dto = getDetailPt();
			vo.setPltType(PayrollConst.DETAIL_TYPE_PT);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_PA)) {
			// ^x
			dto = getDetailPa();
			vo.setPltType(PayrollConst.DETAIL_TYPE_PA);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_PD)) {
			// ^T
			dto = getDetailPd();
			vo.setPltType(PayrollConst.DETAIL_TYPE_PD);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_PB)) {
			// ^
			dto = getDetailPb();
			vo.setPltType(PayrollConst.DETAIL_TYPE_PB);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_PS)) {
			// ^v
			dto = getDetailPs();
			vo.setPltType(PayrollConst.DETAIL_TYPE_PS);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_BA)) {
			// ܗ^x
			dto = getDetailBa();
			vo.setPltType(PayrollConst.DETAIL_TYPE_BA);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_BD)) {
			// ܗ^T
			dto = getDetailBd();
			vo.setPltType(PayrollConst.DETAIL_TYPE_BD);
		} else if (key1.equals(PayrollConst.DETAIL_TYPE_BS)) {
			// ܗ^v
			dto = getDetailBs();
			vo.setPltType(PayrollConst.DETAIL_TYPE_BS);
		}
		
		// f[^݊mF
		if (dto == null) {
			addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			setNextCmd(DetailListAction.CMD_RE_SEARCH);
			return;
		}
		// VOɐݒ
		vo.setFields(dto);
		// ҏWۃtOmF
		if (dto.getEditFlag() == PayrollConst.DETAIL_EDIT_NG) {
			vo.setMode(2);
		} else {
			vo.setMode(1);
		}
	}
	
	/**
	 * o^sB
	 * @throws Exception 
	 */
	private void regist() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// ׋敪Xg擾
		if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PT)) {
			// ^Α
			registDetailPt();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PA)) {
			// ^x
			registDetailPa();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PD)) {
			// ^T
			registDetailPd();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PB)) {
			// ^
			registDetailPb();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_PS)) {
			// ^v
			registDetailPs();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BA)) {
			// ܗ^x
			registDetailBa();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BD)) {
			// ܗ^T
			registDetailBd();
		} else if (vo.getPltType().equals(PayrollConst.DETAIL_TYPE_BS)) {
			// ܗ^v
			registDetailBs();
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IC0001", ""));
		// ʕ\
		key1 = vo.getPltType();
		key2 = vo.getTxtCode();
		select();
	}
	
	/**
	 * ^ΑӖאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailPt() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailPtDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ^xאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailPa() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailPaDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ^Tאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailPd() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailPdDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ^󖾍אݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailPb() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailPbDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ^vאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailPs() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailPsDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ܗ^xאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailBa() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ܗ^Tאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailBd() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ܗ^vאݒ擾B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	private DetailDto getDetailBs() throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new PmDetailBsDao(cfg, cmd, aspUser, user, conn).findForKey(key2);
	}
	
	/**
	 * ^ΑӖאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailPt() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailPtDao dao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
		// 擾
		DetailTimeDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new DetailTimeDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ^xאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailPa() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailPaDao dao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
		// 擾
		DetailPaDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new DetailPaDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ^Tאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailPd() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailPdDao dao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
		// 擾
		DetailPdDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new DetailPdDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ^󖾍אݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailPb() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailPbDao dao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
		// 擾
		DetailPbDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new DetailPbDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ^vאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailPs() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailPsDao dao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
		// 擾
		DetailMoneyDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new DetailMoneyDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ܗ^xאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailBa() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailBaDao dao = new PmDetailBaDao(cfg, cmd, aspUser, user, conn);
		// 擾
		PmDetailBaDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new PmDetailBaDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ܗ^Tאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailBd() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailBdDao dao = new PmDetailBdDao(cfg, cmd, aspUser, user, conn);
		// 擾
		PmDetailBdDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new PmDetailBdDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
	/**
	 * ܗ^vאݒo^B
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws MospException 
	 */
	private void registDetailBs() throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// VO擾
		DetailCardVo vo = (DetailCardVo)getVo();
		// DAO
		PmDetailBsDao dao = new PmDetailBsDao(cfg, cmd, aspUser, user, conn);
		// 擾
		PmDetailBsDto dto = dao.findForUpdate(vo.getTxtCode());
		if (dto == null) {
			// VKo^
			dto = new PmDetailBsDto();
			dto.setDetailCode(vo.getTxtCode());
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.insert(dto, true);
		} else {
			// XV
			dto.setDetailName(vo.getTxtName());
			dto.setDetailAbbr(vo.getTxtAbbr());
			dto.setDeleteFlag(Byte.parseByte(vo.getPltDelete()));
			dao.update(dto, true);
		}
	}
	
}
