/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.action;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dao.MSyozokuDao;
import jp.mosp.kintai.common.dao.MYakusyokuDao;
import jp.mosp.kintai.common.dto.MSyozokuDto;
import jp.mosp.kintai.common.dto.MYakusyokuDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.report.dto.WithholdingListDto;

public class WithholdingListAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_WITHHOLDING_LIST_ALL	= "P3040";
	private static final String	CMD_WITHHOLDING_LIST_ONE	= "P3041";
	private static final String	CMD_WITHHOLDING_LIST_ALL2	= "P3042";
	
	public String[][]			aryGender;
	// ݒe[u
	public List<MosPConfDto>	listConf;
	public String[][]			aryEra;
	public String[][]			aryStation;
	public String[][]			aryPltIncomeTaxType;
	public String[][]			aryPltAdjustmentType;
	

	/**
	 * RXgN^
	 */
	public WithholdingListAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// 擾ϊmF
		if (aryStation != null) {
			return;
		}
		// z擾
		aryStation = getStationArrayAll();
		aryPosition = getPositionArrayAll();
		aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// Ǖw(v) Up
		aryGender = getCodeArray(PayrollConst.TID_GENDER);
		aryPltIncomeTaxType = LegalConst.INCOME_TAX_ARRAY;
		aryPltAdjustmentType = LegalConst.ADJUSTMENT_ARRAY;
		if (cmd.equals(CMD_WITHHOLDING_LIST_ALL)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getPltReportYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltReportYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingList(date, null, vo);
			// [쐬
//			String fileName = vo.getPltReportYear ()
//							+ PayrollConst.FILE_WITHHOLDING_LIST;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
//			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else if (cmd.equals(CMD_WITHHOLDING_LIST_ONE)) {
			// VO̎擾
			AdjustmentReferVo vo = (AdjustmentReferVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// ЈR[hNULL
			vo.setLblChangeKCode(vo.getHidKCode());
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingListOne(date, vo.getHidKCode(), vo);
			for (int i = 0; i < list.size(); i++) {
				WithholdingListDto dtoTmp = list.get(i);
				// ^׏o
				if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
					report(vo, dtoTmp);
				} else {
					reportXls(vo, dtoTmp);
				}
			}
		} else if (cmd.equals(CMD_WITHHOLDING_LIST_ALL2)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String
				.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingListDto> list = getWithholdingList(date, null, vo);
			// [쐬
//			String fileName = vo.getHidAdjustYear ()
//							+ PayrollConst.FILE_WITHHOLDING_LIST;
//			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * 򒥎f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingListDto> getWithholdingList(Date targetMonth, String kCode, MosPVo vo) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingListDto> list = new ArrayList<WithholdingListDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		int j = 0;
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
			// lݒ
			setHumanInfo(cdAdjustmentDto);
			// ^Aܗ^擾
			setPaymentBonusInfo();
			// Nf[^ݒ
			WithholdingListDto dto = new WithholdingListDto(adjustYear, cdAdjustmentDto, mKihonDto, mKojinDto,
					cmIncomeTaxDto, cmMidwayEnterDto, listPaymentData, listBonusData, pdPayDeductionDao, cmCompanyDto);
			// 敪ݒ
			setMonthType(dto);
			// taݒ
			setJapanDate(dto);
			// R[hݒ
			setDtoCodeName(dto);
			
			// Xgɐݒ
			list.add(dto);
			j++;
		}
		// ^f[^mF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		return list;
	}
	
	/**
	 * 򒥎f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingListDto> getWithholdingListOne(Date targetMonth, String kCode, MosPVo vo) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingListDto> list = new ArrayList<WithholdingListDto>();
		// Ѓf[^ݒ
		setCompanyDataInfo();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
		}
		// ^f[^mF
		if (listAdjustment.size() == 0) {
			// 
			cdAdjustmentDto = new CdAdjustmentDto();
			cdAdjustmentDto.setKCode(kCode);
		}
		setVo(vo);
		setUrl(vo.getRetUrl());
		// lݒ
		setHumanInfo(cdAdjustmentDto);
		// ^Aܗ^擾
		setPaymentBonusInfo();
		// Nf[^ݒ
		WithholdingListDto dto = new WithholdingListDto(adjustYear, cdAdjustmentDto, mKihonDto, mKojinDto,
				cmIncomeTaxDto, cmMidwayEnterDto, listPaymentData, listBonusData, pdPayDeductionDao, cmCompanyDto);
		// {lݒ
		setWidowType(dto);
		// 敪ݒ
		setMonthType(dto);
		// taݒ
		setJapanDate(dto);
		// R[hݒ
		setDtoCodeName(dto);
		// Xgɐݒ
		list.add(dto);
		
		return list;
	}
	
	/**
	 * {l敪ݒ
	 * @param dto
	 */
	private void setWidowType(WithholdingListDto dto) {
		if (cmIncomeTaxDto != null) {
			String widowType = cmIncomeTaxDto.getSelfWidowType();
			// Ǖw(v)̏ꍇ͐ʂŔfĐݒAݒȂ̏ꍇ͈ʉǕw
			if (widowType.equals(LegalConst.WIDOW_GENERAL)) {
				dto.setWidow(PayrollConst.ADJ_APPLICABLE);
				// DTOmF
//				if (mKojinDto != null) {
//					String gender = mKojinDto.getGender();
//					// Ǖv
//					if (gender.equals(aryGender[0][0])) {
//						dto.setWidow(PayrollConst.ADJ_APPLICABLE);
//					}
//					// ʉǕw
//					if (gender.equals(aryGender[1][0])) {
//						dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
//					}
//				} else {
//					// ʂ̐ݒ肪Ȃꍇ͈ʉǕwɐݒ
//					dto.setGeWidow(PayrollConst.ADJ_APPLICABLE);
//				}
			} else if (widowType.equals(LegalConst.WIDOW_SPECIAL)) {
				// ʉǕw
				dto.setSpWidow(PayrollConst.ADJ_APPLICABLE);
			}
		}
	}
	
	/**
	 * 敪ݒ
	 * @param dto
	 */
	private void setMonthType(WithholdingListDto dto) {
		dto.setMonthType01("1");
		dto.setMonthType02("2");
		dto.setMonthType03("3");
		dto.setMonthType04("4");
		dto.setMonthType05("5");
		dto.setMonthType06("6");
		dto.setMonthType07("7");
		dto.setMonthType08("8");
		dto.setMonthType09("9");
		dto.setMonthType10("10");
		dto.setMonthType11("11");
		dto.setMonthType12("12");
		
	}
	
	/**
	 * ^Aܗ^擾
	 * @param vo
	 * @throws Exception 
	 */
	private void setPaymentBonusInfo() throws Exception {
		// vZΏۋ^f[^擾
		listPaymentData = phPaymentDao.findForConditionDate(kCode, targetBefDate, targetAffDate);
		// vZΏۏܗ^f[^擾
		listBonusData = phBonusDao.findForConditionDate(kCode, startAdjDate, lastDate);
		// ^f[^mF
		setTargetPaymentData();
		// Ώۃf[^ŌvZ(o^Ȃ)
		calcTargetIncomeTax(false);
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	private void setHumanInfo(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾
//			mKihonDto = mKihonPayrollDao.findForDate(kCode, targetDate);
			mKihonDto = mKihonPayrollDao.findForKey(kCode);
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			// lǗ擾
			mKojinDto = mKojinDao.findForKey(kCode);
			
			// l^擾
			cmIncomeTaxDto = cmIncomeTaxDao.findForEmployeeDate(kCode, targetDate);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey(kCode);
		}
	}
	
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setCompanyDataInfo() throws SQLException, IllegalAccessException, NoSuchFieldException {
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		cmCompanyDto = dao.findAll();
	}
	
	/**
	 * at擾
	 * @param dto
	 * @throws MospException
	 */
	private void setJapanDate(WithholdingListDto dto) throws MospException {
		String[] strDate;
		// \pN擾(Ώ۔N)
		if (targetAffDate != null) {
			strDate = getJpImperialCal(listConf, targetAffDate);
			strDate[0] = getCodeName(strDate[0], aryEra);
			dto.setAdjustYear(strDate[0] + strDate[1]);
			dto.setAdjustYearYY(strDate[1]);
			
		}
		if (mKojinDto != null) {
			if (mKojinDto.getSeinenbi() != 0) {
				// N
				strDate = getJpImperialCal(listConf, DateUtil.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				
				strDate[0] = getCodeName(strDate[0], aryEra);
				dto.setBirthDate(strDate[0] + " " + strDate[1] + PayrollConst.NAM_YEAR + " " + strDate[2] + " "
						+ PayrollConst.NAM_MONTH + " " + strDate[3] + PayrollConst.NAM_DAY);
			} else {
				dto.setBirthDate(" " + " " + " " + PayrollConst.NAM_YEAR + " " + " " + " " + PayrollConst.NAM_MONTH
						+ " " + " " + PayrollConst.NAM_DAY);
				
			}
		}
	}
	
	/**
	 * R[h̐ݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setDtoCodeName(WithholdingListDto dto) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		MSyozokuDto mSyozokuDto;
		MYakusyokuDto mYakusyokuDto;
		String positionName;
		String stationName;
		
		// gpDTȌ
		MSyozokuDao mSyozokuDao = new MSyozokuDao();
		mSyozokuDao.initDao(cfg, cmd, aspUser, user, conn);
		MYakusyokuDao mYakusyokuDao = new MYakusyokuDao();
		mYakusyokuDao.initDao(cfg, cmd, aspUser, user, conn);
		
		mSyozokuDto = mSyozokuDao.findForKey(dto.getStationCode());
		if (mSyozokuDto != null) {
			stationName = mSyozokuDto.getSName();
		} else {
			stationName = "";
		}
		
		mYakusyokuDto = mYakusyokuDao.findForKey(dto.getPositionCode(), dto.getTouKyu());
		if (mYakusyokuDto != null) {
			positionName = mYakusyokuDto.getYname();
		} else {
			positionName = "";
		}
		
		if (cmIncomeTaxDto != null) {
			// ېŋ敪
			dto.setIncomeTaxType(getCodeName(dto.getIncomeTaxType(), aryPltIncomeTaxType));
			// N敪
			dto.setAdjustmentType(getCodeName(dto.getAdjustmentType(), aryPltAdjustmentType));
		}
		if (mKihonDto != null) {
			// R[h
			String stationCode = dto.getPositionCode() + " - " + dto.getStationCode();
			// 
			dto.setStationCode(stationCode);
			//dto.setPositionCode("");
			dto.setStationName(stationName);
			dto.setPositionName(positionName);
			
		}
	}
	
	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(AdjustmentReferVo vo, WithholdingListDto dto) throws Exception {
		int line;
		int column;
		int sumtmp;
		// RlNV擾
		getConnection();
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_WITHHOLDINGLIST_XLS);
		
		// wb_[
		poi.prtItem(9, 1, dto.getAdjustYearYY()); // ΏۘaNxNx(gO^Cg)
		
		line = 1;
		poi.prtItem(line, 4, dto.getStationName()); // 
		poi.prtItem(line, 9, dto.getPositionName()); // E
		poi.prtItem(line, 17, dto.getPostalCode()); // X֔ԍ
		poi.prtItem(line, 33, dto.getFName()); // tKi
		poi.prtItem(line, 42, dto.getKCode()); // ԍ
		
		line = 2;
		poi.prtItem(line, 14, dto.getAddress()); // Z
		poi.prtItem(line, 33, dto.getKName()); // 		
		
		poi.prtItem(4, 33, dto.getBirthDate()); // N		
		
		/* ^ */
		// xi^j
		line = 7;
		column = 4;
		if (null != dto.getPaymentMonth01()) {
			poi.prtItem(line, column, dto.getPaymentMonth01());
		}
		if (null != dto.getPaymentMonth02()) {
			prtItemChk(poi, line + 2, column, dto.getPaymentMonth02());
		}
		if (null != dto.getPaymentMonth03()) {
			prtItemChk(poi, line + 4, column, dto.getPaymentMonth03());
		}
		if (null != dto.getPaymentMonth04()) {
			prtItemChk(poi, line + 6, column, dto.getPaymentMonth04());
		}
		if (null != dto.getPaymentMonth05()) {
			prtItemChk(poi, line + 8, column, dto.getPaymentMonth05());
		}
		if (null != dto.getPaymentMonth06()) {
			prtItemChk(poi, line + 10, column, dto.getPaymentMonth06());
		}
		if (null != dto.getPaymentMonth07()) {
			prtItemChk(poi, line + 12, column, dto.getPaymentMonth07());
		}
		if (null != dto.getPaymentMonth08()) {
			prtItemChk(poi, line + 14, column, dto.getPaymentMonth08());
		}
		if (null != dto.getPaymentMonth09()) {
			prtItemChk(poi, line + 16, column, dto.getPaymentMonth09());
		}
		if (null != dto.getPaymentMonth10()) {
			prtItemChk(poi, line + 18, column, dto.getPaymentMonth10());
		}
		if (null != dto.getPaymentMonth11()) {
			prtItemChk(poi, line + 20, column, dto.getPaymentMonth11());
		}
		if (null != dto.getPaymentMonth12()) {
			prtItemChk(poi, line + 22, column, dto.getPaymentMonth12());
		}
		
		// xi^j
		line = 7;
		column = 5;
		if (null != dto.getPaymentPayDay01()) {
			prtItemChk(poi, line, column, dto.getPaymentPayDay01());
		}
		if (null != dto.getPaymentPayDay02()) {
			prtItemChk(poi, line + 2, column, dto.getPaymentPayDay02());
		}
		if (null != dto.getPaymentPayDay03()) {
			prtItemChk(poi, line + 4, column, dto.getPaymentPayDay03());
		}
		if (null != dto.getPaymentPayDay04()) {
			prtItemChk(poi, line + 6, column, dto.getPaymentPayDay04());
		}
		if (null != dto.getPaymentPayDay05()) {
			prtItemChk(poi, line + 8, column, dto.getPaymentPayDay05());
		}
		if (null != dto.getPaymentPayDay06()) {
			prtItemChk(poi, line + 10, column, dto.getPaymentPayDay06());
		}
		if (null != dto.getPaymentPayDay07()) {
			prtItemChk(poi, line + 12, column, dto.getPaymentPayDay07());
		}
		if (null != dto.getPaymentPayDay08()) {
			prtItemChk(poi, line + 14, column, dto.getPaymentPayDay08());
		}
		if (null != dto.getPaymentPayDay09()) {
			prtItemChk(poi, line + 16, column, dto.getPaymentPayDay09());
		}
		if (null != dto.getPaymentPayDay10()) {
			prtItemChk(poi, line + 18, column, dto.getPaymentPayDay10());
		}
		if (null != dto.getPaymentPayDay11()) {
			prtItemChk(poi, line + 20, column, dto.getPaymentPayDay11());
		}
		if (null != dto.getPaymentPayDay12()) {
			prtItemChk(poi, line + 22, column, dto.getPaymentPayDay12());
		}
		
		// xzi^j
		line = 7;
		column = 7;
		if (null != dto.getPayTotalAllowance01()) {
			prtItemChk(poi, line, column, dto.getPayTotalAllowance01());
		}
		if (null != dto.getPayTotalAllowance02()) {
			prtItemChk(poi, line + 2, column, dto.getPayTotalAllowance02());
		}
		if (null != dto.getPayTotalAllowance03()) {
			prtItemChk(poi, line + 4, column, dto.getPayTotalAllowance03());
		}
		if (null != dto.getPayTotalAllowance04()) {
			prtItemChk(poi, line + 6, column, dto.getPayTotalAllowance04());
		}
		if (null != dto.getPayTotalAllowance05()) {
			prtItemChk(poi, line + 8, column, dto.getPayTotalAllowance05());
		}
		if (null != dto.getPayTotalAllowance06()) {
			prtItemChk(poi, line + 10, column, dto.getPayTotalAllowance06());
		}
		if (null != dto.getPayTotalAllowance07()) {
			prtItemChk(poi, line + 12, column, dto.getPayTotalAllowance07());
		}
		if (null != dto.getPayTotalAllowance08()) {
			prtItemChk(poi, line + 14, column, dto.getPayTotalAllowance08());
		}
		if (null != dto.getPayTotalAllowance09()) {
			prtItemChk(poi, line + 16, column, dto.getPayTotalAllowance09());
		}
		if (null != dto.getPayTotalAllowance10()) {
			prtItemChk(poi, line + 18, column, dto.getPayTotalAllowance10());
		}
		if (null != dto.getPayTotalAllowance11()) {
			prtItemChk(poi, line + 20, column, dto.getPayTotalAllowance11());
		}
		if (null != dto.getPayTotalAllowance12()) {
			prtItemChk(poi, line + 22, column, dto.getPayTotalAllowance12());
		}
		
		// Љی̍Tzi^j
		line = 7;
		column = 10;
		if (null != dto.getPaySocInsDeduction01()) {
			prtItemChk(poi, line, column, dto.getPaySocInsDeduction01());
		}
		if (null != dto.getPaySocInsDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getPaySocInsDeduction02());
		}
		if (null != dto.getPaySocInsDeduction03()) {
			prtItemChk(poi, line + 4, column, dto.getPaySocInsDeduction03());
		}
		if (null != dto.getPaySocInsDeduction04()) {
			prtItemChk(poi, line + 6, column, dto.getPaySocInsDeduction04());
		}
		if (null != dto.getPaySocInsDeduction05()) {
			prtItemChk(poi, line + 8, column, dto.getPaySocInsDeduction05());
		}
		if (null != dto.getPaySocInsDeduction06()) {
			prtItemChk(poi, line + 10, column, dto.getPaySocInsDeduction06());
		}
		if (null != dto.getPaySocInsDeduction07()) {
			prtItemChk(poi, line + 12, column, dto.getPaySocInsDeduction07());
		}
		if (null != dto.getPaySocInsDeduction08()) {
			prtItemChk(poi, line + 14, column, dto.getPaySocInsDeduction08());
		}
		if (null != dto.getPaySocInsDeduction09()) {
			prtItemChk(poi, line + 16, column, dto.getPaySocInsDeduction09());
		}
		if (null != dto.getPaySocInsDeduction10()) {
			prtItemChk(poi, line + 18, column, dto.getPaySocInsDeduction10());
		}
		if (null != dto.getPaySocInsDeduction11()) {
			prtItemChk(poi, line + 20, column, dto.getPaySocInsDeduction11());
		}
		if (null != dto.getPaySocInsDeduction12()) {
			prtItemChk(poi, line + 22, column, dto.getPaySocInsDeduction12());
		}
		
		// ЉیT̋^̋zi^j		
		line = 7;
		column = 12;
		if (null != dto.getPayPayInsDeduction01()) {
			prtItemChk(poi, line, column, dto.getPayPayInsDeduction01());
		}
		if (null != dto.getPayPayInsDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getPayPayInsDeduction02());
		}
		if (null != dto.getPayPayInsDeduction03()) {
			prtItemChk(poi, line + 4, column, dto.getPayPayInsDeduction03());
		}
		if (null != dto.getPayPayInsDeduction04()) {
			prtItemChk(poi, line + 6, column, dto.getPayPayInsDeduction04());
		}
		if (null != dto.getPayPayInsDeduction05()) {
			prtItemChk(poi, line + 8, column, dto.getPayPayInsDeduction05());
		}
		if (null != dto.getPayPayInsDeduction06()) {
			prtItemChk(poi, line + 10, column, dto.getPayPayInsDeduction06());
		}
		if (null != dto.getPayPayInsDeduction07()) {
			prtItemChk(poi, line + 12, column, dto.getPayPayInsDeduction07());
		}
		if (null != dto.getPayPayInsDeduction08()) {
			prtItemChk(poi, line + 14, column, dto.getPayPayInsDeduction08());
		}
		if (null != dto.getPayPayInsDeduction09()) {
			prtItemChk(poi, line + 16, column, dto.getPayPayInsDeduction09());
		}
		if (null != dto.getPayPayInsDeduction10()) {
			prtItemChk(poi, line + 18, column, dto.getPayPayInsDeduction10());
		}
		if (null != dto.getPayPayInsDeduction11()) {
			prtItemChk(poi, line + 20, column, dto.getPayPayInsDeduction11());
		}
		if (null != dto.getPayPayInsDeduction12()) {
			prtItemChk(poi, line + 22, column, dto.getPayPayInsDeduction12());
		}
		
		// }{e̐i^j		
		line = 7;
		column = 14;
		if (null != dto.getPayDependentCount01()) {
			prtItemChk(poi, line, column, dto.getPayDependentCount01());
		}
		if (null != dto.getPayDependentCount02()) {
			prtItemChk(poi, line + 2, column, dto.getPayDependentCount02());
		}
		if (null != dto.getPayDependentCount03()) {
			prtItemChk(poi, line + 4, column, dto.getPayDependentCount03());
		}
		if (null != dto.getPayDependentCount04()) {
			prtItemChk(poi, line + 6, column, dto.getPayDependentCount04());
		}
		if (null != dto.getPayDependentCount05()) {
			prtItemChk(poi, line + 8, column, dto.getPayDependentCount05());
		}
		if (null != dto.getPayDependentCount06()) {
			prtItemChk(poi, line + 10, column, dto.getPayDependentCount06());
		}
		if (null != dto.getPayDependentCount07()) {
			prtItemChk(poi, line + 12, column, dto.getPayDependentCount07());
		}
		if (null != dto.getPayDependentCount08()) {
			prtItemChk(poi, line + 14, column, dto.getPayDependentCount08());
		}
		if (null != dto.getPayDependentCount09()) {
			prtItemChk(poi, line + 16, column, dto.getPayDependentCount09());
		}
		if (null != dto.getPayDependentCount10()) {
			prtItemChk(poi, line + 18, column, dto.getPayDependentCount10());
		}
		if (null != dto.getPayDependentCount11()) {
			prtItemChk(poi, line + 20, column, dto.getPayDependentCount11());
		}
		if (null != dto.getPayDependentCount12()) {
			prtItemChk(poi, line + 22, column, dto.getPayDependentCount12());
		}
		
		// ZoŊziŊzji^j
		line = 7;
		column = 17;
		if (null != dto.getPayIncomeTax01()) {
			prtItemChk(poi, line, column, dto.getPayIncomeTax01());
		}
		if (null != dto.getPayIncomeTax02()) {
			prtItemChk(poi, line + 2, column, dto.getPayIncomeTax02());
		}
		if (null != dto.getPayIncomeTax03()) {
			prtItemChk(poi, line + 4, column, dto.getPayIncomeTax03());
		}
		if (null != dto.getPayIncomeTax04()) {
			prtItemChk(poi, line + 6, column, dto.getPayIncomeTax04());
		}
		if (null != dto.getPayIncomeTax05()) {
			prtItemChk(poi, line + 8, column, dto.getPayIncomeTax05());
		}
		if (null != dto.getPayIncomeTax06()) {
			prtItemChk(poi, line + 10, column, dto.getPayIncomeTax06());
		}
		if (null != dto.getPayIncomeTax07()) {
			prtItemChk(poi, line + 12, column, dto.getPayIncomeTax07());
		}
		if (null != dto.getPayIncomeTax08()) {
			prtItemChk(poi, line + 14, column, dto.getPayIncomeTax08());
		}
		if (null != dto.getPayIncomeTax09()) {
			prtItemChk(poi, line + 16, column, dto.getPayIncomeTax09());
		}
		if (null != dto.getPayIncomeTax10()) {
			prtItemChk(poi, line + 18, column, dto.getPayIncomeTax10());
		}
		if (null != dto.getPayIncomeTax11()) {
			prtItemChk(poi, line + 20, column, dto.getPayIncomeTax11());
		}
		if (null != dto.getPayIncomeTax12()) {
			prtItemChk(poi, line + 22, column, dto.getPayIncomeTax12());
		}
		
		// NɂߕsŊzi^j
		line = 7;
		column = 21;
		if (null != dto.getPayAdjCalcGap01()) {
			prtItemChk(poi, line, column, dto.getPayAdjCalcGap01());
		}
		if (null != dto.getPayAdjCalcGap02()) {
			prtItemChk(poi, line + 2, column, dto.getPayAdjCalcGap02());
		}
		if (null != dto.getPayAdjCalcGap03()) {
			prtItemChk(poi, line + 4, column, dto.getPayAdjCalcGap03());
		}
		if (null != dto.getPayAdjCalcGap04()) {
			prtItemChk(poi, line + 6, column, dto.getPayAdjCalcGap04());
		}
		if (null != dto.getPayAdjCalcGap05()) {
			prtItemChk(poi, line + 8, column, dto.getPayAdjCalcGap05());
		}
		if (null != dto.getPayAdjCalcGap06()) {
			prtItemChk(poi, line + 10, column, dto.getPayAdjCalcGap06());
		}
		if (null != dto.getPayAdjCalcGap07()) {
			prtItemChk(poi, line + 12, column, dto.getPayAdjCalcGap07());
		}
		if (null != dto.getPayAdjCalcGap08()) {
			prtItemChk(poi, line + 14, column, dto.getPayAdjCalcGap08());
		}
		if (null != dto.getPayAdjCalcGap09()) {
			prtItemChk(poi, line + 16, column, dto.getPayAdjCalcGap09());
		}
		if (null != dto.getPayAdjCalcGap10()) {
			prtItemChk(poi, line + 18, column, dto.getPayAdjCalcGap10());
		}
		if (null != dto.getPayAdjCalcGap11()) {
			prtItemChk(poi, line + 20, column, dto.getPayAdjCalcGap11());
		}
		if (null != dto.getPayAdjCalcGap12()) {
			prtItemChk(poi, line + 22, column, dto.getPayAdjCalcGap12());
		}
		
		// Ŋzi^j		
		line = 7;
		column = 23;
		if (null != dto.getPayPaymentTax01()) {
			prtItemChk(poi, line + 0, column, dto.getPayPaymentTax01());
		}
		if (null != dto.getPayPaymentTax02()) {
			prtItemChk(poi, line + 2, column, dto.getPayPaymentTax02());
		}
		if (null != dto.getPayPaymentTax03()) {
			prtItemChk(poi, line + 4, column, dto.getPayPaymentTax03());
		}
		if (null != dto.getPayPaymentTax04()) {
			prtItemChk(poi, line + 6, column, dto.getPayPaymentTax04());
		}
		if (null != dto.getPayPaymentTax05()) {
			prtItemChk(poi, line + 8, column, dto.getPayPaymentTax05());
		}
		if (null != dto.getPayPaymentTax06()) {
			prtItemChk(poi, line + 10, column, dto.getPayPaymentTax06());
		}
		if (null != dto.getPayPaymentTax07()) {
			prtItemChk(poi, line + 12, column, dto.getPayPaymentTax07());
		}
		if (null != dto.getPayPaymentTax08()) {
			prtItemChk(poi, line + 14, column, dto.getPayPaymentTax08());
		}
		if (null != dto.getPayPaymentTax09()) {
			prtItemChk(poi, line + 16, column, dto.getPayPaymentTax09());
		}
		if (null != dto.getPayPaymentTax10()) {
			prtItemChk(poi, line + 18, column, dto.getPayPaymentTax10());
		}
		if (null != dto.getPayPaymentTax11()) {
			prtItemChk(poi, line + 20, column, dto.getPayPaymentTax11());
		}
		if (null != dto.getPayPaymentTax12()) {
			prtItemChk(poi, line + 22, column, dto.getPayPaymentTax12());
		}
		
		line = 31;
		prtItemChk(poi, line, 7, dto.getTotalPayTotalAllowance()); // xzvi^j
		prtItemChk(poi, line, 10, dto.getTotalPaySocInsDeduction()); // ^Љیvi^j
		prtItemChk(poi, line, 12, dto.getTotalPayPayInsDeduction()); // ^ЉیT̋^̋zvi^j
		prtItemChk(poi, line, 17, dto.getTotalPayIncomeTax()); // ^ōvi^j
		prtItemChk(poi, line, 21, dto.getTotalPayAdjCalcGap()); // ^Nɂߕsvi^j
		prtItemChk(poi, line, 23, dto.getTotalPayIncomeTax() + dto.getTotalPayAdjCalcGap()); // Ŋzi^j		
		
		/* ܗ^ */
		// xiܗ^j
		line = 33;
		column = 3;
		if (null != dto.getBonusMonth01()) {
			prtItemChk(poi, line + 0, column, dto.getBonusMonth01());
		}
		if (null != dto.getBonusMonth02()) {
			prtItemChk(poi, line + 2, column, dto.getBonusMonth02());
		}
		if (null != dto.getBonusMonth03()) {
			prtItemChk(poi, line + 4, column, dto.getBonusMonth03());
		}
		if (null != dto.getBonusMonth04()) {
			prtItemChk(poi, line + 6, column, dto.getBonusMonth04());
		}
		if (null != dto.getBonusMonth05()) {
			prtItemChk(poi, line + 8, column, dto.getBonusMonth05());
		}
//		if(null != dto.getBonusMonth06())   prtItemChk( poi, Line + 10, Column, dto.getBonusMonth06());
		column = 4;
		if (null != dto.getBonusMonth01()) {
			prtItemChk(poi, line + 0, column, dto.getBonusMonth01());
		}
		if (null != dto.getBonusMonth02()) {
			prtItemChk(poi, line + 2, column, dto.getBonusMonth02());
		}
		if (null != dto.getBonusMonth03()) {
			prtItemChk(poi, line + 4, column, dto.getBonusMonth03());
		}
		if (null != dto.getBonusMonth04()) {
			prtItemChk(poi, line + 6, column, dto.getBonusMonth04());
		}
		if (null != dto.getBonusMonth05()) {
			prtItemChk(poi, line + 8, column, dto.getBonusMonth05());
//		if(null != dto.getBonusMonth06())   prtItemChk( poi, Line + 10, Column, dto.getBonusMonth06());
		}
		
		// xiܗ^j
		column = 5;
		if (null != dto.getBonusPayDay01()) {
			prtItemChk(poi, line + 0, column, dto.getBonusPayDay01());
		}
		if (null != dto.getBonusPayDay02()) {
			prtItemChk(poi, line + 2, column, dto.getBonusPayDay02());
		}
		if (null != dto.getBonusPayDay03()) {
			prtItemChk(poi, line + 4, column, dto.getBonusPayDay03());
		}
		if (null != dto.getBonusPayDay04()) {
			prtItemChk(poi, line + 6, column, dto.getBonusPayDay04());
		}
		if (null != dto.getBonusPayDay05()) {
			prtItemChk(poi, line + 8, column, dto.getBonusPayDay05());
//		if(null != dto.getBonusPayDay06())  prtItemChk( poi, Line + 10, Column,  dto.getBonusPayDay06());
		}
		
		//xziܗ^j
		line = 33;
		column = 7;
		if (null != dto.getBonTotalAllowance01()) {
			prtItemChk(poi, line + 0, column, dto.getBonTotalAllowance01());
		}
		if (null != dto.getBonTotalAllowance02()) {
			prtItemChk(poi, line + 2, column, dto.getBonTotalAllowance02());
		}
		if (null != dto.getBonTotalAllowance03()) {
			prtItemChk(poi, line + 4, column, dto.getBonTotalAllowance03());
		}
		if (null != dto.getBonTotalAllowance04()) {
			prtItemChk(poi, line + 6, column, dto.getBonTotalAllowance04());
		}
		if (null != dto.getBonTotalAllowance05()) {
			prtItemChk(poi, line + 8, column, dto.getBonTotalAllowance05());
//		if(null != dto.getBonTotalAllowance06())  prtItemChk( poi, Line + 10, Column,   dto.getBonTotalAllowance06());
		}
		
		// 
		// Љی̍Tziܗ^j
		line = 33;
		column = 10;
		if (null != dto.getBonSocInsDeduction01()) {
			prtItemChk(poi, line + 0, column, dto.getBonSocInsDeduction01());
		}
		if (null != dto.getBonSocInsDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getBonSocInsDeduction02());
		}
		if (null != dto.getBonSocInsDeduction03()) {
			prtItemChk(poi, line + 4, column, dto.getBonSocInsDeduction03());
		}
		if (null != dto.getBonSocInsDeduction04()) {
			prtItemChk(poi, line + 6, column, dto.getBonSocInsDeduction04());
		}
		if (null != dto.getBonSocInsDeduction05()) {
			prtItemChk(poi, line + 8, column, dto.getBonSocInsDeduction05());
//		if(null != dto.getBonSocInsDeduction06())  prtItemChk( poi, Line + 10, Column,   dto.getBonSocInsDeduction06());
		}
		
		// ЉیT̋^̋ziܗ^j		
		line = 33;
		column = 12;
		if (null != dto.getBonPayInsDeduction01()) {
			prtItemChk(poi, line + 0, column, dto.getBonPayInsDeduction01());
		}
		if (null != dto.getBonPayInsDeduction02()) {
			prtItemChk(poi, line + 2, column, dto.getBonPayInsDeduction02());
		}
		if (null != dto.getBonPayInsDeduction03()) {
			prtItemChk(poi, line + 4, column, dto.getBonPayInsDeduction03());
		}
		if (null != dto.getBonPayInsDeduction04()) {
			prtItemChk(poi, line + 6, column, dto.getBonPayInsDeduction04());
		}
		if (null != dto.getBonPayInsDeduction05()) {
			prtItemChk(poi, line + 8, column, dto.getBonPayInsDeduction05());
//		if(null != dto.getBonPayInsDeduction06()) prtItemChk( poi, Line + 10, Column,   dto.getBonPayInsDeduction06());
		}
		
		// }{e̐iܗ^j
		line = 33;
		column = 14;
		if (null != dto.getBonDependentCount01()) {
			prtItemChk(poi, line + 0, column, dto.getBonDependentCount01());
		}
		if (null != dto.getBonDependentCount02()) {
			prtItemChk(poi, line + 2, column, dto.getBonDependentCount02());
		}
		if (null != dto.getBonDependentCount03()) {
			prtItemChk(poi, line + 4, column, dto.getBonDependentCount03());
		}
		if (null != dto.getBonDependentCount04()) {
			prtItemChk(poi, line + 6, column, dto.getBonDependentCount04());
		}
		if (null != dto.getBonDependentCount05()) {
			prtItemChk(poi, line + 8, column, dto.getBonDependentCount05());
//		if(null != dto.getBonDependentCount06()) prtItemChk( poi, Line + 10, Column,   dto.getBonDependentCount06());
		}
		
		// ZoŊziŊzjiܗ^j
		line = 34;
		column = 17;
		if (null != dto.getBonIncomeTax01()) {
			prtItemChk(poi, line + 0, column, dto.getBonIncomeTax01());
		}
		if (null != dto.getBonIncomeTax02()) {
			prtItemChk(poi, line + 2, column, dto.getBonIncomeTax02());
		}
		if (null != dto.getBonIncomeTax03()) {
			prtItemChk(poi, line + 4, column, dto.getBonIncomeTax03());
		}
		if (null != dto.getBonIncomeTax04()) {
			prtItemChk(poi, line + 6, column, dto.getBonIncomeTax04());
		}
		if (null != dto.getBonIncomeTax05()) {
			prtItemChk(poi, line + 8, column, dto.getBonIncomeTax05());
//		if(null != dto.getBonIncomeTax06()) prtItemChk( poi, Line + 10, Column,   dto.getBonIncomeTax06());
		}
		
		// NɂߕsŊziܗ^j
		line = 33;
		column = 21;
		if (null != dto.getBonAdjCalcGap01()) {
			prtItemChk(poi, line + 0, column, dto.getBonAdjCalcGap01());
		}
		if (null != dto.getBonAdjCalcGap02()) {
			prtItemChk(poi, line + 2, column, dto.getBonAdjCalcGap02());
		}
		if (null != dto.getBonAdjCalcGap03()) {
			prtItemChk(poi, line + 4, column, dto.getBonAdjCalcGap03());
		}
		if (null != dto.getBonAdjCalcGap04()) {
			prtItemChk(poi, line + 6, column, dto.getBonAdjCalcGap04());
		}
		if (null != dto.getBonAdjCalcGap05()) {
			prtItemChk(poi, line + 8, column, dto.getBonAdjCalcGap05());
//		if(null != dto.getBonAdjCalcGap06()) prtItemChk( poi, Line + 10, Column,   dto.getBonAdjCalcGap06());
		}
		
		// Ŋziܗ^j		
		line = 33;
		column = 23;
		if (null != dto.getBonPaymentTax01()) {
			prtItemChk(poi, line + 0, column, dto.getBonPaymentTax01());
		}
		if (null != dto.getBonPaymentTax02()) {
			prtItemChk(poi, line + 2, column, dto.getBonPaymentTax02());
		}
		if (null != dto.getBonPaymentTax03()) {
			prtItemChk(poi, line + 4, column, dto.getBonPaymentTax03());
		}
		if (null != dto.getBonPaymentTax04()) {
			prtItemChk(poi, line + 6, column, dto.getBonPaymentTax04());
		}
		if (null != dto.getBonPaymentTax05()) {
			prtItemChk(poi, line + 8, column, dto.getBonPaymentTax05());
//		if(null != dto.getBonPaymentTax06()) prtItemChk( poi, Line + 10, Column, dto.getBonPaymentTax06());
		}
		
		// Őŗ
		line = 33;
		column = 18;
		if (null != dto.getBonIncomeTaxRate01()) {
			prtItemChk(poi, line + 0, column, dto.getBonIncomeTaxRate01());
		}
		if (null != dto.getBonIncomeTaxRate02()) {
			prtItemChk(poi, line + 2, column, dto.getBonIncomeTaxRate02());
		}
		if (null != dto.getBonIncomeTaxRate03()) {
			prtItemChk(poi, line + 4, column, dto.getBonIncomeTaxRate03());
		}
		if (null != dto.getBonIncomeTaxRate04()) {
			prtItemChk(poi, line + 6, column, dto.getBonIncomeTaxRate04());
		}
		if (null != dto.getBonIncomeTaxRate05()) {
			prtItemChk(poi, line + 8, column, dto.getBonIncomeTaxRate05());
//		if(null != dto.getBonIncomeTaxRate06()) prtItemChk( poi, Line + 10, Column, dto.getBonIncomeTaxRate06());
		}
		
		line = 43;
		prtItemChk(poi, line, 7, dto.getTotalBonTotalAllowance()); // xzviܗ^j
		prtItemChk(poi, line, 10, dto.getTotalBonSocInsDeduction()); //^Љیviܗ^j
		prtItemChk(poi, line, 12, dto.getTotalBonPayInsDeduction()); // ^ЉیT̋^̋zviܗ^j
		prtItemChk(poi, line, 17, dto.getTotalBonIncomeTax()); // ^ōviܗ^j
		prtItemChk(poi, line, 21, dto.getTotalBonAdjCalcGap()); // ^Nɂߕsv
		prtItemChk(poi, line, 23, dto.getTotalBonIncomeTax() + dto.getTotalBonAdjCalcGap()); // Ŋziܗ^j		
		
		/* ONJz */
		line = 7;
		prtItemChk(poi, line, 31, 0); // ҕt͒Ŋz F0
		prtItemChk(poi, line, 35, 0); // c F0
		prtItemChk(poi, line, 40, 0); // ҕt͒Ŋz		
		prtItemChk(poi, line, 43, 0); // c
		
		/* }{T̐\ */
		// }{e		
		line = 12;
		if (null != dto.getGeneralDependent()) {
			prtItemChk(poi, line, 31, dto.getGeneralDependent()); // ҕt͒Ŋz F0
		}
		if ((null != dto.getSpouseGe()) && (dto.getSpouseGe().equals(PayrollConst.ADJ_APPLICABLE))) { // TΏ۔z(ʔzҁȋjL)
			prtItemChk(poi, line, 28, PayrollConst.PRESENCE_ON);
		} else {
			prtItemChk(poi, line, 28, PayrollConst.PRESENCE_OFF);
		}
		if ((null != dto.getSpouseEl()) && (dto.getSpouseEl().equals(PayrollConst.ADJ_APPLICABLE))) { // TΏ۔z(VlzҗL)
			prtItemChk(poi, line, 30, PayrollConst.PRESENCE_ON);
		} else {
			prtItemChk(poi, line, 30, PayrollConst.PRESENCE_OFF);
		}
		if (null != dto.getGeneralDependent()) {
			prtItemChk(poi, line, 31, dto.getGeneralDependent()); // ʂ̕}{e		
		}
		if (null != dto.getSpecificDependent()) {
			prtItemChk(poi, line, 33, dto.getSpecificDependent()); // }{e	
		}
		if (null != dto.getLiveWithEldRel()) {
			prtItemChk(poi, line, 35, dto.getLiveWithEldRel()); // Vl}{e(Ve)
		}
		if (null != dto.getElderlyDependent()) {
			prtItemChk(poi, line, 37, dto.getElderlyDependent()); // Vl}{e(̑)
		}
		if (null != dto.getTotallHandicap()) {
			prtItemChk(poi, line, 39, dto.getTotallHandicap()); // QҌv		
		}
		
		if (null != dto.getTotallDeduction()) {
			prtItemChk(poi, 14, 43, dto.getTotallDeduction()); // ]鋋^TΏ۔z҂ƕ}{e̍v
		}
		if (null != dto.getConsortFlg()) {
			prtItemChk(poi, 15, 45, dto.getConsortFlg()); // z҂̗L
		}
		
		/* N */
		line = 18;
		prtItemChk(poi, line + 0, 35, dto.getTotalPayTotalAllowance()); // ^E蓖Fz
		prtItemChk(poi, line + 0, 41, dto.getTotalPayIncomeTax()); // ^E蓖FŊz
		prtItemChk(poi, line + 1, 35, dto.getTotalBonTotalAllowance()); // ܗ^Fz
		prtItemChk(poi, line + 1, 41, dto.getTotalBonIncomeTax()); // ܗ^FŊz
		prtItemChk(poi, line + 2, 35, dto.getTotalAllowance()); // zv
		prtItemChk(poi, line + 2, 41, dto.getIncomeTax()); // Ŋzv
		column = 35;
		prtItemChk(poi, line + 3, column, dto.getAfterDeductIncome()); // ^T̋^̋z	
		prtItemChk(poi, line + 4, column, dto.getPayInsDeduction()); // ЉیTzF^̍T
		prtItemChk(poi, line + 5, column, 0); // ЉیTzF\ɂЉی̍T(:0)
		prtItemChk(poi, line + 6, column, 0); // ЉیTzF\ɂ鏬K͊Ƌϓ|̍T(:0)
		prtItemChk(poi, line + 8, column, dto.getLifeInsDeduction()); // ی̍Tz
		prtItemChk(poi, line + 9, column, dto.getEarthquakeIns()); // nkی̍Tz
		prtItemChk(poi, line + 10, column, dto.getSpouseSpDeduction()); // zғʍTz
		prtItemChk(poi, line + 11, column, dto.getDependentsDeduction()); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		
		// Tz̍v
		sumtmp = dto.getPayInsDeduction() + dto.getLifeInsDeduction() + dto.getEarthquakeIns()
				+ dto.getSpouseSpDeduction() + dto.getDependentsDeduction();
		prtItemChk(poi, line + 13, 35, sumtmp); // Tz̍vz
		// ېŋ^		
		sumtmp = (int)round(dto.getAfterDeductIncome() - sumtmp, -3, BigDecimal.ROUND_DOWN);
		prtItemChk(poi, line + 16, 35, sumtmp); // ېŋ^z
		
		line = 22;
		column = 41;
		prtItemChk(poi, line + 0, column, dto.getSpouseSumIncome()); // z҂̍vz		
		prtItemChk(poi, line + 2, column, dto.getPrivatePension()); // lNیxz		
		prtItemChk(poi, line + 4, column, dto.getLongTermDamageIns()); // Qیxz					
		prtItemChk(poi, line + 7, column, dto.getMutualAidDeduction()); // K͊Ƌϓ|̋z					
		prtItemChk(poi, line + 10, column, 0); // Nی					
		prtItemChk(poi, line + 12, column, dto.getCalcIncomeTax()); // ZoNŊz
		prtItemChk(poi, line + 13, column, dto.getHouseLoanDeduction()); // ZؓʍTz
		prtItemChk(poi, line + 14, column, dto.getAdjustedIncomeTax()); // NNŊz		
		
		// z
		int sumTmpSashihiki = dto.getAdjustedIncomeTax() - dto.getIncomeTax();
		prtItemChk(poi, line + 15, column, sumTmpSashihiki); // z
		if (0 < sumTmpSashihiki) {
			prtItemChk(poi, line + 15, 29, PayrollConst.BALANCE_LOW); // Fsz
		} else {
			prtItemChk(poi, line + 15, 29, PayrollConst.BALANCE_OVER); // Fߊz
		}
		
		line = 38;
		column = 41;
		prtItemChk(poi, line + 0, column, 0); // {NŌ̋^璥Ŋzɏ[z
		prtItemChk(poi, line + 1, column, 0); // ^ɌW関̐Ŋzɏ[z
		
		// ҕtz
		// izj|i{NŌ̋^璥Ŋzɏ[zj|i^ɌW関̐Ŋzɏ[zj
		sumtmp = sumTmpSashihiki - 0 - 0;
		prtItemChk(poi, line + 2, column, sumtmp); // ҕtz
		prtItemChk(poi, line + 3, column, sumtmp); // {NɊҕtz
		prtItemChk(poi, line + 3, column, 0); // NɂĊҕtz
		prtItemChk(poi, line + 4, column, 0); // {NŌ̋^璥z
		prtItemChk(poi, line + 5, column, 0); // NɌJzĒz
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + PayrollConst.FILE_NAME_SEPARATOR + dto.getKCode()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_WITHHOLDINGLIST_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(AdjustmentReferVo vo, WithholdingListDto dto) throws Exception {
		int line;
		int column;
		int sumTmp;
		
		// RlNV擾
		getConnection();
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE)
				+ PayrollConst.TEMPLATE_WITHHOLDINGLIST_ODS);
		
		// wb_[
		odsBean.setValue(1, 9, dto.getAdjustYearYY()); // ΏۘaNxNx(gO^Cg)
		
		line = 1;
		setValueChk(odsBean, 4, line, dto.getStationName()); // 
		setValueChk(odsBean, 9, line, dto.getPositionName()); // E
		setValueChk(odsBean, 17, line, dto.getPostalCode()); // X֔ԍ
		setValueChk(odsBean, 33, line, dto.getFName()); // tKi
		setValueChk(odsBean, 42, line, dto.getKCode()); // ԍ
		
		line = 2;
		setValueChk(odsBean, 14, line, dto.getAddress()); // Z
		setValueChk(odsBean, 33, line, dto.getKName()); // 		
		
		setValueChk(odsBean, 33, 4, dto.getBirthDate()); // N		
		
		/* ^ */
		// xi^j
		line = 7;
		column = 4;
		if (null != dto.getPaymentMonth01()) {
			setValueChk(odsBean, column, line, dto.getPaymentMonth01());
		}
		if (null != dto.getPaymentMonth02()) {
			setValueChk(odsBean, column, line + 2, dto.getPaymentMonth02());
		}
		if (null != dto.getPaymentMonth03()) {
			setValueChk(odsBean, column, line + 4, dto.getPaymentMonth03());
		}
		if (null != dto.getPaymentMonth04()) {
			setValueChk(odsBean, column, line + 6, dto.getPaymentMonth04());
		}
		if (null != dto.getPaymentMonth05()) {
			setValueChk(odsBean, column, line + 8, dto.getPaymentMonth05());
		}
		if (null != dto.getPaymentMonth06()) {
			setValueChk(odsBean, column, line + 10, dto.getPaymentMonth06());
		}
		if (null != dto.getPaymentMonth07()) {
			setValueChk(odsBean, column, line + 12, dto.getPaymentMonth07());
		}
		if (null != dto.getPaymentMonth08()) {
			setValueChk(odsBean, column, line + 14, dto.getPaymentMonth08());
		}
		if (null != dto.getPaymentMonth09()) {
			setValueChk(odsBean, column, line + 16, dto.getPaymentMonth09());
		}
		if (null != dto.getPaymentMonth10()) {
			setValueChk(odsBean, column, line + 18, dto.getPaymentMonth10());
		}
		if (null != dto.getPaymentMonth11()) {
			setValueChk(odsBean, column, line + 20, dto.getPaymentMonth11());
		}
		if (null != dto.getPaymentMonth12()) {
			setValueChk(odsBean, column, line + 22, dto.getPaymentMonth12());
		}
		
		// xi^j
		line = 7;
		column = 5;
		if (null != dto.getPaymentPayDay01()) {
			setValueChk(odsBean, column, line, dto.getPaymentPayDay01());
		}
		if (null != dto.getPaymentPayDay02()) {
			setValueChk(odsBean, column, line + 2, dto.getPaymentPayDay02());
		}
		if (null != dto.getPaymentPayDay03()) {
			setValueChk(odsBean, column, line + 4, dto.getPaymentPayDay03());
		}
		if (null != dto.getPaymentPayDay04()) {
			setValueChk(odsBean, column, line + 6, dto.getPaymentPayDay04());
		}
		if (null != dto.getPaymentPayDay05()) {
			setValueChk(odsBean, column, line + 8, dto.getPaymentPayDay05());
		}
		if (null != dto.getPaymentPayDay06()) {
			setValueChk(odsBean, column, line + 10, dto.getPaymentPayDay06());
		}
		if (null != dto.getPaymentPayDay07()) {
			setValueChk(odsBean, column, line + 12, dto.getPaymentPayDay07());
		}
		if (null != dto.getPaymentPayDay08()) {
			setValueChk(odsBean, column, line + 14, dto.getPaymentPayDay08());
		}
		if (null != dto.getPaymentPayDay09()) {
			setValueChk(odsBean, column, line + 16, dto.getPaymentPayDay09());
		}
		if (null != dto.getPaymentPayDay10()) {
			setValueChk(odsBean, column, line + 18, dto.getPaymentPayDay10());
		}
		if (null != dto.getPaymentPayDay11()) {
			setValueChk(odsBean, column, line + 20, dto.getPaymentPayDay11());
		}
		if (null != dto.getPaymentPayDay12()) {
			setValueChk(odsBean, column, line + 22, dto.getPaymentPayDay12());
		}
		
		// xzi^j
		line = 7;
		column = 7;
		if (null != dto.getPayTotalAllowance01()) {
			setValueChk(odsBean, column, line, dto.getPayTotalAllowance01());
		}
		if (null != dto.getPayTotalAllowance02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayTotalAllowance02());
		}
		if (null != dto.getPayTotalAllowance03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayTotalAllowance03());
		}
		if (null != dto.getPayTotalAllowance04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayTotalAllowance04());
		}
		if (null != dto.getPayTotalAllowance05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayTotalAllowance05());
		}
		if (null != dto.getPayTotalAllowance06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayTotalAllowance06());
		}
		if (null != dto.getPayTotalAllowance07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayTotalAllowance07());
		}
		if (null != dto.getPayTotalAllowance08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayTotalAllowance08());
		}
		if (null != dto.getPayTotalAllowance09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayTotalAllowance09());
		}
		if (null != dto.getPayTotalAllowance10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayTotalAllowance10());
		}
		if (null != dto.getPayTotalAllowance11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayTotalAllowance11());
		}
		if (null != dto.getPayTotalAllowance12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayTotalAllowance12());
		}
		
		// Љی̍Tzi^j
		line = 7;
		column = 10;
		if (null != dto.getPaySocInsDeduction01()) {
			setValueChk(odsBean, column, line, dto.getPaySocInsDeduction01());
		}
		if (null != dto.getPaySocInsDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getPaySocInsDeduction02());
		}
		if (null != dto.getPaySocInsDeduction03()) {
			setValueChk(odsBean, column, line + 4, dto.getPaySocInsDeduction03());
		}
		if (null != dto.getPaySocInsDeduction04()) {
			setValueChk(odsBean, column, line + 6, dto.getPaySocInsDeduction04());
		}
		if (null != dto.getPaySocInsDeduction05()) {
			setValueChk(odsBean, column, line + 8, dto.getPaySocInsDeduction05());
		}
		if (null != dto.getPaySocInsDeduction06()) {
			setValueChk(odsBean, column, line + 10, dto.getPaySocInsDeduction06());
		}
		if (null != dto.getPaySocInsDeduction07()) {
			setValueChk(odsBean, column, line + 12, dto.getPaySocInsDeduction07());
		}
		if (null != dto.getPaySocInsDeduction08()) {
			setValueChk(odsBean, column, line + 14, dto.getPaySocInsDeduction08());
		}
		if (null != dto.getPaySocInsDeduction09()) {
			setValueChk(odsBean, column, line + 16, dto.getPaySocInsDeduction09());
		}
		if (null != dto.getPaySocInsDeduction10()) {
			setValueChk(odsBean, column, line + 18, dto.getPaySocInsDeduction10());
		}
		if (null != dto.getPaySocInsDeduction11()) {
			setValueChk(odsBean, column, line + 20, dto.getPaySocInsDeduction11());
		}
		if (null != dto.getPaySocInsDeduction12()) {
			setValueChk(odsBean, column, line + 22, dto.getPaySocInsDeduction12());
		}
		
		// ЉیT̋^̋zi^j		
		line = 7;
		column = 12;
		if (null != dto.getPayPayInsDeduction01()) {
			setValueChk(odsBean, column, line, dto.getPayPayInsDeduction01());
		}
		if (null != dto.getPayPayInsDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayPayInsDeduction02());
		}
		if (null != dto.getPayPayInsDeduction03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayPayInsDeduction03());
		}
		if (null != dto.getPayPayInsDeduction04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayPayInsDeduction04());
		}
		if (null != dto.getPayPayInsDeduction05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayPayInsDeduction05());
		}
		if (null != dto.getPayPayInsDeduction06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayPayInsDeduction06());
		}
		if (null != dto.getPayPayInsDeduction07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayPayInsDeduction07());
		}
		if (null != dto.getPayPayInsDeduction08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayPayInsDeduction08());
		}
		if (null != dto.getPayPayInsDeduction09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayPayInsDeduction09());
		}
		if (null != dto.getPayPayInsDeduction10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayPayInsDeduction10());
		}
		if (null != dto.getPayPayInsDeduction11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayPayInsDeduction11());
		}
		if (null != dto.getPayPayInsDeduction12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayPayInsDeduction12());
		}
		
		// }{e̐i^j		
		line = 7;
		column = 14;
		if (null != dto.getPayDependentCount01()) {
			setValueChk(odsBean, column, line, dto.getPayDependentCount01());
		}
		if (null != dto.getPayDependentCount02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayDependentCount02());
		}
		if (null != dto.getPayDependentCount03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayDependentCount03());
		}
		if (null != dto.getPayDependentCount04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayDependentCount04());
		}
		if (null != dto.getPayDependentCount05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayDependentCount05());
		}
		if (null != dto.getPayDependentCount06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayDependentCount06());
		}
		if (null != dto.getPayDependentCount07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayDependentCount07());
		}
		if (null != dto.getPayDependentCount08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayDependentCount08());
		}
		if (null != dto.getPayDependentCount09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayDependentCount09());
		}
		if (null != dto.getPayDependentCount10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayDependentCount10());
		}
		if (null != dto.getPayDependentCount11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayDependentCount11());
		}
		if (null != dto.getPayDependentCount12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayDependentCount12());
		}
		
		// ZoŊziŊzji^j
		line = 7;
		column = 17;
		if (null != dto.getPayIncomeTax01()) {
			setValueChk(odsBean, column, line, dto.getPayIncomeTax01());
		}
		if (null != dto.getPayIncomeTax02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayIncomeTax02());
		}
		if (null != dto.getPayIncomeTax03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayIncomeTax03());
		}
		if (null != dto.getPayIncomeTax04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayIncomeTax04());
		}
		if (null != dto.getPayIncomeTax05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayIncomeTax05());
		}
		if (null != dto.getPayIncomeTax06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayIncomeTax06());
		}
		if (null != dto.getPayIncomeTax07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayIncomeTax07());
		}
		if (null != dto.getPayIncomeTax08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayIncomeTax08());
		}
		if (null != dto.getPayIncomeTax09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayIncomeTax09());
		}
		if (null != dto.getPayIncomeTax10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayIncomeTax10());
		}
		if (null != dto.getPayIncomeTax11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayIncomeTax11());
		}
		if (null != dto.getPayIncomeTax12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayIncomeTax12());
		}
		
		// NɂߕsŊzi^j
		line = 7;
		column = 21;
		if (null != dto.getPayAdjCalcGap01()) {
			setValueChk(odsBean, column, line, dto.getPayAdjCalcGap01());
		}
		if (null != dto.getPayAdjCalcGap02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayAdjCalcGap02());
		}
		if (null != dto.getPayAdjCalcGap03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayAdjCalcGap03());
		}
		if (null != dto.getPayAdjCalcGap04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayAdjCalcGap04());
		}
		if (null != dto.getPayAdjCalcGap05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayAdjCalcGap05());
		}
		if (null != dto.getPayAdjCalcGap06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayAdjCalcGap06());
		}
		if (null != dto.getPayAdjCalcGap07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayAdjCalcGap07());
		}
		if (null != dto.getPayAdjCalcGap08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayAdjCalcGap08());
		}
		if (null != dto.getPayAdjCalcGap09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayAdjCalcGap09());
		}
		if (null != dto.getPayAdjCalcGap10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayAdjCalcGap10());
		}
		if (null != dto.getPayAdjCalcGap11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayAdjCalcGap11());
		}
		if (null != dto.getPayAdjCalcGap12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayAdjCalcGap12());
		}
		
		// Ŋzi^j		
		line = 7;
		column = 23;
		if (null != dto.getPayPaymentTax01()) {
			setValueChk(odsBean, column, line + 0, dto.getPayPaymentTax01());
		}
		if (null != dto.getPayPaymentTax02()) {
			setValueChk(odsBean, column, line + 2, dto.getPayPaymentTax02());
		}
		if (null != dto.getPayPaymentTax03()) {
			setValueChk(odsBean, column, line + 4, dto.getPayPaymentTax03());
		}
		if (null != dto.getPayPaymentTax04()) {
			setValueChk(odsBean, column, line + 6, dto.getPayPaymentTax04());
		}
		if (null != dto.getPayPaymentTax05()) {
			setValueChk(odsBean, column, line + 8, dto.getPayPaymentTax05());
		}
		if (null != dto.getPayPaymentTax06()) {
			setValueChk(odsBean, column, line + 10, dto.getPayPaymentTax06());
		}
		if (null != dto.getPayPaymentTax07()) {
			setValueChk(odsBean, column, line + 12, dto.getPayPaymentTax07());
		}
		if (null != dto.getPayPaymentTax08()) {
			setValueChk(odsBean, column, line + 14, dto.getPayPaymentTax08());
		}
		if (null != dto.getPayPaymentTax09()) {
			setValueChk(odsBean, column, line + 16, dto.getPayPaymentTax09());
		}
		if (null != dto.getPayPaymentTax10()) {
			setValueChk(odsBean, column, line + 18, dto.getPayPaymentTax10());
		}
		if (null != dto.getPayPaymentTax11()) {
			setValueChk(odsBean, column, line + 20, dto.getPayPaymentTax11());
		}
		if (null != dto.getPayPaymentTax12()) {
			setValueChk(odsBean, column, line + 22, dto.getPayPaymentTax12());
		}
		
		line = 31;
		setValueChk(odsBean, 7, line, dto.getTotalPayTotalAllowance()); // xzvi^j
		setValueChk(odsBean, 10, line, dto.getTotalPaySocInsDeduction()); // ^Љیvi^j
		setValueChk(odsBean, 12, line, dto.getTotalPayPayInsDeduction()); // ^ЉیT̋^̋zvi^j
		setValueChk(odsBean, 17, line, dto.getTotalPayIncomeTax()); // ^ōvi^j
		setValueChk(odsBean, 21, line, dto.getTotalPayAdjCalcGap()); // ^Nɂߕsvi^j
		setValueChk(odsBean, 23, line, dto.getTotalPayIncomeTax() + dto.getTotalPayAdjCalcGap()); // Ŋzi^j		
		
		/* ܗ^ */
		// xiܗ^j
		line = 33;
		column = 3;
		if (null != dto.getBonusMonth01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonusMonth01());
		}
		if (null != dto.getBonusMonth02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonusMonth02());
		}
		if (null != dto.getBonusMonth03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonusMonth03());
		}
		if (null != dto.getBonusMonth04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonusMonth04());
		}
		if (null != dto.getBonusMonth05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonusMonth05());
		}
//		if(null != dto.getBonusMonth06())   setValueChk( odsBean, Column, Line + 10, dto.getBonusMonth06());
		column = 4;
		if (null != dto.getBonusMonth01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonusMonth01());
		}
		if (null != dto.getBonusMonth02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonusMonth02());
		}
		if (null != dto.getBonusMonth03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonusMonth03());
		}
		if (null != dto.getBonusMonth04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonusMonth04());
		}
		if (null != dto.getBonusMonth05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonusMonth05());
//		if(null != dto.getBonusMonth06())   setValueChk( odsBean, Column, Line + 10, dto.getBonusMonth06());
		}
		
		// xiܗ^j
		column = 5;
		if (null != dto.getBonusPayDay01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonusPayDay01());
		}
		if (null != dto.getBonusPayDay02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonusPayDay02());
		}
		if (null != dto.getBonusPayDay03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonusPayDay03());
		}
		if (null != dto.getBonusPayDay04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonusPayDay04());
		}
		if (null != dto.getBonusPayDay05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonusPayDay05());
//		if(null != dto.getBonusPayDay06())  setValueChk( odsBean, Column, Line + 10,  dto.getBonusPayDay06());
		}
		
		//xziܗ^j
		line = 33;
		column = 7;
		if (null != dto.getBonTotalAllowance01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonTotalAllowance01());
		}
		if (null != dto.getBonTotalAllowance02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonTotalAllowance02());
		}
		if (null != dto.getBonTotalAllowance03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonTotalAllowance03());
		}
		if (null != dto.getBonTotalAllowance04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonTotalAllowance04());
		}
		if (null != dto.getBonTotalAllowance05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonTotalAllowance05());
//		if(null != dto.getBonTotalAllowance06())  setValueChk( odsBean, Column, Line + 10,   dto.getBonTotalAllowance06());
		}
		
		// 
		// Љی̍Tziܗ^j
		line = 33;
		column = 10;
		if (null != dto.getBonSocInsDeduction01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonSocInsDeduction01());
		}
		if (null != dto.getBonSocInsDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonSocInsDeduction02());
		}
		if (null != dto.getBonSocInsDeduction03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonSocInsDeduction03());
		}
		if (null != dto.getBonSocInsDeduction04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonSocInsDeduction04());
		}
		if (null != dto.getBonSocInsDeduction05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonSocInsDeduction05());
//		if(null != dto.getBonSocInsDeduction06())  setValueChk( odsBean, Column, Line + 10,   dto.getBonSocInsDeduction06());
		}
		
		// ЉیT̋^̋ziܗ^j		
		line = 33;
		column = 12;
		if (null != dto.getBonPayInsDeduction01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPayInsDeduction01());
		}
		if (null != dto.getBonPayInsDeduction02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonPayInsDeduction02());
		}
		if (null != dto.getBonPayInsDeduction03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonPayInsDeduction03());
		}
		if (null != dto.getBonPayInsDeduction04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonPayInsDeduction04());
		}
		if (null != dto.getBonPayInsDeduction05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonPayInsDeduction05());
//		if(null != dto.getBonPayInsDeduction06()) setValueChk( odsBean, Column, Line + 10,   dto.getBonPayInsDeduction06());
		}
		
		// }{e̐iܗ^j
		line = 33;
		column = 14;
		if (null != dto.getBonDependentCount01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonDependentCount01());
		}
		if (null != dto.getBonDependentCount02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonDependentCount02());
		}
		if (null != dto.getBonDependentCount03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonDependentCount03());
		}
		if (null != dto.getBonDependentCount04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonDependentCount04());
		}
		if (null != dto.getBonDependentCount05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonDependentCount05());
//		if(null != dto.getBonDependentCount06()) setValueChk( odsBean, Column, Line + 10,   dto.getBonDependentCount06());
		}
		
		// ZoŊziŊzjiܗ^j
		line = 34;
		column = 17;
		if (null != dto.getBonIncomeTax01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonIncomeTax01());
		}
		if (null != dto.getBonIncomeTax02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonIncomeTax02());
		}
		if (null != dto.getBonIncomeTax03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonIncomeTax03());
		}
		if (null != dto.getBonIncomeTax04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonIncomeTax04());
		}
		if (null != dto.getBonIncomeTax05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonIncomeTax05());
//		if(null != dto.getBonIncomeTax06()) setValueChk( odsBean, Column, Line + 10,   dto.getBonIncomeTax06());
		}
		
		// NɂߕsŊziܗ^j
		line = 33;
		column = 21;
		if (null != dto.getBonAdjCalcGap01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonAdjCalcGap01());
		}
		if (null != dto.getBonAdjCalcGap02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonAdjCalcGap02());
		}
		if (null != dto.getBonAdjCalcGap03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonAdjCalcGap03());
		}
		if (null != dto.getBonAdjCalcGap04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonAdjCalcGap04());
		}
		if (null != dto.getBonAdjCalcGap05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonAdjCalcGap05());
//		if(null != dto.getBonAdjCalcGap06()) setValueChk( odsBean, Column, Line + 10,   dto.getBonAdjCalcGap06());
		}
		
		// Ŋziܗ^j		
		line = 33;
		column = 23;
		if (null != dto.getBonPaymentTax01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonPaymentTax01());
		}
		if (null != dto.getBonPaymentTax02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonPaymentTax02());
		}
		if (null != dto.getBonPaymentTax03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonPaymentTax03());
		}
		if (null != dto.getBonPaymentTax04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonPaymentTax04());
		}
		if (null != dto.getBonPaymentTax05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonPaymentTax05());
//		if(null != dto.getBonPaymentTax06()) setValueChk( odsBean, Column, Line + 10, dto.getBonPaymentTax06());
		}
		
		// Őŗ
		line = 33;
		column = 18;
		if (null != dto.getBonIncomeTaxRate01()) {
			setValueChk(odsBean, column, line + 0, dto.getBonIncomeTaxRate01());
		}
		if (null != dto.getBonIncomeTaxRate02()) {
			setValueChk(odsBean, column, line + 2, dto.getBonIncomeTaxRate02());
		}
		if (null != dto.getBonIncomeTaxRate03()) {
			setValueChk(odsBean, column, line + 4, dto.getBonIncomeTaxRate03());
		}
		if (null != dto.getBonIncomeTaxRate04()) {
			setValueChk(odsBean, column, line + 6, dto.getBonIncomeTaxRate04());
		}
		if (null != dto.getBonIncomeTaxRate05()) {
			setValueChk(odsBean, column, line + 8, dto.getBonIncomeTaxRate05());
//		if(null != dto.getBonIncomeTaxRate06()) setValueChk( odsBean, Column, Line + 10, dto.getBonIncomeTaxRate06());
		}
		
		line = 43;
		setValueChk(odsBean, 7, line, dto.getTotalBonTotalAllowance()); // xzviܗ^j
		setValueChk(odsBean, 10, line, dto.getTotalBonSocInsDeduction()); //^Љیviܗ^j
		setValueChk(odsBean, 12, line, dto.getTotalBonPayInsDeduction()); // ^ЉیT̋^̋zviܗ^j
		setValueChk(odsBean, 17, line, dto.getTotalBonIncomeTax()); // ^ōviܗ^j
		setValueChk(odsBean, 21, line, dto.getTotalBonAdjCalcGap()); // ^Nɂߕsv
		setValueChk(odsBean, 23, line, dto.getTotalBonIncomeTax() + dto.getTotalBonAdjCalcGap()); // Ŋziܗ^j		
		
		/* ONJz */
		line = 7;
		setValueChk(odsBean, 31, line, 0); // ҕt͒Ŋz F0
		setValueChk(odsBean, 35, line, 0); // c F0
		setValueChk(odsBean, 40, line, 0); // ҕt͒Ŋz		
		setValueChk(odsBean, 43, line, 0); // c
		
		/* }{T̐\ */
		// }{e		
		line = 12;
		if (null != dto.getGeneralDependent()) {
			setValueChk(odsBean, line, 31, dto.getGeneralDependent()); // ҕt͒Ŋz F0
		}
		if ((null != dto.getSpouseGe()) && (dto.getSpouseGe().equals(PayrollConst.ADJ_APPLICABLE))) { // TΏ۔z(ʔzҁȋjL)
			setValueChk(odsBean, 28, line, PayrollConst.PRESENCE_ON);
		} else {
			setValueChk(odsBean, 28, line, PayrollConst.PRESENCE_OFF);
		}
		if ((null != dto.getSpouseEl()) && (dto.getSpouseEl().equals(PayrollConst.ADJ_APPLICABLE))) { // TΏ۔z(VlzҗL)
			setValueChk(odsBean, 30, line, PayrollConst.PRESENCE_ON);
		} else {
			setValueChk(odsBean, 30, line, PayrollConst.PRESENCE_OFF);
		}
		if (null != dto.getGeneralDependent()) {
			setValueChk(odsBean, 31, line, dto.getGeneralDependent()); // ʂ̕}{e		
		}
		if (null != dto.getSpecificDependent()) {
			setValueChk(odsBean, 33, line, dto.getSpecificDependent()); // }{e	
		}
		if (null != dto.getLiveWithEldRel()) {
			setValueChk(odsBean, 35, line, dto.getLiveWithEldRel()); // Vl}{e(Ve)
		}
		if (null != dto.getElderlyDependent()) {
			setValueChk(odsBean, 37, line, dto.getElderlyDependent()); // Vl}{e(̑)
		}
		if (null != dto.getTotallHandicap()) {
			setValueChk(odsBean, 39, line, dto.getTotallHandicap()); // QҌv		
		}
		
		if (null != dto.getTotallDeduction()) {
			setValueChk(odsBean, 43, 14, dto.getTotallDeduction()); // ]鋋^TΏ۔z҂ƕ}{e̍v
		}
		if (null != dto.getConsortFlg()) {
			setValueChk(odsBean, 45, 15, dto.getConsortFlg()); // z҂̗L
		}
		
		/* N */
		line = 18;
		setValueChk(odsBean, 35, line + 0, dto.getTotalPayTotalAllowance()); // ^E蓖Fz
		setValueChk(odsBean, 41, line + 0, dto.getTotalPayIncomeTax()); // ^E蓖FŊz
		setValueChk(odsBean, 35, line + 1, dto.getTotalBonTotalAllowance()); // ܗ^Fz
		setValueChk(odsBean, 41, line + 1, dto.getTotalBonIncomeTax()); // ܗ^FŊz
		setValueChk(odsBean, 35, line + 2, dto.getTotalAllowance()); // zv
		setValueChk(odsBean, 41, line + 2, dto.getIncomeTax()); // Ŋzv
		column = 35;
		setValueChk(odsBean, column, line + 3, dto.getAfterDeductIncome()); // ^T̋^̋z	
		setValueChk(odsBean, column, line + 4, dto.getPayInsDeduction()); // ЉیTzF^̍T
		setValueChk(odsBean, column, line + 5, 0); // ЉیTzF\ɂЉی̍T(:0)
		setValueChk(odsBean, column, line + 6, 0); // ЉیTzF\ɂ鏬K͊Ƌϓ|̍T(:0)
		setValueChk(odsBean, column, line + 8, dto.getLifeInsDeduction()); // ی̍Tz
		setValueChk(odsBean, column, line + 9, dto.getEarthquakeIns()); // nkی̍Tz
		setValueChk(odsBean, column, line + 10, dto.getSpouseSpDeduction()); // zғʍTz
		setValueChk(odsBean, column, line + 11, dto.getDependentsDeduction()); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		
		// Tz̍v
		sumTmp = dto.getPayInsDeduction() + dto.getLifeInsDeduction() + dto.getEarthquakeIns()
				+ dto.getSpouseSpDeduction() + dto.getDependentsDeduction();
		setValueChk(odsBean, 35, line + 13, sumTmp); // Tz̍vz
		// ېŋ^		
		sumTmp = (int)round(dto.getAfterDeductIncome() - sumTmp, -3, BigDecimal.ROUND_DOWN);
		setValueChk(odsBean, 35, line + 16, sumTmp); // ېŋ^z
		
		line = 22;
		column = 41;
		setValueChk(odsBean, column, line + 0, dto.getSpouseSumIncome()); // z҂̍vz		
		setValueChk(odsBean, column, line + 2, dto.getPrivatePension()); // lNیxz		
		setValueChk(odsBean, column, line + 4, dto.getLongTermDamageIns()); // Qیxz					
		setValueChk(odsBean, column, line + 7, dto.getMutualAidDeduction()); // K͊Ƌϓ|̋z					
		setValueChk(odsBean, column, line + 10, 0); // Nی					
		setValueChk(odsBean, column, line + 12, dto.getCalcIncomeTax()); // ZoNŊz
		setValueChk(odsBean, column, line + 13, dto.getHouseLoanDeduction()); // ZؓʍTz
		setValueChk(odsBean, column, line + 14, dto.getAdjustedIncomeTax()); // NNŊz		
		
		// z
		int sumTmpSashihiki = dto.getAdjustedIncomeTax() - dto.getIncomeTax();
		setValueChk(odsBean, column, line + 15, sumTmpSashihiki); // z
		if (0 < sumTmpSashihiki) {
			setValueChk(odsBean, 29, line + 15, PayrollConst.BALANCE_LOW); // Fsz
		} else {
			setValueChk(odsBean, 29, line + 15, PayrollConst.BALANCE_OVER); // Fߊz
		}
		
		line = 38;
		column = 41;
		setValueChk(odsBean, column, line + 0, 0); // {NŌ̋^璥Ŋzɏ[z
		setValueChk(odsBean, column, line + 1, 0); // ^ɌW関̐Ŋzɏ[z
		
		// ҕtz
		// izj|i{NŌ̋^璥Ŋzɏ[zj|i^ɌW関̐Ŋzɏ[zj
		sumTmp = sumTmpSashihiki - 0 - 0;
		setValueChk(odsBean, column, line + 2, sumTmp); // ҕtz
		setValueChk(odsBean, column, line + 3, sumTmp); // {NɊҕtz
		setValueChk(odsBean, column, line + 3, 0); // NɂĊҕtz
		setValueChk(odsBean, column, line + 4, 0); // {NŌ̋^璥z
		setValueChk(odsBean, column, line + 5, 0); // NɌJzĒz
		
		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + PayrollConst.FILE_NAME_SEPARATOR + dto.getKCode()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_WITHHOLDINGLIST_ODS;
		
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}
	
}
