/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.io.File;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.ResidenceTaxDao;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.ResidenceTaxDto;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * @author koike
 *
 */
public class ResidenceTaxListAction extends PayrollAction {
	
	//R}h
	private static final String	CMD_RESID_TAX_PERSON	= "P9018";
	private static final String	CMD_RESID_TAX_COMPANY	= "P9019";
	
	private Date				sysDate;
	

	/**
	 * RXgN^
	 */
	public ResidenceTaxListAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		//VO擾yѐݒ
		prepareVo();
		
		//[o͓t擾
		sysDate = getSystemDate();
		
		if (cmd.equals(CMD_RESID_TAX_PERSON)) {
			personTax();
		} else if (cmd.equals(CMD_RESID_TAX_COMPANY)) {
			companyTax();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		
	}
	
	/**
	 * Zňꗗ\쐬(ZŐl)
	 * @throws Exception Oꍇ
	 */
	private void personTax() throws Exception {
		//DBRlNV擾
		getConnection();
		//PAYROLLmF
		confirmPayrollAuth();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		//p[^擾
		vo.setParams(request);
		//Ώ۔N擾
		Date date = vo.getDate(String.valueOf(vo.getPltOutYear()), String.valueOf(vo.getPltOutMonth()), String
			.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		
		//ZŃf[^擾
		ResidenceTaxDao dao = new ResidenceTaxDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<ResidenceTaxDto> list = dao.findForCondition(date);
		//DAO
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = cmCompanyDao.findAll();
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			//ODS
			makeAttendanceBookOds(list, vo, date, dto);
		} else {
			//XLS
			makeAttendanceBook(list, vo, date, dto);
		}
		
	}
	
	/**
	 * Zňꗗ\쐬(ZŎs)
	 * @throws Exception Oꍇ
	 */
	private void companyTax() throws Exception {
		//DBRlNV擾
		getConnection();
		//PAYROLLmF
		confirmPayrollAuth();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		//p[^擾
		vo.setParams(request);
		//Ώ۔N擾
		Date date = vo.getDate(String.valueOf(vo.getPltOutYear()), String.valueOf(vo.getPltOutMonth()), String
			.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		//ZŃf[^擾
		ResidenceTaxDao dao = new ResidenceTaxDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<ResidenceTaxDto> list = dao.findForCondition(date);
		//DAO
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = cmCompanyDao.findAll();
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			//ODS
			makeAttendanceBook2Ods(list, vo, date, dto);
		} else {
			//XLS
			makeAttendanceBook2(list, vo, date, dto);
		}
	}
	
	/**
	 * Zňꗗ\쐬(ZŐl)XLS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception Oꍇ
	 */
	private void makeAttendanceBook(List<ResidenceTaxDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		String cityCodeOld = "";
		String cityCodeNew = "";
		int subCnt = 0;
		int subTotalAmo = 0;
		int totalAmo = 0;
		int totalCnt = 0;
		int printDataRow = 7;
		//[쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_RES_TAX_PARSON_LIST);
		//tHgݒׂ̈̏
		poi.createCellStyleAndFont();
		setStyle(poi, true, false);
		//wb_[ݒ
		poi.prtItem(1, 0, jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		poi.prtItem(3, 1, companyDto.getCompanyName());
		poi.prtItem(3, 5, jpnYMD(sysDate, vo));
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow++;
					poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  "
							+ subCnt + PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
					setStyle(poi, false, true);
					printDataRow++;
					totalCnt = totalCnt + subCnt;
					subCnt = 0;
				}
				printDataRow++;
				poi.prtItem(printDataRow, 1, PayrollConst.BRACKET_LEFT2 + dto.getPaymentCityCode()
						+ PayrollConst.BRACKET_RIGHT2);
				setStyle(poi, false, true);
				poi.prtItem(printDataRow, 3, dto.getCityName());
				setStyle(poi, false, true);
				printDataRow++;
			}
			
			poi.prtItem(printDataRow, 1, dto.getKCode());
			setStyle(poi, false, true);
			poi.prtItem(printDataRow, 3, dto.getKName());
			setStyle(poi, false, true);
			printDataRow++;
			subCnt++;
			cityCodeOld = cityCodeNew;
		}
		if (dtolist.size() != 0) {
			printDataRow++;
			totalCnt = totalCnt + subCnt;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
					+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			printDataRow++;
			printDataRow++;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
					+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			
		}
		
		//z̐ݒ
		setStyle(poi, true, false);
		printDataRow = 9;
		
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow++;
					poi.prtBorderTop(printDataRow, 5);
					poi.prtItem(printDataRow, 5, insertComma(String.valueOf(subTotalAmo)));
					setStyle(poi, false, false);
					setStyle(poi, true, false);
					printDataRow = printDataRow + 3;
					totalAmo = totalAmo + subTotalAmo;
					subTotalAmo = 0;
				}
			}
			poi.prtItem(printDataRow, 5, insertComma(String.valueOf(dto.getResidenceTax())));
			setStyle(poi, false, false);
			subTotalAmo = subTotalAmo + dto.getResidenceTax();
			printDataRow++;
			cityCodeOld = cityCodeNew;
		}
		
		if (dtolist.size() != 0) {
			printDataRow++;
			totalAmo = totalAmo + subTotalAmo;
			poi.prtBorderTop(printDataRow, 5);
			poi.prtItem(printDataRow, 5, insertComma(String.valueOf(subTotalAmo)));
			setStyle(poi, false, false);
			printDataRow = printDataRow + 2;
			poi.prtBorderTop(printDataRow, 5);
			poi.prtItem(printDataRow, 5, insertComma(String.valueOf(totalAmo)));
			setStyle(poi, false, false);
		}
		String fileName = vo.getPltYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_RES_TAX_PARSON_LIST;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * Zňꗗ\쐬(ZŐl)ODS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception Oꍇ
	 */
	private void makeAttendanceBookOds(List<ResidenceTaxDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		String cityCodeOld = "";
		String cityCodeNew = "";
		int subCnt = 0;
		int subTotalAmo = 0;
		int totalAmo = 0;
		int totalCnt = 0;
		int printDataRow = 7;
		//ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(PayrollConst.TEMPLATE_RES_TAX_PARSON_LIST_ODS);
		//[쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		//V[g
		Sheet sheet = ss.getSheet(0);
		//wb_[ݒ
		sheet.getCellAt(0, 1).setValue(jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		sheet.getCellAt(1, 3).setValue(companyDto.getCompanyName());
		sheet.getCellAt(5, 3).setValue(jpnYMD(sysDate, vo));
		//rX^CR[h̎擾
		String styleCodeBorderBotom = sheet.getCellAt(3, 3).getStyleName();
		//׃f[^̐ݒ
		sheet.insertDuplicatedRows(sheet.getRowCount() - 1, 6000);
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow = printDataRow + 2;
					sheet.getCellAt(3, printDataRow).setValue(
							PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
									+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
					printDataRow++;
					totalCnt = totalCnt + subCnt;
					subCnt = 0;
				}
				printDataRow++;
				sheet.getCellAt(1, printDataRow).setValue(
						PayrollConst.BRACKET_LEFT2 + dto.getPaymentCityCode() + PayrollConst.BRACKET_RIGHT2);
				sheet.getCellAt(3, printDataRow).setValue(dto.getCityName());
				printDataRow++;
			}
			sheet.getCellAt(1, printDataRow).setValue(dto.getKCode());
			sheet.getCellAt(3, printDataRow).setValue(dto.getKName());
			printDataRow++;
			subCnt++;
			cityCodeOld = cityCodeNew;
		}
		if (dtolist.size() != 0) {
			printDataRow = printDataRow + 2;
			totalCnt = totalCnt + subCnt;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
							+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
							+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			
		}
		//z̐ݒ
		printDataRow = 9;
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow++;
					sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
					printDataRow++;
					sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(subTotalAmo)));
					printDataRow = printDataRow + 3;
					totalAmo = totalAmo + subTotalAmo;
					subTotalAmo = 0;
				}
			}
			sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(dto.getResidenceTax())));
			subTotalAmo = subTotalAmo + dto.getResidenceTax();
			printDataRow++;
			cityCodeOld = cityCodeNew;
		}
		
		if (dtolist.size() != 0) {
			totalAmo = totalAmo + subTotalAmo;
			printDataRow++;
			sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(subTotalAmo)));
			printDataRow++;
			sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(totalAmo)));
		}
		String fileName = vo.getPltYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_RES_TAX_PARSON_LIST_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * Zňꗗ\쐬(ZŎs撬)
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception Oꍇ
	 */
	private void makeAttendanceBook2(List<ResidenceTaxDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		String cityCodeOld = "";
		String cityCodeNew = "";
		int subCnt = 0;
		int subTotalAmo = 0;
		int totalAmo = 0;
		int totalCnt = 0;
		int printDataRow = 7;
		//[쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_RES_TAX_LIST);
		//tHgݒׂ̈̏
		poi.createCellStyleAndFont();
		setStyle(poi, true, false);
		//wb_[ݒ
		poi.prtItem(1, 0, jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		poi.prtItem(3, 1, companyDto.getCompanyName());
		poi.prtItem(3, 5, jpnYMD(sysDate, vo));
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow++;
					poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  "
							+ subCnt + PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
					setStyle(poi, false, true);
					printDataRow++;
					totalCnt = totalCnt + subCnt;
					subCnt = 0;
				}
				printDataRow++;
				poi.prtItem(printDataRow, 1, PayrollConst.BRACKET_LEFT2 + dto.getPaymentCityCode()
						+ PayrollConst.BRACKET_RIGHT2);
				setStyle(poi, false, true);
				poi.prtItem(printDataRow, 3, dto.getCityName());
				setStyle(poi, false, true);
				printDataRow++;
			}
			//Z
			subCnt++;
			cityCodeOld = cityCodeNew;
		}
		if (dtolist.size() != 0) {
			printDataRow++;
			totalCnt = totalCnt + subCnt;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
					+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			printDataRow++;
			printDataRow++;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
					+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			
		}
		
		//z̐ݒ
		setStyle(poi, true, false);
		printDataRow = 10;
		
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					poi.prtItem(printDataRow, 5, insertComma(String.valueOf(subTotalAmo)));
					setStyle(poi, false, false);
					printDataRow = printDataRow + 4;
					setStyle(poi, true, false);
					totalAmo = totalAmo + subTotalAmo;
					subTotalAmo = 0;
				}
			}
			subTotalAmo = subTotalAmo + dto.getResidenceTax();
			cityCodeOld = cityCodeNew;
		}
		
		if (dtolist.size() != 0) {
			totalAmo = totalAmo + subTotalAmo;
			poi.prtItem(printDataRow, 5, insertComma(String.valueOf(subTotalAmo)));
			setStyle(poi, false, false);
			printDataRow = printDataRow + 2;
			poi.prtBorderTop(printDataRow, 5);
			poi.prtItem(printDataRow, 5, insertComma(String.valueOf(totalAmo)));
			setStyle(poi, false, false);
		}
		String fileName = vo.getPltYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_RES_TAX_LIST;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * Zňꗗ\쐬(ZŎs撬)
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception Oꍇ
	 */
	private void makeAttendanceBook2Ods(List<ResidenceTaxDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		String cityCodeOld = "";
		String cityCodeNew = "";
		int subCnt = 0;
		int subTotalAmo = 0;
		int totalAmo = 0;
		int totalCnt = 0;
		int printDataRow = 7;
		//ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(PayrollConst.TEMPLATE_RES_TAX_LIST_ODS);
		//[쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		//V[g
		Sheet sheet = ss.getSheet(0);
		//wb_[ݒ
		sheet.getCellAt(0, 1).setValue(jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		sheet.getCellAt(1, 3).setValue(companyDto.getCompanyName());
		sheet.getCellAt(5, 3).setValue(jpnYMD(sysDate, vo));
		//rX^CR[h̎擾
		String styleCodeBorderBotom = sheet.getCellAt(3, 3).getStyleName();
		//׃f[^̐ݒ
		sheet.insertDuplicatedRows(sheet.getRowCount() - 1, 6000);
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					printDataRow++;
					sheet.getCellAt(3, printDataRow).setValue(
							PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
									+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
					printDataRow++;
					totalCnt = totalCnt + subCnt;
					subCnt = 0;
				}
				printDataRow++;
				sheet.getCellAt(1, printDataRow).setValue(
						PayrollConst.BRACKET_LEFT2 + dto.getPaymentCityCode() + PayrollConst.BRACKET_RIGHT2);
				sheet.getCellAt(3, printDataRow).setValue(dto.getCityName());
				printDataRow++;
			}
			//Z
			subCnt++;
			cityCodeOld = cityCodeNew;
		}
		if (dtolist.size() != 0) {
			printDataRow++;
			totalCnt = totalCnt + subCnt;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CITY_PARSON_TOTAL + "  " + subCnt
							+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			printDataRow++;
			printDataRow++;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
							+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
		}
		
		//z̐ݒ
		printDataRow = 10;
		
		for (int i = 0; i < dtolist.size(); i++) {
			ResidenceTaxDto dto = dtolist.get(i);
			cityCodeNew = dto.getPaymentCityCode();
			if (!cityCodeNew.equals(cityCodeOld)) {
				if (i != 0) {
					sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(subTotalAmo)));
					printDataRow = printDataRow + 3;
					totalAmo = totalAmo + subTotalAmo;
					subTotalAmo = 0;
				}
			}
			subTotalAmo = subTotalAmo + dto.getResidenceTax();
			cityCodeOld = cityCodeNew;
		}
		
		if (dtolist.size() != 0) {
			totalAmo = totalAmo + subTotalAmo;
			sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(subTotalAmo)));
			printDataRow = printDataRow + 2;
			sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(5, printDataRow).setValue(insertComma(String.valueOf(totalAmo)));
		}
		String fileName = vo.getPltYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_RES_TAX_LIST_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * ZtHgEX^Cݒ 
	 * @param poi PoiUtility
	 * @param styleFlg X^CtO
	 * @param halignFlg EtO
	 */
	private void setStyle(PoiUtility poi, boolean styleFlg, boolean halignFlg) {
		int fontSize = 13;
		//tHgݒׂ̈̏
		if (styleFlg == true) {
			poi.createCellStyle();
		} else {
			poi.setFontType(PoiUtility.MS_MINTYO);
			poi.setFontSize(fontSize);
			if (halignFlg == true) {
				poi.setFontHAlignLeft();
			} else {
				poi.setFontHAlignRight();
			}
			poi.reflectCellStyle();
		}
		
	}
	
}
