/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PaymentListDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.PaymentListDto;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

/**
 * ^f[^o͂sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_REPORT}
 * </li></ul>
 */
public class PayDataOutputAction extends PayrollAction {
	
	/**
	 * ^f[^o̓R}hB<br><br>
	 * ɂA^f[^CSVŏo͂B<br>
	 */
	public static final String	CMD_REPORT	= "P1265";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PayDataOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (cmd.equals(CMD_REPORT)) {
			// ^f[^o
			report();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void report() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Ώ۔N擾
		Date targetMonth = getDate(vo.getPltYear(), vo.getPltMonth(), PayrollConst.TIME_DEFAULT_DAY);
		// DAO
		PaymentListDao dao = new PaymentListDao(cfg, cmd, aspUser, user, conn);
		// 
		List<PaymentListDto> list = dao.findForPaymentData(vo.getTxtKCode(), vo.getPltOffice(), vo.getPltSection(),
				targetMonth);
		// ̎擾pz擾
		String[][] aryOffice = getOfficeArrayAll();
		String[][] arySection = getSectionArrayAll();
		String[][] aryPosition = getPositionArrayAll();
		// R[hϊ
		for (PaymentListDto dto : list) {
			dto.setOfficeName(getCodeName(dto.getJCode(), aryOffice));
			dto.setSectionName(getCodeName(dto.getSCode(), arySection));
			dto.setPositionName(getCodeName(dto.getYCode(), aryPosition));
		}
		// ׍ڎ擾
		PmDetailPaDao pmDetailPaDao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
		PmDetailPbDao pmDetailPbDao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
		PmDetailPdDao pmDetailPdDao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
		PmDetailPsDao pmDetailPsDao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
		PmDetailPtDao pmDetailPtDao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
		List<DetailPaDto> listAllowance = pmDetailPaDao.findNotDelete();
		List<DetailPbDto> listBreakdown = pmDetailPbDao.findNotDelete();
		List<DetailPdDto> listDeduction = pmDetailPdDao.findNotDelete();
		List<DetailMoneyDto> listSum = pmDetailPsDao.findNotDelete();
		List<DetailTimeDto> listTime = pmDetailPtDao.findNotDelete();
		// o͓e쐬
		StringBuffer sb = new StringBuffer();
		// o͓e(^Cg)쐬
		sb.append(getCsvData(vo.getName("P_EMPLOYEE") + vo.getName("C_CODE")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_EMPLOYEE") + vo.getName("C_NAME")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_OFFICE") + vo.getName("C_CODE")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_OFFICE")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_SECTION") + vo.getName("C_CODE")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_SECTION")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_POSITION") + vo.getName("C_CODE")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_POSITION")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_CALCULATE") + vo.getName("C_YEAR") + vo.getName("C_MONTH")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_ALLOWANCE") + vo.getName("C_DAY")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		for (int i = 0; i < listTime.size(); i++) {
			sb.append(getCsvData(listTime.get(i).getDetailAbbr()));
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		for (int i = 0; i < listAllowance.size(); i++) {
			sb.append(getCsvData(listAllowance.get(i).getDetailAbbr()));
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		for (int i = 0; i < listDeduction.size(); i++) {
			sb.append(getCsvData(listDeduction.get(i).getDetailAbbr()));
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		for (int i = 0; i < listBreakdown.size(); i++) {
			sb.append(getCsvData(listBreakdown.get(i).getDetailAbbr()));
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		for (int i = 0; i < listSum.size(); i++) {
			sb.append(getCsvData(listSum.get(i).getDetailAbbr()));
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		sb.append(getCsvData(vo.getName("P_TAXATION") + vo.getName("P_ALLOWANCE") + vo.getName("P_MONEY_AMOUNT")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_HUMAN_INSURANCE") + vo.getName("P_SUM")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_DEPENDENT_COUNT")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_INCOME_TAX") + vo.getName("P_MONEY_AMOUNT")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_INSURANCE_EMPLOY") + vo.getName("P_TARGET") + vo.getName("P_MONEY_AMOUNT")));
		sb.append(PayrollConst.STR_CSV_SEPARATOR);
		sb.append(getCsvData(vo.getName("P_BONUS") + vo.getName("P_CALCULATE") + vo.getName("P_TARGET")
				+ vo.getName("P_MONEY_AMOUNT")));
		sb.append(PayrollConst.STR_CSV_NEW_LINE);
		// o͓e(f[^)쐬
		for (PaymentListDto dto : list) {
			Payment payment = getPayment(dto.getKCode(), targetMonth);
			sb.append(getCsvData(dto.getKCode())); // ЈR[h
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSimei())); // Ј
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getJCode())); // ƏR[h;
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getOfficeName())); // Ə
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSCode())); // R[h
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getSectionName())); // 
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getYCode())); // ER[h
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(dto.getPositionName())); // E
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getCalcMonthStr())); // vZN
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getPayDate())); // x
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			for (int i = 0; i < listTime.size(); i++) {
				sb.append(getCsvData(payment.getTimeAmount(listTime.get(i).getDetailCode())));
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			for (int i = 0; i < listAllowance.size(); i++) {
				sb.append(getCsvData(payment.getAllowanceAmount(listAllowance.get(i).getDetailCode())));
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			for (int i = 0; i < listDeduction.size(); i++) {
				sb.append(getCsvData(payment.getDeductionAmount(listDeduction.get(i).getDetailCode())));
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			for (int i = 0; i < listBreakdown.size(); i++) {
				sb.append(getCsvData(payment.getBreakdownAmount(listBreakdown.get(i).getDetailCode())));
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			for (int i = 0; i < listSum.size(); i++) {
				sb.append(getCsvData(payment.getSumAmount(listSum.get(i).getDetailCode())));
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			sb.append(getCsvData(payment.getTaxation())); // ېŎxz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getSocInsTotal())); // Љیv
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getDependent())); // }{̐
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getIncomeTax())); // Ŋz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getInsureUnemploy())); // ٗpیΏۊz
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
			sb.append(getCsvData(payment.getBonusBase())); // ܗ^vZΏۊz
			sb.append(PayrollConst.STR_CSV_NEW_LINE);
		}
		// o͓eݒ
		String fileName = vo.getPltYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_PAYMENT_DATA;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, sb);
	}
	
}
