/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class CmResidenceTaxDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3269758042340276374L;
	
	// tB[h
	private String				kCode;										// ЈR[h
	private Date				resExpectedDate;							// ZœKpN
	private String				paymentCityCode;							// [tsR[h
	private String				submitCityCode;							// osR[h
	private int					juneAmount;								// 6
	private int					julyAmount;								// 7
	private int					augustAmount;								// 8
	private int					septemberAmount;							// 9
	private int					octoberAmount;								// 10
	private int					novemberAmount;							// 11
	private int					decemberAmount;							// 12
	private int					januaryAmount;								// 1
	private int					februaryAmount;							// 2
	private int					marchAmount;								// 3
	private int					aprilAmount;								// 4
	private int					mayAmount;									// 5
																			
	
	/**
	 * RXgN^
	 */
	public CmResidenceTaxDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public Date getResExpectedDate() {
		return getDateField(resExpectedDate);
	} // ZœKpN
	
	public String getPaymentCityCode() {
		return paymentCityCode;
	} // [tsR[h
	
	public String getSubmitCityCode() {
		return submitCityCode;
	} // osR[h
	
	public int getJuneAmount() {
		return juneAmount;
	} // 6
	
	public int getJulyAmount() {
		return julyAmount;
	} // 7
	
	public int getAugustAmount() {
		return augustAmount;
	} // 8
	
	public int getSeptemberAmount() {
		return septemberAmount;
	} // 9
	
	public int getOctoberAmount() {
		return octoberAmount;
	} // 10
	
	public int getNovemberAmount() {
		return novemberAmount;
	} // 11
	
	public int getDecemberAmount() {
		return decemberAmount;
	} // 12
	
	public int getJanuaryAmount() {
		return januaryAmount;
	} // 1
	
	public int getFebruaryAmount() {
		return februaryAmount;
	} // 2
	
	public int getMarchAmount() {
		return marchAmount;
	} // 3
	
	public int getAprilAmount() {
		return aprilAmount;
	} // 4
	
	public int getMayAmount() {
		return mayAmount;
	} // 5
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setResExpectedDate(Date resExpectedDate) {
		this.resExpectedDate = getDateField(resExpectedDate);
	} // ZœKpN
	
	public void setPaymentCityCode(String paymentCityCode) {
		this.paymentCityCode = paymentCityCode;
	} // [tsR[h
	
	public void setSubmitCityCode(String submitCityCode) {
		this.submitCityCode = submitCityCode;
	} // osR[h
	
	public void setJuneAmount(int juneAmount) {
		this.juneAmount = juneAmount;
	} // 6
	
	public void setJulyAmount(int julyAmount) {
		this.julyAmount = julyAmount;
	} // 7
	
	public void setAugustAmount(int augustAmount) {
		this.augustAmount = augustAmount;
	} // 8
	
	public void setSeptemberAmount(int septemberAmount) {
		this.septemberAmount = septemberAmount;
	} // 9
	
	public void setOctoberAmount(int octoberAmount) {
		this.octoberAmount = octoberAmount;
	} // 10
	
	public void setNovemberAmount(int novemberAmount) {
		this.novemberAmount = novemberAmount;
	} // 11
	
	public void setDecemberAmount(int decemberAmount) {
		this.decemberAmount = decemberAmount;
	} // 12
	
	public void setJanuaryAmount(int januaryAmount) {
		this.januaryAmount = januaryAmount;
	} // 1
	
	public void setFebruaryAmount(int februaryAmount) {
		this.februaryAmount = februaryAmount;
	} // 2
	
	public void setMarchAmount(int marchAmount) {
		this.marchAmount = marchAmount;
	} // 3
	
	public void setAprilAmount(int aprilAmount) {
		this.aprilAmount = aprilAmount;
	} // 4
	
	public void setMayAmount(int mayAmount) {
		this.mayAmount = mayAmount;
	} // 5
	
}
