/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CdAdjustmentDto;

public class AdjustmentListVo extends AdjustmentCardVo {
	
	private static final long	serialVersionUID		= 4435830626039652278L;
	
	// URLACSS
	private static final String	RETURN_URL				= "/jsp/payroll/common/adjustmentList.jsp";
	private static final String	EXTRA_JS				= "/pub/payroll/common/js/adjustmentList.js";
	private static final String	EXTRA_CSS				= "/pub/payroll/common/css/adjustmentList.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE				= PayrollConst.TTL_ADJUSTMENT_LIST;
	
	// p[^
	public static final String	PRM_TXT_K_CODE			= "txtKCode";
	public static final String	PRM_TXT_K_NAME			= "txtKName";
	public static final String	PRM_TXT_K_KANA			= "txtKKana";
	public static final String	PRM_PLT_ADJUST_YEAR		= "pltAdjustYear";
	public static final String	PRM_PLT_ADJUST_STATUS	= "pltAdjustStatus";
	public static final String	PRM_TXT_INC_TAX_FROM	= "txtIncTaxFrom";
	public static final String	PRM_TXT_INC_TAX_TO		= "txtIncTaxTo";
	public static final String	PRM_PLT_REPORT_YEAR		= "pltReportYear";
	
	// tB[hyѐ
	public static final String	NAM_K_CODE				= PayrollConst.NAM_M_KIHON_KCODE;
	public static final String	NAM_K_KANA				= PayrollConst.NAM_K_KANA;
	public static final String	NAM_ADJUST_YEAR			= PayrollConst.NAM_ADJUST_YEAR;
	public static final String	NAM_FINAL_INCOME_TAX	= PayrollConst.NAM_FINAL_INCOME_TAX;
	public static final int		LEN_K_CODE				= PayrollConst.LEN_K_CODE;
	public static final int		LEN_K_NAME				= PayrollConst.LEN_K_NAME;
	public static final int		LEN_MONEY_AMOUNT		= PayrollConst.LEN_MONEY_AMOUNT;
	
	// tB[h
	private String[]			aryKCode;
	private String[]			aryAdjustYear;
	private String[]			aryAdjustStatus;
	private String[]			aryTaxGap;
	private String[]			aryFinalIncomeTax;
	private String[]			aryIncomeDeductSum;
	private String[]			aryIncomeTaxSum;
	private String[]			aryTaxedPaymentSum;
	
	private String				txtKCode;
	private String				txtKName;
	private String				txtKKana;
	private int					pltAdjustYear;
	private String				pltAdjustStatus;
	private String				txtIncTaxFrom;
	private String				txtIncTaxTo;
	private int					pltReportYear;
	
	// v_EXg
	public String[][]			aryPltAdjustYear;
	public String[][]			aryPltAdjustSatus;
	public String[][]			aryGender;
	// ݒe[u
	public List<MosPConfDto>	listConf;
	
	// \[gL[
	public final String			KEY_K_CODE				= "keyKCode";
	public final String			KEY_ADJUST_YEAR			= "keyAdjustYear";
	public final String			KEY_ADJUST_STATUS		= "keyAdjustStatus";
	public final String			KEY_TAX_GAP				= "keyTaxGap";
	public final String			KEY_FINAL_INCOME_TAX	= "keyFinalIncomeTax";
	public final String			KEY_INCOME_DEDUCT_SUM	= "keyIncomeDeductSum";
	public final String			KEY_INCOME_TAX_SUM		= "keyIncomeTaxSum";
	public final String			KEY_TAXED_PAYMENT_SUM	= "keyTaxedPaymentSum";
	

	/**
	 * RXgN^
	 */
	public AdjustmentListVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtKCode = "";
		txtKName = "";
		txtKKana = "";
		pltAdjustYear = 0;
		pltAdjustStatus = "";
		txtIncTaxFrom = "";
		txtIncTaxTo = "";
		pltReportYear = 0;
		aryKCode = new String[0];
		aryAdjustYear = new String[0];
		aryAdjustStatus = new String[0];
		aryTaxGap = new String[0];
		aryFinalIncomeTax = new String[0];
		aryIncomeDeductSum = new String[0];
		aryIncomeTaxSum = new String[0];
		aryTaxedPaymentSum = new String[0];
		setFormerKey(KEY_K_CODE);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtKKana = request.getParameter(PRM_TXT_K_KANA);
		pltAdjustYear = getIntParam(request.getParameter(PRM_PLT_ADJUST_YEAR));
		pltAdjustStatus = request.getParameter(PRM_PLT_ADJUST_STATUS);
		txtIncTaxFrom = request.getParameter(PRM_TXT_INC_TAX_FROM);
		txtIncTaxTo = request.getParameter(PRM_TXT_INC_TAX_TO);
		pltReportYear = getIntParam(request.getParameter(PRM_PLT_REPORT_YEAR));
	}
	
	/**
	 * tB[hݒ
	 * @param list ЈXg
	 */
	@Override
	public void setFields(List list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryKCode = new String[count];
		aryAdjustYear = new String[count];
		aryAdjustStatus = new String[count];
		aryTaxGap = new String[count];
		aryFinalIncomeTax = new String[count];
		aryIncomeDeductSum = new String[count];
		aryIncomeTaxSum = new String[count];
		aryTaxedPaymentSum = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			CdAdjustmentDto dto = (CdAdjustmentDto)it.next();
			aryKCode[i] = escapeHTML(dto.getKCode());
			aryAdjustYear[i] = String.valueOf(dto.getAdjustYear());
			aryAdjustStatus[i] = escapeHTML(getCodeName(dto.getAdjustStatus(), aryPltAdjustSatus));
			aryTaxGap[i] = insertComma(String.valueOf(dto.getTaxGap()));
			aryFinalIncomeTax[i] = insertComma(String.valueOf(dto.getFinalIncomeTax()));
			aryIncomeDeductSum[i] = insertComma(String.valueOf(dto.getIncomeDeductSum()));
			aryIncomeTaxSum[i] = insertComma(String.valueOf(dto.getIncomeTaxSum()));
			aryTaxedPaymentSum[i] = insertComma(String.valueOf(dto.getTaxedPaymentSum()));
			i++;
		}
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	// ANZT\bh
	public String[] getEscAryKCode() {
		return aryKCode.clone();
	}
	
	public String[] getEscAryAdjustYear() {
		return aryAdjustYear.clone();
	}
	
	public String[] getEscAryAdjustStatus() {
		return aryAdjustStatus.clone();
	}
	
	public String[] getEscAryTaxGap() {
		return aryTaxGap.clone();
	}
	
	public String[] getEscAryFinalIncomeTax() {
		return aryFinalIncomeTax.clone();
	}
	
	public String[] getEscAryIncomeDeductSum() {
		return aryIncomeDeductSum.clone();
	}
	
	public String[] getEscAryIncomeTaxSum() {
		return aryIncomeTaxSum.clone();
	}
	
	public String[] getEscAryTaxedPaymentSum() {
		return aryTaxedPaymentSum.clone();
	}
	
	public String getTxtKCode() {
		return txtKCode;
	}
	
	public String getTxtKName() {
		return txtKName;
	}
	
	public String getTxtKKana() {
		return txtKKana;
	}
	
	public int getPltAdjustYear() {
		return pltAdjustYear;
	}
	
	public String getPltAdjustStatus() {
		return pltAdjustStatus;
	}
	
	public String getTxtIncTaxFrom() {
		return txtIncTaxFrom;
	}
	
	public String getTxtIncTaxTo() {
		return txtIncTaxTo;
	}
	
	public int getPltReportYear() {
		return pltReportYear;
	}
	
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	public String getEscTxtKKana() {
		return escapeHTML(txtKKana);
	}
	
	public String getEscTxtIncTaxFrom() {
		return escapeHTML(txtIncTaxFrom);
	}
	
	public String getEscTxtIncTaxTo() {
		return escapeHTML(txtIncTaxTo);
	}
	
	public String getStrAdjustYear() {
		return String.valueOf(pltAdjustYear);
	}
	
	public String getStrReportYear() {
		return String.valueOf(pltReportYear);
	}
	
	public void setPltAdjustYear(int pltAdjustYear) {
		this.pltAdjustYear = pltAdjustYear;
	}
	
	public void setPltAdjustStatus(String pltAdjustStatus) {
		this.pltAdjustStatus = pltAdjustStatus;
	}
	
	public void setPltReportYear(int pltReportYear) {
		this.pltReportYear = pltReportYear;
	}
	
}
