/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.payroll.common.part;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.part.AuthorityPart;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.payroll.common.PayrollMenuConst;

/**
 * @author koike
 *
 */
public class PayrollMosPMenuPart extends MosPMenuPart {
	
	/**
	 * RXgN^
	 */
	public PayrollMosPMenuPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public PayrollMosPMenuPart(PartInfo partInfo) {
		super(partInfo);
	}
	
	/**
	 * ftHgDTO쐬iCmComponentj
	 * <p>j[ԍ</p>
	 * Αӓ́c{@link CommonConst#AUTH_EMPLOYEE_MENU}<br>
	 * ΑӊǗc{@link CommonConst#AUTH_MANAGER_MENU}<br>
	 * lǗc{@link CommonConst#AUTH_HUMAN_MENU}<br>
	 * ^Ǘc{@link CommonConst#AUTH_PAYROLL_MENU}<br>
	 * vZc{@link CommonConst#AUTH_CALCULATE_MENU}<br>
	 * @param menuNo		j[ԍ
	 * @return Ώۃj[ftHgDTO
	 */
	public static CmComponentDto getDefaultCompoDto(int menuNo) {
		CmComponentDto dto = new CmComponentDto();
		String[] aryDefault = getDefaultCompArray()[menuNo];
		dto.setDivision(aryDefault[0]);
		dto.setCompCode(aryDefault[0]);
		dto.setCompName(aryDefault[1]);
		dto.setManage(Integer.parseInt(aryDefault[2]));
		dto.setComponent(aryDefault[3]);
		return dto;
	}
	
	/**
	 * SR}hXg
	 * @return	SR}hXg
	 */
	public static List<String[][]> getAllCmdArrayList() {
		List<String[][]> list = new ArrayList<String[][]>();
		list.add(PayrollMenuConst.getEmployeeCmdArray());
		list.add(MosPMenuConst.getCmdManagerArray());
		list.add(MosPMenuConst.getCmdHumanArray());
		list.add(PayrollMenuConst.getPayrollCmdArray());
		list.add(MosPMenuConst.getCmdSystemArray());
		return list;
	}
	
	/**
	 * eftHg{̔z쐬 {division/code,name,manage,component}
	 * @return array
	 */
	public static String[][] getDefaultCompArray() {
		return new String[][]{
			{ CommonConst.CONF_ID_EMPLOYEE, CommonConst.NAM_AUTH_EMPLOYEE, CommonConst.NUM_BELONGING_SECTION,
				convAryToComponent(PayrollMenuConst.getEmployeeCmdArray()) },
			{ CommonConst.CONF_ID_MANAGER, CommonConst.NAM_AUTH_MANAGER, CommonConst.NUM_SELECT_SECTION,
				convAryToComponent(MosPMenuConst.getCmdManagerArray()) },
			{ CommonConst.CONF_ID_HUMAN, CommonConst.NAM_AUTH_HUMAN, CommonConst.NUM_ALL_SECTION,
				convAryToComponent(MosPMenuConst.getCmdHumanArray()) },
			{ CommonConst.CONF_ID_PAYROLL, CommonConst.NAM_AUTH_PAYROLL, CommonConst.NUM_ALL_SECTION,
				convAryToComponent(MosPMenuConst.getPayrollRestrictCalcArray()) },
			{ CommonConst.CONF_ID_CALCULATE, CommonConst.NAM_AUTH_CALCULATE, CommonConst.NUM_ALL_SECTION,
				convAryToComponent(PayrollMenuConst.getPayrollCmdArray()) }, };
	}
	
	/**
	 * ]ƈR}h擾
	 * @return ]ƈR}h
	 * @throws Exception	Oꍇ
	 */
	@Override
	public CmComponentDto getEmployeeComponentInfo() throws Exception {
		CmComponentDto componentDto = null;
		CmAuthorityDto dto = part().authority().getUserAuthDto();
		if (VariousUtil.isNotNull(dto)) {
			componentDto = part().component().findForKey(dto.getEmployee());
		}
		// ftHgR[h̐ݒ
		if (VariousUtil.isNull(componentDto)) {
			componentDto = getDefaultCompoDto(CommonConst.AUTH_EMPLOYEE_MENU);
		}
		return componentDto;
	}
	
	/**
	 * ^R}h擾
	 * @return	^R}h
	 * @throws Exception	Oꍇ
	 */
	@Override
	public CmComponentDto getPayrollComponentInfo() throws Exception {
		CmComponentDto componentDto = null;
		CmAuthorityDto dto = part().authority().getUserAuthDto();
		if (VariousUtil.isNotNull(dto)) {
			componentDto = part().component().findForKey(dto.getPayroll());
		}
		// ftHgR[h̐ݒ
		if (VariousUtil.isNull(componentDto)) {
			if (AuthorityPart.isCalculateAuth(user.getAuthority())) {
				componentDto = getDefaultCompoDto(CommonConst.AUTH_CALCULATE_MENU);
			} else {
				componentDto = getDefaultCompoDto(CommonConst.AUTH_PAYROLL_MENU);
			}
		}
		return componentDto;
	}
	
}
