/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.dao.PsSlipDao;

public class PmDetailBsDao extends PayrollDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String	TABLE				= "PM_DETAIL_BS";
	
	/**
	 *  L[1B<br>
	 */
	public static final String	KEY_01				= "DETAIL_CODE";
	
	public static final String	COL_DETAIL_CODE		= "DETAIL_CODE";
	public static final String	COL_DETAIL_NAME		= "DETAIL_NAME";
	public static final String	COL_DETAIL_ABBR		= "DETAIL_ABBR";
	
	public static final String	COL_DISPLAY_TYPE	= "DISPLAY_TYPE";
	public static final String	COL_EXPRESSION		= "EXPRESSION";
	public static final String	COL_INPUT_TYPE		= "INPUT_TYPE";
	public static final String	COL_EDIT_FLAG		= "EDIT_FLAG";
	public static final String	COL_DELETE_FLAG		= "DELETE_FLAG";
	

	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PmDetailBsDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private PmDetailBsDto mapping() throws SQLException {
		PmDetailBsDto dto = new PmDetailBsDto();
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE));
		dto.setDetailName(rs.getString(COL_DETAIL_NAME));
		dto.setDetailAbbr(rs.getString(COL_DETAIL_ABBR));
		dto.setDisplayType(rs.getByte(COL_DISPLAY_TYPE));
		dto.setExpression(rs.getString(COL_EXPRESSION));
		dto.setInputType(rs.getByte(COL_INPUT_TYPE));
		dto.setEditFlag(rs.getByte(COL_EDIT_FLAG));
		dto.setDeleteFlag(rs.getByte(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	private List<PmDetailBsDto> mappingAll() throws SQLException {
		List<PmDetailBsDto> all = new ArrayList<PmDetailBsDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmDetailBsDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param detailCode ׍ڃR[h(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmDetailBsDto findForKey(String detailCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, detailCode);
			executeQuery();
			PmDetailBsDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^yэsbN擾B
	 * @param detailCode ׍ڃR[h(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmDetailBsDto findForUpdate(String detailCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, detailCode);
			executeQuery();
			PmDetailBsDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param detailAbbr  ח
	 * @param deleteFlag  폜tO
	 * @param sortKey     \[gL[
	 * @param isAscending tO
	 * @param limit       ~bg
	 * @param offset      ItZbg
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PmDetailBsDto> find(String detailAbbr, String deleteFlag, String sortKey, boolean isAscending,
			int limit, int offset) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass()) + getConditionForDetailList(deleteFlag)
					+ getPageStatement(sortKey, isAscending));
			setParam(index++, "%" + detailAbbr + "%");
			if (deleteFlag != null && !deleteFlag.equals("")) {
				setParam(index++, Byte.parseByte(deleteFlag));
			}
			setParam(index++, limit);
			setParam(index++, offset);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ蓾f[^̌擾B<br>
	 * @param detailAbbr ח
	 * @param deleteFlag 폜tO
	 * @return int 
	 * @throws SQLException
	 */
	public int count(String detailAbbr, String deleteFlag) throws SQLException {
		try {
			index = 1;
			prepareStatement(getSelectCountStatement() + getConditionForDetailList(deleteFlag));
			setParam(index++, "%" + detailAbbr + "%");
			if (deleteFlag != null && !deleteFlag.equals("")) {
				setParam(index++, Byte.parseByte(deleteFlag));
			}
			executeQuery();
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * אݒꗗpSQL擾B
	 * @param deleteFlag 폜tO
	 * @return	^vZpSQL 
	 */
	private static String getConditionForDetailList(String deleteFlag) {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_DETAIL_ABBR + " LIKE ? ");
		if (deleteFlag == null || deleteFlag.equals("")) {
			return sb.toString();
		}
		sb.append("AND ");
		sb.append(COL_DELETE_FLAG + " = ? ");
		return sb.toString();
	}
	
	/**
	 * ɂf[^擾B
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmDetailBsDto> findNotDelete() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * PS_SLIPɐݒ肳Ă閾׃Xg擾B
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmDetailBsDto> findForSlip(String slipCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass(), true) + PsSlipDao.getQueryForSlip(getTable(getClass())));
			setParam(index++, slipCode);
			setParam(index++, PayrollConst.DETAIL_TYPE_BS);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B<br>
	 * @param dto     }ΏDTO
	 * @param needLog OvۃtO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmDetailBsDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @param needLog OvۃtO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmDetailBsDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getDetailCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ肷B<br>
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PmDetailBsDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getDetailCode());
		setParam(index++, dto.getDetailName());
		setParam(index++, dto.getDetailAbbr());
		setParam(index++, dto.getDisplayType());
		setParam(index++, dto.getExpression());
		setParam(index++, dto.getInputType());
		setParam(index++, dto.getEditFlag());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
