/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dto.PayrollLineupDto;

public class PayrollLineupDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE1				= "UD_BONUS";
	public static final String	TABLE2				= "UH_BASIS";
	public static final String	TABLE3				= "UD_PAYMENT";
	public static final String	KEY_1				= "K_CODE";		// ЈR[h
	public static final String	KEY_2				= "CALC_DATE";		// vZN
																		
	// 
	public static final String	COL_CALC_STATUS		= "CALC_STATUS";	// f[^Xe[^X
	public static final String	COL_PAYMENT_TOTAL	= "PAYMENT_TOTAL";	// ܗ^xz
	public static final String	COL_CALC_DATE		= "CALC_DATE";		// vZN
	public static final String	COL_PAYDAY			= "PAYDAY";		// ܗ^x
	public static final String	COL_K_CODE			= "K_CODE";		// ЈR[h
	public static final String	COL_K_NAME			= "K_NAME";		// Ј
	public static final String	COL_K_KANA			= "K_KANA";		// ЈtKi
	public static final String	COL_STATION_CODE	= "STATION_CODE";	// R[h
	public static final String	COL_POSITION_CODE	= "POSITION_CODE";	// EʃR[h
	public static final String	COL_EXPECTED_DATE	= "EXPECTED_DATE";	// KpN
	public static final String	COL_APPLIED_DATE	= "APPLIED_DATE";	// Kp
																		
	
	/**
	 * RXgN^
	 */
	public PayrollLineupDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PayrollLineupDto> mappingAll(boolean isNoData) throws SQLException {
		List<PayrollLineupDto> all = new ArrayList<PayrollLineupDto>();
		while (rs.next()) {
			all.add(mapping(isNoData));
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PayrollLineupDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private PayrollLineupDto mapping(boolean isNoData) throws SQLException {
		PayrollLineupDto dto = new PayrollLineupDto();
		if (isNoData) {
			dto.setPaymentTotal(0);
			dto.setCalcStatus(BonusConst.CALC_STATUS_NO);
		} else {
			dto.setPaymentTotal(rs.getInt(COL_PAYMENT_TOTAL));
			dto.setCalcStatus(rs.getString(COL_CALC_STATUS));
			dto.setCalcDate(rs.getDate(COL_CALC_DATE));
		}
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setKName(rs.getString(COL_K_NAME));
		dto.setStationCode(rs.getString(COL_STATION_CODE));
		dto.setPositionCode(rs.getString(COL_POSITION_CODE));
		return dto;
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PayrollLineupDto> mappingBonusAll(boolean isNoData) throws SQLException {
		List<PayrollLineupDto> all = new ArrayList<PayrollLineupDto>();
		while (rs.next()) {
			all.add(mappingBonus(isNoData));
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PayrollLineupDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private PayrollLineupDto mappingBonus(boolean isNoData) throws SQLException {
		PayrollLineupDto dto = new PayrollLineupDto();
		if (isNoData) {
			dto.setPaymentTotal(0);
			dto.setCalcStatus(BonusConst.CALC_STATUS_NO);
		} else {
			dto.setPaymentTotal(rs.getInt(COL_PAYMENT_TOTAL));
			dto.setCalcStatus(rs.getString(COL_CALC_STATUS));
			dto.setCalcDate(rs.getDate(COL_CALC_DATE));
			dto.setPayday(rs.getDate(COL_PAYDAY));
		}
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setKName(rs.getString(COL_K_NAME));
		dto.setStationCode(rs.getString(COL_STATION_CODE));
		dto.setPositionCode(rs.getString(COL_POSITION_CODE));
		return dto;
	}
	
	/**
	 * ɂf[^擾(ܗ^)
	 * @param calcDate     vZN
	 * @param statusData   vZXe[^X
	 * @param kCode        ЈR[h
	 * @param kName        Ј
	 * @param kKana        ЈtKi
	 * @param stationCode  
	 * @param positionCode E
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<PayrollLineupDto> findForBonusCondition(Date payday, String statusData, String kCode, String kName,
			String kKana, String stationCode, String positionCode) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" UDBO." + COL_PAYDAY);
		sb.append(", ");
		sb.append(" UDBO." + COL_CALC_DATE);
		sb.append(", ");
		sb.append(" UDBO." + COL_CALC_STATUS);
		sb.append(", ");
		sb.append(" UDBO." + COL_PAYMENT_TOTAL);
		sb.append(", ");
		sb.append(" UHBA." + COL_K_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_K_NAME);
		sb.append(", ");
		sb.append(" UHBA." + COL_STATION_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_POSITION_CODE);
		sb.append(" FROM (");
		sb.append(TABLE1 + " AS UDBO ");
		sb.append("  RIGHT JOIN  ");
		sb.append("(");
		sb.append(" SELECT ");
		sb.append(" * ");
		sb.append(" FROM " + TABLE2 + ",( ");
		sb.append(" SELECT ");
		sb.append(COL_K_CODE + " AS H_K_CODE, ");
		sb.append("MAX(" + COL_EXPECTED_DATE + ") AS H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE2 + " ");
		sb.append("WHERE ");
		sb.append(COL_EXPECTED_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append("GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE");
		sb.append(") " + " AS UHBA ");
		sb.append(" ON ");
		sb.append(" UDBO." + COL_K_CODE + " = " + " UHBA." + COL_K_CODE);
		sb.append(" ) ");
		sb.append("WHERE ");
		sb.append(" UDBO." + COL_K_CODE + " LIKE ? ");
		sb.append(" AND ");
		sb.append(" UDBO." + COL_PAYDAY + " = ? ");
		if (statusData != null && !statusData.equals("")) {
			sb.append("AND ");
			sb.append(" UDBO." + COL_CALC_STATUS + " = ? ");
		}
		if (kName != null && !kName.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_K_NAME + " LIKE ? ");
		}
		if (kKana != null && !kKana.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_K_KANA + " LIKE ? ");
		}
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("AND ");
			sb.append(" UDBO." + COL_STATION_CODE + " = ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_POSITION_CODE + " = ? ");
		}
		try {
			prepareStatement(sb.toString());
			setParam(index++, payday);
			setParam(index++, kCode + "%");
			setParam(index++, payday);
			if (statusData != null && !statusData.equals("")) {
				setParam(index++, statusData);
			}
			if (kName != null && !kName.equals("")) {
				setParam(index++, "%" + kName + "%");
			}
			if (kKana != null && !kKana.equals("")) {
				setParam(index++, "%" + kKana + "%");
			}
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			executeQuery();
			List<PayrollLineupDto> list = mappingBonusAll(false);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(vZXe[^XFf[^쐬)
	 * @param calcDate     vZN
	 * @param kCode        ЈR[h
	 * @param kName        Ј
	 * @param kKana        ЈtKi
	 * @param stationCode  
	 * @param positionCode E
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PayrollLineupDto> findForPayNoExCondition(Date calcDate, Date startDate, Date endDate, String kCode,
			String kName, String kKana, String stationCode, String positionCode) throws SQLException,
			IllegalAccessException {
		PhBasisDao dao = new PhBasisDao();
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" UHBA." + COL_K_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_K_NAME);
		sb.append(", ");
		sb.append(" UHBA." + COL_STATION_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_POSITION_CODE);
		sb.append(" FROM ");
		sb.append("(");
		sb.append(dao.findForDataLineUp(stationCode));
		sb.append(") AS UHBA");
		sb.append(" WHERE ");
		sb.append(" NOT EXISTS ");
		sb.append("(");
		sb.append(" SELECT ");
		sb.append(" * ");
		sb.append(" FROM " + TABLE3);
		sb.append(" WHERE ");
		sb.append(COL_K_CODE + " = " + "UHBA." + COL_K_CODE);
		sb.append(" AND ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(")");
		if (kCode != null && !kCode.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_K_CODE + " LIKE ? ");
		}
		if (kName != null && !kName.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_K_NAME + " LIKE ? ");
		}
		if (kKana != null && !kKana.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_K_KANA + " LIKE ? ");
		}
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_STATION_CODE + " = ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(" UHBA." + COL_POSITION_CODE + " = ? ");
		}
		
		try {
			prepareStatement(sb.toString());
			setParam(index++, endDate);
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			setParam(index++, calcDate);
			if (kCode != null && !kCode.equals("")) {
				setParam(index++, kCode + "%");
			}
			if (kName != null && !kName.equals("")) {
				setParam(index++, "%" + kName + "%");
			}
			if (kKana != null && !kKana.equals("")) {
				setParam(index++, "%" + kKana + "%");
			}
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			executeQuery();
			List<PayrollLineupDto> list = mappingAll(true);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(f[^쐬ȊO)
	 * @param calcDate     vZN
	 * @param statusData   vZXe[^X
	 * @param kCode        ЈR[h
	 * @param kName        Ј
	 * @param kKana        ЈtKi
	 * @param stationCode  
	 * @param positionCode E
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PayrollLineupDto> findForPaymentCondition(Date calcDate, Date startDate, Date endDate,
			String statusData, String kCode, String kName, String kKana, String stationCode, String positionCode)
			throws SQLException, IllegalAccessException {
		PhBasisDao dao = new PhBasisDao();
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(" UDPA." + COL_CALC_DATE);
		sb.append(", ");
		sb.append(" UDPA." + COL_CALC_STATUS);
		sb.append(", ");
		sb.append(" UDPA." + COL_PAYMENT_TOTAL);
		sb.append(", ");
		sb.append(" UHBA." + COL_K_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_K_NAME);
		sb.append(", ");
		sb.append(" UHBA." + COL_STATION_CODE);
		sb.append(", ");
		sb.append(" UHBA." + COL_POSITION_CODE);
		sb.append(" FROM (");
		sb.append("(");
		sb.append(dao.findForDataLineUp(stationCode));
		sb.append(") AS UHBA ");
		sb.append(" LEFT JOIN ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(" * ");
		sb.append(" FROM " + TABLE3);
		sb.append(" WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(") AS UDPA");
		sb.append(" ON ");
		sb.append(" UHBA." + COL_K_CODE + " = " + "UDPA." + COL_K_CODE);
		sb.append(") ");
		sb.append("WHERE ");
		sb.append(" UHBA." + COL_K_CODE + " LIKE ? ");
		if (statusData != null && !statusData.equals("")) {
			sb.append("AND ");
			sb.append(" UDPA." + COL_CALC_STATUS + " = ? ");
		}
		if (kName != null && !kName.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_K_NAME + " LIKE ? ");
		}
		if (kKana != null && !kKana.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_K_KANA + " LIKE ? ");
		}
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_STATION_CODE + " = ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append("AND ");
			sb.append(" UHBA." + COL_POSITION_CODE + " = ? ");
		}
		try {
			prepareStatement(sb.toString());
			setParam(index++, endDate);
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			setParam(index++, calcDate);
			setParam(index++, kCode + "%");
			if (statusData != null && !statusData.equals("")) {
				setParam(index++, statusData);
			}
			if (kName != null && !kName.equals("")) {
				setParam(index++, "%" + kName + "%");
			}
			if (kKana != null && !kKana.equals("")) {
				setParam(index++, "%" + kKana + "%");
			}
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			executeQuery();
			List<PayrollLineupDto> list = mappingAll(false);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
