/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.dto.CmCommutationDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmResidenceTaxDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;
import jp.mosp.payroll.dto.CmUnitAmountDto;

/**
 * ЈNXB<br><br>
 */
public class Employee {
	
	/**
	 * ЈR[hB<br>
	 * {@link Employee}𔻕ʂL[ƂȂ鍀ځB
	 */
	private String					kCode;
	
	/**
	 * Ώ۔NB<br>
	 * 擾ۂɗpAi[B
	 */
	//private Date targetDate;
	
	/**
	 * ЈB<br>
	 * {@link #targetDate}ȑOōŐV̗擾Ai[B
	 */
	//private String kName;
	
	/**
	 * B<br>
	 */
	private String					sectionName;
	
	/**
	 * l{B<br>
	 * {@link #kCode}̐l{AKpN̍~ŕׂĊi[B
	 */
	//private List<ChBasisDto> listBasis;
	
	private MKihonDto				kihon;
	private MKojinDto				kojin;
	private CmSocInsuranceDto		socInsurance;
	private CmIncomeTaxDto			incomeTax;
	private CmResidenceTaxDto		residenceTax;
	private List<CmCommutationDto>	commutation;
	private List<CmUnitAmountDto>	unitAmount;
	private List<CmPaymentMeansDto>	paymentMeans;
	

	/**
	 * CX^X𐶐AtB[hݒ肷B<br>
	 * @param kihon l{
	 * @param socInsurance 
	 * @param incomeTax 
	 * @param residenceTax 
	 * @param commutation 
	 * @param unitAmount 
	 * @param paymentMeans 
	 */
	public Employee(MKihonDto kihon, CmSocInsuranceDto socInsurance, CmIncomeTaxDto incomeTax,
			CmResidenceTaxDto residenceTax, List<CmCommutationDto> commutation, List<CmUnitAmountDto> unitAmount,
			List<CmPaymentMeansDto> paymentMeans) {
		this.kihon = kihon;
		this.socInsurance = socInsurance;
		this.incomeTax = incomeTax;
		this.residenceTax = residenceTax;
		this.commutation = commutation;
		this.unitAmount = unitAmount;
		this.paymentMeans = paymentMeans;
		kCode = kihon.getKCode();
	}
	
	/**
	 * @return
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * @return
	 */
	public String getKName() {
		return kihon.getSimei();
	}
	
	/**
	 * @return
	 */
	public String getSectionCode() {
		return kihon.getSCode();
	}
	
	/**
	 * @return
	 */
	public String getSectionName() {
		return sectionName;
	}
	
	/**
	 * @param sectionName
	 */
	public void setSectionName(String sectionName) {
		this.sectionName = sectionName;
	}
	
	/**
	 * @param kojinDto
	 */
	public void setMKojinDto(MKojinDto kojinDto) {
		kojin = kojinDto;
	}
	
	/**
	 * `[R[h擾B
	 * @return `[R[h
	 */
	public String getSlipCode() {
		return PayrollConst.SLIP_ALL;
	}
	
	/**
	 * ʋΎ蓖擾B
	 * @return ʋΎ蓖
	 */
	public List<CmCommutationDto> getCommutation() {
		return commutation;
	}
	
	/**
	 * P擾B
	 * @return P
	 */
	public List<CmUnitAmountDto> getUnitAmount() {
		return unitAmount;
	}
	
	/**
	 * x@擾B
	 * @return x@
	 */
	public List<CmPaymentMeansDto> getPaymentMeans() {
		return paymentMeans;
	}
	
	/**
	 * NیWVz擾B
	 * @return NیWVz
	 */
	public int getHealthPayment() {
		if (socInsurance == null) {
			return 0;
		}
		return socInsurance.getHealthPayment();
	}
	
	/**
	 * ٗpی敪擾B
	 * @return ٗpی敪
	 */
	public String getCalcUnemployType() {
		if (socInsurance == null) {
			return "";
		}
		return socInsurance.getCalcUnemployType();
	}
	
	/**
	 * NWVz擾B
	 * @return NWVz
	 */
	public int getPensionPayment() {
		if (socInsurance == null) {
			return 0;
		}
		return socInsurance.getPensionPayment();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getJuneAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getJuneAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getJulyAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getJulyAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getAugustAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getAugustAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getSeptemberAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getSeptemberAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getOctoberAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getOctoberAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getNovemberAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getNovemberAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getDecemberAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getDecemberAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getJanuaryAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getJanuaryAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getFebruaryAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getFebruaryAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getMarchAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getMarchAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getAprilAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getAprilAmount();
	}
	
	/**
	 * Zł擾B<br>
	 * @return Z
	 */
	public int getMayAmount() {
		if (residenceTax == null) {
			return 0;
		}
		return residenceTax.getMayAmount();
	}
	
	/**
	 * }{̐擾B
	 * @return }{̐
	 */
	public byte getDependent() {
		if (incomeTax == null) {
			return 0;
		}
		return (byte)incomeTax.getDependentCount();
	}
	
	/**
	 * ^敪擾B
	 * @return ^敪
	 */
	public byte getPaymentType() {
		if (kihon != null && !kihon.getKyKubun().equals("")) {
			return Byte.parseByte(kihon.getKyKubun());
		}
		return PayrollConst.PAYMENT_MONTH;
	}
	
	/**
	 * ېŋ敪擾B
	 * @return ېŋ敪
	 */
	public String getIncomeTaxType() {
		if (incomeTax != null && !incomeTax.getIncomeTaxType().equals("")) {
			return incomeTax.getIncomeTaxType();
		}
		if (kihon != null && !kihon.getTxKubun().equals("")) {
			return kihon.getTxKubun();
		}
		return LegalConst.INCOME_TAX_NOT;
	}
	
	/**
	 * ی敪擾B
	 * @return ی敪
	 */
	public String getNursingInsType() {
		if (socInsurance == null) {
			return "";
		}
		return socInsurance.getNursingInsType();
	}
	
	/**
	 * ʂ擾B
	 * @return ʃR[h
	 * @throws MospException MosPOꍇ
	 */
	public String getGender() throws MospException {
		if (kojin == null) {
			return "1";
		}
		return kojin.getSeibetu();
	}
	
	/**
	 * N擾B
	 * @return N
	 * @throws MospException MosPOꍇ
	 */
	public Date getBirthDate() throws MospException {
		if (kojin == null) {
			return null;
		}
		return PayrollUtility.getDate(String.valueOf(kojin.getSeinenbi()));
	}
	
	/**
	 * N擾B
	 * @param toDate NNZ
	 * @return N
	 * @throws MospException MosPOꍇ 
	 */
	public int getAge(Date toDate) throws MospException {
		if (toDate == null) {
			return 0;
		}
		Date birthDate = getBirthDate();
		if (birthDate == null) {
			return 0;
		}
		return PayrollUtility.getAge(birthDate, toDate);
	}
	
	/**
	 * Nیԍ擾B
	 * @return Nیԍ
	 */
	public String getKenpoNo() {
		if (socInsurance == null) {
			return "";
		}
		return socInsurance.getHealthNo();
	}
	
	/**
	 * Nԍ擾B
	 * @return Nԍ
	 */
	public String getKohoNo() {
		if (socInsurance == null) {
			return "";
		}
		return socInsurance.getPensionNo();
		
	}
}
