/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;

/**
 * @author koike
 *
 */
public class OverTimeAgreementListVo extends MosPVo {
	
	private static final long	serialVersionUID					= -4182787195011179817L;
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF							= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON							= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_TIME_ID				= "txtOverTimeId";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_TIME_CODE				= "txtOverTimeCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_TYPE_NAME				= "txtWorkTypeName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUSE						= "txtCause";
	/**
	 * 
	 */
	public static final String	PRM_TXT_AGREE_TYPE					= "txtAgreeType";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LIMIT_CODE					= "txtLimitCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_TIME_RATE				= "txtOverTimeRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUTION_MONTH				= "txtCautionMonth";
	/**
	 * 
	 */
	public static final String	PRM_TXT_MONTHLY_OVER_TIME_RATE		= "txtMonthlyOverTimeRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_ACQUIRE_RATE			= "txtSubAcquireRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE	= "txtSubAcquireHolidayRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_QUIT_RATE				= "txtSubQuitRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_DATE					= "txtStartDate";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE_FLAG					= "pltDelete";
	
	// tB[h
	private String[]			aryOverTimeId;
	private String[]			aryOverTimeCode;
	private String[]			aryWorkTypeName;
	private String[]			aryStartDate;
	private String[]			aryDelete;
	private String				txtOverTimeCode;
	private String				txtWorkTypeName;
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_CODE;
	/**
	 * 
	 */
	public String				NAM_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public String				NAM_DELET_FLAG;
	/**
	 * 
	 */
	public int					LEN_OVER_TIME_CODE;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_OVER_TIME_CODE					= "keyOverTimeCode";
	/**
	 * 
	 */
	public final String			KEY_WORK_TYPE_NAME					= "keyWorkTypeName";
	/**
	 * 
	 */
	public final String			KEY_START_DATE						= "keyStartDate";
	/**
	 * 
	 */
	public final String			KEY_DELET_FLAG						= "keyDelete";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public OverTimeAgreementListVo() {
		super();
		setViewPath(getClassName());
		aryOverTimeId = new String[0];
		aryOverTimeCode = new String[0];
		aryWorkTypeName = new String[0];
		aryStartDate = new String[0];
		aryDelete = new String[0];
		txtOverTimeCode = "";
		txtWorkTypeName = "";
		pltDelete = "";
		setFormerKey(KEY_OVER_TIME_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_OVER_TIME_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OVER_TIME_CODE = CommonConst.NAM_OVER_TIME + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_WORK_TYPE_NAME = CommonConst.NAM_WORK_TYPE_NAME;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		NAM_DELET_FLAG = CommonConst.NAM_DELETE_FLAG;
		LEN_OVER_TIME_CODE = 10;
	}
	
	/**
	 * tB[h̑ÓmF
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtOverTimeCode = request.getParameter(PRM_TXT_OVER_TIME_CODE);
		txtWorkTypeName = request.getParameter(PRM_TXT_WORK_TYPE_NAME);
		pltDelete = request.getParameter(PRM_PLT_DELETE_FLAG);
	}
	
	/**
	 * tB[hݒ
	 * @param listOverTimeAgreement ԊO胊Xg
	 */
	@Override
	public void setFields(List<?> listOverTimeAgreement) {
		// Xg̐ݒ
		list = listOverTimeAgreement;
		// f[^̎擾
		count = listOverTimeAgreement.size();
		// z̏
		aryOverTimeId = new String[count];
		aryOverTimeCode = new String[count];
		aryWorkTypeName = new String[count];
		aryStartDate = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listOverTimeAgreement.iterator();
		while (it.hasNext()) {
			CmAgreementOverTimeDto dto = (CmAgreementOverTimeDto)it.next();
			aryOverTimeId[i] = String.valueOf(dto.getOverTimeId());
			aryOverTimeCode[i] = escapeHTML(dto.getOverTimeCode());
			aryWorkTypeName[i] = escapeHTML(dto.getWorkTypeName());
			aryStartDate[i] = escapeHTML(DateUtil.convDateFormatted(dto.getStartDate()));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}
	
	/**
	 * @return txtOverTimeCode
	 */
	public String getEscTxtOverTimeCode() {
		return escapeHTML(txtOverTimeCode);
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getEscTxtWorkTypeName() {
		return escapeHTML(txtWorkTypeName);
	}
	
	/**
	 * @param txtOverTimeCode Zbg txtOverTimeCode
	 */
	public void setTxtOverTimeCode(String txtOverTimeCode) {
		this.txtOverTimeCode = txtOverTimeCode;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDetele() {
		return pltDelete;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @return aryOverTimeId
	 */
	public String[] getEscAryOverTimeId() {
		return aryOverTimeId.clone();
	}
	
	/**
	 * @return aryOverTimeCode
	 */
	public String[] getEscAryOverTimeCode() {
		return aryOverTimeCode.clone();
	}
	
	/**
	 * @return aryWorkTypeName
	 */
	public String[] getEscAryWorkTypeName() {
		return aryWorkTypeName.clone();
	}
	
	/**
	 * @return aryStartDate
	 */
	public String[] getEscAryStartDate() {
		return aryStartDate.clone();
	}
	
	/**
	 * @return aryOverTimeCode
	 */
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
}
