/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;

/**
 * @author matsusita
 *
 */
public class LaborAgreementListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 9196105086256454814L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_AGREE_CODE	= "txtAgreeCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String[]			aryAgreeCode;
	private String[]			aryAgreeName;
	private String[]			aryAgreeType;
	private String[]			aryOverTimeCode;
	private String[]			aryWorkOnCode;
	private String[]			aryDelete;
	private String				txtAgreeCode;
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_AGREE_CODE;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_WORK_ON;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_AGREE_CODE;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_AGREE_CODE		= "keyAgreeCode";
	/**
	 * 
	 */
	public final String			KEY_OVER_TIME_CODE	= "keyOverTimeCode";
	/**
	 * 
	 */
	public final String			KEY_WORK_ON_CODE	= "keyWorkOnCode";
	/**
	 * 
	 */
	public final String			KEY_DELETE			= "keyDelete";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public LaborAgreementListVo() {
		super();
		setViewPath(getClassName());
		aryAgreeCode = new String[0];
		aryAgreeName = new String[0];
		aryAgreeType = new String[0];
		aryOverTimeCode = new String[0];
		aryWorkOnCode = new String[0];
		aryDelete = new String[0];
		setFormerKey(KEY_AGREE_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LABOR_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_AGREE_CODE = CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_OVER_TIME = CommonConst.NAM_OVER_TIME + CommonConst.NAM_AGREEMENT;
		NAM_WORK_ON = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_AGREEMENT;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_AGREE_CODE = 10;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtAgreeCode = request.getParameter(PRM_TXT_AGREE_CODE);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	@Override
	public void setFields(List<?> listAgreement) throws MospException {
		// Xg̐ݒ
		list = listAgreement;
		// f[^̎擾
		count = listAgreement.size();
		// z̏
		aryAgreeCode = new String[count];
		aryAgreeType = new String[count];
		aryOverTimeCode = new String[count];
		aryWorkOnCode = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listAgreement.iterator();
		while (it.hasNext()) {
			CmLaborAgreementDto dto = (CmLaborAgreementDto)it.next();
			aryAgreeCode[i] = escapeHTML(dto.getAgreeCode());
			aryAgreeType[i] = escapeHTML(dto.getAgreeType());
			aryOverTimeCode[i] = escapeHTML(dto.getOverTimeCode());
			aryWorkOnCode[i] = escapeHTML(dto.getWorkOnCode());
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			} else {
				throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
			}
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return aryAgreeCode
	 */
	public String[] getEscAryAgreeCode() {
		return aryAgreeCode.clone();
	}
	
	/**
	 * @return aryAgreeType
	 */
	public String[] getEscAryAgreeType() {
		return aryAgreeType.clone();
	}
	
	/**
	 * @return aryOverTimeCode
	 */
	public String[] getEscAryOverTimeCode() {
		return aryOverTimeCode.clone();
	}
	
	/**
	 * @return aryWorkOnCode
	 */
	public String[] getEscAryWorkOnCode() {
		return aryWorkOnCode.clone();
	}
	
	/**
	 * @return aryDelete
	 */
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
	/**
	 * @return txtAgreeCode
	 */
	public String getTxtAgreeCode() {
		return txtAgreeCode;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return txtAgreeCode
	 */
	public String getEscTxtAgreeCode() {
		return escapeHTML(txtAgreeCode);
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	/**
	 * 
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @return aryAgreeName
	 */
	public String[] getAryAgreeName() {
		return aryAgreeName.clone();
	}
	
	/**
	 * @param aryAgreeName Zbg aryAgreeName
	 */
	public void setAryAgreeName(String[] aryAgreeName) {
		this.aryAgreeName = aryAgreeName.clone();
	}
	
}
