/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dao.CmAgreementOverTimeDao;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;
import jp.mosp.mospcommon.system.vo.OverTimeAgreementListVo;

/**
 * @author koike
 *
 */
public class OverTimeAgreementListAction extends MosPAction {
	
	private static final String	CMD_OVER_TIME_AGREEMENT_LIST_SHOW		= "S2520";
	private static final String	CMD_OVER_TIME_AGREEMENT_LIST_SEARCH		= "S2521";
	private static final String	CMD_OVER_TIME_AGREEMENT_LIST_RE_SEARCH	= "S2522";
	private static final String	CMD_OVER_TIME_AGREEMENT_LIST_SORT		= "S2523";
	

	/**
	 * RXgN^
	 */
	public OverTimeAgreementListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_OVER_TIME_AGREEMENT_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OverTimeAgreementListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
		// lɃZbg	
		vo.setSearchmode(OverTimeAgreementListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		vo.setParams(request);
		searchCompanyList();
		vo.setFormerKey(vo.KEY_OVER_TIME_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(OverTimeAgreementListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		if (vo.getSearchmode() == OverTimeAgreementListVo.SEARCH_ON) {
			removeSessionDto();
			searchCompanyList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * ԊO胊Xg
	 * @throws Exception 	Oꍇ
	 */
	private void searchCompanyList() throws Exception {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		CmAgreementOverTimeDao dao = new CmAgreementOverTimeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getEscTxtOverTimeCode(), vo.getEscTxtWorkTypeName(), vo.getPltDetele()));
		// Ώۂꍇ̃bZ[Wݒ		
		if (vo.getEscAryOverTimeCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		OverTimeAgreementListVo vo = (OverTimeAgreementListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_OVER_TIME_CODE)) {
			comp = new CompOverTimeCode();
		} else if (key.equals(vo.KEY_WORK_TYPE_NAME)) {
			comp = new CompWorkTypeName();
		} else if (key.equals(vo.KEY_START_DATE)) {
			comp = new CompStartDate();
		} else if (key.equals(vo.KEY_DELET_FLAG)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ԊOR[hɂrNX
	 */
	protected static class CompOverTimeCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1968731795232866615L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementOverTimeDto dto1 = (CmAgreementOverTimeDto)obj1;
			CmAgreementOverTimeDto dto2 = (CmAgreementOverTimeDto)obj2;
			return dto1.getOverTimeCode().compareTo(dto2.getOverTimeCode());
		}
	}
	
	/**
	 * Ɩ̎ނɂrNX
	 */
	protected static class CompWorkTypeName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8838582673151573558L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementOverTimeDto dto1 = (CmAgreementOverTimeDto)obj1;
			CmAgreementOverTimeDto dto2 = (CmAgreementOverTimeDto)obj2;
			return dto1.getWorkTypeName().compareTo(dto2.getWorkTypeName());
		}
	}
	
	/**
	 * JnNɂrNX
	 */
	protected static class CompStartDate implements Comparator<Object>, Serializable {
		
		static final long	serialVersionUID	= -5477700673618451874L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementOverTimeDto dto1 = (CmAgreementOverTimeDto)obj1;
			CmAgreementOverTimeDto dto2 = (CmAgreementOverTimeDto)obj2;
			return dto1.getStartDate().compareTo(dto2.getStartDate());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -724735214174462788L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementOverTimeDto dto1 = (CmAgreementOverTimeDto)obj1;
			CmAgreementOverTimeDto dto2 = (CmAgreementOverTimeDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
}
