/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system;

import java.util.Date;

import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;

/**
 * Jg
 * @author yoshida
 *
 */
public class AgreementInfo implements AgreementBaseInfo {
	
	private static final long		serialVersionUID		= 5369841808240192161L;
	
	// tB[h
	private String					agreeCode				= "";
	
	private String					kCode					= "";
	private String					salaryGrpCd				= "";
	
	private String					overTimeCode			= "";
	private String					workOnCode				= "";
	
	private String					overWorkTypeName		= "";
	private String					overCause				= "";
	private String					overAgreeType			= "";
	private String					limitCode				= "";
	private int						overTimeRate			= 0;
	private int						cautionMonth			= 0;
	private int						monthlyOverTimeRate		= 0;
	private int						subAcquireRate			= 0;
	private int						subAcquireHolidayRate	= 0;
	private int						subQuitRate				= 0;
	private Date					overStartDate			= null;
	
	private String					workOnWorkTypeName		= "";
	private String					workOnCause				= "";
	private String					standardWeekHoliday		= "";
	private String					officialHoliday			= "";
	private String					japaneseHolidayFlag		= "";
	private String					holidayMasterFlag		= "";
	private int						standardHolidayRate		= 0;
	private int						officialHolidayRate		= 0;
	private int						numberOfWorkOn			= 0;
	private int						workOnStartTime			= 0;
	private int						workOnEndTime			= 0;
	private Date					workOnStartDate			= null;
	
	private String					limitName				= "";
	private String					termType				= "";
	private int						prescribedTime			= 0;
	private int						cautionDay				= 0;
	private int						cautionTerm				= 0;
	private int						cautionYear				= 0;
	private int						limitDay				= 0;
	private int						limitTerm				= 0;
	private int						limitYear				= 0;
	private int						rateTerm				= 0;
	private int						rateYear				= 0;
	
	private CmLaborAgreementDto		agreementDto;
	private CmAgreementOverTimeDto	overTimeDto;
	private CmAgreementWorkOnDto	workOnDto;
	private CmLimitStandardDto		standardDto;
	

	/**
	 * 
	 */
	public AgreementInfo() {
	}
	
	/**
	 * @return agreeCode
	 */
	public String getAgreeCode() {
		return agreeCode;
	}
	
	/**
	 * @return kCode
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * @return salaryGrpCd
	 */
	public String getSalaryGrpCd() {
		return salaryGrpCd;
	}
	
	/**
	 * @return overTimeCode
	 */
	public String getOverTimeCode() {
		return overTimeCode;
	}
	
	/**
	 * @return workOnCode
	 */
	public String getWorkOnCode() {
		return workOnCode;
	}
	
	/**
	 * @return overWorkTypeName
	 */
	public String getOverWorkTypeName() {
		return overWorkTypeName;
	}
	
	/**
	 * @return overCause
	 */
	public String getOverCause() {
		return overCause;
	}
	
	/**
	 * @return overAgreeType
	 */
	public String getOverAgreeType() {
		return overAgreeType;
	}
	
	/**
	 * @return limitCode
	 */
	public String getLimitCode() {
		return limitCode;
	}
	
	/**
	 * @return overTimeRate
	 */
	public int getOverTimeRate() {
		return overTimeRate;
	}
	
	/**
	 * @return cautionMonth
	 */
	public int getCautionMonth() {
		return cautionMonth;
	}
	
	/**
	 * @return monthlyOverTimeRate
	 */
	public int getMonthlyOverTimeRate() {
		return monthlyOverTimeRate;
	}
	
	/**
	 * @return subAcquireRate
	 */
	public int getSubAcquireRate() {
		return subAcquireRate;
	}
	
	/**
	 * @return subAcquireHolidayRate
	 */
	public int getSubAcquireHolidayRate() {
		return subAcquireHolidayRate;
	}
	
	/**
	 * @return subQuitRate
	 */
	public int getSubQuitRate() {
		return subQuitRate;
	}
	
	/**
	 * @return overStartDate
	 */
	public Date getOverStartDate() {
		return (Date)overStartDate.clone();
	}
	
	/**
	 * @return workOnWorkTypeName
	 */
	public String getWorkOnWorkTypeName() {
		return workOnWorkTypeName;
	}
	
	/**
	 * @return workOnCause
	 */
	public String getWorkOnCause() {
		return workOnCause;
	}
	
	/**
	 * @return standardWeekHoliday
	 */
	public String getStandardWeekHoliday() {
		return standardWeekHoliday;
	}
	
	/**
	 * @return officialHoliday
	 */
	public String getOfficialHoliday() {
		return officialHoliday;
	}
	
	/**
	 * @return japaneseHolidayFlag
	 */
	public String getJapaneseHolidayFlag() {
		return japaneseHolidayFlag;
	}
	
	/**
	 * @return holidayMasterFlag
	 */
	public String getHolidayMasterFlag() {
		return holidayMasterFlag;
	}
	
	/**
	 * @return standardHolidayRate
	 */
	public int getStandardHolidayRate() {
		return standardHolidayRate;
	}
	
	/**
	 * @return officialHolidayRate
	 */
	public int getOfficialHolidayRate() {
		return officialHolidayRate;
	}
	
	/**
	 * @return numberOfWorkOn
	 */
	public int getNumberOfWorkOn() {
		return numberOfWorkOn;
	}
	
	/**
	 * @return workOnStartTime
	 */
	public int getWorkOnStartTime() {
		return workOnStartTime;
	}
	
	/**
	 * @return workOnEndTime
	 */
	public int getWorkOnEndTime() {
		return workOnEndTime;
	}
	
	/**
	 * @return workOnStartDate
	 */
	public Date getWorkOnStartDate() {
		return (Date)workOnStartDate.clone();
	}
	
	/**
	 * @return limitName
	 */
	public String getLimitName() {
		return limitName;
	}
	
	/**
	 * @return termType
	 */
	public String getTermType() {
		return termType;
	}
	
	/**
	 * @return prescribedTime
	 */
	public int getPrescribedTime() {
		return prescribedTime;
	}
	
	/**
	 * @return cautionDay
	 */
	public int getCautionDay() {
		return cautionDay;
	}
	
	/**
	 * @return cautionTerm
	 */
	public int getCautionTerm() {
		return cautionTerm;
	}
	
	/**
	 * @return cautionYear
	 */
	public int getCautionYear() {
		return cautionYear;
	}
	
	/**
	 * @return limitDay
	 */
	public int getLimitDay() {
		return limitDay;
	}
	
	/**
	 * @return limitTerm
	 */
	public int getLimitTerm() {
		return limitTerm;
	}
	
	/**
	 * @return limitYear
	 */
	public int getLimitYear() {
		return limitYear;
	}
	
	/**
	 * @return rateTerm
	 */
	public int getRateTerm() {
		return rateTerm;
	}
	
	/**
	 * @return rateYear
	 */
	public int getRateYear() {
		return rateYear;
	}
	
	/**
	 * @return agreementDto
	 */
	public CmLaborAgreementDto getAgreementDto() {
		return agreementDto;
	}
	
	/**
	 * @return overTimeDto
	 */
	public CmAgreementOverTimeDto getOverTimeDto() {
		return overTimeDto;
	}
	
	/**
	 * @return workOnDto
	 */
	public CmAgreementWorkOnDto getWorkOnDto() {
		return workOnDto;
	}
	
	/**
	 * @return standardDto
	 */
	public CmLimitStandardDto getStandardDto() {
		return standardDto;
	}
	
	/**
	 * @param agreeCode Zbg agreeCode
	 */
	public void setAgreeCode(String agreeCode) {
		this.agreeCode = agreeCode;
	}
	
	/**
	 * @param kCode Zbg kCode
	 */
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	/**
	 * @param salaryGrpCd Zbg salaryGrpCd
	 */
	public void setSalaryGrpCd(String salaryGrpCd) {
		this.salaryGrpCd = salaryGrpCd;
	}
	
	/**
	 * @param overTimeCode Zbg overTimeCode
	 */
	public void setOverTimeCode(String overTimeCode) {
		this.overTimeCode = overTimeCode;
	}
	
	/**
	 * @param workOnCode Zbg workOnCode
	 */
	public void setWorkOnCode(String workOnCode) {
		this.workOnCode = workOnCode;
	}
	
	/**
	 * @param overWorkTypeName Zbg overWorkTypeName
	 */
	public void setOverWorkTypeName(String overWorkTypeName) {
		this.overWorkTypeName = overWorkTypeName;
	}
	
	/**
	 * @param overCause Zbg overCause
	 */
	public void setOverCause(String overCause) {
		this.overCause = overCause;
	}
	
	/**
	 * @param overAgreeType Zbg overAgreeType
	 */
	public void setOverAgreeType(String overAgreeType) {
		this.overAgreeType = overAgreeType;
	}
	
	/**
	 * @param limitCode Zbg limitCode
	 */
	public void setLimitCode(String limitCode) {
		this.limitCode = limitCode;
	}
	
	/**
	 * @param overTimeRate Zbg overTimeRate
	 */
	public void setOverTimeRate(int overTimeRate) {
		this.overTimeRate = overTimeRate;
	}
	
	/**
	 * @param cautionMonth Zbg cautionMonth
	 */
	public void setCautionMonth(int cautionMonth) {
		this.cautionMonth = cautionMonth;
	}
	
	/**
	 * @param monthlyOverTimeRate Zbg monthlyOverTimeRate
	 */
	public void setMonthlyOverTimeRate(int monthlyOverTimeRate) {
		this.monthlyOverTimeRate = monthlyOverTimeRate;
	}
	
	/**
	 * @param subAcquireRate Zbg subAcquireRate
	 */
	public void setSubAcquireRate(int subAcquireRate) {
		this.subAcquireRate = subAcquireRate;
	}
	
	/**
	 * @param subAcquireHolidayRate Zbg subAcquireHolidayRate
	 */
	public void setSubAcquireHolidayRate(int subAcquireHolidayRate) {
		this.subAcquireHolidayRate = subAcquireHolidayRate;
	}
	
	/**
	 * @param subQuitRate Zbg subQuitRate
	 */
	public void setSubQuitRate(int subQuitRate) {
		this.subQuitRate = subQuitRate;
	}
	
	/**
	 * @param overStartDate Zbg overStartDate
	 */
	public void setOverStartDate(Date overStartDate) {
		this.overStartDate = (Date)overStartDate.clone();
	}
	
	/**
	 * @param workOnWorkTypeName Zbg workOnWorkTypeName
	 */
	public void setWorkOnWorkTypeName(String workOnWorkTypeName) {
		this.workOnWorkTypeName = workOnWorkTypeName;
	}
	
	/**
	 * @param workOnCause Zbg workOnCause
	 */
	public void setWorkOnCause(String workOnCause) {
		this.workOnCause = workOnCause;
	}
	
	/**
	 * @param standardWeekHoliday Zbg standardWeekHoliday
	 */
	public void setStandardWeekHoliday(String standardWeekHoliday) {
		this.standardWeekHoliday = standardWeekHoliday;
	}
	
	/**
	 * @param officialHoliday Zbg officialHoliday
	 */
	public void setOfficialHoliday(String officialHoliday) {
		this.officialHoliday = officialHoliday;
	}
	
	/**
	 * @param japaneseHolidayFlag Zbg japaneseHolidayFlag
	 */
	public void setJapaneseHolidayFlag(String japaneseHolidayFlag) {
		this.japaneseHolidayFlag = japaneseHolidayFlag;
	}
	
	/**
	 * @param holidayMasterFlag Zbg holidayMasterFlag
	 */
	public void setHolidayMasterFlag(String holidayMasterFlag) {
		this.holidayMasterFlag = holidayMasterFlag;
	}
	
	/**
	 * @param standardHolidayRate Zbg standardHolidayRate
	 */
	public void setStandardHolidayRate(int standardHolidayRate) {
		this.standardHolidayRate = standardHolidayRate;
	}
	
	/**
	 * @param officialHolidayRate Zbg officialHolidayRate
	 */
	public void setOfficialHolidayRate(int officialHolidayRate) {
		this.officialHolidayRate = officialHolidayRate;
	}
	
	/**
	 * @param numberOfWorkOn Zbg numberOfWorkOn
	 */
	public void setNumberOfWorkOn(int numberOfWorkOn) {
		this.numberOfWorkOn = numberOfWorkOn;
	}
	
	/**
	 * @param workOnStartTime Zbg workOnStartTime
	 */
	public void setWorkOnStartTime(int workOnStartTime) {
		this.workOnStartTime = workOnStartTime;
	}
	
	/**
	 * @param workOnEndTime Zbg workOnEndTime
	 */
	public void setWorkOnEndTime(int workOnEndTime) {
		this.workOnEndTime = workOnEndTime;
	}
	
	/**
	 * @param workOnStartDate Zbg workOnStartDate
	 */
	public void setWorkOnStartDate(Date workOnStartDate) {
		this.workOnStartDate = (Date)workOnStartDate.clone();
	}
	
	/**
	 * @param limitName Zbg limitName
	 */
	public void setLimitName(String limitName) {
		this.limitName = limitName;
	}
	
	/**
	 * @param termType Zbg termType
	 */
	public void setTermType(String termType) {
		this.termType = termType;
	}
	
	/**
	 * @param prescribedTime Zbg prescribedTime
	 */
	public void setPrescribedTime(int prescribedTime) {
		this.prescribedTime = prescribedTime;
	}
	
	/**
	 * @param cautionDay Zbg cautionDay
	 */
	public void setCautionDay(int cautionDay) {
		this.cautionDay = cautionDay;
	}
	
	/**
	 * @param cautionTerm Zbg cautionTerm
	 */
	public void setCautionTerm(int cautionTerm) {
		this.cautionTerm = cautionTerm;
	}
	
	/**
	 * @param cautionYear Zbg cautionYear
	 */
	public void setCautionYear(int cautionYear) {
		this.cautionYear = cautionYear;
	}
	
	/**
	 * @param limitDay Zbg limitDay
	 */
	public void setLimitDay(int limitDay) {
		this.limitDay = limitDay;
	}
	
	/**
	 * @param limitTerm Zbg limitTerm
	 */
	public void setLimitTerm(int limitTerm) {
		this.limitTerm = limitTerm;
	}
	
	/**
	 * @param limitYear Zbg limitYear
	 */
	public void setLimitYear(int limitYear) {
		this.limitYear = limitYear;
	}
	
	/**
	 * @param rateTerm Zbg rateTerm
	 */
	public void setRateTerm(int rateTerm) {
		this.rateTerm = rateTerm;
	}
	
	/**
	 * @param rateYear Zbg rateYear
	 */
	public void setRateYear(int rateYear) {
		this.rateYear = rateYear;
	}
	
	/**
	 * @param agreementDto Zbg agreementDto
	 */
	public void setAgreementDto(CmLaborAgreementDto agreementDto) {
		this.agreementDto = agreementDto;
	}
	
	/**
	 * @param overTimeDto Zbg overTimeDto
	 */
	public void setOverTimeDto(CmAgreementOverTimeDto overTimeDto) {
		this.overTimeDto = overTimeDto;
	}
	
	/**
	 * @param workOnDto Zbg workOnDto
	 */
	public void setWorkOnDto(CmAgreementWorkOnDto workOnDto) {
		this.workOnDto = workOnDto;
	}
	
	/**
	 * @param standardDto Zbg standardDto
	 */
	public void setStandardDto(CmLimitStandardDto standardDto) {
		this.standardDto = standardDto;
	}
	
}
