/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system;

import java.io.Serializable;
import java.util.Date;

/**
 * Jg
 * @author yoshida
 *
 */
public interface AgreementBaseInfo extends Serializable {
	
	/**
	 * @return JgR[hB
	 */
	String getAgreeCode();
	
	/**
	 * @return ЈR[h
	 */
	String getKCode();
	
	/**
	 * @return ^O[vR[hB
	 */
	String getSalaryGrpCd();
	
	/**
	 * @return ԊOR[hB
	 */
	String getOverTimeCode();
	
	/**
	 * @return xoR[hB
	 */
	String getWorkOnCode();
	
	/**
	 * @return ԊOƖ̎ށB
	 */
	String getOverWorkTypeName();
	
	/**
	 * @return ԊO̓IRB
	 */
	String getOverCause();
	
	/**
	 * @return ԊO苦ށB
	 */
	String getOverAgreeType();
	
	/**
	 * @return xR[hB
	 */
	String getLimitCode();
	
	/**
	 * @return ԊOB
	 */
	int getOverTimeRate();
	
	/**
	 * @return 60ԎԊOxԁB
	 */
	int getCautionMonth();
	
	/**
	 * @return 60ԎԊOB
	 */
	int getMonthlyOverTimeRate();
	
	/**
	 * @return ֋xɎ擾B
	 */
	int getSubAcquireRate();
	
	/**
	 * @return ֋xɎ擾xB
	 */
	int getSubAcquireHolidayRate();
	
	/**
	 * @return ֋xɕB
	 */
	int getSubQuitRate();
	
	/**
	 * @return ԊOJnNB
	 */
	Date getOverStartDate();
	
	/**
	 * @return xoƖ̎ށB
	 */
	String getWorkOnWorkTypeName();
	
	/**
	 * @return xo̓IRB
	 */
	String getWorkOnCause();
	
	/**
	 * @return xB
	 */
	String getStandardWeekHoliday();
	
	/**
	 * @return @xB
	 */
	String getOfficialHoliday();
	
	/**
	 * @return ̏jtOB
	 */
	String getJapaneseHolidayFlag();
	
	/**
	 * @return jՓ}X^tOB
	 */
	String getHolidayMasterFlag();
	
	/**
	 * @return xB
	 */
	int getStandardHolidayRate();
	
	/**
	 * @return @xB
	 */
	int getOfficialHolidayRate();
	
	/**
	 * @return xoB
	 */
	int getNumberOfWorkOn();
	
	/**
	 * @return xoJnB
	 */
	int getWorkOnStartTime();
	
	/**
	 * @return xoIB
	 */
	int getWorkOnEndTime();
	
	/**
	 * @return xoJnNB
	 */
	Date getWorkOnStartDate();
	
	/**
	 * @return x́B
	 */
	String getLimitName();
	
	/**
	 * @return Ԃ̎ށB
	 */
	String getTermType();
	
	/**
	 * @return JԁB
	 */
	int getPrescribedTime();
	
	/**
	 * @return 1̌xԁB
	 */
	int getCautionDay();
	
	/**
	 * @return wԂ̌xԁB
	 */
	int getCautionTerm();
	
	/**
	 * @return 1ŇxԁB
	 */
	int getCautionYear();
	
	/**
	 * @return ̌xԁB
	 */
	int getLimitDay();
	
	/**
	 * @return wԂ̌xԁB
	 */
	int getLimitTerm();
	
	/**
	 * @return 1ŇxԁB
	 */
	int getLimitYear();
	
	/**
	 * @return wԂ̊B
	 */
	int getRateTerm();
	
	/**
	 * @return 1N̊B
	 */
	int getRateYear();
	
}
