/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.report.dto.MExportDto;

/**
 * M_EXPORT(GLX|[g}X^)DAONX B
 */
public class MExportDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_EXPORT(GLX|[g}X^)B
	 */
	public static final String	TABLE		= "M_EXPORT";
	
	/**
	 * KEY_1 = ENAME()B
	 */
	public static final String	KEY_1		= "ENAME";
	/**
	 * KEY_2 = EFILE(t@CID)B
	 */
	public static final String	KEY_2		= "EFILE";
	/**
	 * KEY_3 = ELINE(s)B
	 */
	public static final String	KEY_3		= "ELINE";
	
	// 
	/**
	 * ENAME()B
	 */
	public static final String	COL_ENAME	= "ENAME";
	/**
	 * EFILE(t@CID)B
	 */
	public static final String	COL_EFILE	= "EFILE";
	/**
	 * ELINE(s)B
	 */
	public static final String	COL_ELINE	= "ELINE";
	/**
	 * EFID(tB[hID)B
	 */
	//public static final String	COL_EFID		= "EFID";
	/**
	 * EFTYPE(tB[hTYPE)B
	 */
	//public static final String	COL_EFTYPE		= "EFTYPE";
	/**
	 * EFNAME(tB[h)B
	 */
	public static final String	COL_EFNAME	= "EFNAME";
	

	/**
	 * DELETEFLAG(폜tO)B
	 */
	//public static final String	COL_DELETEFLAG	= "DELETEFLAG";
	
	/**
	 * RXgN^
	 */
	public MExportDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MExportDto> mappingAll() throws SQLException {
		List<MExportDto> all = new ArrayList<MExportDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_exportDto m_exportR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MExportDto mapping() throws SQLException {
		MExportDto dto = new MExportDto();
		dto.setEName(rs.getString(COL_ENAME)); //
		dto.setEFile(rs.getString(COL_EFILE)); //e[uID
		dto.setELine(rs.getInt(COL_ELINE)); //
		dto.setEFName(rs.getString(COL_EFNAME)); //tB[h
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param ename (L[)
	 * @param efile t@CID
	 * @param eline s
	 * @return m_exportDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MExportDto findForKey(String ename, String efile, int eline) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, ename);
			setParam(index++, efile);
			setParam(index++, eline);
			executeQuery();
			MExportDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param ename (L[)
	 * @param efile t@CID
	 * @param eline s
	 * @return m_exportDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MExportDto findForUpdate(String ename, String efile, String eline) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, ename);
			setParam(index++, efile);
			setParam(index++, eline);
			executeQuery();
			MExportDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MExportDto> findForCondition() throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_ELINE);
		sb.append(" = 0 ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MExportDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param ename 
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MExportDto> findForCondition(String ename) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_ENAME);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, ename);
			executeQuery();
			List<MExportDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param ename 
	 * @param efile t@CID
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MExportDto> findForCondition(String ename, String efile) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_ENAME);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_EFILE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, ename);
			setParam(index++, efile);
			executeQuery();
			List<MExportDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MExportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MExportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getEName());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MExportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getEName());
			setParam(index++, dto.getEFile());
			setParam(index++, dto.getELine());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param ename XVΏename
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(String ename) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_ENAME);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, ename);
			executeUpdate();
			return 0;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param ename XVΏename
	 * @param efile XVΏefile
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(String ename, String efile) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_ENAME);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_EFILE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, ename);
			setParam(index++, efile);
			executeUpdate();
			return 0;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MExportDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getEName()); //
		setParam(index++, dto.getEFile()); //e[uID
		setParam(index++, dto.getELine()); //
		setParam(index++, dto.getEFName()); //tB[h
		setCommonParams(isInsert);
	}
	
}
