/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;

/**
 * @author matsusita
 *
 */
public class SubHolidayCloseOperationCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6329234170498691307L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_POSSIBLE		= 0;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_HID_OCCUR_YEAR	= "hidOccurYear";
	/**
	 * 
	 */
	public static final String	PRM_HID_OCCUR_MONTH	= "hidOccurMonth";
	
	// tB[h
	private String				hidOccurYear;
	private String				hidOccurMonth;
	
	// tB[h(\̂)
	private String				lblStartDate;
	private String				lblEndDate;
	
	// [h(0:A1:s)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OCCUR_DATE;
	

	/**
	 * RXgN^B
	 */
	public SubHolidayCloseOperationCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "ߏ";
		aryMenu = new String[][]{ { CMD_MENU_PAYROLL, CommonConst.NAM_TO_MENU },
			MosPMenuConst.getMenuSubHolidayManagement() };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OCCUR_DATE = CommonConst.NAM_HOLIDAY_MONTH;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidOccurYear = request.getParameter(PRM_HID_OCCUR_YEAR);
		hidOccurMonth = request.getParameter(PRM_HID_OCCUR_MONTH);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return hidOccurYear
	 */
	public String getHidOccurYear() {
		return hidOccurYear;
	}
	
	/**
	 * @return hidOccurMonth
	 */
	public String getHidOccurMonth() {
		return hidOccurMonth;
	}
	
	/**
	 * @return hidOccurYear
	 */
	public String getEscHidOccurYear() {
		return escapeHTML(hidOccurYear);
	}
	
	/**
	 * @return hidOccurMonth
	 */
	public String getEscHidOccurMonth() {
		return escapeHTML(hidOccurMonth);
	}
	
	/**
	 * @param hidOccurYear Zbg hidOccurYear
	 */
	public void setHidOccurYear(String hidOccurYear) {
		this.hidOccurYear = hidOccurYear;
	}
	
	/**
	 * @param hidOccurMonth Zbg hidOccurMonth
	 */
	public void setHidOccurMonth(String hidOccurMonth) {
		this.hidOccurMonth = hidOccurMonth;
	}
	
	/**
	 * @return lblStartDate
	 */
	public String getEscLblStartDate() {
		return escapeHTML(lblStartDate);
	}
	
	/**
	 * @return lblEndDate
	 */
	public String getEscLblEndDate() {
		return escapeHTML(lblEndDate);
	}
	
	/**
	 * @param lblStartDate Zbg lblStartDate
	 */
	public void setLblStartDate(String lblStartDate) {
		this.lblStartDate = lblStartDate;
	}
	
	/**
	 * @param lblEndDate Zbg lblEndDate
	 */
	public void setLblEndDate(String lblEndDate) {
		this.lblEndDate = lblEndDate;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
