/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;

/**
 * @author matsusita
 *
 */
public class SubHolidayAttitudeCardVo extends MosPVo {
	
	private static final long	serialVersionUID							= 5540553755809443835L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_POSSIBLE								= 0;
	/**
	 * 
	 */
	public static final int		MODE_DISABLED								= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_ATTITUDE_STATUS						= "pltAttitudeStatus";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR			= "txtPaymentAcquireTimeHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN			= "txtPaymentAcquireTimeMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR		= "txtPaymentAcquireHolidayHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN			= "txtPaymentAcquireHolidayMin";
	/**
	 * 
	 */
	public static final String	PRM_HID_PAYMENT_QUIT_TIME					= "hidPaymentQuitTime";
	/**
	 * 
	 */
	public static final String	PRM_HID_CONVERTED_MONTHLY_OVER_TIME_HOUR	= "hidConvertedMonthlyOverTimeHour";
	/**
	 * 
	 */
	public static final String	PRM_HID_CONVERTED_MONTHLY_OVER_TIME_MIN		= "hidConvertedMonthlyOverTimeMin";
	/**
	 * 
	 */
	public static final String	PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_HOUR	= "hidConvertedMonthlyWeekHolidayHour";
	/**
	 * 
	 */
	public static final String	PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_MIN	= "hidConvertedMonthlyWeekHolidayMin";
	
	// tB[h
	private String				pltAttitudeStatus;
	private String				txtPaymentAcquireTimeHour;
	private String				txtPaymentAcquireTimeMin;
	private String				txtPaymentAcquireHolidayHour;
	private String				txtPaymentAcquireHolidayMin;
	private String				hidPaymentQuitTime;
	
	private String				hidConvertedMonthlyOverTimeHour;
	private String				hidConvertedMonthlyOverTimeMin;
	private String				hidConvertedMonthlyWeekHolidayHour;
	private String				hidConvertedMonthlyWeekHolidayMin;
	private String				hidRate;
	private String				hidHolidayRate;
	
	private String				lblOccurYear;
	private String				lblOccurMonth;
	private String				lblCloseDate;
	
	// [h(0:A1:s)
	private int					mode;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltAttitudeStatus;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OCCUR_MONTH;
	/**
	 * 
	 */
	public String				NAM_CLOSE_DATE;
	/**
	 * 
	 */
	public String				NAM_ATTITUDE_STATUS;
	/**
	 * 
	 */
	public String				NAM_CONVERTED_MONTHLY_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_TIME;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN;
	
	/**
	 * 
	 */
	public String				NAM_WEEKDAY;
	/**
	 * 
	 */
	public String				NAM_STANDARD_WEEK_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_RATE;
	
	/**
	 * 
	 */
	public int					LEN_HOUR;
	/**
	 * 
	 */
	public int					LEN_MIN;
	

	/**
	 * RXgN^
	 */
	public SubHolidayAttitudeCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "xӌmF";
		createAryMenu(CMD_MENU_INPUT, MosPMenuConst.getMenuApplication());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OCCUR_MONTH = CommonConst.NAM_HOLIDAY_MONTH;
		NAM_CLOSE_DATE = "ؓ";
		NAM_ATTITUDE_STATUS = "ӌ";
		NAM_CONVERTED_MONTHLY_OVER_TIME = "Z㎞";
		NAM_PAYMENT_ACQUIRE_TIME = "֋xɎ擾ԊO";
		NAM_PAYMENT_ACQUIRE_TIME_HOUR = "֋xɎ擾ԊO" + CommonConst.NAM_ROUND_BRACKETS_LEFT + CommonConst.NAM_COMMON_TIME
				+ CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_PAYMENT_ACQUIRE_TIME_MIN = "֋xɎ擾ԊO" + CommonConst.NAM_ROUND_BRACKETS_LEFT + CommonConst.NAM_MINUTES
				+ CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_PAYMENT_ACQUIRE_HOLIDAY = "֋xɎ擾xԊO";
		NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR = "֋xɎ擾xԊO" + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_COMMON_TIME + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN = "֋xɎ擾xԊO" + CommonConst.NAM_ROUND_BRACKETS_LEFT + CommonConst.NAM_MINUTES
				+ CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_WEEKDAY = CommonConst.NAM_WEEKDAY;
		NAM_STANDARD_WEEK_HOLIDAY = CommonConst.NAM_STANDARD_WEEK_HOLIDAY;
		NAM_RATE = CommonConst.NAM_CONVERSION_RATE;
		LEN_HOUR = 3;
		LEN_MIN = CommonConst.LEN_TIME_MIN;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtPaymentAcquireTimeHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtPaymentAcquireTimeMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtPaymentAcquireHolidayHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtPaymentAcquireHolidayMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidPaymentQuitTime(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidConvertedMonthlyOverTimeHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidConvertedMonthlyOverTimeMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidConvertedMonthlyWeekHolidayHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidConvertedMonthlyWeekHolidayMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setHidRate(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setHidHolidayRate(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setLblOccurYear(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setLblOccurMonth(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setLblCloseDate(DateUtil.convDateFormatted(DateUtil.getInitialDate()));
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltAttitudeStatus = request.getParameter(PRM_PLT_ATTITUDE_STATUS);
		txtPaymentAcquireTimeHour = request.getParameter(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR);
		txtPaymentAcquireTimeMin = request.getParameter(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN);
		txtPaymentAcquireHolidayHour = request.getParameter(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR);
		txtPaymentAcquireHolidayMin = request.getParameter(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN);
		hidPaymentQuitTime = request.getParameter(PRM_HID_PAYMENT_QUIT_TIME);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(KdSubstituteHolidayDto dto) {
		lblOccurYear = String.valueOf(dto.getOccurYear());
		lblOccurMonth = String.valueOf(dto.getOccurMonth());
		lblCloseDate = DateUtil.convDateFormatted(dto.getCloseDate());
		txtPaymentAcquireTimeHour = TimeUtil.convIntegerTimeToStringHour(dto.getPaymentAcquireTime());
		txtPaymentAcquireTimeMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getPaymentAcquireTime());
		txtPaymentAcquireHolidayHour = TimeUtil.convIntegerTimeToStringHour(dto.getPaymentAcquireHoliday());
		txtPaymentAcquireHolidayMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getPaymentAcquireHoliday());
		hidPaymentQuitTime = String.valueOf(dto.getPaymentQuitTime());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(KdSubstituteHolidayDto dto) {
		dto.setAttitudeStatus(CommonConst.CODE_ATTITUDE_STATUS_FIXED);
		dto.setPaymentAcquireTime(TimeUtil.convStringTimeToIntegerTime(txtPaymentAcquireTimeHour,
				txtPaymentAcquireTimeMin));
		dto.setPaymentAcquireHoliday(TimeUtil.convStringTimeToIntegerTime(txtPaymentAcquireHolidayHour,
				txtPaymentAcquireHolidayMin));
		dto.setPaymentQuitTime(NumberUtil.getIntParam(hidPaymentQuitTime));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtPaymentAcquireTimeHour, NAM_PAYMENT_ACQUIRE_TIME_HOUR, PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR);
		checkRequired(txtPaymentAcquireTimeMin, NAM_PAYMENT_ACQUIRE_TIME_MIN, PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN);
		checkRequired(txtPaymentAcquireHolidayHour, NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR,
				PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR);
		checkRequired(txtPaymentAcquireHolidayMin, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN, PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN);
		// ^CvmF
		checkNumber(txtPaymentAcquireTimeHour, NAM_PAYMENT_ACQUIRE_TIME_HOUR, PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR);
		checkNumber(txtPaymentAcquireTimeMin, NAM_PAYMENT_ACQUIRE_TIME_MIN, PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN);
		checkNumber(txtPaymentAcquireHolidayHour, NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR,
				PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR);
		checkNumber(txtPaymentAcquireHolidayMin, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN, PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN);
		// 񒷊mF
		checkLength(txtPaymentAcquireTimeHour, LEN_HOUR, NAM_PAYMENT_ACQUIRE_TIME_HOUR,
				PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR);
		checkLength(txtPaymentAcquireTimeMin, LEN_MIN, NAM_PAYMENT_ACQUIRE_TIME_MIN, PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN);
		checkLength(txtPaymentAcquireHolidayHour, LEN_HOUR, NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR,
				PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR);
		checkLength(txtPaymentAcquireHolidayMin, LEN_MIN, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN,
				PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return pltAttitudeStatus
	 */
	public String getPltAttitudeStatus() {
		return pltAttitudeStatus;
	}
	
	/**
	 * @return txtPaymentAcquireTimeHour
	 */
	public String getTxtPaymentAcquireTimeHour() {
		return txtPaymentAcquireTimeHour;
	}
	
	/**
	 * @return txtPaymentAcquireTimeMin
	 */
	public String getTxtPaymentAcquireTimeMin() {
		return txtPaymentAcquireTimeMin;
	}
	
	/**
	 * @return txtPaymentAcquireHolidayHour
	 */
	public String getTxtPaymentAcquireHolidayHour() {
		return txtPaymentAcquireHolidayHour;
	}
	
	/**
	 * @return txtPaymentAcquireHolidayMin
	 */
	public String getTxtPaymentAcquireHolidayMin() {
		return txtPaymentAcquireHolidayMin;
	}
	
	/**
	 * @return hidPaymentQuitTime
	 */
	public String getHidPaymentQuitTime() {
		return hidPaymentQuitTime;
	}
	
	/**
	 * @return hidConvertedMonthlyOverTimeHour
	 */
	public String getHidConvertedMonthlyOverTimeHour() {
		return hidConvertedMonthlyOverTimeHour;
	}
	
	/**
	 * @return hidConvertedMonthlyOverTimeMin
	 */
	public String getHidConvertedMonthlyOverTimeMin() {
		return hidConvertedMonthlyOverTimeMin;
	}
	
	/**
	 * @return hidConvertedMonthlyWeekHolidayHour
	 */
	public String getHidConvertedMonthlyWeekHolidayHour() {
		return hidConvertedMonthlyWeekHolidayHour;
	}
	
	/**
	 * @return hidConvertedMonthlyWeekHolidayMin
	 */
	public String getHidConvertedMonthlyWeekHolidayMin() {
		return hidConvertedMonthlyWeekHolidayMin;
	}
	
	/**
	 * @return hidRate
	 */
	public String getHidRate() {
		return hidRate;
	}
	
	/**
	 * @return hidHolidayRate
	 */
	public String getHidHolidayRate() {
		return hidHolidayRate;
	}
	
	/**
	 * @return lblOccurYear
	 */
	public String getLblOccurYear() {
		return lblOccurYear;
	}
	
	/**
	 * @return lblOccurMonth
	 */
	public String getLblOccurMonth() {
		return lblOccurMonth;
	}
	
	/**
	 * @return lblCloseDate
	 */
	public String getLblCloseDate() {
		return lblCloseDate;
	}
	
	/**
	 * @return txtPaymentAcquireTimeHour
	 */
	public String getEscTxtPaymentAcquireTimeHour() {
		return escapeHTML(txtPaymentAcquireTimeHour);
	}
	
	/**
	 * @return txtPaymentAcquireTimeMin
	 */
	public String getEscTxtPaymentAcquireTimeMin() {
		return escapeHTML(txtPaymentAcquireTimeMin);
	}
	
	/**
	 * @return txtPaymentAcquireHolidayHour
	 */
	public String getEscTxtPaymentAcquireHolidayHour() {
		return escapeHTML(txtPaymentAcquireHolidayHour);
	}
	
	/**
	 * @return txtPaymentAcquireHolidayMin
	 */
	public String getEscTxtPaymentAcquireHolidayMin() {
		return escapeHTML(txtPaymentAcquireHolidayMin);
	}
	
	/**
	 * @return hidPaymentQuitTime
	 */
	public String getEscHidPaymentQuitTime() {
		return escapeHTML(hidPaymentQuitTime);
	}
	
	/**
	 * @return hidConvertedMonthlyOverTimeHour
	 */
	public String getEscHidConvertedMonthlyOverTimeHour() {
		return escapeHTML(hidConvertedMonthlyOverTimeHour);
	}
	
	/**
	 * @return hidConvertedMonthlyOverTimeMin
	 */
	public String getEscHidConvertedMonthlyOverTimeMin() {
		return escapeHTML(hidConvertedMonthlyOverTimeMin);
	}
	
	/**
	 * @return hidConvertedMonthlyWeekHolidayHour
	 */
	public String getEscHidConvertedMonthlyWeekHolidayHour() {
		return escapeHTML(hidConvertedMonthlyWeekHolidayHour);
	}
	
	/**
	 * @return hidConvertedMonthlyWeekHolidayMin
	 */
	public String getEscHidConvertedMonthlyWeekHolidayMin() {
		return escapeHTML(hidConvertedMonthlyWeekHolidayMin);
	}
	
	/**
	 * @return hidRate
	 */
	public String getEscHidRate() {
		return escapeHTML(hidRate);
	}
	
	/**
	 * @return hidHolidayRate
	 */
	public String getEscHidHolidayRate() {
		return escapeHTML(hidHolidayRate);
	}
	
	/**
	 * @return lblOccurYear
	 */
	public String getEscLblOccurYear() {
		return escapeHTML(lblOccurYear);
	}
	
	/**
	 * @return lblOccurMonth
	 */
	public String getEscLblOccurMonth() {
		return escapeHTML(lblOccurMonth);
	}
	
	/**
	 * @return lblCloseDate
	 */
	public String getEscLblCloseDate() {
		return escapeHTML(lblCloseDate);
	}
	
	/**
	 * @param pltAttitudeStatus Zbg pltAttitudeStatus
	 */
	public void setPltAttitudeStatus(String pltAttitudeStatus) {
		this.pltAttitudeStatus = pltAttitudeStatus;
	}
	
	/**
	 * @param txtPaymentAcquireTimeHour Zbg txtPaymentAcquireTimeHour
	 */
	public void setTxtPaymentAcquireTimeHour(String txtPaymentAcquireTimeHour) {
		this.txtPaymentAcquireTimeHour = txtPaymentAcquireTimeHour;
	}
	
	/**
	 * @param txtPaymentAcquireTimeMin Zbg txtPaymentAcquireTimeMin
	 */
	public void setTxtPaymentAcquireTimeMin(String txtPaymentAcquireTimeMin) {
		this.txtPaymentAcquireTimeMin = txtPaymentAcquireTimeMin;
	}
	
	/**
	 * @param txtPaymentAcquireHolidayHour Zbg txtPaymentAcquireHolidayHour
	 */
	public void setTxtPaymentAcquireHolidayHour(String txtPaymentAcquireHolidayHour) {
		this.txtPaymentAcquireHolidayHour = txtPaymentAcquireHolidayHour;
	}
	
	/**
	 * @param txtPaymentAcquireHolidayMin Zbg txtPaymentAcquireHolidayMin
	 */
	public void setTxtPaymentAcquireHolidayMin(String txtPaymentAcquireHolidayMin) {
		this.txtPaymentAcquireHolidayMin = txtPaymentAcquireHolidayMin;
	}
	
	/**
	 * @param hidPaymentQuitTime Zbg hidPaymentQuitTime
	 */
	public void setHidPaymentQuitTime(String hidPaymentQuitTime) {
		this.hidPaymentQuitTime = hidPaymentQuitTime;
	}
	
	/**
	 * @param hidConvertedMonthlyOverTimeHour Zbg hidConvertedMonthlyOverTimeHour
	 */
	public void setHidConvertedMonthlyOverTimeHour(String hidConvertedMonthlyOverTimeHour) {
		this.hidConvertedMonthlyOverTimeHour = hidConvertedMonthlyOverTimeHour;
	}
	
	/**
	 * @param hidConvertedMonthlyOverTimeMin Zbg hidConvertedMonthlyOverTimeMin
	 */
	public void setHidConvertedMonthlyOverTimeMin(String hidConvertedMonthlyOverTimeMin) {
		this.hidConvertedMonthlyOverTimeMin = hidConvertedMonthlyOverTimeMin;
	}
	
	/**
	 * @param hidConvertedMonthlyWeekHolidayHour Zbg hidConvertedMonthlyWeekHolidayHour
	 */
	public void setHidConvertedMonthlyWeekHolidayHour(String hidConvertedMonthlyWeekHolidayHour) {
		this.hidConvertedMonthlyWeekHolidayHour = hidConvertedMonthlyWeekHolidayHour;
	}
	
	/**
	 * @param hidConvertedMonthlyWeekHolidayMin Zbg hidConvertedMonthlyWeekHolidayMin
	 */
	public void setHidConvertedMonthlyWeekHolidayMin(String hidConvertedMonthlyWeekHolidayMin) {
		this.hidConvertedMonthlyWeekHolidayMin = hidConvertedMonthlyWeekHolidayMin;
	}
	
	/**
	 * @param hidRate Zbg hidRate
	 */
	public void setHidRate(String hidRate) {
		this.hidRate = hidRate;
	}
	
	/**
	 * @param hidHolidayRate Zbg hidHolidayRate
	 */
	public void setHidHolidayRate(String hidHolidayRate) {
		this.hidHolidayRate = hidHolidayRate;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param lblOccurYear Zbg lblOccurYear
	 */
	public void setLblOccurYear(String lblOccurYear) {
		this.lblOccurYear = lblOccurYear;
	}
	
	/**
	 * @param lblOccurMonth Zbg lblOccurMonth
	 */
	public void setLblOccurMonth(String lblOccurMonth) {
		this.lblOccurMonth = lblOccurMonth;
	}
	
	/**
	 * @param lblCloseDate Zbg lblCloseDate
	 */
	public void setLblCloseDate(String lblCloseDate) {
		this.lblCloseDate = lblCloseDate;
	}
	
}
