/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;

/**
 * @author matsusita
 *
 */
public class PreparatoryOperationCardVo extends MosPVo {
	
	private static final long	serialVersionUID			= -8838627779979597062L;
	
	// p[^
	/**
	 * hidOccurYear
	 */
	public static final String	PRM_HID_OCCUR_YEAR			= "hidOccurYear";
	/**
	 * hidOccurMonth
	 */
	public static final String	PRM_HID_OCCUR_MONTH			= "hidOccurMonth";
	/**
	 * pltCloseYear
	 */
	public static final String	PRM_PLT_CLOSE_YEAR			= "pltCloseYear";
	/**
	 * pltCloseMonth
	 */
	public static final String	PRM_PLT_CLOSE_MONTH			= "pltCloseMonth";
	/**
	 * pltCloseDay
	 */
	public static final String	PRM_PLT_CLOSE_DAY			= "pltCloseDay";
	/**
	 * hidLimitStartDate
	 */
	public static final String	PRM_HID_LIMIT_START_DATE	= "hidLimitStartDate";
	/**
	 * hidLimitEndDate
	 */
	public static final String	PRM_HID_LIMIT_END_DATE		= "hidLimitEndDate";
	
	// tB[h
	private String				hidOccurYear;
	private String				hidOccurMonth;
	private String				pltCloseYear;
	private String				pltCloseMonth;
	private String				pltCloseDay;
	private String				hidLimitStartDate;
	private String				hidLimitEndDate;
	
	// tB[h(\̂)
	private String				lblStartDate;
	private String				lblEndDate;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OCCUR_DATE;
	/**
	 * 
	 */
	public String				NAM_CLOSE_DATE;
	/**
	 * 
	 */
	public String				NAM_LIMIT_START_DATE;
	/**
	 * 
	 */
	public String				NAM_LIMIT_END_DATE;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	

	/**
	 * RXgN^
	 */
	public PreparatoryOperationCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "O";
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuSubHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OCCUR_DATE = CommonConst.NAM_HOLIDAY_MONTH;
		NAM_CLOSE_DATE = "ؓ";
		NAM_LIMIT_START_DATE = "Jn";
		NAM_LIMIT_END_DATE = "I";
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidOccurYear = request.getParameter(PRM_HID_OCCUR_YEAR);
		hidOccurMonth = request.getParameter(PRM_HID_OCCUR_MONTH);
		pltCloseYear = request.getParameter(PRM_PLT_CLOSE_YEAR);
		pltCloseMonth = request.getParameter(PRM_PLT_CLOSE_MONTH);
		pltCloseDay = request.getParameter(PRM_PLT_CLOSE_DAY);
		hidLimitStartDate = request.getParameter(PRM_HID_LIMIT_START_DATE);
		hidLimitEndDate = request.getParameter(PRM_HID_LIMIT_END_DATE);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// tÓmF
		checkDate(getIntParam(pltCloseYear), getIntParam(pltCloseMonth), getIntParam(pltCloseDay), NAM_CLOSE_DATE,
				PRM_PLT_CLOSE_DAY);
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return hidOccurYear
	 */
	public String getHidOccurYear() {
		return hidOccurYear;
	}
	
	/**
	 * @return hidOccurMonth
	 */
	public String getHidOccurMonth() {
		return hidOccurMonth;
	}
	
	/**
	 * @return pltCloseYear
	 */
	public String getPltCloseYear() {
		return pltCloseYear;
	}
	
	/**
	 * @return pltCloseMonth
	 */
	public String getPltCloseMonth() {
		return pltCloseMonth;
	}
	
	/**
	 * @return pltCloseDay
	 */
	public String getPltCloseDay() {
		return pltCloseDay;
	}
	
	/**
	 * @return hidLimitStartDate
	 */
	public String getHidLimitStartDate() {
		return hidLimitStartDate;
	}
	
	/**
	 * @return hidLimitEndDate
	 */
	public String getHidLimitEndDate() {
		return hidLimitEndDate;
	}
	
	/**
	 * @return hidOccurYear
	 */
	public String getEscHidOccurYear() {
		return escapeHTML(hidOccurYear);
	}
	
	/**
	 * @return hidOccurMonth
	 */
	public String getEscHidOccurMonth() {
		return escapeHTML(hidOccurMonth);
	}
	
	/**
	 * @return hidLimitStartDate
	 */
	public String getEscHidLimitStartDate() {
		return escapeHTML(hidLimitStartDate);
	}
	
	/**
	 * @return hidLimitEndDate
	 */
	public String getEscHidLimitEndDate() {
		return escapeHTML(hidLimitEndDate);
	}
	
	/**
	 * @param hidOccurYear Zbg hidOccurYear
	 */
	public void setHidOccurYear(String hidOccurYear) {
		this.hidOccurYear = hidOccurYear;
	}
	
	/**
	 * @param hidOccurMonth Zbg hidOccurMonth
	 */
	public void setHidOccurMonth(String hidOccurMonth) {
		this.hidOccurMonth = hidOccurMonth;
	}
	
	/**
	 * @param pltCloseYear Zbg pltCloseYear
	 */
	public void setPltCloseYear(String pltCloseYear) {
		this.pltCloseYear = pltCloseYear;
	}
	
	/**
	 * @param pltCloseMonth Zbg pltCloseMonth
	 */
	public void setPltCloseMonth(String pltCloseMonth) {
		this.pltCloseMonth = pltCloseMonth;
	}
	
	/**
	 * @param pltCloseDay Zbg pltCloseDay
	 */
	public void setPltCloseDay(String pltCloseDay) {
		this.pltCloseDay = pltCloseDay;
	}
	
	/**
	 * @param hidLimitStartDate Zbg hidLimitStartDate
	 */
	public void setHidLimitStartDate(String hidLimitStartDate) {
		this.hidLimitStartDate = hidLimitStartDate;
	}
	
	/**
	 * @param hidLimitEndDate Zbg hidLimitEndDate
	 */
	public void setHidLimitEndDate(String hidLimitEndDate) {
		this.hidLimitEndDate = hidLimitEndDate;
	}
	
	/**
	 * @return lblStartDate
	 */
	public String getEscLblStartDate() {
		return escapeHTML(lblStartDate);
	}
	
	/**
	 * @return lblEndDate
	 */
	public String getEscLblEndDate() {
		return escapeHTML(lblEndDate);
	}
	
	/**
	 * @param lblStartDate Zbg lblStartDate
	 */
	public void setLblStartDate(String lblStartDate) {
		this.lblStartDate = lblStartDate;
	}
	
	/**
	 * @param lblEndDate Zbg lblEndDate
	 */
	public void setLblEndDate(String lblEndDate) {
		this.lblEndDate = lblEndDate;
	}
	
}
