/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class PaidHolidayCardVo extends MosPVo {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID			= 7480270108620872623L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_VIEW					= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE					= 1;
	
	// p[^
	/**
	 * hidSelectKCode
	 */
	public static final String	PRM_HID_SELECT_K_CODE		= "hidSelectKCode";
	/**
	 * hidSelectYearMonth
	 */
	public static final String	PRM_HID_SELECT_YEAR_MONTH	= "hidSelectYearMonth";
	/**
	 * hidSelectYear
	 */
	public static final String	PRM_HID_SELECT_YEAR			= "hidSelectYear";
	/**
	 * hidSelectMonth
	 */
	public static final String	PRM_HID_SELECT_MONTH		= "hidSelectMonth";
	/**
	 * txtSupplyLastDays
	 */
	public static final String	PRM_TXT_SUPPLY_LAST_DAYS	= "txtSupplyLastDays";
	/**
	 * txtSupplyDays
	 */
	public static final String	PRM_TXT_SUPPLY_DAYS			= "txtSupplyDays";
	/**
	 * txtWasteLastDays
	 */
	public static final String	PRM_TXT_WASTE_LAST_DAYS		= "txtWasteLastDays";
	/**
	 * txtWasteDays
	 */
	public static final String	PRM_TXT_WASTE_DAYS			= "txtWasteDays";
	/**
	 * txtSupplyLastHour
	 */
	public static final String	PRM_TXT_SUPPLY_LAST_HOUR	= "txtSupplyLastHour";
	/**
	 * txtSupplyHour
	 */
	public static final String	PRM_TXT_SUPPLY_HOUR			= "txtSupplyHour";
	/**
	 * txtWasteLastHour
	 */
	public static final String	PRM_TXT_WASTE_LAST_HOUR		= "txtWasteLastHour";
	/**
	 * txtWasteHour
	 */
	public static final String	PRM_TXT_WASTE_HOUR			= "txtWasteHour";
	
	/**
	 * txtSupplyLastDays
	 */
	public static final String	PRM_HID_SUPPLY_LAST_DAYS	= "hidSupplyLastDays";
	/**
	 * txtSupplyDays
	 */
	public static final String	PRM_HID_SUPPLY_DAYS			= "hidSupplyDays";
	/**
	 * txtWasteLastDays
	 */
	public static final String	PRM_HID_WASTE_LAST_DAYS		= "hidWasteLastDays";
	/**
	 * txtWasteDays
	 */
	public static final String	PRM_HID_WASTE_DAYS			= "hidWasteDays";
	/**
	 * txtSupplyLastHour
	 */
	public static final String	PRM_HID_SUPPLY_LAST_HOUR	= "hidSupplyLastHour";
	/**
	 * txtSupplyHour
	 */
	public static final String	PRM_HID_SUPPLY_HOUR			= "hidSupplyHour";
	/**
	 * txtWasteLastHour
	 */
	public static final String	PRM_HID_WASTE_LAST_HOUR		= "hidWasteLastHour";
	/**
	 * txtWasteHour
	 */
	public static final String	PRM_HID_WASTE_HOUR			= "hidWasteHour";
	
	/**
	 * hidLastRemainDays
	 */
	public static final String	PRM_HID_LAST_REMAIN_DAYS	= "hidLastRemainDays";
	/**
	 * hidLastRemainHour
	 */
	public static final String	PRM_HID_LAST_REMAIN_HOUR	= "hidLastRemainHour";
	/**
	 * hidRemainDays
	 */
	public static final String	PRM_HID_REMAIN_DAYS			= "hidRemainDays";
	/**
	 * hidRemainHour
	 */
	public static final String	PRM_HID_REMAIN_HOUR			= "hidRemainHour";
	/**
	 * txtLastRemainDays
	 */
	public static final String	PRM_TXT_LAST_REMAIN_DAYS	= "txtLastRemainDays";
	/**
	 * txtLastRemainHour
	 */
	public static final String	PRM_TXT_LAST_REMAIN_HOUR	= "txtLastRemainHour";
	/**
	 * txtRemainDays
	 */
	public static final String	PRM_TXT_REMAIN_DAYS			= "txtRemainDays";
	/**
	 * txtRemainHour
	 */
	public static final String	PRM_TXT_REMAIN_HOUR			= "txtRemainHour";
	/**
	 * txtTotalRemainDays
	 */
	public static final String	PRM_TXT_TOTAL_REMAIN_DAYS	= "txtTotalRemainDays";
	/**
	 * txtTotalRemainHour
	 */
	public static final String	PRM_TXT_TOTAL_REMAIN_HOUR	= "txtTotalRemainHour";
	/**
	 * hidTotalRemainDays
	 */
	public static final String	PRM_HID_TOTAL_REMAIN_DAYS	= "hidTotalRemainDays";
	/**
	 * hidTotalRemainHour
	 */
	public static final String	PRM_HID_TOTAL_REMAIN_HOUR	= "hidTotalRemainHour";
	
	/**
	 * hidPossible
	 */
	public static final String	PRM_HID_POSSIBLE			= "hidPossible";
	/**
	 * txtSupplyPossible
	 */
	public static final String	PRM_TXT_SUPPLY_POSSIBLE		= "txtSupplyPossible";
	/**
	 * txtWastePossible
	 */
	public static final String	PRM_TXT_WASTE_POSSIBLE		= "txtWastePossible";
	/**
	 * txtPossible
	 */
	public static final String	PRM_TXT_POSSIBLE			= "txtPossible";
	
	// tB[h
	private String				hidSelectKCode;
	private String				hidSelectYear;
	private String				hidSelectMonth;
	private String				hidSelectYearMonth;
	private String				lblSelectYearMonth;
	private String				lblLastRemainDays;
	private String				lblLastRemainHour;
	private String				lblRemainDays;
	private String				lblRemainHour;
	private String				lblPossible;
	private String				lblTotalRemainDays;
	private String				lblTotalRemainHour;
	private String				lblRequestDays;
	private String				lblRequestHour;
	private String				lblApprovedDays;
	private String				lblApprovedHour;
	
	private String				hidLastRemainDays;
	private String				hidLastRemainHour;
	private String				hidRemainDays;
	private String				hidRemainHour;
	private String				hidSupplyLastDays;
	private String				hidSupplyDays;
	private String				hidWasteLastDays;
	private String				hidWasteDays;
	private String				hidSupplyLastHour;
	private String				hidSupplyHour;
	private String				hidWasteLastHour;
	private String				hidWasteHour;
	
	private String				txtLastRemainDays;
	private String				txtLastRemainHour;
	private String				txtRemainDays;
	private String				txtRemainHour;
	private String				txtSupplyLastDays;
	private String				txtSupplyDays;
	private String				txtWasteLastDays;
	private String				txtWasteDays;
	private String				txtSupplyLastHour;
	private String				txtSupplyHour;
	private String				txtWasteLastHour;
	private String				txtWasteHour;
	
	private String				txtTotalRemainDays;
	private String				txtTotalRemainHour;
	private String				hidTotalRemainDays;
	private String				hidTotalRemainHour;
	
	private String				hidPossible;
	private String				txtSupplyPossible;
	private String				txtWastePossible;
	private String				txtPossible;
	
	private String[][]			aryPaidHoliday;
	
	// [h(1FXV)
	private int					mode;
	// ԒPʔNxpf
	private boolean				usePaidHolidayHour;
	
	// tB[hyѐ
	/**
	 * ЈR[h
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * IN
	 */
	public String				NAM_SELECT_YEAR_MONTH;
	/**
	 * v
	 */
	public String				NAM_TOTAL;
	/**
	 * ONx
	 */
	public String				NAM_LAST_YEAR;
	/**
	 * Nx
	 */
	public String				NAM_THIS_YEAR;
	/**
	 * ۗL
	 */
	public String				NAM_AMOUNT;
	/**
	 * t^
	 */
	public String				NAM_SUPPLY_DAYS;
	/**
	 * t^
	 */
	public String				NAM_SUPPLY_DAYS_LAST;
	/**
	 * t^
	 */
	public String				NAM_SUPPLY_DAYS_THIS;
	/**
	 * t^Ԑ
	 */
	public String				NAM_SUPPLY_HOUR;
	/**
	 * t^Ԑ
	 */
	public String				NAM_SUPPLY_HOUR_LAST;
	/**
	 * t^Ԑ
	 */
	public String				NAM_SUPPLY_HOUR_THIS;
	/**
	 * p
	 */
	public String				NAM_WASTE_DAYS;
	/**
	 * p
	 */
	public String				NAM_WASTE_DAYS_LAST;
	/**
	 * p
	 */
	public String				NAM_WASTE_DAYS_THIS;
	/**
	 * pԐ
	 */
	public String				NAM_WASTE_HOUR;
	/**
	 * pԐ
	 */
	public String				NAM_WASTE_HOUR_LAST;
	/**
	 * pԐ
	 */
	public String				NAM_WASTE_HOUR_THIS;
	/**
	 * p
	 */
	public String				NAM_USE_DAYS;
	/**
	 * p
	 */
	public String				NAM_USE_HOUR;
	/**
	 * N
	 */
	public String				NAM_YEAR_MONTH;
	/**
	 * ONxc
	 */
	public String				NAM_LAST_YEAR_REMAIN_DAYS;
	/**
	 * ONxc
	 */
	public String				NAM_LAST_YEAR_REMAIN_HOUR;
	/**
	 * Nxc
	 */
	public String				NAM_THIS_YEAR_REMAIN_DAYS;
	/**
	 * Nxc
	 */
	public String				NAM_THIS_YEAR_REMAIN_HOUR;
	/**
	 * ԒPʗp\
	 */
	public String				NAM_POSSIBLE;
	/**
	 * t^ԒPʗp\
	 */
	public String				NAM_SUPPLY_POSSIBLE;
	/**
	 * pԒPʗp\
	 */
	public String				NAM_WASTE_POSSIBLE;
	/**
	 * 
	 */
	public int					LEN_PAID_HOLIDAY;
	/**
	 * 
	 */
	public int					LEN_INTEGER;
	/**
	 * 
	 */
	public int					LEN_DECIMAL;
	

	/**
	 * 
	 */
	public PaidHolidayCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_VIEW;
		setUsePaidHolidayHour(false);
		aryPaidHoliday = StringUtil.getBlankArray(0, 0);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_PAID_HOLIDAY;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuPaidHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = "ЈR[h";
		NAM_K_NAME = "";
		NAM_SECTION = "";
		NAM_SELECT_YEAR_MONTH = "IN";
		NAM_TOTAL = "v";
		NAM_LAST_YEAR = "ONx";
		NAM_THIS_YEAR = "Nx";
		NAM_AMOUNT = "ۗL";
		NAM_SUPPLY_DAYS = "x";
		NAM_SUPPLY_DAYS_LAST = "x(ONx)";
		NAM_SUPPLY_DAYS_THIS = "x(Nx)";
		NAM_SUPPLY_HOUR = "x";
		NAM_SUPPLY_HOUR_LAST = "x(ONx)";
		NAM_SUPPLY_HOUR_THIS = "x(Nx)";
		NAM_WASTE_DAYS = "p";
		NAM_WASTE_DAYS_LAST = "p(ONx)";
		NAM_WASTE_DAYS_THIS = "p(Nx)";
		NAM_WASTE_HOUR = "p";
		NAM_WASTE_HOUR_LAST = "p(ONx)";
		NAM_WASTE_HOUR_THIS = "p(Nx)";
		NAM_USE_DAYS = "p";
		NAM_USE_HOUR = "p";
		NAM_YEAR_MONTH = "N";
		NAM_LAST_YEAR_REMAIN_DAYS = "ONxc";
		NAM_LAST_YEAR_REMAIN_HOUR = "ONxc";
		NAM_THIS_YEAR_REMAIN_DAYS = "Nxc";
		NAM_THIS_YEAR_REMAIN_HOUR = "Nxc";
		NAM_POSSIBLE = "ԒPʗp\";
		NAM_SUPPLY_POSSIBLE = "xԒPʗp\";
		NAM_WASTE_POSSIBLE = "pԒPʗp\";
		LEN_PAID_HOLIDAY = 4;
		LEN_INTEGER = 2;
		LEN_DECIMAL = 1;
	}
	
	/**
	 * 
	 */
	public void setDefaultValue() {
		txtLastRemainDays = "0.0";
		txtLastRemainHour = "0";
		txtRemainDays = "0.0";
		txtRemainHour = "0";
		txtPossible = "0";
		txtSupplyLastDays = "0.0";
		txtSupplyDays = "0.0";
		txtSupplyLastHour = "0";
		txtSupplyHour = "0";
		txtSupplyPossible = "0";
		txtWasteLastDays = "0.0";
		txtWasteDays = "0.0";
		txtWasteLastHour = "0";
		txtWasteHour = "0";
		txtWastePossible = "0";
		txtTotalRemainDays = "0.0";
		txtTotalRemainHour = "0";
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidSelectKCode = request.getParameter(PRM_HID_SELECT_K_CODE);
		hidSelectYearMonth = request.getParameter(PRM_HID_SELECT_YEAR_MONTH);
		txtSupplyLastDays = request.getParameter(PRM_TXT_SUPPLY_LAST_DAYS);
		txtSupplyLastHour = request.getParameter(PRM_TXT_SUPPLY_LAST_HOUR);
		txtSupplyDays = request.getParameter(PRM_TXT_SUPPLY_DAYS);
		txtSupplyHour = request.getParameter(PRM_TXT_SUPPLY_HOUR);
		txtSupplyPossible = request.getParameter(PRM_TXT_SUPPLY_POSSIBLE);
		txtWasteLastDays = request.getParameter(PRM_TXT_WASTE_LAST_DAYS);
		txtWasteLastHour = request.getParameter(PRM_TXT_WASTE_LAST_HOUR);
		txtWasteDays = request.getParameter(PRM_TXT_WASTE_DAYS);
		txtWasteHour = request.getParameter(PRM_TXT_WASTE_HOUR);
		txtWastePossible = request.getParameter(PRM_TXT_WASTE_POSSIBLE);
		String[] selectYearMonth = StringUtil.divideByHyphen(hidSelectYearMonth);
		hidSelectYear = selectYearMonth[0];
		hidSelectMonth = selectYearMonth[1];
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var USE_PAID_HOLIDAY_HOUR = ");
		sb.append(usePaidHolidayHour);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return aryPaidHoliday
	 */
	public String[][] getEscAryPaidHoliday() {
		return aryPaidHoliday.clone();
	}
	
	/**
	 * @param usePaidHolidayHour Zbg usePaidHolidayHour
	 */
	public void setUsePaidHolidayHour(boolean usePaidHolidayHour) {
		this.usePaidHolidayHour = usePaidHolidayHour;
	}
	
	/**
	 * @return hidSelectKCode
	 */
	public String getHidSelectKCode() {
		return hidSelectKCode;
	}
	
	/**
	 * @return hidSelectYear
	 */
	public String getHidSelectYear() {
		return hidSelectYear;
	}
	
	/**
	 * @return hidSelectMonth
	 */
	public String getHidSelectMonth() {
		return hidSelectMonth;
	}
	
	/**
	 * @return hidSelectYearMonth
	 */
	public String getHidSelectYearMonth() {
		return hidSelectYearMonth;
	}
	
	/**
	 * @return lblSelectYearMonth
	 */
	public String getLblSelectYearMonth() {
		return lblSelectYearMonth;
	}
	
	/**
	 * @return lblLastRemainDays
	 */
	public String getLblLastRemainDays() {
		return lblLastRemainDays;
	}
	
	/**
	 * @return lblLastRemainHour
	 */
	public String getLblLastRemainHour() {
		return lblLastRemainHour;
	}
	
	/**
	 * @return lblRemainDays
	 */
	public String getLblRemainDays() {
		return lblRemainDays;
	}
	
	/**
	 * @return lblRemainHour
	 */
	public String getLblRemainHour() {
		return lblRemainHour;
	}
	
	/**
	 * @return lblPossible
	 */
	public String getLblPossible() {
		return lblPossible;
	}
	
	/**
	 * @return lblTotalRemainDays
	 */
	public String getLblTotalRemainDays() {
		return lblTotalRemainDays;
	}
	
	/**
	 * @return lblRequestDays
	 */
	public String getLblRequestDays() {
		return lblRequestDays;
	}
	
	/**
	 * @return lblRequestHour
	 */
	public String getLblRequestHour() {
		return lblRequestHour;
	}
	
	/**
	 * @return lblApprovedDays
	 */
	public String getLblApprovedDays() {
		return lblApprovedDays;
	}
	
	/**
	 * @return lblApprovedHour
	 */
	public String getLblApprovedHour() {
		return lblApprovedHour;
	}
	
	/**
	 * @return hidLastRemainDays
	 */
	public String getHidLastRemainDays() {
		return hidLastRemainDays;
	}
	
	/**
	 * @return hidLastRemainHour
	 */
	public String getHidLastRemainHour() {
		return hidLastRemainHour;
	}
	
	/**
	 * @return hidRemainDays
	 */
	public String getHidRemainDays() {
		return hidRemainDays;
	}
	
	/**
	 * @return hidRemainHour
	 */
	public String getHidRemainHour() {
		return hidRemainHour;
	}
	
	/**
	 * @return hidSupplyLastDays
	 */
	public String getHidSupplyLastDays() {
		return hidSupplyLastDays;
	}
	
	/**
	 * @return hidSupplyDays
	 */
	public String getHidSupplyDays() {
		return hidSupplyDays;
	}
	
	/**
	 * @return hidWasteLastDays
	 */
	public String getHidWasteLastDays() {
		return hidWasteLastDays;
	}
	
	/**
	 * @return hidWasteDays
	 */
	public String getHidWasteDays() {
		return hidWasteDays;
	}
	
	/**
	 * @return hidSupplyLastHour
	 */
	public String getHidSupplyLastHour() {
		return hidSupplyLastHour;
	}
	
	/**
	 * @return hidSupplyHour
	 */
	public String getHidSupplyHour() {
		return hidSupplyHour;
	}
	
	/**
	 * @return hidWasteLastHour
	 */
	public String getHidWasteLastHour() {
		return hidWasteLastHour;
	}
	
	/**
	 * @return hidWasteHour
	 */
	public String getHidWasteHour() {
		return hidWasteHour;
	}
	
	/**
	 * @return txtLastRemainDays
	 */
	public String getTxtLastRemainDays() {
		return txtLastRemainDays;
	}
	
	/**
	 * @return txtLastRemainHour
	 */
	public String getTxtLastRemainHour() {
		return txtLastRemainHour;
	}
	
	/**
	 * @return txtRemainDays
	 */
	public String getTxtRemainDays() {
		return txtRemainDays;
	}
	
	/**
	 * @return txtRemainHour
	 */
	public String getTxtRemainHour() {
		return txtRemainHour;
	}
	
	/**
	 * @return txtSupplyLastDays
	 */
	public String getTxtSupplyLastDays() {
		return txtSupplyLastDays;
	}
	
	/**
	 * @return txtSupplyDays
	 */
	public String getTxtSupplyDays() {
		return txtSupplyDays;
	}
	
	/**
	 * @return txtWasteLastDays
	 */
	public String getTxtWasteLastDays() {
		return txtWasteLastDays;
	}
	
	/**
	 * @return txtWasteDays
	 */
	public String getTxtWasteDays() {
		return txtWasteDays;
	}
	
	/**
	 * @return txtSupplyLastHour
	 */
	public String getTxtSupplyLastHour() {
		return txtSupplyLastHour;
	}
	
	/**
	 * @return txtSupplyHour
	 */
	public String getTxtSupplyHour() {
		return txtSupplyHour;
	}
	
	/**
	 * @return txtWasteLastHour
	 */
	public String getTxtWasteLastHour() {
		return txtWasteLastHour;
	}
	
	/**
	 * @return txtWasteHour
	 */
	public String getTxtWasteHour() {
		return txtWasteHour;
	}
	
	/**
	 * @return txtTotalRemainDays
	 */
	public String getTxtTotalRemainDays() {
		return txtTotalRemainDays;
	}
	
	/**
	 * @return txtTotalRemainHour
	 */
	public String getTxtTotalRemainHour() {
		return txtTotalRemainHour;
	}
	
	/**
	 * @return hidTotalRemainDays
	 */
	public String getHidTotalRemainDays() {
		return hidTotalRemainDays;
	}
	
	/**
	 * @return hidTotalRemainHour
	 */
	public String getHidTotalRemainHour() {
		return hidTotalRemainHour;
	}
	
	/**
	 * @return hidPossible
	 */
	public String getHidPossible() {
		return hidPossible;
	}
	
	/**
	 * @return txtSupplyPossible
	 */
	public String getTxtSupplyPossible() {
		return txtSupplyPossible;
	}
	
	/**
	 * @return txtWastePossible
	 */
	public String getTxtWastePossible() {
		return txtWastePossible;
	}
	
	/**
	 * @return txtPossible
	 */
	public String getTxtPossible() {
		return txtPossible;
	}
	
	/**
	 * @return aryPaidHoliday
	 */
	public String[][] getAryPaidHoliday() {
		return aryPaidHoliday.clone();
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @return usePaidHolidayHour
	 */
	public boolean isUsePaidHolidayHour() {
		return usePaidHolidayHour;
	}
	
	/**
	 * @param hidSelectKCode Zbg hidSelectKCode
	 */
	public void setHidSelectKCode(String hidSelectKCode) {
		this.hidSelectKCode = hidSelectKCode;
	}
	
	/**
	 * @param hidSelectYear Zbg hidSelectYear
	 */
	public void setHidSelectYear(String hidSelectYear) {
		this.hidSelectYear = hidSelectYear;
	}
	
	/**
	 * @param hidSelectMonth Zbg hidSelectMonth
	 */
	public void setHidSelectMonth(String hidSelectMonth) {
		this.hidSelectMonth = hidSelectMonth;
	}
	
	/**
	 * @param hidSelectYearMonth Zbg hidSelectYearMonth
	 */
	public void setHidSelectYearMonth(String hidSelectYearMonth) {
		this.hidSelectYearMonth = hidSelectYearMonth;
	}
	
	/**
	 * @param lblSelectYearMonth Zbg lblSelectYearMonth
	 */
	public void setLblSelectYearMonth(String lblSelectYearMonth) {
		this.lblSelectYearMonth = lblSelectYearMonth;
	}
	
	/**
	 * @param lblLastRemainDays Zbg lblLastRemainDays
	 */
	public void setLblLastRemainDays(String lblLastRemainDays) {
		this.lblLastRemainDays = lblLastRemainDays;
	}
	
	/**
	 * @param lblLastRemainHour Zbg lblLastRemainHour
	 */
	public void setLblLastRemainHour(String lblLastRemainHour) {
		this.lblLastRemainHour = lblLastRemainHour;
	}
	
	/**
	 * @param lblRemainDays Zbg lblRemainDays
	 */
	public void setLblRemainDays(String lblRemainDays) {
		this.lblRemainDays = lblRemainDays;
	}
	
	/**
	 * @param lblRemainHour Zbg lblRemainHour
	 */
	public void setLblRemainHour(String lblRemainHour) {
		this.lblRemainHour = lblRemainHour;
	}
	
	/**
	 * @param lblPossible Zbg lblPossible
	 */
	public void setLblPossible(String lblPossible) {
		this.lblPossible = lblPossible;
	}
	
	/**
	 * @param lblTotalRemainDays Zbg lblTotalRemainDays
	 */
	public void setLblTotalRemainDays(String lblTotalRemainDays) {
		this.lblTotalRemainDays = lblTotalRemainDays;
	}
	
	/**
	 * @param lblRequestDays Zbg lblRequestDays
	 */
	public void setLblRequestDays(String lblRequestDays) {
		this.lblRequestDays = lblRequestDays;
	}
	
	/**
	 * @param lblRequestHour Zbg lblRequestHour
	 */
	public void setLblRequestHour(String lblRequestHour) {
		this.lblRequestHour = lblRequestHour;
	}
	
	/**
	 * @param lblApprovedDays Zbg lblApprovedDays
	 */
	public void setLblApprovedDays(String lblApprovedDays) {
		this.lblApprovedDays = lblApprovedDays;
	}
	
	/**
	 * @param lblApprovedHour Zbg lblApprovedHour
	 */
	public void setLblApprovedHour(String lblApprovedHour) {
		this.lblApprovedHour = lblApprovedHour;
	}
	
	/**
	 * @param hidLastRemainDays Zbg hidLastRemainDays
	 */
	public void setHidLastRemainDays(String hidLastRemainDays) {
		this.hidLastRemainDays = hidLastRemainDays;
	}
	
	/**
	 * @param hidLastRemainHour Zbg hidLastRemainHour
	 */
	public void setHidLastRemainHour(String hidLastRemainHour) {
		this.hidLastRemainHour = hidLastRemainHour;
	}
	
	/**
	 * @param hidRemainDays Zbg hidRemainDays
	 */
	public void setHidRemainDays(String hidRemainDays) {
		this.hidRemainDays = hidRemainDays;
	}
	
	/**
	 * @param hidRemainHour Zbg hidRemainHour
	 */
	public void setHidRemainHour(String hidRemainHour) {
		this.hidRemainHour = hidRemainHour;
	}
	
	/**
	 * @param hidSupplyLastDays Zbg hidSupplyLastDays
	 */
	public void setHidSupplyLastDays(String hidSupplyLastDays) {
		this.hidSupplyLastDays = hidSupplyLastDays;
	}
	
	/**
	 * @param hidSupplyDays Zbg hidSupplyDays
	 */
	public void setHidSupplyDays(String hidSupplyDays) {
		this.hidSupplyDays = hidSupplyDays;
	}
	
	/**
	 * @param hidWasteLastDays Zbg hidWasteLastDays
	 */
	public void setHidWasteLastDays(String hidWasteLastDays) {
		this.hidWasteLastDays = hidWasteLastDays;
	}
	
	/**
	 * @param hidWasteDays Zbg hidWasteDays
	 */
	public void setHidWasteDays(String hidWasteDays) {
		this.hidWasteDays = hidWasteDays;
	}
	
	/**
	 * @param hidSupplyLastHour Zbg hidSupplyLastHour
	 */
	public void setHidSupplyLastHour(String hidSupplyLastHour) {
		this.hidSupplyLastHour = hidSupplyLastHour;
	}
	
	/**
	 * @param hidSupplyHour Zbg hidSupplyHour
	 */
	public void setHidSupplyHour(String hidSupplyHour) {
		this.hidSupplyHour = hidSupplyHour;
	}
	
	/**
	 * @param hidWasteLastHour Zbg hidWasteLastHour
	 */
	public void setHidWasteLastHour(String hidWasteLastHour) {
		this.hidWasteLastHour = hidWasteLastHour;
	}
	
	/**
	 * @param hidWasteHour Zbg hidWasteHour
	 */
	public void setHidWasteHour(String hidWasteHour) {
		this.hidWasteHour = hidWasteHour;
	}
	
	/**
	 * @param txtLastRemainDays Zbg txtLastRemainDays
	 */
	public void setTxtLastRemainDays(String txtLastRemainDays) {
		this.txtLastRemainDays = txtLastRemainDays;
	}
	
	/**
	 * @param txtLastRemainHour Zbg txtLastRemainHour
	 */
	public void setTxtLastRemainHour(String txtLastRemainHour) {
		this.txtLastRemainHour = txtLastRemainHour;
	}
	
	/**
	 * @param txtRemainDays Zbg txtRemainDays
	 */
	public void setTxtRemainDays(String txtRemainDays) {
		this.txtRemainDays = txtRemainDays;
	}
	
	/**
	 * @param txtRemainHour Zbg txtRemainHour
	 */
	public void setTxtRemainHour(String txtRemainHour) {
		this.txtRemainHour = txtRemainHour;
	}
	
	/**
	 * @param txtSupplyLastDays Zbg txtSupplyLastDays
	 */
	public void setTxtSupplyLastDays(String txtSupplyLastDays) {
		this.txtSupplyLastDays = txtSupplyLastDays;
	}
	
	/**
	 * @param txtSupplyDays Zbg txtSupplyDays
	 */
	public void setTxtSupplyDays(String txtSupplyDays) {
		this.txtSupplyDays = txtSupplyDays;
	}
	
	/**
	 * @param txtWasteLastDays Zbg txtWasteLastDays
	 */
	public void setTxtWasteLastDays(String txtWasteLastDays) {
		this.txtWasteLastDays = txtWasteLastDays;
	}
	
	/**
	 * @param txtWasteDays Zbg txtWasteDays
	 */
	public void setTxtWasteDays(String txtWasteDays) {
		this.txtWasteDays = txtWasteDays;
	}
	
	/**
	 * @param txtSupplyLastHour Zbg txtSupplyLastHour
	 */
	public void setTxtSupplyLastHour(String txtSupplyLastHour) {
		this.txtSupplyLastHour = txtSupplyLastHour;
	}
	
	/**
	 * @param txtSupplyHour Zbg txtSupplyHour
	 */
	public void setTxtSupplyHour(String txtSupplyHour) {
		this.txtSupplyHour = txtSupplyHour;
	}
	
	/**
	 * @param txtWasteLastHour Zbg txtWasteLastHour
	 */
	public void setTxtWasteLastHour(String txtWasteLastHour) {
		this.txtWasteLastHour = txtWasteLastHour;
	}
	
	/**
	 * @param txtWasteHour Zbg txtWasteHour
	 */
	public void setTxtWasteHour(String txtWasteHour) {
		this.txtWasteHour = txtWasteHour;
	}
	
	/**
	 * @param txtTotalRemainDays Zbg txtTotalRemainDays
	 */
	public void setTxtTotalRemainDays(String txtTotalRemainDays) {
		this.txtTotalRemainDays = txtTotalRemainDays;
	}
	
	/**
	 * @param txtTotalRemainHour Zbg txtTotalRemainHour
	 */
	public void setTxtTotalRemainHour(String txtTotalRemainHour) {
		this.txtTotalRemainHour = txtTotalRemainHour;
	}
	
	/**
	 * @param hidTotalRemainDays Zbg hidTotalRemainDays
	 */
	public void setHidTotalRemainDays(String hidTotalRemainDays) {
		this.hidTotalRemainDays = hidTotalRemainDays;
	}
	
	/**
	 * @param hidTotalRemainHour Zbg hidTotalRemainHour
	 */
	public void setHidTotalRemainHour(String hidTotalRemainHour) {
		this.hidTotalRemainHour = hidTotalRemainHour;
	}
	
	/**
	 * @param aryPaidHoliday Zbg aryPaidHoliday
	 */
	public void setAryPaidHoliday(String[][] aryPaidHoliday) {
		this.aryPaidHoliday = aryPaidHoliday.clone();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param lblTotalRemainHour Zbg lblTotalRemainHour
	 */
	public void setLblTotalRemainHour(String lblTotalRemainHour) {
		this.lblTotalRemainHour = lblTotalRemainHour;
	}
	
	/**
	 * @return lblTotalRemainHour
	 */
	public String getLblTotalRemainHour() {
		return lblTotalRemainHour;
	}
	
	/**
	 * @param hidPossible Zbg hidPossible
	 */
	public void setHidPossible(String hidPossible) {
		this.hidPossible = hidPossible;
	}
	
	/**
	 * @param txtSupplyPossible Zbg txtSupplyPossible
	 */
	public void setTxtSupplyPossible(String txtSupplyPossible) {
		this.txtSupplyPossible = txtSupplyPossible;
	}
	
	/**
	 * @param txtWastePossible Zbg txtWastePossible
	 */
	public void setTxtWastePossible(String txtWastePossible) {
		this.txtWastePossible = txtWastePossible;
	}
	
	/**
	 * @param txtPossible Zbg txtPossible
	 */
	public void setTxtPossible(String txtPossible) {
		this.txtPossible = txtPossible;
	}
	
}
