/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.dao.MYukyuDao;
import jp.mosp.kintai.dto.MYukyuDto;
import jp.mosp.kintai.payroll.vo.PaidHolidayOldCardVo;

/**
 * @author yoshida
 *
 */
public class PaidHolidayOldCardAction extends KintaiCommonAction {
	
	// R}h
	/**
	 * P1118
	 */
	public static final String	CMD_CARD_SELECT	= "P1118";	// \
	private static final String	CMD_CARD_UPDATE	= "P1119";	// XV
															
	
	/**
	 * RXgN^
	 */
	public PaidHolidayOldCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CARD_SELECT)) {
			// \
			select();
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PaidHolidayOldCardVo();
	}
	
	@Override
	protected void select() throws Exception {
		PaidHolidayOldCardVo vo = (PaidHolidayOldCardVo)getVo();
		// ΏێЈݒ
		vo.setHidSelectKCode(key1);
		// Ώ۔N
		vo.setHidSelectYearMonth(key2);
		String[] selectYearMonth = StringUtil.divideByHyphen(vo.getHidSelectYearMonth());
		vo.setHidSelectYear(selectYearMonth[0]);
		vo.setHidSelectMonth(selectYearMonth[1]);
		// Lx̕\
		setPaidHolidayInfo();
	}
	
	@Override
	protected void update() throws Exception {
		PaidHolidayOldCardVo vo = (PaidHolidayOldCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		int iCalcPayment = DateUtil.convDateToInteger(getCalcPayment(DateUtil.getYearMonth(vo.getHidSelectYear(), vo
			.getHidSelectMonth())));
		// ^vZΏ۔N擾
		//String targetDate = DateUtil.convDateToString(getCalcPayment());
		// o^
		// DAO
		MYukyuDao dao = part().paidHoliday().getMYukyuDao();
		// DTȌ
		MYukyuDto dto = new MYukyuDto();
		// Lx擾
		MYukyuDto currentDto = dao.findForUpdate(vo.getHidSelectKCode(), iCalcPayment);
		// Lx̌vZ
		calcPaidHoliday();
		if (!chkExistDto(currentDto)) {
			// Lxo^
			dto.setKCode(vo.getHidSelectKCode());
			dto.setKyuyoYMD(iCalcPayment);
			dto.setSyutoku(Integer.parseInt(vo.getHidSupply()));
			dto.setHaiki(Double.parseDouble(vo.getHidWaste()));
			dto.setTZanT(Double.parseDouble(vo.getHidThisRemain()));
			dto.setTZanZ(Double.parseDouble(vo.getHidLastRemain()));
			dao.insert(dto);
		} else {
			// LxXV
			dto = currentDto;
			dto.setSyutoku(Integer.parseInt(vo.getHidSupply()));
			dto.setHaiki(Double.parseDouble(vo.getHidWaste()));
			dto.setTZanT(Double.parseDouble(vo.getHidThisRemain()));
			dto.setTZanZ(Double.parseDouble(vo.getHidLastRemain()));
			dao.update(dto);
		}
		// Ď擾
		chkUpdate(part().paidHoliday().getYukyuInfo(dto.getKCode(), String.valueOf(dto.getKyuyoYMD())));
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// Lx̕\
		setPaidHolidayInfo();
	}
	
	/**
	 * Lx̕\
	 * @throws Exception  	Oꍇ
	 */
	private void setPaidHolidayInfo() throws Exception {
		PaidHolidayOldCardVo vo = (PaidHolidayOldCardVo)getVo();
		vo.setDefaultValues();
		String kCode = vo.getHidSelectKCode();
		// I̐ݒ
		setLabelBasisInfo(part().human().getBasisInfo(kCode));
		// ΏۏWvN
		Date targetMonth = DateUtil.getYearMonth(vo.getHidSelectYear(), vo.getHidSelectMonth());
		vo.setLblSelectYearMonth(DateUtil.convDateToJPYearMonthShort(targetMonth));
		Date calcMonth = getCalcPayment(targetMonth);
		// Ώ۔N̗L擾
		MYukyuDto currentDto = part().paidHoliday().getYukyuInfo(kCode, calcMonth);
		// Lx̃`FbN
		if (VariousUtil.isNull(currentDto)) {
			// Ώ۔N̑O擾
			currentDto = part().paidHoliday().getYukyuInfo(kCode, DateUtil.addMonth(calcMonth, -1));
		}
		if (VariousUtil.isNull(currentDto)) {
			currentDto = new MYukyuDto();
		}
		// VOɏݒ
		if (VariousUtil.isNotNull(currentDto)) {
			vo.setFields(currentDto);
		}
		// Lx񃊃Xg̎擾
		vo.initListInfo();
		vo.setFields(part().paidHoliday().getMYukyuDao().findForList(kCode, DateUtil.convDateToString(calcMonth)));
		// [hݒ
		vo.setMode(PaidHolidayOldCardVo.MODE_UPDATE);
	}
	
	/**
	 * LxvZ
	 * @throws Exception  	Oꍇ
	 */
	private void calcPaidHoliday() throws Exception {
		PaidHolidayOldCardVo vo = (PaidHolidayOldCardVo)getVo();
		// ΏۓۗLONiύXj= ۗLONiύXOj + t^iONj- piONj
		double lastReamin = Double.parseDouble(vo.getHidLastRemain()) + Double.parseDouble(vo.getTxtLastSupply())
				- Double.parseDouble(vo.getTxtLastWaste());
		// pۗLA0ɖ߂B
		if (lastReamin < 0) {
			double resultLastRemain = Double.parseDouble(vo.getTxtLastWaste()) + lastReamin;
			vo.setTxtLastWaste(String.valueOf(resultLastRemain));
			vo.setHidLastRemain(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		} else {
			vo.setHidLastRemain(String.valueOf(lastReamin));
		}
		// ΏۓۗLNiύXj= ۗLNiύXOj + t^iONj- piONj
		double thisRemain = Double.parseDouble(vo.getHidThisRemain()) + Double.parseDouble(vo.getTxtThisSupply())
				- Double.parseDouble(vo.getTxtThisWaste());
		// pۗLA0ɖ߂B
		if (thisRemain < 0) {
			double resultThisRemain = Double.parseDouble(vo.getTxtThisWaste()) + thisRemain;
			vo.setTxtThisWaste(String.valueOf(resultThisRemain));
			vo.setHidThisRemain(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		} else {
			vo.setHidThisRemain(String.valueOf(thisRemain));
		}
		// p = piNj+ piONj
		double dispose = Double.parseDouble(vo.getHidWaste()) + Double.parseDouble(vo.getTxtThisWaste())
				+ Double.parseDouble(vo.getTxtLastWaste());
		vo.setHidWaste(String.valueOf(dispose));
		// 擾 = 擾iNj+ 擾iONj
		int supply = Integer.parseInt(vo.getHidSupply()) + Integer.parseInt(vo.getTxtThisSupply())
				+ Integer.parseInt(vo.getTxtLastSupply());
		vo.setHidSupply(String.valueOf(supply));
	}
	
}
