/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.CsvUtil;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.dto.MYukyuDto;
import jp.mosp.kintai.payroll.dao.KdPaidHolidayDao;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.kintai.payroll.vo.PaidHolidayImportCardVo;

/**
 * @author nakamura
 *
 */
public class PaidHolidayImportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SHOW	= "P1120";
	private static final String	CMD_UPLOAD	= "P1121";
	private static final String	CMD_IMPORT	= "P1122";
	private static final String	CMD_REPORT	= "P1123";
	
	private StringBuffer		errMessage;
	// t@CdmFp
	private HashSet<String>		hashSet;
	// G[
	private int					errorCount;
	// \pz
	private List<String[]>		viewList;
	// G[|[g
	private StringBuffer		errorReport;
	

	/**
	 * RXgN^[
	 */
	public PaidHolidayImportCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo();
		// 
		init();
		// R}h̏
		if (CMD_SHOW.equals(cmd)) {
			// \
			show();
		} else if (CMD_UPLOAD.equals(cmd)) {
			// Abv[h
			upload();
		} else if (CMD_IMPORT.equals(cmd)) {
			// o^
			insert();
		} else if (CMD_REPORT.equals(cmd)) {
			// G[o
			report();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PaidHolidayImportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		getConnection();
	}
	
	@Override
	protected void show() throws Exception {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		vo.setMode(PaidHolidayImportCardVo.MODE_VIEW);
	}
	
	/**
	 * Abv[h
	 * @throws Exception 	Oꍇ
	 */
	private void upload() throws Exception {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		// t@Cݒ
		vo.setFilUploadFile(multipartFieldList);
		// Abv[ht@C
		String uploadFileName = vo.getFilUploadFile().getName();
		// LxɏC|[gp̃Xg
		List<MYukyuDto> oldImportList = new ArrayList<MYukyuDto>();
		// VLxɏC|[gp̃Xg
		List<KdPaidHolidayDto> newImportList = new ArrayList<KdPaidHolidayDto>();
		// t@CdmFp
		hashSet = new HashSet<String>();
		// \pz
		viewList = new ArrayList<String[]>();
		// G[
		errorCount = 0;
		// G[|[g
		errorReport = new StringBuffer();
		// csvt@C
		if (uploadFileName.matches(".*" + ".csv" + ".*")) {
			String[][] aryAllValues = CsvUtil.getAllValues(getUploadFile(vo.getFilUploadFile()));
			String[] oldTableHeader = part().paidHoliday().getOldPaidHolidayCsvHeader();
			String[] newTableHeader = part().paidHoliday().getNewPaidHolidayCsvHeader();
			int i = 0;
			for (String[] aryValue : aryAllValues) {
				// G[e
				errMessage = new StringBuffer();
				// wb_[
				if (i == 0) {
					if (StringUtil.checkArraysEquals(aryValue, oldTableHeader)) {
						vo.setTable(PaidHolidayImportCardVo.TABLE_OLD);
					} else if (StringUtil.checkArraysEquals(aryValue, newTableHeader)) {
						vo.setTable(PaidHolidayImportCardVo.TABLE_NEW);
					} else {
						// G[bZ[W̕\
						addErrMessage(getMessage(CommonConst.MSG_INVALID_HEAD_TYPE, ""));
						break;
					}
				} else {
					if (vo.getTable() == PaidHolidayImportCardVo.TABLE_OLD) {
						if (aryValue.length >= oldTableHeader.length) {
							// LxɃe[u
							convDataToOldInfo(aryValue, oldTableHeader, i, oldImportList);
						} else {
							// G[bZ[W̕\
							addCsvErrMessage("WC0013", String.valueOf(i));
							addErrorReport(oldTableHeader, aryValue);
						}
					} else if (vo.getTable() == PaidHolidayImportCardVo.TABLE_NEW) {
						if (aryValue.length >= newTableHeader.length - 4) {
							// VLxɃe[u
							convDataToNewInfo(aryValue, newTableHeader, i, newImportList);
						} else {
							// G[bZ[W̕\
							addCsvErrMessage("WC0013", String.valueOf(i));
							addErrorReport(newTableHeader, aryValue);
						}
					}
				}
				i++;
			}
		} else {
			addErrMessage(getMessage(CommonConst.MSG_NO_CSV_DATA, ""));
		}
		// [h̐ݒ
		vo.setMode(PaidHolidayImportCardVo.MODE_VIEW);
		if (vo.getTable() == PaidHolidayImportCardVo.TABLE_OLD) {
			// C|[gXgZbg
			vo.setOldImportList(oldImportList);
			// bZ[W̕\
			setMessage(getMessage("IC0005", String.valueOf(oldImportList.size())));
			// \pJ̐ݒ
			setOldColumnName();
		} else if (vo.getTable() == PaidHolidayImportCardVo.TABLE_NEW) {
			// C|[gXgZbg
			vo.setNewImportList(newImportList);
			// bZ[W̕\
			setMessage(getMessage("IC0005", String.valueOf(newImportList.size())));
			// \pJ̐ݒ
			setNewColumnName();
		}
		if (oldImportList.size() != 0 || newImportList.size() != 0) {
			// [h̐ݒ
			vo.setMode(PaidHolidayImportCardVo.MODE_UPLOAD);
		}
		if (errorCount > 0) {
			// C|[głȂG[̏ڍׂZbg
			vo.setErrorReport(errorReport);
			// G[bZ[W
			StringBuffer sb = new StringBuffer();
			sb.append(errorCount);
			sb.append("̃f[^");
			addErrMessage(getMessage(CommonConst.MSG_NO_UPLOAD_KEY, sb.toString()));
			// [h̐ݒ
			vo.setMode(PaidHolidayImportCardVo.MODE_REPORT);
		}
		// VOփZbg
		vo.setFields(viewList);
		vo.initListInfo();
	}
	
	@Override
	protected void insert() throws Exception {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		// [h̐ݒ
		vo.setMode(PaidHolidayImportCardVo.MODE_VIEW);
		// G[̂s
		HashSet<Integer> errSet = new HashSet<Integer>();
		if (vo.getTable() == PaidHolidayImportCardVo.TABLE_OLD) {
			if (VariousUtil.isNotNull(vo.getOldImportList())) {
				List<MYukyuDto> oldImportList = vo.getOldImportList();
				int i = 0;
				for (MYukyuDto dto : oldImportList) {
					// Ј̑݊mF
					if (VariousUtil.isNull(part().human().getBasisInfo(dto.getKCode()))) {
						// G[bZ[W̕\
						addErrMessage(getMessage("IC0006", String.valueOf(i)));
						errSet.add(i);
					}
					// f[^̏dmF
					if (VariousUtil.isNotNull(part().paidHoliday().getYukyuInfo(dto.getKCode(), dto.getKyuyoYMD()))) {
						// G[bZ[W̕\
						addErrMessage(getMessage("WC1023", ""));
						errSet.add(i);
					}
					i++;
				}
				if (errSet.size() == 0) {
					// o^
					int count = part().paidHoliday().getMYukyuDao()
						.insert(oldImportList, CommonConst.NUM_DIVIDE_NUMBER);
					// R~bg
					commit();
					// bZ[W̕\
					setMessage(getMessage("IC0014", String.valueOf(count)));
				}
			} else {
				// G[bZ[W̕\
				addErrMessage(getMessage("WC0018", ""));
			}
		} else if (vo.getTable() == PaidHolidayImportCardVo.TABLE_NEW) {
			if (VariousUtil.isNotNull(vo.getNewImportList())) {
				List<KdPaidHolidayDto> newImportList = vo.getNewImportList();
				// DAȌ
				KdPaidHolidayDao dao = part().paidHoliday().getPaidHolidayDao();
				int i = 0;
				for (KdPaidHolidayDto dto : newImportList) {
					// Ј̑݊mF
					if (VariousUtil.isNull(part().human().getBasisInfo(dto.getKCode()))) {
						// G[bZ[W̕\
						addErrMessage(getMessage("IC0006", String.valueOf(i)));
						errSet.add(i);
					}
					if (VariousUtil.isNotNull(dao.findForKey(dto.getPaidId(), dto.getKCode()))) {
						// G[bZ[W̕\
						addErrMessage(getMessage("WC1023", ""));
						errSet.add(i);
					}
					i++;
				}
				if (errSet.size() == 0) {
					// o^
					int count = dao.insert(newImportList, CommonConst.NUM_DIVIDE_NUMBER);
					// R~bg
					commit();
					// bZ[W̕\
					setMessage(getMessage("IC0014", String.valueOf(count)));
				}
			} else {
				// G[bZ[W̕\
				addErrMessage(getMessage("WC0018", ""));
			}
		}
	}
	
	/**
	 * |[go
	 */
	private void report() {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		if (vo.getTable() == PaidHolidayImportCardVo.TABLE_OLD) {
			// o̓t@C
			request.setAttribute(MospConst.ATT_FILE_NAME, "MYukyuImportError.csv");
		} else if (vo.getTable() == PaidHolidayImportCardVo.TABLE_NEW) {
			// o̓t@C
			request.setAttribute(MospConst.ATT_FILE_NAME, "PaidHolidayImportError.csv");
		}
		// o͓e
		request.setAttribute(MospConst.ATT_FILE_OBJECT, vo.getErrorReport());
		// V[PXԕsvݒ
		setNeedProcSeq(false);
	}
	
	/**
	 * @param aryValue f[^z
	 * @param aryHeader wb_[z
	 * @param i CfbNX
	 * @param oldImportList LxɏC|[gp̃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void convDataToOldInfo(String[] aryValue, String[] aryHeader, int i, List<MYukyuDto> oldImportList)
			throws Exception {
		// ЈR[h
		String kCode = aryValue[0];
		// ^vZN
		int kyuyoYMD = 0;
		// Oc(N)
		double zZanT = 0;
		// Oc(ON)
		double zZanZ = 0;
		// gp
		double syoka = 0;
		// 擾
		int syutoku = 0;
		// p
		double haiki = 0;
		// c(N)
		double tZanT = 0;
		// c(ON)
		double tZanZ = 0;
		try {
			// ڒmF
			checkLength(aryValue[0], aryHeader[0], CommonConst.LEN_K_CODE);
			checkLength(aryValue[1], aryHeader[1], CommonConst.LEN_KYUYO_YMD);
			checkLength(aryValue[5], aryHeader[5], CommonConst.LEN_SYUTOKU);
			// ݊mF
			checkAvailableUser(kCode, i);
			// t̕ϊ
			Date kyuyoDate = checkTargetDate(aryValue[1], aryHeader[1]);
			if (VariousUtil.isNotNull(kyuyoDate)) {
				kyuyoYMD = DateUtil.convDateToInteger(kyuyoDate);
			}
			// lmF
			if (checkPaidHolidayValue(aryValue[2], aryHeader[2])) {
				zZanT = Double.parseDouble(aryValue[2]);
			}
			if (checkPaidHolidayValue(aryValue[3], aryHeader[3])) {
				zZanZ = Double.parseDouble(aryValue[3]);
			}
			if (checkPaidHolidayValue(aryValue[4], aryHeader[4])) {
				syoka = Double.parseDouble(aryValue[4]);
			}
			if (checkNumber(aryValue[5], aryHeader[5])) {
				syutoku = Integer.parseInt(aryValue[5]);
			}
			if (checkPaidHolidayValue(aryValue[6], aryHeader[6])) {
				haiki = Double.parseDouble(aryValue[6]);
			}
			if (checkPaidHolidayValue(aryValue[7], aryHeader[7])) {
				tZanT = Double.parseDouble(aryValue[7]);
			}
			if (checkPaidHolidayValue(aryValue[8], aryHeader[8])) {
				tZanZ = Double.parseDouble(aryValue[8]);
			}
		} catch (NumberFormatException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (NullPointerException e) {
			// G[ꗗ֒ǉ			
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (MospException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC1023", "");
		}
		if (kyuyoYMD > 0) {
			// t@CdmF
			String hashCode = StringUtil.combineByComma(kCode, String.valueOf(kyuyoYMD));
			if (!hashSet.contains(hashCode)) {
				hashSet.add(hashCode);
			} else {
				// t@CdG[bZ[W
				addCsvErrMessage("WC0027", "");
			}
			// f[^dmF
			if (VariousUtil.isNotNull(part().paidHoliday().getYukyuInfo(kCode, kyuyoYMD))) {
				// G[ꗗ֒ǉ
				addCsvErrMessage("WC1023", "");
			}
		}
		if (errMessage.length() == 0) {
			// C|[gpXg֒ǉ
			oldImportList.add(PaidHolidayPart.createMYukyuDto(kCode, kyuyoYMD, zZanT, zZanZ, syoka, syutoku, haiki,
					tZanT, tZanZ));
			// \pXg֒ǉ
			viewList.add(aryValue);
		} else {
			// G[ꗗ֒ǉ
			addErrorReport(aryHeader, aryValue);
		}
	}
	
	/**
	 * @param aryValue f[^z
	 * @param aryHeader wb_[z
	 * @param i CfbNX
	 * @param newImportList VLxɏC|[gp̃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void convDataToNewInfo(String[] aryValue, String[] aryHeader, int i, List<KdPaidHolidayDto> newImportList)
			throws Exception {
		// LxID
		long paidHolidayId = 0;
		// ЈR[h
		String kCode = aryValue[1];
		// R[h
		String processType = aryValue[2];
		// 
		Date processDate = null;
		// ONxc
		double lastRemainDays = 0;
		// ONxc
		int lastRemainHour = 0;
		// Nxc
		double remainDays = 0;
		// Nxc
		int remainHour = 0;
		// ԒPʎ擾\
		int possible = 0;
		// 폜tO
		int deleteFlag = 0;
		try {
			// ڒmF
			checkLength(aryValue[0], aryHeader[0], CommonConst.LEN_PAID_HOLIDAY_ID);
			checkLength(aryValue[1], aryHeader[1], CommonConst.LEN_K_CODE);
			checkLength(aryValue[2], aryHeader[2], CommonConst.LEN_PROCESS_TYPE);
			checkLength(aryValue[3], aryHeader[3], CommonConst.LEN_PROCESS_DATE);
			checkLength(aryValue[5], aryHeader[5], CommonConst.LEN_LAST_REMAIN_HOUR);
			checkLength(aryValue[7], aryHeader[7], CommonConst.LEN_REMAIN_HOUR);
			checkLength(aryValue[8], aryHeader[8], CommonConst.LEN_POSSIBLE);
			checkLength(aryValue[9], aryHeader[9], CommonConst.LEN_FLAG);
			// ݊mF
			checkAvailableUser(kCode, i);
			// R[hmF
			checkProcessCode(processType, aryHeader[2]);
			// t̕ϊ
			processDate = checkTargetDate(aryValue[3], aryHeader[3]);
			// lmF
			if (checkNumber(aryValue[0], aryHeader[0])) {
				paidHolidayId = Long.parseLong(aryValue[0]);
			}
			if (checkPaidHolidayValue(aryValue[4], aryHeader[4])) {
				lastRemainDays = Double.parseDouble(aryValue[4]);
			}
			if (checkNumber(aryValue[5], aryHeader[5])) {
				lastRemainHour = Integer.parseInt(aryValue[5]);
			}
			if (checkPaidHolidayValue(aryValue[6], aryHeader[6])) {
				remainDays = Double.parseDouble(aryValue[6]);
			}
			if (checkNumber(aryValue[7], aryHeader[7])) {
				remainHour = Integer.parseInt(aryValue[7]);
			}
			if (checkNumber(aryValue[8], aryHeader[8])) {
				possible = Integer.parseInt(aryValue[8]);
			}
			if (checkNumber(aryValue[9], aryHeader[9])) {
				deleteFlag = Integer.parseInt(aryValue[9]);
			}
		} catch (NumberFormatException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (NullPointerException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage(CommonConst.MSG_INVALID_DATA_TYPE, String.valueOf(i));
		} catch (MospException e) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC1023", "");
		}
		// t@CdmF
		String hashCode = StringUtil.combineByComma(String.valueOf(paidHolidayId), kCode);
		if (!hashSet.contains(hashCode)) {
			hashSet.add(hashCode);
		} else {
			// t@CdG[bZ[W
			addCsvErrMessage("WC0027", "");
		}
		// f[^dmF
		if (VariousUtil.isNotNull(part().paidHoliday().getPaidHolidayDao().findForKey(paidHolidayId, kCode))) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC1023", "");
		}
		if (errMessage.length() == 0) {
			// C|[gpXg֒ǉ
			newImportList.add(PaidHolidayPart.createKdPaidHolidayDto(paidHolidayId, kCode, processType, processDate,
					lastRemainDays, lastRemainHour, remainDays, remainHour, possible, deleteFlag));
			// \pXg֒ǉ
			viewList.add(aryValue);
		} else {
			// G[ꗗ֒ǉ
			addErrorReport(aryHeader, aryValue);
		}
	}
	
	/**
	 * tϊ
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @return ϊt
	 * @throws MospException 	MosPOꍇ
	 */
	private Date checkTargetDate(String value, String header) throws MospException {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		Date date = null;
		// yyyy/mm/ddłꍇ
		date = DateUtil.convStringDateToDate(value);
		if (VariousUtil.isNull(date)) {
			// yyyy-mm-ddłꍇ
			date = DateUtil.convHyphenDateToDate(value);
			if (VariousUtil.isNull(date)) {
				// yyyymmddłꍇ
				if (value.length() < 9) {
					date = DateUtil.convStringBaseDateToDate(value);
					// tmF(JzĂꍇG[)
					if (!String.valueOf(DateUtil.convDateToInteger(date)).equals(value)) {
						// G[ꗗ֒ǉ
						addCsvErrMessage("WC0006", header);
					}
				}
			}
		}
		if (VariousUtil.isNotNull(date)) {
			if (!ValidateUtility.chkDate(MospUtility.getYear(date), MospUtility.getMonth(date) - 1, MospUtility
				.getDay(date))) {
				// G[ꗗ֒ǉ
				addCsvErrMessage("WC0006", header);
			}
			if (vo.getTable() == PaidHolidayImportCardVo.TABLE_OLD) {
				// J@{s̏ꍇ
				if (MosPCodePart.afterLegalReformDate(date)) {
					// G[ꗗ֒ǉ
					addCsvErrMessage("WC0028", StringUtil.combineByComma(header, DateUtil
						.convDateToFormatDateJPShort(DateUtil.getLegalReformDate())));
				}
			} else if (vo.getTable() == PaidHolidayImportCardVo.TABLE_NEW) {
				// J@{sȌꍇ
				if (!MosPCodePart.afterLegalReformDate(date)) {
					// G[ꗗ֒ǉ
					addCsvErrMessage("WC0023", StringUtil.combineByComma(header, DateUtil
						.convDateToFormatDateJPShort(DateUtil.getLegalReformDate())));
				}
			}
		} else {
			// G[ꗗ֒ǉ
			addCsvErrMessage("WC0006", header);
		}
		return date;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param i CfbNX
	 * @throws Exception Oꍇ
	 */
	private void checkAvailableUser(String kCode, int i) throws Exception {
		// ݊mF
		if (VariousUtil.isNull(part().human().getBasisInfo(kCode))) {
			// G[ꗗ֒ǉ
			addCsvErrMessage("IC0006", String.valueOf(i));
		}
	}
	
	/**
	 * LxɎclmF
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @throws MospException 	MosPOꍇ
	 * @return 
	 * <p>
	 * Ώۂ0.5Ŋ؂ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private boolean checkPaidHolidayValue(String value, String header) throws MospException {
		if (ValidateUtility.chkNumeric(value)) {
			double days = Double.parseDouble(value);
			if (String.valueOf(days).endsWith(".0") || String.valueOf(days).endsWith(".5")) {
				return true;
			}
		}
		addCsvErrMessage("WC0005", header);
		return false;
	}
	
	/**
	 * ^mF(_mF)
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @throws MospException 	MosPOꍇ
	 * @return 
	 * <p>
	 * Ώۂ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private boolean checkNumber(String value, String header) throws MospException {
		if (!ValidateUtility.chkRegex("\\d*", value)) {
			addCsvErrMessage("WC0005", header);
			return false;
		}
		return true;
	}
	
	/**
	 * 񒷊mF(ő啶)
	 * <p>
	 * 񂪍ő啶蒷ꍇG[bZ[WڂɒǉB
	 * </p>
	 * @param value Ώە
	 * @param header Ώۃwb_[
	 * @param maxLength ő啶
	 * @throws MospException  	MosPOꍇ
	 */
	private void checkLength(String value, String header, int maxLength) throws MospException {
		StringBuffer sb = new StringBuffer();
		sb.append(".{0,");
		sb.append(maxLength);
		sb.append("}");
		if (!ValidateUtility.chkRegex(sb.toString(), value)) {
			addCsvErrMessage("WC0004", StringUtil.combineByComma(header, String.valueOf(maxLength)));
		}
	}
	
	/**
	 * R[hmF
	 * <p>
	 * \zȂR[h̏ꍇG[bZ[WڂɒǉB
	 * </p>
	 * @param value ΏۏR[h
	 * @param header Ώwb_[
	 * @throws MospException MosPOꍇ
	 */
	private void checkProcessCode(String value, String header) throws MospException {
		if (!CommonConst.CODE_PROCESS_INITIAL.equals(value) && !CommonConst.CODE_PROCESS_MONTHLY.equals(value)
				&& !CommonConst.CODE_PROCESS_SUPPLY.equals(value) && !CommonConst.CODE_PROCESS_WASTE.equals(value)) {
			addCsvErrMessage("WA1001", header);
		}
	}
	
	/**
	 * @param msgCode bZ[WR[h
	 * @param rep u(ꍇ̓J}؂)
	 * @throws MospException 	MosPOꍇ
	 */
	private void addCsvErrMessage(String msgCode, String rep) throws MospException {
		errMessage.append(getCsvData(getMessage(msgCode, rep)));
		errMessage.append(CommonConst.STR_CSV_SEPARATOR);
	}
	
	private void addErrorReport(String[] aryHeader, String[] aryValue) {
		for (int i = 0; aryHeader.length > i; i++) {
			if (i != aryHeader.length) {
				errorReport.append(getCsvData(aryHeader[i]) + CommonConst.STR_CSV_SEPARATOR);
			} else {
				errorReport.append(getCsvData(aryHeader[i]));
			}
		}
		errorReport.append(CommonConst.STR_CSV_NEW_LINE);
		for (int i = 0; aryValue.length > i; i++) {
			if (i != aryValue.length) {
				errorReport.append(getCsvData(aryValue[i]) + CommonConst.STR_CSV_SEPARATOR);
			} else {
				errorReport.append(getCsvData(aryValue[i]));
			}
		}
		errorReport.append(errMessage);
		errorReport.deleteCharAt(errorReport.lastIndexOf(CommonConst.STR_CSV_SEPARATOR));
		errorReport.append(CommonConst.STR_CSV_NEW_LINE);
		errorCount++;
	}
	
	private void setOldColumnName() {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		List<String> list = new LinkedList<String>();
		list.add(CommonConst.NAM_K_CODE);
		list.add(CommonConst.NAM_KYUYO_YMD);
		list.add(CommonConst.NAM_ZZANT);
		list.add(CommonConst.NAM_ZZANZ);
		list.add(CommonConst.NAM_SYOKA);
		list.add(CommonConst.NAM_SYUTOKU);
		list.add(CommonConst.NAM_HAIKI);
		list.add(CommonConst.NAM_TZANT);
		list.add(CommonConst.NAM_TZANZ);
		vo.setAryColumnName(StringUtil.listToArray(list));
	}
	
	private void setNewColumnName() {
		PaidHolidayImportCardVo vo = (PaidHolidayImportCardVo)getVo();
		List<String> list = new LinkedList<String>();
		list.add(CommonConst.NAM_PAID_HOLIDAY_ID);
		list.add(CommonConst.NAM_K_CODE);
		list.add(CommonConst.NAM_PROCESS_TYPE);
		list.add(CommonConst.NAM_PROCESS_DATE);
		list.add(CommonConst.NAM_LAST_REMAIN_DAYS);
		list.add(CommonConst.NAM_LAST_REMAIN_HOUR);
		list.add(CommonConst.NAM_REMAIN_DAYS);
		list.add(CommonConst.NAM_REMAIN_HOUR);
		list.add(CommonConst.NAM_POSSIBLE);
		vo.setAryColumnName(StringUtil.listToArray(list));
	}
	
}
