/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.CmWorkTypeDao;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;

/**
 * Ζ`ԂɊւPartNX
 * @author yoshida
 *	@version	0.0.5
 */
public class WorkTypePart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public WorkTypePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public WorkTypePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MWorkTypeDaoCX^X
	 */
	private CmWorkTypeDao	workTypeDao;
	

	/**
	 * CM_WORKTYPEe[upDAO̎擾
	 * @return	ςMWorkTypeDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public CmWorkTypeDao getCmWorkTypeDao() throws Exception {
		if (VariousUtil.isNull(workTypeDao)) {
			workTypeDao = (CmWorkTypeDao)getPreparedDao(CmWorkTypeDao.class.getCanonicalName());
		}
		return workTypeDao;
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeArrayNotDeleted() throws Exception {
		// ̎擾
		List<CmWorkTypeDto> listWorkType = findAvailable();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < aryWorkType.length; i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeArrayWithWeekHoliday() throws Exception {
		return StringUtil.addArrayLastRowValue(getWorkTypeArrayNotDeleted(), CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeArrayAll() throws Exception {
		// ̎擾
		List<CmWorkTypeDto> listWorkType = findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < aryWorkType.length; i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[] getWorkTypeCodeArrayAll() throws Exception {
		// ̎擾
		List<CmWorkTypeDto> listWorkType = findAll();
		// z̍쐬
		String[] aryWorkType = new String[listWorkType.size()];
		for (int i = 0; i < aryWorkType.length; i++) {
			aryWorkType[i] = listWorkType.get(i).getShiftCode();
		}
		return aryWorkType;
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	private String[][] getWorkTypeArrayAllWithWeekHoliday() throws Exception {
		return StringUtil.addArrayLastRowValue(getWorkTypeArrayAll(), CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.NAM_STANDARD_WEEK_HOLIDAY);
	}
	
	/**
	 * Ζ`ԃR[hixA@x܂ށj擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeArrayAllWithHoliday() throws Exception {
		return StringUtil.addArrayLastRowValue(getWorkTypeArrayAllWithWeekHoliday(),
				CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY, CommonConst.NAM_OFFICIAL_HOLIDAY);
	}
	
	/**
	 * Ζ`ԏ擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeDataArray() throws Exception {
		// ̎擾
		List<CmWorkTypeDto> listWorkType = findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][8];
		for (int i = 0; i < aryWorkType.length; i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
			aryWorkType[i][2] = String.valueOf(listWorkType.get(i).getStartTime());
			aryWorkType[i][3] = String.valueOf(listWorkType.get(i).getQuitTime());
			aryWorkType[i][4] = String.valueOf(listWorkType.get(i).getWorkTime());
			aryWorkType[i][5] = String.valueOf(listWorkType.get(i).getBreakTime());
			aryWorkType[i][6] = String.valueOf(listWorkType.get(i).getOverStart());
			aryWorkType[i][7] = String.valueOf(listWorkType.get(i).getOverBreak());
		}
		return aryWorkType;
	}
	

	/**
	 * Ζ`ԃ}bv
	 */
	private Map<String, CmWorkTypeDto>	workTypeMap;
	

	/**
	 * Ζ`ԃ}bv擾
	 * @return Ζ`ԃ}bv
	 * @throws Exception  Oꍇ
	 */
	public Map<String, CmWorkTypeDto> getWorkTypeMap() throws Exception {
		if (VariousUtil.isNull(workTypeMap)) {
			// ̎擾
			List<CmWorkTypeDto> listWorkType = findAll();
			// Map̍쐬
			workTypeMap = new HashMap<String, CmWorkTypeDto>();
			for (CmWorkTypeDto dto : listWorkType) {
				workTypeMap.put(dto.getShiftCode(), dto);
			}
		}
		return workTypeMap;
	}
	
	/**
	 * Ζ`ԃ}bv(TxA@x܂)擾
	 * @return  Ζ`ԃ}bv
	 * @throws Exception  Oꍇ
	 */
	public Map<String, CmWorkTypeDto> getWorkTypeAllMap() throws Exception {
		workTypeMap = getWorkTypeMap();
		// Txixj
		CmWorkTypeDto weekHolidayDto = new CmWorkTypeDto();
		weekHolidayDto.setShiftCode(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		weekHolidayDto.setShiftName(CommonConst.NAM_STANDARD_WEEK_HOLIDAY);
		workTypeMap.put(weekHolidayDto.getShiftCode(), weekHolidayDto);
		// @xi@xj
		CmWorkTypeDto officialHolidayDto = new CmWorkTypeDto();
		officialHolidayDto.setShiftCode(CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY);
		officialHolidayDto.setShiftName(CommonConst.NAM_OFFICIAL_HOLIDAY);
		workTypeMap.put(officialHolidayDto.getShiftCode(), officialHolidayDto);
		return workTypeMap;
	}
	
	/**
	 * Ζ`ԏ擾(TxA@x܂)
	 * @since	0.0.2
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	(DTO)
	 * @throws Exception Oꍇ
	 */
	public CmWorkTypeDto getWorkTypeInfo(String shiftCode) throws Exception {
		return getWorkTypeAllMap().get(shiftCode);
	}
	
	/**
	 * Ζ`ԏ擾(p\̂)
	 * @since	0.0.2
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	(DTO)
	 * @throws Exception Oꍇ
	 */
	public CmWorkTypeDto getAvailableWorkTypeInfo(String shiftCode) throws Exception {
		return getCmWorkTypeDao().findForAvailable(shiftCode);
	}
	
	/**
	 * Ζ`ԏ擾
	 * @since	0.0.3
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	(DTO)
	 * @throws Exception Oꍇ
	 */
	public CmWorkTypeDto findForKey(String shiftCode) throws Exception {
		return getCmWorkTypeDao().findForKey(shiftCode);
	}
	
	/**
	 * Ζ`Ԗ̎擾
	 * @since	0.0.3
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	Ζ`Ԗ
	 * @throws Exception Oꍇ
	 */
	public String getWorkTypeName(String shiftCode) throws Exception {
		return getWorkTypeName(shiftCode, false);
	}
	
	/**
	 * Ζ`Ԗ̎擾
	 * @param shiftCode	 	ΏۋΖ`ԃR[h
	 * @param addTime \tO
	 * @return Ζ`Ԗ
	 * @throws Exception Oꍇ
	 */
	public String getWorkTypeName(String shiftCode, boolean addTime) throws Exception {
		CmWorkTypeDto dto = getWorkTypeAllMap().get(shiftCode);
		if (VariousUtil.isNotNull(dto)) {
			if (addTime) {
				return getWorkTypeNameForView(dto);
			}
			return dto.getShiftName();
		}
		return shiftCode;
	}
	
	/**
	 * Ζ`ԃXg擾(JnAIt)(p\̂)
	 * @since	0.0.4
	 * @return	Ζ`ԃXg
	 * @throws Exception Oꍇ
	 */
	public String[][] getWorkTypeInfoArray() throws Exception {
		List<CmWorkTypeDto> list = findAvailable();
		String[][] aryWorkType = new String[list.size()][2];
		int i = 0;
		for (CmWorkTypeDto dto : list) {
			aryWorkType[i][0] = dto.getShiftCode();
			aryWorkType[i][1] = getWorkTypeNameForView(dto);
			i++;
		}
		return aryWorkType;
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	private String[][] getWorkTypeInfoArrayWithWeekHoliday() throws Exception {
		return StringUtil.addArrayLastRowValue(getWorkTypeInfoArray(), CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.NAM_STANDARD_WEEK_HOLIDAY);
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxA@xtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getWorkTypeInfoArrayWithHoliday() throws Exception {
		return StringUtil.addArrayLastRowValue(getWorkTypeInfoArrayWithWeekHoliday(),
				CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY, CommonConst.NAM_OFFICIAL_HOLIDAY);
	}
	
	/**
	 * Ζ`ԃXg擾(p\̂)
	 * @since	0.0.5
	 * @return	Ζ`ԃXg
	 * @throws Exception Oꍇ
	 */
	public List<CmWorkTypeDto> findAvailable() throws Exception {
		return getCmWorkTypeDao().findAvailable();
	}
	
	/**
	 * Ζ`ԃXg擾
	 * @since	0.0.5
	 * @return	Ζ`ԃXg
	 * @throws Exception Oꍇ
	 */
	public List<CmWorkTypeDto> findAll() throws Exception {
		return getCmWorkTypeDao().findAll();
	}
	
	/**
	 * Ζ`Ԏ擾
	 * @since	0.0.5
	 * @param dto			ΏDTO
	 * @return	Ζ`Ԏ
	 */
	public static String getWorkTypeTimeForView(CmWorkTypeDto dto) {
		StringBuffer sb = new StringBuffer();
		if (VariousUtil.isNotNull(dto)) {
			sb.append(TimeUtil.convIntegerTimeToStringTime(dto.getStartTime()));
			sb.append(CommonConst.STR_TERM);
			sb.append(TimeUtil.convIntegerTimeToStringTime(dto.getQuitTime()));
			return StringUtil.surroundBracket(sb.toString());
		}
		return sb.toString();
	}
	
	/**
	 * Ζ`Ԗ(JnAIt)擾
	 * @since	0.0.5
	 * @param dto			ΏDTO
	 * @return	Ζ`Ԗ(JnAIt)
	 */
	public static String getWorkTypeNameForView(CmWorkTypeDto dto) {
		StringBuffer sb = new StringBuffer();
		if (VariousUtil.isNotNull(dto)) {
			sb.append(dto.getShiftName());
			sb.append(getWorkTypeTimeForView(dto));
		}
		return sb.toString();
	}
	
	/**
	 * Ζ`Ԗ(JnAIt)擾
	 * @since	0.0.5
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	Ζ`Ԗ(JnAIt)
	 * @throws Exception Oꍇ
	 */
	public String getWorkTypeNameForView(String shiftCode) throws Exception {
		return getWorkTypeNameForView(findForKey(shiftCode));
	}
	
}
