/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.ComponentPart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.MSyozokuDao;
import jp.mosp.kintai.common.dto.MSyozokuDto;

/**
 * ɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class SectionPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public SectionPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo 	Part𗘗pۂɕKvȏ
	 */
	public SectionPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MSyozokuDaoCX^X
	 */
	private MSyozokuDao	syozokuDao;
	

	/**
	 * M_SYOZOKUe[upDAO擾
	 * @return	ςMSyozokuDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public MSyozokuDao getMSyozokuDao() throws Exception {
		if (VariousUtil.isNull(syozokuDao)) {
			syozokuDao = (MSyozokuDao)getPreparedDao(MSyozokuDao.class.getCanonicalName());
		}
		return syozokuDao;
	}
	
	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return (MSyozokuDto)
	 * @throws Exception  Oꍇ
	 */
	public MSyozokuDto getSectionInfo(String sCode) throws Exception {
		// ̎擾
		return getMSyozokuDao().findForKey(sCode);
	}
	
	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return 
	 * @throws Exception  Oꍇ
	 */
	public String getSectionName(String sCode) throws Exception {
		MSyozokuDto dto = getSectionInfo(sCode);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getSName();
		}
		return "";
	}
	
	/**
	 * R[h擾
	 * @param kCode 擾ΏێЈR[h
	 * @return R[h
	 * @throws Exception Oꍇ
	 */
	public String getBelongSectionCode(String kCode) throws Exception {
		// l{擾
		HumanBasisDtoInterface mKihonDto = part().human().getBasisInfo(kCode);
		if (VariousUtil.isNotNull(mKihonDto)) {
			return mKihonDto.getSCode();
		}
		return "";
	}
	
	/**
	 * ̎擾
	 * @param kCode 擾ΏێЈR[h
	 * @return 
	 * @throws Exception Oꍇ
	 */
	public String getBelongSectionName(String kCode) throws Exception {
		return getSectionName(getBelongSectionCode(kCode));
	}
	
	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getSectionArrayAll() throws Exception {
		// ̎擾
		// z̍쐬
		return getSectionArray(findAll());
	}
	
	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	public String[][] getSectionArrayForManager() throws Exception {
		// z̍쐬
		return getSectionArray(getSectionListForManager());
	}
	
	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @since	0.0.2
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	public List<MSyozokuDto> getSectionListForManager() throws Exception {
		// ̎擾
		return findForCondition(part().human().getBasisInfoOfUser().getSCode());
	}
	
	/**
	 * R[h擾(p\cɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	public String[][] getSectionArrayForHuman() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection;
		// 쌠mF		
		if (part().authority().hasHumanAuth()) {
			listSection = findAll();
		} else {
			listSection = getSectionListForManager();
		}
		// z̍쐬
		return getSectionArray(listSection);
	}
	
	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hz
	 * @throws Exception Oꍇ
	 */
	public String[][] getSectionScopeArrayForPayroll() throws Exception {
		return getSectionArray(getSectionScopeListForPayroll());
	}
	
	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @since	0.0.2
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	public List<MSyozokuDto> getSectionScopeListForPayroll() throws Exception {
		CmComponentDto componentDto = part().menu().getPayrollComponentInfo();
		List<MSyozokuDto> listSection = null;
		// v_Eݒ
		if (ComponentPart.isBelongingSection(componentDto)) {
			listSection = getSectionListForManager();
		} else if (ComponentPart.isSelectSection(componentDto)) {
			listSection = findAll();
		} else if (ComponentPart.isAllSection(componentDto)) {
			listSection = findAll();
			MSyozokuDto dto = new MSyozokuDto();
			dto.setSCode(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
			dto.setSName(CommonConst.NAM_ALL_SECTION);
			listSection.add(0, dto);
		}
		return listSection;
	}
	
	/**
	 * Xg擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	public Map<String, MSyozokuDto> getSectionMap() throws Exception {
		// ̎擾
		List<MSyozokuDto> listSection = findAll();
		// z̍쐬
		HashMap<String, MSyozokuDto> map = new HashMap<String, MSyozokuDto>();
		for (MSyozokuDto dto : listSection) {
			map.put(dto.getSCode(), dto);
		}
		return map;
	}
	
	/**
	 * SR[hz擾
	 * @return	R[hz
	 * @throws Exception Oꍇ
	 */
	public String[] getSectionCodeArrayAll() throws Exception {
		List<MSyozokuDto> listSection = findAll();
		String[] arySectionCode = new String[listSection.size()];
		int i = 0;
		for (MSyozokuDto dto : listSection) {
			arySectionCode[i] = dto.getSCode();
			i++;
		}
		return arySectionCode;
	}
	
	/**
	 * ΏۏR[hXg擾
	 * @since	0.0.2
	 * @param sCode		ΏۏR[h
	 * @return	񃊃Xg
	 * @throws Exception Oꍇ
	 */
	public List<MSyozokuDto> findForCondition(String sCode) throws Exception {
		return getMSyozokuDao().findForCondition(sCode);
	}
	
	/**
	 * SR[hXg擾
	 * @since	0.0.2
	 * @return	񃊃Xg
	 * @throws Exception Oꍇ
	 */
	public List<MSyozokuDto> findAll() throws Exception {
		return getMSyozokuDao().findAll();
	}
	
	/**
	 * 񃊃Xgzϊ
	 * @since	0.0.2
	 * @param list	Ώۏ񃊃Xg
	 * @return	z
	 */
	public static String[][] getSectionArray(List<MSyozokuDto> list) {
		String[][] arySection = new String[0][0];
		if (VariousUtil.isNotNull(list)) {
			arySection = new String[list.size()][2];
			int i = 0;
			for (MSyozokuDto dto : list) {
				arySection[i][0] = dto.getSCode();
				arySection[i][1] = dto.getSName();
				i++;
			}
		}
		return arySection;
	}
	
}
