/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.List;

import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.MKaisyaDao;
import jp.mosp.kintai.common.dto.MKaisyaDto;

/**
 * ƏɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class OfficePart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public OfficePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public OfficePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MKaisyaDao	kaisyaDao;
	

	/**
	 * M_KAISYAe[upDAO擾
	 * @return	ςMKaisyaDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MKaisyaDao getMKaisyaDao() throws Exception {
		if (VariousUtil.isNull(kaisyaDao)) {
			kaisyaDao = (MKaisyaDao)getPreparedDao(MKaisyaDao.class.getCanonicalName());
		}
		return kaisyaDao;
	}
	
	/**
	 * Ə擾(M_KAISYA)
	 * @param jCode 擾ΏێƏR[h
	 * @return Ə(MKaisyaDto)
	 * @throws Exception 	Oꍇ
	 */
	public MKaisyaDto getOfficeInfo(String jCode) throws Exception {
		// ̎擾
		return getMKaisyaDao().findForKey(jCode);
	}
	
	/**
	 * Ə̎擾
	 * @param jCode	 擾ΏێƏR[h
	 * @return	Ə
	 * @throws Exception	Oꍇ
	 */
	public String getOfficeName(String jCode) throws Exception {
		MKaisyaDto dto = getOfficeInfo(jCode);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getKaiMei();
		}
		return "";
	}
	
	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getOfficeArrayAll() throws Exception {
		// ̎擾
		List<MKaisyaDto> listOffice = getMKaisyaDao().findAll();
		// z̍쐬
		String[][] aryOffice = new String[listOffice.size()][2];
		for (int i = 0; i < aryOffice.length; i++) {
			aryOffice[i][0] = listOffice.get(i).getId();
			aryOffice[i][1] = listOffice.get(i).getKaiMei();
		}
		return aryOffice;
	}
	
	/**
	 * ƏR[h擾(p\̂)(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception	Oꍇ
	 */
	public String[][] getOfficeArray() throws Exception {
		// ̎擾
		List<MKaisyaDto> listOffice;
		if (part().authority().hasPayrollAuth()) {
			listOffice = getMKaisyaDao().findAll();
		} else {
			listOffice = getMKaisyaDao().findForCondition(part().human().getBasisInfoOfUser().getJCode());
		}
		// z̍쐬
		String[][] aryOffice = new String[listOffice.size()][2];
		for (int i = 0; i < aryOffice.length; i++) {
			aryOffice[i][0] = listOffice.get(i).getId();
			aryOffice[i][1] = listOffice.get(i).getKaiMei();
		}
		return aryOffice;
	}
	
	/**
	 * ƏR[h擾î݁j(M_KAISYA)
	 * @param kCode 擾ΏێЈR[h
	 * @return ƏR[h
	 * @throws Exception	Oꍇ
	 */
	public String getBelongOfficeCode(String kCode) throws Exception {
		// l{擾
		HumanBasisDtoInterface mKihonDto = part().human().getBasisInfo(kCode);
		if (VariousUtil.isNotNull(mKihonDto)) {
			return mKihonDto.getJCode();
		}
		return "";
	}
	
}
