/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.workflow.dao.AttendanceRouteDao;
import jp.mosp.workflow.dao.PmAttendanceDao;
import jp.mosp.workflow.dto.AttendanceRouteDto;
import jp.mosp.workflow.dto.PmAttendanceDto;

/**
 * ΑӏFpPartNX
 * @author yoshida
 *	@version	0.0.9
 */
public class KintaiApprovalPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public KintaiApprovalPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public KintaiApprovalPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * AttendanceRouteDaoCX^X
	 */
	private AttendanceRouteDao	attendanceRouteDao;
	

	/**
	 * ΑӏFp[ge[upDAO擾
	 * @since	0.0.2
	 * @return	ςAttendanceRouteDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public AttendanceRouteDao getAttendanceRouteDao() throws Exception {
		if (VariousUtil.isNull(attendanceRouteDao)) {
			attendanceRouteDao = (AttendanceRouteDao)getPreparedDao(AttendanceRouteDao.class.getCanonicalName());
		}
		return attendanceRouteDao;
	}
	

	/**
	 * PmAttendanceDaoCX^X
	 */
	private PmAttendanceDao	pmAttendanceDao;
	

	/**
	 * ΑӏF[g}X^e[upDAO擾
	 * @since	0.0.2
	 * @return	ςPmAttendanceDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public PmAttendanceDao getPmAttendanceDao() throws Exception {
		if (VariousUtil.isNull(pmAttendanceDao)) {
			pmAttendanceDao = (PmAttendanceDao)getPreparedDao(PmAttendanceDao.class.getCanonicalName());
		}
		return pmAttendanceDao;
	}
	
	/**
	 * oΕ\tO擾
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isRequest(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[0].equals(snriyuu);
	}
	
	/**
	 * oΕ\tO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isRequest(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isRequest(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕꎟFσtO擾
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stApproved(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[1].equals(snriyuu);
	}
	
	/**
	 * oΕꎟFσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stApproved(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return is1stApproved(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕꎟ߃tO擾
	 * @since	0.0.4
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * ꎟ߂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stReturned(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[2].equals(snriyuu);
	}
	
	/**
	 * oΕꎟ߃tO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * ꎟ߂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stReturned(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return is1stReturned(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕ񎟏FσtO擾
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndApproved(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[3].equals(snriyuu);
	}
	
	/**
	 * oΕ񎟏FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndApproved(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return is2ndApproved(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕ񎟏FσtO擾
	 * @since	0.0.4
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * 񎟍ߍςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndReturned(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[4].equals(snriyuu);
	}
	
	/**
	 * oΕ񎟏FσtO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * 񎟍ߍςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndReturned(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return is2ndReturned(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕ돳FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isApproved(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			if (is1stApproved(dto) || is2ndApproved(dto)) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * oΕ뉺tO擾
	 * @since	0.0.7
	 * @param snriyuu		ΏۏFR
	 * @return
	 * <p>
	 * ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDraft(String snriyuu) {
		return VariousUtil.getApprovalStatusCodeArray()[5].equals(snriyuu) || StringUtil.isNull(snriyuu);
	}
	
	/**
	 * oΕ뉺tO擾
	 * @since	0.0.7
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDraft(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isDraft(dto.getSnRiyuu());
		}
		return false;
	}
	
	/**
	 * p\ΑӏF[gꗗ
	 * @since	0.0.2
	 * @param kCode  ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 󏊑FjbgR[hXg
	 * @throws Exception	Oꍇ
	 */
	public String[][] getBelongRouteInfoArray(String kCode, Date targetDate) throws Exception {
		// ̎擾
		List<AttendanceRouteDto> listRoute = getAttendanceRouteList(kCode, targetDate);
		String[][] aryRoute = new String[listRoute.size()][5];
		for (int i = 0; i < aryRoute.length; i++) {
			aryRoute[i][0] = listRoute.get(i).getSCode();
			aryRoute[i][1] = listRoute.get(i).getKCode();
			aryRoute[i][2] = listRoute.get(i).getLayer1();
			aryRoute[i][3] = listRoute.get(i).getLastLayer();
			aryRoute[i][4] = listRoute.get(i).getJCode();
		}
		return aryRoute;
	}
	
	/**
	 * p\ΑӏF[gꗗ
	 * @since	0.0.2
	 * @param kCode 		ΏێЈR[h
	 * @param approver		FҎЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 󏊑FjbgR[hXg
	 * <p>
	 * [0]cꎟF[gR[h
	 * [1]c񎟏F[gR[h
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	public String[] getTargetRouteInfo(String kCode, String approver, Date targetDate) throws Exception {
		// o͔z
		String[] aryRoute = StringUtil.getBlankArrayOneDimension(2);
		List<AttendanceRouteDto> routeList = getAttendanceRouteList(approver, targetDate);
		Map<String, AttendanceRouteDto> kCodeMap = new HashMap<String, AttendanceRouteDto>();
		Map<String, AttendanceRouteDto> sectionMap = new HashMap<String, AttendanceRouteDto>();
		for (AttendanceRouteDto dto : routeList) {
			// ЈR[h
			if (StringUtil.isNotNull(dto.getKCode())) {
				kCodeMap.put(dto.getKCode(), dto);
			}
			// ƏAR[h
			if (StringUtil.isNotNull(dto.getJCode()) && StringUtil.isNotNull(dto.getSCode())) {
				StringBuffer sb = new StringBuffer();
				sb.append(dto.getJCode());
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(dto.getSCode());
				sectionMap.put(sb.toString(), dto);
			}
		}
		// ΏێЈ
		HumanBasisDtoInterface humanBasis = part().human().getMKihonDao().findForApprovalKCode(kCode,
				part().human().getBasisInfo(approver).getJCode(),
				part().mospuser().getUserInfoForKCode(approver).getDataLevel(),
				DateUtil.convDateToInteger(part().calculate().getStartDate(targetDate)));
		if (VariousUtil.isNotNull(humanBasis)) {
			// ЈR[h
			if (kCodeMap.containsKey(humanBasis.getKCode())) {
				aryRoute[0] = kCodeMap.get(kCode).getLayer1();
				aryRoute[1] = kCodeMap.get(kCode).getLastLayer();
			} else {
				// ƏR[hAR[h
				StringBuffer sectionKey = new StringBuffer();
				sectionKey.append(humanBasis.getJCode());
				sectionKey.append(CommonConst.STR_UNDER_SEPARATOR);
				sectionKey.append(humanBasis.getSCode());
				if (sectionMap.containsKey(sectionKey.toString())) {
					aryRoute[0] = sectionMap.get(sectionKey.toString()).getLayer1();
					aryRoute[1] = sectionMap.get(sectionKey.toString()).getLastLayer();
				}
			}
		}
		return aryRoute;
	}
	
	/**
	 * FRz擾
	 * @since	0.0.3
	 * @return	FRz
	 * @throws Exception	Oꍇ
	 */
	public String[][] getApprovalReasonArray() throws Exception {
		// FR
		return part().mospcode().getMosPCodeArray(CommonConst.TID_APPROVAL_REASON);
	}
	
	/**
	 * FR\
	 * @since	0.0.3
	 * @param riyuu FR
	 * @return	result
	 * @throws Exception 	Oꍇ
	 */
	public String[] getApproval(String riyuu) throws Exception {
		String[][] aryApprovalReason = getApprovalReasonArray();
		String[] result = new String[2];
		if (KintaiApprovalPart.isRequest(riyuu)) {
			// \̏ꍇiꎟc\A񎟁c󗓁j
			result[0] = aryApprovalReason[0][1];
			result[1] = "";
		} else if (KintaiApprovalPart.is1stApproved(riyuu)) {
			// ꎟFς̏ꍇiꎟcFρA񎟐\j
			result[0] = aryApprovalReason[1][1];
			result[1] = aryApprovalReason[0][1];
		} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_1ST_RETURNED)) {
			// ꎟ߂̏ꍇiꎟc߁A񎟁c󗓁j
			result[0] = aryApprovalReason[2][1];
			result[1] = "";
		} else if (KintaiApprovalPart.is2ndApproved(riyuu)) {
			// 񎟏Fς̏ꍇiꎟcFρA񎟏Fρj
			result[0] = aryApprovalReason[1][1];
			result[1] = aryApprovalReason[3][1];
		} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_2ND_RETURNED)) {
			// ꎟ߂̏ꍇiꎟc񎟍߁A񎟁c󗓁j
			result[0] = aryApprovalReason[4][1];
			result[1] = "";
		} else {
			result[0] = "";
			result[1] = "";
		}
		return result;
	}
	
	/**
	 * ΑӏF󋵖̎擾
	 * @since	0.0.3
	 * @param snRiyuu		ΑӏF󋵃R[h
	 * @return				ΑӏF󋵖
	 * @throws Exception	Oꍇ
	 */
	public String getApprovalName(String snRiyuu) throws Exception {
		return part().mospcode().getTName(CommonConst.TID_APPROVAL_REASON, snRiyuu);
	}
	
	/**
	 * ΑӏF󋵖̎擾
	 * @since	0.0.3
	 * @param dto		ΏDTO
	 * @return			ΑӏF󋵖
	 * @throws Exception	Oꍇ
	 */
	public String getApprovalName(KintaiCommonDtoInterface dto) throws Exception {
		return getApprovalName(dto.getSnRiyuu());
	}
	
	/**
	 * FΏێ҈ꗗ
	 * @since	0.0.4
	 * @param kCode			ΏۏFҎЈR[h
	 * @param targetDate	Ώ۔N
	 * @return	FΏێ҈ꗗ
	 * @throws Exception	Oꍇ
	 */
	public List<MKihonDto> getApprovalEmployeeList(String kCode, Date targetDate) throws Exception {
		// ̐ݒ
		List<MKihonDto> listEmployee = new ArrayList<MKihonDto>();
		List<AttendanceRouteDto> listRoute = getAttendanceRouteList(kCode, targetDate);
		Set<String> employeeKCodeSet = new HashSet<String>();
		for (AttendanceRouteDto dto : listRoute) {
			// ΏۏЈꗗ
			List<MKihonDto> selectSectionUserList = part().human().getMKihonDao().findForApproval(dto.getSCode(),
					part().office().getBelongOfficeCode(kCode), kCode,
					part().mospuser().getUserInfoForKCode(kCode).getDataLevel(),
					DateUtil.convDateToInteger(part().calculate().getStartDate(targetDate)));
			for (MKihonDto mKihonDto : selectSectionUserList) {
				employeeKCodeSet.add(mKihonDto.getKCode());
			}
			// ǉЈ
			MKihonDto addMKihonDto = part().human().getBasisInfo(dto.getKCode());
			if (VariousUtil.chkExistDto(addMKihonDto)) {
				employeeKCodeSet.add(addMKihonDto.getKCode());
			}
		}
		// Јꗗ֒ǉ
		for (String employeeKCode : employeeKCodeSet) {
			listEmployee.add(part().human().getBasisInfo(employeeKCode));
		}
		return listEmployee;
	}
	
	/**
	 * ΏۋΑӏF[gꗗXg擾
	 * @since	0.0.5
	 * @param kCode			ΏۏFҎЈR[h
	 * @param targetDate	Ώ۔N
	 * @return list (DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<AttendanceRouteDto> getAttendanceRouteList(String kCode, Date targetDate) throws Exception {
		return getAttendanceRouteDao().findForApproval(kCode, part().section().getBelongSectionCode(kCode),
				part().office().getBelongOfficeCode(kCode),
				DateUtil.convDateFormattedByHyphen(part().calculate().getStartDate(targetDate)));
	}
	
	/**
	 * ΏێЈΑӏF[gR[h擾
	 * @since	0.0.5
	 * @param kCode		ΏێЈR[h
	 * @return	ΑӏF[gR[h
	 * @throws Exception	Oꍇ
	 */
	public String getRequestRouteCode(String kCode) throws Exception {
		PmAttendanceDto dto = getPmAttendanceDao().findForKCode(kCode);
		if (VariousUtil.isNull(dto)) {
			dto = getPmAttendanceDao().findForRequest(part().section().getBelongSectionCode(kCode),
					part().office().getBelongOfficeCode(kCode));
		}
		if (VariousUtil.chkExistDto(dto)) {
			return dto.getRtCode();
		}
		return "";
	}
	
	/**
	 * ΑӏF[Nt[F󋵃R[h擾
	 * @since	0.0.6
	 * @param snriyuu	ΏۋΑӏFR[h
	 * @return
	 * <p>
	 * [0]cFKw
	 * [1]cF
	 * </p>
	 */
	public static String[] toWorkflowStatusArray(String snriyuu) {
		return new String[]{ toWorkflowLayer(snriyuu), toWorkflowStatus(snriyuu) };
	}
	
	/**
	 * FKw擾
	 * @since	0.0.9
	 * @param snriyuu	ΏۋΑӏFR[h
	 * @return	FKw
	 */
	public static String toWorkflowLayer(String snriyuu) {
		String number = "";
		if (isRequest(snriyuu) || isDraft(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_REQUEST_LAYER);
		}
		if (is1stApproved(snriyuu) || is1stReturned(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAYER1);
		}
		if (is2ndApproved(snriyuu) || is2ndReturned(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAST_LAYER);
		}
		return number;
	}
	
	/**
	 * F󋵖̎擾
	 * @since	0.0.9
	 * @param snriyuu	ΏۋΑӏFR[h
	 * @return	F
	 */
	public static String toWorkflowStatus(String snriyuu) {
		String status = "";
		if (StringUtil.isNotNull(snriyuu)) {
			if (isRequest(snriyuu)) {
				status = WorkflowPart.getStatusCodeArray()[0];
			}
			if (is1stApproved(snriyuu) || is2ndApproved(snriyuu)) {
				status = WorkflowPart.getStatusCodeArray()[1];
			}
			if (is1stReturned(snriyuu) || is2ndReturned(snriyuu)) {
				status = WorkflowPart.getStatusCodeArray()[2];
			}
			// 
			if (isDraft(snriyuu)) {
				status = WorkflowPart.getStatusCodeArray()[4];
			}
		}
		return status;
	}
	
	/**
	 * ΑӏFҔf
	 * @since	0.0.9
	 * @param kCode			ΏێЈR[h
	 * @param approver		ΏۏFҎЈR[h
	 * @param snriyuu	F󋵃R[h
	 * @param targetDate	Ώ۔N
	 * @return
	 * <p>
	 * ΑӏF҂łꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	public boolean isApprover(String kCode, String approver, String snriyuu, Date targetDate) throws Exception {
		String[] aryRouteinfo = getTargetRouteInfo(kCode, approver, targetDate);
		boolean is1stApprover = part().approval().isApprover(aryRouteinfo[0], approver, targetDate);
		boolean is2ndApprover = part().approval().isApprover(aryRouteinfo[1], approver, targetDate);
		if (StringUtil.isNull(snriyuu)) {
			return is1stApprover || is2ndApprover;
		} else {
			if (isRequest(snriyuu)) {
				return is1stApprover;
			}
			if (is1stApproved(snriyuu)) {
				return is2ndApprover;
			}
			return false;
		}
	}
	
}
