/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dto;

import jp.mosp.common.common.BaseDto;

/**
 * M_YAKUSYOKU(E}X^)DTONXB
 */
public class MYakusyokuDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 5333429464401331944L;
	// tB[h
	private String				ycode				= "";
	private String				yname				= "";
	private String				tokyu				= "";
	private String				tkekkin				= "";
	private String				kekkin				= "";
	private String				skekkin				= "";
	private String				tiji				= "";
	private String				zaji				= "";
	private String				ksji				= "";
	private String				snji				= "";
	private String				kaikin				= "";
	private String				syokuji				= "";
	private String				cyoku1				= "";
	private String				cyoku2				= "";
	private String				cyoku3				= "";
	private String				hoka1				= "";
	private String				hoka2				= "";
	private String				hoka3				= "";
	private String				hoka4				= "";
	private String				hoka5				= "";
	private int					tkekkintan			= 0;
	private int					kekkintan			= 0;
	private int					skekkintan			= 0;
	private int					tijitan				= 0;
	private int					zajitan				= 0;
	private int					ksjitan				= 0;
	private int					snjitan				= 0;
	private int					kaikintan			= 0;
	private int					syokujitan			= 0;
	private int					cyoku1tan			= 0;
	private int					cyoku2tan			= 0;
	private int					cyoku3tan			= 0;
	private int					hoka1tan			= 0;
	private int					hoka2tan			= 0;
	private int					hoka3tan			= 0;
	private int					hoka4tan			= 0;
	private int					hoka5tan			= 0;
	

	/**
	 * RXgN^B
	 */
	public MYakusyokuDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return ycode 	ER[hB
	 */
	public String getYcode() {
		return ycode;
	}
	
	/**
	 * @return yname 	EB
	 */
	public String getYname() {
		return yname;
	}
	
	/**
	 * @return tokyu 	B
	 */
	public String getTokyu() {
		return tokyu;
	}
	
	/**
	 * @return tkekkin 	ʋxɍTLB
	 */
	public String getTkekkin() {
		return tkekkin;
	}
	
	/**
	 * @return kekkin 	ʌ΍TLB
	 */
	public String getKekkin() {
		return kekkin;
	}
	
	/**
	 * @return skekkin 	a΍TLB
	 */
	public String getSkekkin() {
		return skekkin;
	}
	
	/**
	 * @return tiji 	xލTLB
	 */
	public String getTiji() {
		return tiji;
	}
	
	/**
	 * @return zaji 	ʎcƎ蓖LB
	 */
	public String getZaji() {
		return zaji;
	}
	
	/**
	 * @return ksji 	xcƎ蓖LB
	 */
	public String getKsji() {
		return ksji;
	}
	
	/**
	 * @return snji 	[cƎ蓖LB
	 */
	public String getSnji() {
		return snji;
	}
	
	/**
	 * @return kaikin 	FΎ蓖LB
	 */
	public String getKaikin() {
		return kaikin;
	}
	
	/**
	 * @return syokuji 	H蓖LB
	 */
	public String getSyokuji() {
		return syokuji;
	}
	
	/**
	 * @return cyoku1 	1蓖LB
	 */
	public String getCyoku1() {
		return cyoku1;
	}
	
	/**
	 * @return cyoku2 	2蓖LB
	 */
	public String getCyoku2() {
		return cyoku2;
	}
	
	/**
	 * @return cyoku3 	3蓖LB
	 */
	public String getCyoku3() {
		return cyoku3;
	}
	
	/**
	 * @return hoka1 	̑x1LB
	 */
	public String getHoka1() {
		return hoka1;
	}
	
	/**
	 * @return hoka2 	̑x2LB
	 */
	public String getHoka2() {
		return hoka2;
	}
	
	/**
	 * @return hoka3 	̑x3LB
	 */
	public String getHoka3() {
		return hoka3;
	}
	
	/**
	 * @return hoka4 	̑x4LB
	 */
	public String getHoka4() {
		return hoka4;
	}
	
	/**
	 * @return hoka5 	̑x5LB
	 */
	public String getHoka5() {
		return hoka5;
	}
	
	/**
	 * @return tkekkintan 	ʋxɍTPB
	 */
	public int getTkekkintan() {
		return tkekkintan;
	}
	
	/**
	 * @return kekkintan 	ʌ΍TPB
	 */
	public int getKekkintan() {
		return kekkintan;
	}
	
	/**
	 * @return skekkintan 	a΍TPB
	 */
	public int getSkekkintan() {
		return skekkintan;
	}
	
	/**
	 * @return tijitan 	xލTPB
	 */
	public int getTijitan() {
		return tijitan;
	}
	
	/**
	 * @return zajitan 	ʎcƎ蓖PB
	 */
	public int getZajitan() {
		return zajitan;
	}
	
	/**
	 * @return ksjitan 	xcƎ蓖PB
	 */
	public int getKsjitan() {
		return ksjitan;
	}
	
	/**
	 * @return snjitan 	[cƎ蓖PB
	 */
	public int getSnjitan() {
		return snjitan;
	}
	
	/**
	 * @return kaikintan 	FΎ蓖PB
	 */
	public int getKaikintan() {
		return kaikintan;
	}
	
	/**
	 * @return syokujitan 	H蓖PB
	 */
	public int getSyokujitan() {
		return syokujitan;
	}
	
	/**
	 * @return cyoku1tan 	1蓖PB
	 */
	public int getCyoku1tan() {
		return cyoku1tan;
	}
	
	/**
	 * @return cyoku2tan 	2蓖PB
	 */
	public int getCyoku2tan() {
		return cyoku2tan;
	}
	
	/**
	 * @return cyoku3tan 	3蓖PB
	 */
	public int getCyoku3tan() {
		return cyoku3tan;
	}
	
	/**
	 * @return hoka1tan 	̑x1PB
	 */
	public int getHoka1tan() {
		return hoka1tan;
	}
	
	/**
	 * @return hoka2tan 	̑x2PB
	 */
	public int getHoka2tan() {
		return hoka2tan;
	}
	
	/**
	 * @return hoka3tan 	̑x3PB
	 */
	public int getHoka3tan() {
		return hoka3tan;
	}
	
	/**
	 * @return hoka4tan 	̑x4PB
	 */
	public int getHoka4tan() {
		return hoka4tan;
	}
	
	/**
	 * @return hoka5tan 	̑x5PB
	 */
	public int getHoka5tan() {
		return hoka5tan;
	}
	
	/**
	 * @param ycode 	ZbgER[hB
	 */
	public void setYcode(String ycode) {
		this.ycode = ycode;
	}
	
	/**
	 * @param yname 	ZbgEB
	 */
	public void setYname(String yname) {
		this.yname = yname;
	}
	
	/**
	 * @param tokyu 	Zbg铙B
	 */
	public void setTokyu(String tokyu) {
		this.tokyu = tokyu;
	}
	
	/**
	 * @param tkekkin 	ZbgʋxɍTLB
	 */
	public void setTkekkin(String tkekkin) {
		this.tkekkin = tkekkin;
	}
	
	/**
	 * @param kekkin 	Zbgʌ΍TLB
	 */
	public void setKekkin(String kekkin) {
		this.kekkin = kekkin;
	}
	
	/**
	 * @param skekkin 	Zbg鏝a΍TLB
	 */
	public void setSkekkin(String skekkin) {
		this.skekkin = skekkin;
	}
	
	/**
	 * @param tiji 	ZbgxލTLB
	 */
	public void setTiji(String tiji) {
		this.tiji = tiji;
	}
	
	/**
	 * @param zaji 	Zbg镁ʎcƎ蓖LB
	 */
	public void setZaji(String zaji) {
		this.zaji = zaji;
	}
	
	/**
	 * @param ksji 	ZbgxcƎ蓖LB
	 */
	public void setKsji(String ksji) {
		this.ksji = ksji;
	}
	
	/**
	 * @param snji 	Zbg[cƎ蓖LB
	 */
	public void setSnji(String snji) {
		this.snji = snji;
	}
	
	/**
	 * @param kaikin 	Zbg鐸FΎ蓖LB
	 */
	public void setKaikin(String kaikin) {
		this.kaikin = kaikin;
	}
	
	/**
	 * @param syokuji 	ZbgH蓖LB
	 */
	public void setSyokuji(String syokuji) {
		this.syokuji = syokuji;
	}
	
	/**
	 * @param cyoku1 	Zbg1蓖LB
	 */
	public void setCyoku1(String cyoku1) {
		this.cyoku1 = cyoku1;
	}
	
	/**
	 * @param cyoku2 	Zbg2蓖LB
	 */
	public void setCyoku2(String cyoku2) {
		this.cyoku2 = cyoku2;
	}
	
	/**
	 * @param cyoku3 	Zbg3蓖LB
	 */
	public void setCyoku3(String cyoku3) {
		this.cyoku3 = cyoku3;
	}
	
	/**
	 * @param hoka1 	Zbg邻̑x1LB
	 */
	public void setHoka1(String hoka1) {
		this.hoka1 = hoka1;
	}
	
	/**
	 * @param hoka2 	Zbg邻̑x2LB
	 */
	public void setHoka2(String hoka2) {
		this.hoka2 = hoka2;
	}
	
	/**
	 * @param hoka3 	Zbg邻̑x3LB
	 */
	public void setHoka3(String hoka3) {
		this.hoka3 = hoka3;
	}
	
	/**
	 * @param hoka4 	Zbg邻̑x4LB
	 */
	public void setHoka4(String hoka4) {
		this.hoka4 = hoka4;
	}
	
	/**
	 * @param hoka5 	Zbg邻̑x5LB
	 */
	public void setHoka5(String hoka5) {
		this.hoka5 = hoka5;
	}
	
	/**
	 * @param tkekkintan 	ZbgʋxɍTPB
	 */
	public void setTkekkintan(int tkekkintan) {
		this.tkekkintan = tkekkintan;
	}
	
	/**
	 * @param kekkintan 	Zbgʌ΍TPB
	 */
	public void setKekkintan(int kekkintan) {
		this.kekkintan = kekkintan;
	}
	
	/**
	 * @param skekkintan 	Zbg鏝a΍TPB
	 */
	public void setSkekkintan(int skekkintan) {
		this.skekkintan = skekkintan;
	}
	
	/**
	 * @param tijitan 	ZbgxލTPB
	 */
	public void setTijitan(int tijitan) {
		this.tijitan = tijitan;
	}
	
	/**
	 * @param zajitan 	Zbg镁ʎcƎ蓖PB
	 */
	public void setZajitan(int zajitan) {
		this.zajitan = zajitan;
	}
	
	/**
	 * @param ksjitan 	ZbgxcƎ蓖PB
	 */
	public void setKsjitan(int ksjitan) {
		this.ksjitan = ksjitan;
	}
	
	/**
	 * @param snjitan 	Zbg[cƎ蓖PB
	 */
	public void setSnjitan(int snjitan) {
		this.snjitan = snjitan;
	}
	
	/**
	 * @param kaikintan 	Zbg鐸FΎ蓖PB
	 */
	public void setKaikintan(int kaikintan) {
		this.kaikintan = kaikintan;
	}
	
	/**
	 * @param syokujitan 	ZbgH蓖PB
	 */
	public void setSyokujitan(int syokujitan) {
		this.syokujitan = syokujitan;
	}
	
	/**
	 * @param cyoku1tan 	Zbg1蓖PB
	 */
	public void setCyoku1tan(int cyoku1tan) {
		this.cyoku1tan = cyoku1tan;
	}
	
	/**
	 * @param cyoku2tan 	Zbg2蓖PB
	 */
	public void setCyoku2tan(int cyoku2tan) {
		this.cyoku2tan = cyoku2tan;
	}
	
	/**
	 * @param cyoku3tan 	Zbg3蓖PB
	 */
	public void setCyoku3tan(int cyoku3tan) {
		this.cyoku3tan = cyoku3tan;
	}
	
	/**
	 * @param hoka1tan 	Zbg邻̑x1PB
	 */
	public void setHoka1tan(int hoka1tan) {
		this.hoka1tan = hoka1tan;
	}
	
	/**
	 * @param hoka2tan 	Zbg邻̑x2PB
	 */
	public void setHoka2tan(int hoka2tan) {
		this.hoka2tan = hoka2tan;
	}
	
	/**
	 * @param hoka3tan 	Zbg邻̑x3PB
	 */
	public void setHoka3tan(int hoka3tan) {
		this.hoka3tan = hoka3tan;
	}
	
	/**
	 * @param hoka4tan 	Zbg邻̑x4PB
	 */
	public void setHoka4tan(int hoka4tan) {
		this.hoka4tan = hoka4tan;
	}
	
	/**
	 * @param hoka5tan 	Zbg邻̑x5PB
	 */
	public void setHoka5tan(int hoka5tan) {
		this.hoka5tan = hoka5tan;
	}
	
}
