/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dto.CtWorkflowDto;

/**
 * @author yoshida
 *
 */
public class CtWorkflowDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * 
	 */
	public static final String	TABLE				= "CT_WORKFLOW";
	/**
	 * 
	 */
	public static final String	KEY_1				= "WORKFLOW";		//[Nt[ԍ
																		
	// 
	/**
	 * 
	 */
	public static final String	COL_WORKFLOW		= "WORKFLOW";		//[Nt[ԍ
	/**
	 * 
	 */
	public static final String	COL_LAYER_NUMBER	= "LAYERNUMBER";	//Kwԍ
	/**
	 * 
	 */
	public static final String	COL_CURRENT_STATUS	= "CURRENTSTATUS";	//
	/**
	 * 
	 */
	public static final String	COL_RT_CODE			= "RTCODE";		//[gR[h
	/**
	 * 
	 */
	public static final String	COL_DELETE_FLAG		= "DELETEFLAG";	//폜tO
																		
	
	/**
	 * RXgN^
	 */
	public CtWorkflowDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CtWorkflowDto> mappingAll() throws SQLException {
		List<CtWorkflowDto> all = new ArrayList<CtWorkflowDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CtWorkflowDto ct_workflowR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CtWorkflowDto mapping() throws SQLException {
		CtWorkflowDto dto = new CtWorkflowDto();
		dto.setWorkflow(rs.getLong(COL_WORKFLOW)); //[Nt[ԍ
		dto.setLayerNumber(rs.getInt(COL_LAYER_NUMBER)); //Kwԍ
		dto.setCurrentStatus(rs.getString(COL_CURRENT_STATUS)); //
		dto.setRtCode(rs.getString(COL_RT_CODE)); //[gR[h
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG)); //폜tO
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<CtWorkflowDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CtWorkflowDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param workflow [Nt[ԍ(L[)
	 * @return CtWorkflowDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CtWorkflowDto findForKey(long workflow) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, workflow);
			executeQuery();
			CtWorkflowDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param workflow [Nt[ԍ(L[)
	 * @return CtWorkflowDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CtWorkflowDto findForUpdate(long workflow) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, workflow);
			executeQuery();
			CtWorkflowDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param workflow [Nt[ԍ
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String workflow) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, workflow);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param rtCode		[gR[h
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<CtWorkflowDto> findForRtCode(String rtCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_RT_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = 0 ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, rtCode);
			executeQuery();
			List<CtWorkflowDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String max = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_WORKFLOW);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				max = String.valueOf(rs.getLong(1));
			}
			return max;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int insert(CtWorkflowDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int update(CtWorkflowDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getWorkflow());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int delete(CtWorkflowDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getWorkflow());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CtWorkflowDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getWorkflow()); //[Nt[ԍ
		setParam(index++, dto.getLayerNumber()); //Kwԍ
		setParam(index++, dto.getCurrentStatus()); //
		setParam(index++, dto.getRtCode()); //[gR[h
		setParam(index++, dto.getDeleteFlag()); //폜tO
		setCommonParams(isInsert);
	}
	
	/**
	 * FKwƏF󋵂錟̃TuNGs
	 * @return	FKwƏF󋵂錟̃TuNG
	 */
	public static String getSubQueryWorkflowStatus() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_WORKFLOW);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_LAYER_NUMBER);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_CURRENT_STATUS);
		sb.append(" = ? ");
		return sb.toString();
	}
	
}
