/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.common.dto.MKihonDto;

public class HumanListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -3999859872499801119L;
	
	// p[^
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	public static final String	PRM_PLT_OFFICE		= "pltOffice";
	public static final String	PRM_PLT_SECTION		= "pltSection";
	public static final String	PRM_PLT_POSITION	= "pltPosition";
	public static final String	PRM_PLT_RETIREMENT	= "pltRetirement";
	
	// tB[hyѐ
	public String				NAM_K_CODE;
	public String				NAM_K_NAME;
	public String				NAM_OFFICE;
	public String				NAM_SECTION;
	public String				NAM_POSITION;
	public String				NAM_RETIREMENT_TYPE;
	public int					LEN_K_CODE;
	public int					LEN_K_NAME;
	
	// tB[h
	private String[]			aryKCode;
	private String[]			aryKName;
	private String[]			aryOffice;
	private String[]			arySection;
	private String[]			aryPosition;
	private String[]			aryRetirement;
	private String				txtKCode;
	private String				txtKName;
	private String				pltOffice;
	private String				pltSection;
	private String				pltPosition;
	private String				pltRetirement;
	
	// v_EXg
	public String[][]			aryPltOfficeAll;
	public String[][]			aryPltOffice;
	public String[][]			aryPltSectionAll;
	public String[][]			aryPltSection;
	public String[][]			aryPltPositionAll;
	public String[][]			aryPltPosition;
	public String[][]			aryPltRetirement;
	
	// \[gL[
	public final String			KEY_K_CODE			= "keyKCode";
	public final String			KEY_K_NAME			= "keyKName";
	public final String			KEY_OFFICE			= "keyOffice";
	public final String			KEY_SECTION			= "keySection";
	public final String			KEY_POSITION		= "keyPosition";
	public final String			KEY_RETIREMENT		= "keyRetirement";
	

	/**
	 * RXgN^
	 */
	public HumanListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		pltOffice = "";
		pltSection = "";
		pltPosition = "";
		pltRetirement = "";
		aryKCode = new String[0];
		aryKName = new String[0];
		arySection = new String[0];
		aryPosition = new String[0];
		aryRetirement = new String[0];
		aryOffice = new String[0];
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_HUMAN_LIST;
		aryMenu = new String[][]{ { CMD_MENU_HUMAN, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_OFFICE = CommonConst.NAM_OFFICE;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_POSITION = CommonConst.NAM_POSITION1;
		NAM_RETIREMENT_TYPE = CommonConst.NAM_RETIREMENT_TYPE;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltOffice = request.getParameter(PRM_PLT_OFFICE);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
		pltRetirement = request.getParameter(PRM_PLT_RETIREMENT);
	}
	
	@Override
	public void setFields(List<?> listHuman) {
		// Xg̐ݒ
		list = listHuman;
		// f[^̎擾
		count = listHuman.size();
		// z̏
		aryKCode = new String[count];
		aryKName = new String[count];
		aryOffice = new String[count];
		arySection = new String[count];
		aryPosition = new String[count];
		aryRetirement = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			aryKCode[i] = escapeHTML(dto.getKCode());
			aryKName[i] = escapeHTML(dto.getSimei());
			aryOffice[i] = escapeHTML(getCodeName(dto.getJCode(), aryPltOfficeAll));
			arySection[i] = escapeHTML(getCodeName(dto.getSCode(), aryPltSectionAll));
			aryPosition[i] = "";
			for (String[] element : aryPltPositionAll) {
				if (element[0].equals(dto.getYCode()) && element[2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(element[1]);
					break;
				}
			}
			aryRetirement[i] = escapeHTML(getCodeName(dto.getKnKubun(), aryPltRetirement));
			i++;
		}
	}
	
	// ANZT\bh
	public String[] getEscAryKCode() {
		return aryKCode.clone();
	}
	
	public String[] getEscAryKName() {
		return aryKName.clone();
	}
	
	public String[] getEscArySection() {
		return arySection.clone();
	}
	
	public String[] getEscAryPosition() {
		return aryPosition.clone();
	}
	
	public String[] getEscAryRetirement() {
		return aryRetirement.clone();
	}
	
	public String[] getEscAryOffice() {
		return aryOffice.clone();
	}
	
	public String getTxtKCode() {
		return txtKCode;
	}
	
	public String getTxtKName() {
		return txtKName;
	}
	
	public String getPltOfiice() {
		return pltOffice;
	}
	
	public String getPltSection() {
		return pltSection;
	}
	
	public String getPltPosition() {
		return pltPosition;
	}
	
	public String getPltRetirement() {
		return pltRetirement;
	}
	
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	public void setPltRetirement(String pltRetirement) {
		this.pltRetirement = pltRetirement;
	}
	
}
