/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class MosPMenuVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4851143534947875513L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_ADMIN			= 1;
	
	// tB[h
	/**
	 * 
	 */
	public String[]				aryCmd;
	/**
	 * 
	 */
	public String[]				aryName;
	
	// [h
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_MENU;
	

	/**
	 * RXgN^
	 */
	public MosPMenuVo() {
		super();
		setViewPath(getClassName());
		aryCmd = new String[0];
		aryName = new String[0];
		mode = 0;
	}
	
	@Override
	protected void setFieldsName() {
		NAM_MENU = CommonConst.NAM_MENU;
	}
	
	/**
	 * tB[hݒ
	 * <p>	2009/01/07	k.taniai	j[AWΉ	</p>
	 * @param compnent R}hݒ
	 * @param combineAllCmdArray SR}hz
	 */
	public void setFields(String compnent, String[][] combineAllCmdArray) {
		if (compnent.length() > 0) {
			aryCmd = StringUtil.divideByComma(compnent);
			aryName = new String[aryCmd.length];
			for (int i = 0; i < aryCmd.length; i++) {
				aryName[i] = "";
				String cmdNo = aryCmd[i];
				String cmdName = StringUtil.getCodeName(aryCmd[i], combineAllCmdArray);
				if (!cmdNo.equals(cmdName)) {
					aryName[i] = escapeHTML(cmdName);
				}
			}
		}
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return aryCmd
	 */
	public String[] getAryCmd() {
		return aryCmd.clone();
	}
	
	/**
	 * @return aryName
	 */
	public String[] getAryName() {
		return aryName.clone();
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param aryCmd Zbg aryCmd
	 */
	public void setAryCmd(String[] aryCmd) {
		this.aryCmd = aryCmd.clone();
	}
	
	/**
	 * @param aryName Zbg aryName
	 */
	public void setAryName(String[] aryName) {
		this.aryName = aryName.clone();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
