/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

import jp.mosp.common.CommonConst;

/**
 * ԁAɊւPartNX
 * @author yoshida
 *	@version	0.0.4
 */
public class TimeUtil {
	
	/**
	 * 
	 */
	private TimeUtil() {
		// NXɂCX^Xh~
	}
	
	/**
	 * int̎ԂStringɕϊ
	 * @param time	i0̌oߕj
	 * @return	string	ԁij
	 */
	public static String convIntegerTimeToStringHour(int time) {
		return String.valueOf(convIntegerTimeToIntegerHour(time));
	}
	
	/**
	 * int̎ԂStringɕϊ
	 * @since	0.0.3
	 * @param time	i0̌oߕj
	 * @return	ԁij
	 */
	public static int convIntegerTimeToIntegerHour(int time) {
		return time / CommonConst.NUM_1HOUR_MIN;
	}
	
	/**
	 * int̕Stringɕϊ
	 * @param time	i0̌oߕj
	 * @return	string	ԁij
	 */
	public static String convIntegerTimeToStringMinutes(int time) {
		return String.valueOf(convIntegerTimeToIntegerMinutes(time));
	}
	
	/**
	 * int̕Stringɕϊ
	 * @since	0.0.3
	 * @param time	i0̌oߕj
	 * @return	ԁij
	 */
	public static int convIntegerTimeToIntegerMinutes(int time) {
		return time % CommonConst.NUM_1HOUR_MIN;
	}
	
	/**
	 * String̎ԂStringɕϊ
	 * @param time HH:MM
	 * @return HH
	 */
	public static String convStringTimeToStringHour(String time) {
		if (time.equals("")) {
			return "0";
		} else {
			return convIntegerTimeToStringHour(convStringTimeToIntegerTime(time));
		}
	}
	
	/**
	 * String̕Stringɕϊ
	 * @param time HH:MM
	 * @return MM
	 */
	public static String convStringTimeToStringMinutes(String time) {
		if (StringUtil.isNull(time)) {
			return "0";
		} else {
			return convIntegerTimeToStringMinutes(convStringTimeToIntegerTime(time));
		}
	}
	
	/**
	 * ϊiintStringj
	 * @param time i0̌oߕj
	 * @return HH:MM
	 */
	public static String convIntegerTimeToStringTime(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringUtil.addZero(convIntegerTimeToIntegerHour(time)));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(StringUtil.addZero(convIntegerTimeToIntegerMinutes(time)));
		return sb.toString();
	}
	
	/**
	 * ϊiintStringj
	 * @param time  i0̌oߕj
	 * @return HHMM
	 */
	public static String convIntegerTimeToJPTime(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringUtil.addZero(convIntegerTimeToIntegerHour(time)));
		sb.append(CommonConst.NAM_HOUR);
		sb.append(StringUtil.addZero(convIntegerTimeToIntegerMinutes(time)));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}
	
	/**
	 * ϊiStringintj
	 * @param time iHH:MMj
	 * @return int	i0̌oߕj
	 */
	public static int convStringTimeToIntegerTime(String time) {
		String targetTime = time;
		if (StringUtil.isNull(time)) {
			targetTime = "0:0";
		}
		String[] ar = targetTime.split(CommonConst.STR_TIME_SEPARATOR);
		return convStringTimeToIntegerTime(ar[0], ar[1]);
	}
	
	/**
	 * ϊiStringintj
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public static int convStringTimeToIntegerTime(String hour, String min) {
		return convIntegerTimeToIntegerTime(NumberUtil.getIntParam(hour), NumberUtil.getIntParam(min));
	}
	
	/**
	 * ϊiStringStringj
	 * @param hour 
	 * @param min 
	 * @return	HH:mm
	 */
	public static String convStringTimeFormatted(String hour, String min) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringUtil.addZero(hour));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(StringUtil.addZero(min));
		return sb.toString();
	}
	
	/**
	 * ԕϊiintdoublej
	 * @param time i0̌oߕj
	 * @return hh.mm <br>͂̂܂
	 * 				[] 651.05
	 */
	public static double convIntegerTimeToDoubleTime(int time) {
		double dblhour = Math.floor(convMinutesToDoubleHour(time));
		double dblmin = (double)time % CommonConst.NUM_1HOUR_MIN / 100;
		double dtime = dblhour + dblmin;
		return dtime;
	}
	
	/**
	 * ԕϊiintStringj
	 * <p>[] 901.5</p>
	 * <p>15Pʂ̏ꍇ̂ݗpĂB</p>
	 * @param time i0̌oߕj
	 * @return hh.mm 
	 */
	public static String convIntegerMinToStringHour(int time) {
		return String.valueOf(convIntegerTimeToDoubleTime(time));
	}
	
	/**
	 * ԕϊiintStringj
	 * @param time i0̌oߕj
	 * @return HHMM
	 */
	public static String convIntegerTimeToJPHours(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(convIntegerTimeToStringHour(time));
		sb.append(CommonConst.NAM_COMMON_TIME);
		sb.append(StringUtil.addZero(convIntegerTimeToStringMinutes(time)));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}
	
	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	public static String getHourString(double hour) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(2);
		nf.setMinimumFractionDigits(2);
		return nf.format(hour);
	}
	
	/**
	 * ϊiintintj
	 * @since	0.0.2
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public static int convIntegerTimeToIntegerTime(int hour, int min) {
		return (hour * CommonConst.NUM_1HOUR_MIN) + min;
	}
	
	/**
	 * ԏdfB
	 * @since 0.0.4
	 * @param periodStart ԊJni0̌oߕj
	 * @param periodEnd ԏIi0̌oߕj
	 * @param startTime ΏۊJni0̌oߕj
	 * @param endTime ΏۏIi0̌oߕj
	 * @return
	 * <p>
	 * ԂɏdĂꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean coverPeriod(int periodStart, int periodEnd, int startTime, int endTime) {
		if (periodEnd > periodStart && endTime > startTime) {
			// Jn
			if (startTime >= periodStart && periodEnd > startTime) {
				return true;
			}
			// I
			if (endTime > periodStart) {
				if (startTime >= periodEnd) {
					return false;
				}
				return true;
			}
		}
		return false;
	}
	
	/**
	 * 擾
	 * @param time i0̌oߕj
	 * @return HH:MM(24ȍ~uvt)
	 */
	public static String getJPStringTime(int time) {
		StringBuffer sb = new StringBuffer();
		int hour = convIntegerTimeToIntegerHour(time);
		if (hour >= CommonConst.NUM_DAILY_HOUR) {
			sb.append(CommonConst.NAM_NEXT);
			sb.append(StringUtil.addZero(hour - CommonConst.NUM_DAILY_HOUR));
		} else {
			sb.append(StringUtil.addZero(hour));
		}
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(StringUtil.addZero(convIntegerTimeToIntegerMinutes(time)));
		return sb.toString();
	}
	
	/**
	 * 擾
	 * @param time i0̌oߕj
	 * @return H:M(24ȍ~uvt)
	 */
	public static String getJPStringTimeShort(int time) {
		StringBuffer sb = new StringBuffer();
		int hour = convIntegerTimeToIntegerHour(time);
		if (hour >= CommonConst.NUM_DAILY_HOUR) {
			sb.append(CommonConst.NAM_NEXT);
			sb.append(hour - CommonConst.NUM_DAILY_HOUR);
		} else {
			sb.append(hour);
		}
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(convIntegerTimeToIntegerMinutes(time));
		return sb.toString();
	}
	
	/**
	 * Ԏ擾
	 * @param minutes Ώێԁij
	 * @return ϊ㎞ԁij_Oʂ؂グ
	 */
	public static double convMinutesToDoubleHour(int minutes) {
		return new BigDecimal(Double.valueOf(minutes) / CommonConst.NUM_1HOUR_MIN).setScale(2, RoundingMode.CEILING)
			.doubleValue();
	}
	
	/**
	 * Ԏ擾
	 * @param hour Ώێԁij
	 * @return ϊ㎞ԁij_ȉ؂グ
	 */
	public static int convHourToMinutes(double hour) {
		return Double.valueOf(Math.ceil(hour * CommonConst.NUM_1HOUR_MIN)).intValue();
	}
	
}
